#!/bin/fish
# THIS FILE IS GENERATED BY
#      $$GENERATOR$$
# DO NOT EDIT IT MANUALLY
#
# START-ID
#      $$NUTS_ID$$
# END-ID
#
# START-COMMAND

. $$SCRIPT_NUTS_ENV$$

if test -n "$NUTS_JAVA_HOME" ; and test -x "$NUTS_JAVA_HOME/bin/java"
    _java="$NUTS_JAVA_HOME/bin/java"
else test type -p java > /dev/null
    _java=java
else if test -n "$JAVA_HOME" ; and test -x "$JAVA_HOME/bin/java"
#    echo found java executable in JAVA_HOME
    _java="$JAVA_HOME/bin/java"
else
    _java="java"
end

if set -q _java
    version=$("$_java" -version 2>&1 | awk -F '"' '/version/ {print $2}')
    major=`echo $version | cut -d. -f1`
    minor=`echo $version | cut -d. -f2`
    if test "$major" -eq "1"
        major=$minor
    end
    if test "$major" -lt "8"
        echo expected 1.8+ java version, found $version;
        exit 204;
    end
end


if [ x"$1" = x"--debug" ]
  NUTS_DEBUG_ARG="-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005"
else if [[ x"$1" = x"--debug="* ]]
  sub=${1:8}
  sub="${sub},"
  d_port=5005
  d_enable="true"
  d_suspend="y"
  subArray=$(echo $sub | tr "," "\n")

  for curr in $subArray
    if [ ! -z "${curr##*[!0-9]*}" ]
         d_port=$curr
      else if [ x"$curr" = 'xno' ]
         d_enable="false"
      else if [ x"$curr" = 'xsuspend' ]
         d_suspend="y"
      else if [ x"$curr" = 'x!suspend' ]
         d_suspend="n"
      else if [ x"$curr" = 'xs' ]
         d_suspend="y"
      else if [ x"$curr" = 'x!s' ]
         d_suspend="n"
      else
        echo $curr is unsupported
      end
  end

  if [ x$d_enable = x'true' ]
    NUTS_DEBUG_ARG="-agentlib:jdwp=transport=dt_socket,server=y,suspend=$d_suspend,address=$d_port"
  end
  #echo $sub
end


set _NUTS_JAVA_OPTIONS `echo "$NUTS_JAVA_OPTIONS -jar" | xargs`


$_java $NUTS_DEBUG_ARG $_NUTS_JAVA_OPTIONS "$$NUTS_APP_JAR$$" -w "$NUTS_WORKSPACE" $argv
# END-COMMAND
