/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.thevpc.nuts.util.NTruth;

@FunctionalInterface
public interface NTruthPredicate<T> {
    public NTruth test(T var1);

    default public NTruthPredicate<T> negate() {
        return t -> this.test(t).not();
    }

    default public NTruthPredicate<T> and(NTruthPredicate<T> other) {
        return t -> this.test(t).and(other.test(t));
    }

    default public NTruthPredicate<T> or(NTruthPredicate<T> other) {
        return t -> this.test(t).or(other.test(t));
    }

    default public NTruthPredicate<T> xor(NTruthPredicate<T> other) {
        return t -> this.test(t).xor(other.test(t));
    }

    public static <T> NTruthPredicate<T> andAll(Iterable<NTruthPredicate<T>> predicates) {
        return t -> {
            NTruthPredicate p;
            NTruth result = NTruth.TRUE;
            Iterator iterator = predicates.iterator();
            while (iterator.hasNext() && (result = result.and((p = (NTruthPredicate)iterator.next()).test(t))) != NTruth.FALSE) {
            }
            return result;
        };
    }

    public static <T> NTruthPredicate<T> orAll(Iterable<NTruthPredicate<T>> predicates) {
        return t -> {
            NTruthPredicate p;
            NTruth result = NTruth.FALSE;
            Iterator iterator = predicates.iterator();
            while (iterator.hasNext() && (result = result.or((p = (NTruthPredicate)iterator.next()).test(t))) != NTruth.TRUE) {
            }
            return result;
        };
    }

    public static <T> NTruthPredicate<T> andAllSuppliers(Iterable<? extends Supplier<NTruthPredicate<T>>> suppliers) {
        return t -> {
            Supplier s;
            NTruth result = NTruth.TRUE;
            Iterator iterator = suppliers.iterator();
            while (iterator.hasNext() && (result = result.and(((NTruthPredicate)(s = (Supplier)iterator.next()).get()).test(t))) != NTruth.FALSE) {
            }
            return result;
        };
    }

    public static <T> NTruthPredicate<T> orAllSuppliers(Iterable<? extends Supplier<NTruthPredicate<T>>> suppliers) {
        return t -> {
            Supplier s;
            NTruth result = NTruth.FALSE;
            Iterator iterator = suppliers.iterator();
            while (iterator.hasNext() && (result = result.or(((NTruthPredicate)(s = (Supplier)iterator.next()).get()).test(t))) != NTruth.TRUE) {
            }
            return result;
        };
    }

    public static <T> NTruthPredicate<T> of(Predicate<T> predicate) {
        return t -> predicate.test(t) ? NTruth.TRUE : NTruth.FALSE;
    }

    public static <T> NTruthPredicate<T> constant(NTruth value) {
        return t -> value;
    }
}

