/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Iterator;
import java.util.function.Supplier;

public enum NTruth {
    TRUE,
    FALSE,
    UNKNOWN,
    INDETERMINATE;


    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isFalse() {
        return this == FALSE;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isIndeterminate() {
        return this == INDETERMINATE;
    }

    public NTruth and(NTruth other) {
        if (this == FALSE || other == FALSE) {
            return this == INDETERMINATE || other == INDETERMINATE ? INDETERMINATE : FALSE;
        }
        if (this == TRUE && other == TRUE) {
            return TRUE;
        }
        if (this == INDETERMINATE || other == INDETERMINATE) {
            return INDETERMINATE;
        }
        return UNKNOWN;
    }

    public NTruth or(NTruth other) {
        if (this == TRUE || other == TRUE) {
            return TRUE;
        }
        if (this == FALSE && other == FALSE) {
            return FALSE;
        }
        if (this == INDETERMINATE || other == INDETERMINATE) {
            return INDETERMINATE;
        }
        return UNKNOWN;
    }

    public NTruth not() {
        switch (this.ordinal()) {
            case 0: {
                return FALSE;
            }
            case 1: {
                return TRUE;
            }
            case 2: {
                return UNKNOWN;
            }
            case 3: {
                return INDETERMINATE;
            }
        }
        return UNKNOWN;
    }

    public NTruth xor(NTruth other) {
        if (this == INDETERMINATE || other == INDETERMINATE) {
            if (this == INDETERMINATE && other == INDETERMINATE) {
                return UNKNOWN;
            }
            return INDETERMINATE;
        }
        if (this == UNKNOWN || other == UNKNOWN) {
            if (this == UNKNOWN && other == UNKNOWN) {
                return UNKNOWN;
            }
            return INDETERMINATE;
        }
        return this == other ? FALSE : TRUE;
    }

    public static NTruth andAll(Iterable<NTruth> items) {
        NTruth v;
        NTruth result = TRUE;
        Iterator<NTruth> iterator = items.iterator();
        while (iterator.hasNext() && (result = result.and(v = iterator.next())) != FALSE) {
        }
        return result;
    }

    public static NTruth orAll(Iterable<NTruth> items) {
        NTruth v;
        NTruth result = FALSE;
        Iterator<NTruth> iterator = items.iterator();
        while (iterator.hasNext() && (result = result.or(v = iterator.next())) != TRUE) {
        }
        return result;
    }

    public static NTruth andAllSuppliers(Iterable<? extends Supplier<NTruth>> suppliers) {
        Supplier<NTruth> s;
        NTruth v;
        NTruth result = TRUE;
        Iterator<? extends Supplier<NTruth>> iterator = suppliers.iterator();
        while (iterator.hasNext() && (result = result.and(v = (s = iterator.next()).get())) != FALSE) {
        }
        return result;
    }

    public static NTruth orAllSuppliers(Iterable<? extends Supplier<NTruth>> suppliers) {
        Supplier<NTruth> s;
        NTruth v;
        NTruth result = FALSE;
        Iterator<? extends Supplier<NTruth>> iterator = suppliers.iterator();
        while (iterator.hasNext() && (result = result.or(v = (s = iterator.next()).get())) != TRUE) {
        }
        return result;
    }

    public static NTruth of(Boolean b) {
        return b == null ? UNKNOWN : (b != false ? TRUE : FALSE);
    }

    public Boolean toBoolean() {
        switch (this.ordinal()) {
            case 0: {
                return Boolean.TRUE;
            }
            case 1: {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

