/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringBox;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class NToStringBuilder {
    private String name;
    private List<Map.Entry<String, Object>> str = new ArrayList<Map.Entry<String, Object>>();
    private int rowSize = 60;
    private String indentString = "    ";

    public NToStringBuilder() {
    }

    public NToStringBuilder(String name) {
        this.name = NStringUtils.trimToNull(name);
    }

    public NToStringBuilder setRowSize(int rowSize) {
        this.rowSize = rowSize <= 1 ? 1 : rowSize;
        return this;
    }

    public NToStringBuilder setIndentString(String indentString) {
        this.indentString = indentString == null ? "" : indentString;
        return this;
    }

    private NStringBox buildEntry(String k, Object value) {
        int len = 0;
        String ss = value.toString();
        len += k.length();
        len += 3;
        if ((len += ss.length()) < this.rowSize) {
            return new NStringBox(k + " : " + ss);
        }
        return new NStringBox(k + " : \n" + this.indentString + ss);
    }

    public NToStringBuilder addIfNonBlank(String key, Object value) {
        return this.addIf(key, value, NBlankable::isNonBlank);
    }

    public NToStringBuilder addIfNonEmpty(String key, String value) {
        return this.addIf(key, value, v -> NStringUtils.isEmpty(value));
    }

    public NToStringBuilder addIfNonEmpty(String key, Collection<?> value) {
        return this.addIf(key, value, v -> v != null && !v.isEmpty());
    }

    public NToStringBuilder addIfNonEmpty(String key, Map<?, ?> value) {
        return this.addIf(key, value, v -> v != null && !v.isEmpty());
    }

    public NToStringBuilder addIfNonNull(String key, Object value) {
        return this.addIf(key, value, Objects::nonNull);
    }

    public <T> NToStringBuilder addIf(String key, T value, Predicate<T> condition) {
        if (condition == null || condition.test(value)) {
            this.add(key, value);
        }
        return this;
    }

    public NToStringBuilder add(String key, Object value) {
        if (value instanceof CharSequence) {
            return this.add(key, ((CharSequence)value).toString());
        }
        this.str.add(new AbstractMap.SimpleEntry<String, Object>(key, value == null ? "null" : value));
        return this;
    }

    public NToStringBuilder add(String key, String value) {
        this.str.add(new AbstractMap.SimpleEntry<String, String>(key, value == null ? "null" : NStringUtils.formatStringLiteral(value, NElementType.DOUBLE_QUOTED_STRING)));
        return this;
    }

    public String build() {
        NStringBox row;
        if (this.str.isEmpty()) {
            if (this.name == null) {
                return "{}";
            }
            return this.name + "{}";
        }
        String indent = "   ";
        NStringBuilder sb = new NStringBuilder(this.name == null ? 20 : this.name.length() + 20);
        if (this.name != null) {
            sb.append(this.name);
        }
        sb.append("{");
        boolean count = false;
        LinkedHashMap str2 = new LinkedHashMap();
        ArrayList<NStringBox> rows = new ArrayList<NStringBox>();
        boolean multiLine = false;
        int cols = 0;
        for (Map.Entry<String, Object> e : this.str) {
            NStringBox t = this.buildEntry(e.getKey(), e.getValue());
            cols += t.getCols();
            rows.add(t);
            if (multiLine || t.getRows() <= 1) continue;
            multiLine = true;
        }
        if (!multiLine && cols < this.rowSize) {
            for (int i = 0; i < rows.size(); ++i) {
                row = (NStringBox)rows.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(row.getValue());
            }
        } else {
            for (int i = 0; i < rows.size(); ++i) {
                row = (NStringBox)rows.get(i);
                sb.append(new NStringBuilder(row.getValue()).indent(indent));
                if (i + 1 < rows.size()) {
                    sb.append(",\n");
                    continue;
                }
                sb.append("\n");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return this.build();
    }

    public String getName() {
        return this.name;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public String getIndentString() {
        return this.indentString;
    }
}

