/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.expr.NToken;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.text.NPositionType;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NSupportMode;

public class NStringUtils {
    public static final String DEFAULT_VAR_NAME = "var";

    private NStringUtils() {
    }

    public static String normalizeString(String value) {
        if (value == null) {
            return null;
        }
        String nfdNormalizedString = Normalizer.normalize(value, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    public static String trim(String value) {
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public static CharSequence trim(CharSequence value) {
        int st;
        int len0;
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return value.toString().trim();
        }
        int len = len0 = value.length();
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        while (st < len && value.charAt(len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < len0 ? value.subSequence(st, len) : value.toString();
    }

    public static CharSequence trimLeft(CharSequence value) {
        int st;
        if (value == null) {
            return "";
        }
        int len = value.length();
        if (len == 0) {
            return value.toString();
        }
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        if (st > 0) {
            return value.subSequence(st, len);
        }
        return value.toString();
    }

    public static CharSequence trimRight(CharSequence value) {
        int st;
        if (value == null) {
            return "";
        }
        int len = value.length();
        if (len == 0) {
            return value.toString();
        }
        for (st = len; st > 0 && value.charAt(st - 1) <= ' '; --st) {
        }
        if (st < len) {
            return value.subSequence(0, st);
        }
        return value.toString();
    }

    public static String trimLeft(String value) {
        int st;
        if (value == null) {
            return "";
        }
        int len = value.length();
        if (len == 0) {
            return value;
        }
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        if (st > 0) {
            return value.substring(st, len);
        }
        return value;
    }

    public static String trimRight(String value) {
        int st;
        if (value == null) {
            return "";
        }
        int len = value.length();
        if (len == 0) {
            return value;
        }
        for (st = len; st > 0 && value.charAt(st - 1) <= ' '; --st) {
        }
        if (st < len) {
            return value.substring(0, st);
        }
        return value;
    }

    public static String trimToNull(String value) {
        if (value == null) {
            return null;
        }
        String t = value.trim();
        if (t.isEmpty()) {
            return null;
        }
        return t;
    }

    public static String trimToNull(CharSequence value) {
        if (value == null) {
            return null;
        }
        String t = NStringUtils.trim(value).toString();
        if (t.isEmpty()) {
            return null;
        }
        return t;
    }

    public static String trimLeftToNull(CharSequence value) {
        if (value == null) {
            return null;
        }
        String t = NStringUtils.trimLeft(value).toString();
        if (t.isEmpty()) {
            return null;
        }
        return t;
    }

    public static String trimRightToNull(CharSequence value) {
        if (value == null) {
            return null;
        }
        String t = NStringUtils.trimRight(value).toString();
        if (t.isEmpty()) {
            return null;
        }
        return t;
    }

    public static int firstIndexOf(String string, char ... chars) {
        if (string != null && chars != null) {
            char[] value = string.toCharArray();
            for (int i = 0; i < value.length; ++i) {
                for (int j = 0; j < chars.length; ++j) {
                    if (value[i] != chars[j]) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static String firstNonNull(String ... values) {
        return NStringUtils.firstNonNull(values == null ? null : Arrays.asList(values));
    }

    public static String firstNonNull(List<String> values) {
        if (values != null) {
            for (String value : values) {
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static String firstNonEmpty(String ... values) {
        return NStringUtils.firstNonEmpty(values == null ? null : Arrays.asList(values));
    }

    public static String firstNonEmpty(List<String> values) {
        if (values != null) {
            for (String value : values) {
                if (NStringUtils.isEmpty(value)) continue;
                return value;
            }
        }
        return null;
    }

    public static String firstNonBlank(String a, String b) {
        if (!NBlankable.isBlank(a)) {
            return a;
        }
        if (!NBlankable.isBlank(b)) {
            return b;
        }
        return null;
    }

    public static String firstNonBlank(String ... values) {
        return NStringUtils.firstNonBlank(values == null ? null : Arrays.asList(values));
    }

    public static String firstNonBlank(List<String> values) {
        if (values != null) {
            for (String value : values) {
                if (NBlankable.isBlank(value)) continue;
                return value;
            }
        }
        return null;
    }

    public static String formatAlign(String text, int size, NPositionType position) {
        int len;
        if (text == null) {
            text = "";
        }
        if ((len = text.length()) >= size) {
            return text;
        }
        switch (position) {
            case FIRST: {
                StringBuilder sb = new StringBuilder(size);
                sb.append(text);
                for (int i = len; i < size; ++i) {
                    sb.append(' ');
                }
                return sb.toString();
            }
            case LAST: {
                StringBuilder sb = new StringBuilder(size);
                for (int i = len; i < size; ++i) {
                    sb.append(' ');
                }
                sb.append(text);
                return sb.toString();
            }
            case CENTER: {
                int i;
                StringBuilder sb = new StringBuilder(size);
                int h = size / 2 + size % 2;
                for (i = len; i < h; ++i) {
                    sb.append(' ');
                }
                sb.append(text);
                h = size / 2;
                for (i = len; i < h; ++i) {
                    sb.append(' ');
                }
                return sb.toString();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static String formatStringLiteral(String text) {
        return NStringUtils.formatStringLiteral(text, NElementType.DOUBLE_QUOTED_STRING);
    }

    public static String formatStringLiteral(String text, NElementType quoteType) {
        return NStringUtils.formatStringLiteral(text, quoteType, NSupportMode.ALWAYS);
    }

    public static String formatStringLiteral(String text, NElementType quoteType, NSupportMode condition) {
        return NStringUtils.formatStringLiteral(text, quoteType, condition, "");
    }

    public static String formatStringLiteral(String text, NElementType quoteType, NSupportMode condition, String escapeChars) {
        if (text == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        boolean requireQuotes = condition == NSupportMode.ALWAYS;
        boolean allowQuotes = condition != NSupportMode.NEVER;
        block19: for (char c : text.toCharArray()) {
            switch (c) {
                case ' ': {
                    if (allowQuotes) {
                        sb.append(" ");
                        requireQuotes = true;
                        continue block19;
                    }
                    sb.append("\\ ");
                    continue block19;
                }
                case '\n': {
                    sb.append("\\n");
                    if (requireQuotes || !allowQuotes) continue block19;
                    requireQuotes = true;
                    continue block19;
                }
                case '\f': {
                    sb.append("\\f");
                    if (requireQuotes || !allowQuotes) continue block19;
                    requireQuotes = true;
                    continue block19;
                }
                case '\r': {
                    sb.append("\\r");
                    if (requireQuotes || !allowQuotes) continue block19;
                    requireQuotes = true;
                    continue block19;
                }
                case '\t': {
                    sb.append("\\t");
                    if (requireQuotes || !allowQuotes) continue block19;
                    requireQuotes = true;
                    continue block19;
                }
                case '\"': {
                    if (quoteType == NElementType.DOUBLE_QUOTED_STRING) {
                        sb.append("\\").append(c);
                        if (requireQuotes || !allowQuotes) continue block19;
                        requireQuotes = true;
                        continue block19;
                    }
                    sb.append(c);
                    continue block19;
                }
                case '\'': {
                    if (quoteType == NElementType.SINGLE_QUOTED_STRING) {
                        sb.append("\\").append(c);
                        if (requireQuotes || !allowQuotes) continue block19;
                        requireQuotes = true;
                        continue block19;
                    }
                    sb.append(c);
                    continue block19;
                }
                case '`': {
                    if (quoteType == NElementType.ANTI_QUOTED_STRING) {
                        sb.append("\\").append(c);
                        if (requireQuotes || !allowQuotes) continue block19;
                        requireQuotes = true;
                        continue block19;
                    }
                    sb.append(c);
                    continue block19;
                }
                default: {
                    if (escapeChars != null && escapeChars.indexOf(c) >= 0) {
                        if (allowQuotes) {
                            sb.append(c);
                            requireQuotes = true;
                            continue block19;
                        }
                        sb.append("\\").append(c);
                        continue block19;
                    }
                    sb.append(c);
                }
            }
        }
        if (sb.length() == 0) {
            requireQuotes = true;
        }
        if (requireQuotes) {
            switch (quoteType) {
                case DOUBLE_QUOTED_STRING: {
                    sb.insert(0, '\"');
                    sb.append('\"');
                    break;
                }
                case SINGLE_QUOTED_STRING: {
                    sb.insert(0, '\'');
                    sb.append('\'');
                    break;
                }
                case ANTI_QUOTED_STRING: {
                    sb.insert(0, '`');
                    sb.append('`');
                    break;
                }
                case TRIPLE_DOUBLE_QUOTED_STRING: {
                    sb.insert(0, "\"\"\"");
                    sb.append("\"\"\"");
                    break;
                }
                case TRIPLE_SINGLE_QUOTED_STRING: {
                    sb.insert(0, "'''");
                    sb.append("'''");
                    break;
                }
                case TRIPLE_ANTI_QUOTED_STRING: {
                    sb.insert(0, "```");
                    sb.append("```");
                    break;
                }
                case LINE_STRING: {
                    sb.insert(0, "\u00b6 ");
                    sb.append("\n");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported quote type: " + quoteType);
                }
            }
        }
        return sb.toString();
    }

    public static NOptional<List<String>> parsePropertyIdList(String s) {
        return NReservedUtils.parseStringIdList(s);
    }

    public static List<String> parsePropertyStringList(String s) {
        return NReservedLangUtils.parseAndTrimToDistinctList(s);
    }

    public static List<String> split(String value, String chars) {
        return NStringUtils.split(value, chars, true, false);
    }

    public static String repeat(char c, int count) {
        char[] e = new char[count];
        Arrays.fill(e, c);
        return new String(e);
    }

    public static String repeat(String str, int count) {
        if (count < 0) {
            throw new ArrayIndexOutOfBoundsException(count);
        }
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return str;
            }
        }
        StringBuilder sb = new StringBuilder(str.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String alignLeft(String s, int width) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            sb.append(s);
            int x = width - sb.length();
            if (x > 0) {
                sb.append(NStringUtils.repeat(' ', x));
            }
        }
        return sb.toString();
    }

    public static String alignRight(String s, int width) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            sb.append(s);
            int x = width - sb.length();
            if (x > 0) {
                sb.insert(0, NStringUtils.repeat(' ', x));
            }
        }
        return sb.toString();
    }

    public static List<String> split(String value, String chars, boolean trim, boolean ignoreEmpty) {
        if (value == null) {
            value = "";
        }
        StringTokenizer st = new StringTokenizer(value, chars, true);
        ArrayList<String> all = new ArrayList<String>();
        boolean wasSep = true;
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (chars.indexOf(s.charAt(0)) >= 0) {
                if (wasSep) {
                    s = "";
                    if (!ignoreEmpty) {
                        all.add(s);
                    }
                }
                wasSep = true;
                continue;
            }
            wasSep = false;
            if (trim) {
                s = s.trim();
            }
            if (ignoreEmpty && s.isEmpty()) continue;
            all.add(s);
        }
        if (wasSep && !ignoreEmpty) {
            all.add("");
        }
        return all;
    }

    public static String replacePlaceholder(String text, String regexp, Function<String, String> mapper) {
        return NStringUtils.replacePlaceholder(text, Pattern.compile(regexp), null, mapper);
    }

    public static String replacePlaceholder(String text, String regexp, String varName, Function<String, String> mapper) {
        return NStringUtils.replacePlaceholder(text, Pattern.compile(regexp), varName, mapper);
    }

    public static String replacePlaceholder(String text, Pattern regexp, String varName, Function<String, String> mapper) {
        if (text == null) {
            return "";
        }
        if (mapper == null) {
            return "";
        }
        return NStringUtils.parsePlaceHolder(text, regexp, varName).map(t -> {
            switch (t.ttype) {
                case -87: {
                    String x = (String)mapper.apply(t.sval);
                    if (x == null) {
                        return t.image;
                    }
                    return x;
                }
            }
            return t.sval;
        }).collect(Collectors.joining());
    }

    public static Stream<NToken> parsePlaceHolder(final String text, final Pattern pattern, final String patternVarName) {
        NAssert.requireNonNull(pattern, "pattern");
        if (text == null) {
            return Stream.empty();
        }
        final String TT_DEFAULT_STR = NToken.typeString(Integer.MIN_VALUE);
        final String TT_VAR_STR = NToken.typeString(-87);
        return NStringUtils.iterToStream(new Iterator<NToken>(){
            final String vn;
            final Matcher matcher;
            int last;
            final List<NToken> buffer = new ArrayList<NToken>(2);
            {
                this.vn = NBlankable.isBlank(patternVarName) ? NStringUtils.DEFAULT_VAR_NAME : patternVarName;
                this.matcher = pattern.matcher(text);
            }

            private boolean ready() {
                return !this.buffer.isEmpty();
            }

            @Override
            public boolean hasNext() {
                if (this.ready()) {
                    return true;
                }
                if (this.matcher.find()) {
                    String name = this.matcher.group(patternVarName);
                    String all = this.matcher.group();
                    int start = this.matcher.start();
                    if (start > this.last) {
                        String t = text.substring(this.last, start);
                        this.buffer.add(NToken.of(Integer.MIN_VALUE, t, 0, 0, t, TT_DEFAULT_STR));
                    }
                    this.last = start + all.length();
                    this.buffer.add(NToken.of(-87, name, 0, 0, all, TT_VAR_STR));
                    return true;
                }
                if (this.last < text.length()) {
                    String t = text.substring(this.last);
                    this.buffer.add(NToken.of(Integer.MIN_VALUE, t, 0, 0, t, TT_DEFAULT_STR));
                    this.last = text.length();
                }
                return this.ready();
            }

            @Override
            public NToken next() {
                NAssert.requireTrue(this.ready(), "token ready");
                return this.buffer.remove(0);
            }
        });
    }

    public static String replaceDollarPlaceHolder(String text, Function<String, String> mapper) {
        if (mapper == null) {
            return "";
        }
        return NStringUtils.parseDollarPlaceHolder(text).map(t -> {
            switch (t.ttype) {
                case -86: 
                case -85: {
                    String x = (String)mapper.apply(t.sval);
                    if (x == null) {
                        return t.image;
                    }
                    return x;
                }
            }
            return t.sval;
        }).collect(Collectors.joining());
    }

    public static Stream<NToken> parseDollarPlaceHolder(final String text) {
        final String TT_DEFAULT_STR = NToken.typeString(Integer.MIN_VALUE);
        final String TT_DOLLAR_BRACE_STR = NToken.typeString(-86);
        final String TT_DOLLAR_STR = NToken.typeString(-85);
        return NStringUtils.iterToStream(new Iterator<NToken>(){
            final char[] t;
            int p;
            final int length;
            final StringBuilder sb;
            final StringBuilder n;
            final StringBuilder ni;
            final List<NToken> buffer;
            {
                this.t = text == null ? new char[]{} : text.toCharArray();
                this.p = 0;
                this.length = this.t.length;
                this.sb = new StringBuilder(this.length);
                this.n = new StringBuilder(this.length);
                this.ni = new StringBuilder(this.length);
                this.buffer = new ArrayList<NToken>(2);
            }

            private boolean ready() {
                return !this.buffer.isEmpty();
            }

            @Override
            public boolean hasNext() {
                if (this.ready()) {
                    return true;
                }
                while (this.p < this.length) {
                    this.fillOnce();
                    if (!this.ready()) continue;
                    return true;
                }
                if (this.sb.length() > 0) {
                    this.buffer.add(NToken.of(Integer.MIN_VALUE, this.sb.toString(), 0, 0, this.sb.toString(), TT_DEFAULT_STR));
                    this.sb.setLength(0);
                }
                return this.ready();
            }

            private void fillOnce() {
                char c = this.t[this.p];
                if (c == '$' && this.p + 1 < this.length && this.t[this.p + 1] == '{') {
                    this.p += 2;
                    this.n.setLength(0);
                    this.ni.setLength(0);
                    this.ni.append(c).append('{');
                    while (this.p < this.length) {
                        c = this.t[this.p];
                        if (c != '}') {
                            this.n.append(c);
                            this.ni.append(c);
                            ++this.p;
                            continue;
                        }
                        this.ni.append(c);
                        break;
                    }
                    if (this.sb.length() > 0) {
                        this.buffer.add(NToken.of(Integer.MIN_VALUE, this.sb.toString(), 0, 0, this.sb.toString(), TT_DEFAULT_STR));
                        this.sb.setLength(0);
                    }
                    this.buffer.add(NToken.of(-86, this.n.toString(), 0, 0, this.ni.toString(), TT_DOLLAR_BRACE_STR));
                } else if (c == '$' && this.p + 1 < this.length && NStringUtils.isValidVarStart(this.t[this.p + 1])) {
                    ++this.p;
                    this.n.setLength(0);
                    this.ni.setLength(0);
                    this.ni.append(c);
                    while (this.p < this.length) {
                        c = this.t[this.p];
                        if (NStringUtils.isValidVarPart(c)) {
                            this.n.append(c);
                            this.ni.append(c);
                            ++this.p;
                            continue;
                        }
                        --this.p;
                        break;
                    }
                    if (this.sb.length() > 0) {
                        this.buffer.add(NToken.of(Integer.MIN_VALUE, this.sb.toString(), 0, 0, this.sb.toString(), TT_DEFAULT_STR));
                        this.sb.setLength(0);
                    }
                    this.buffer.add(NToken.of(-85, this.n.toString(), 0, 0, this.ni.toString(), TT_DOLLAR_STR));
                } else {
                    this.sb.append(c);
                }
                ++this.p;
            }

            @Override
            public NToken next() {
                NAssert.requireTrue(this.ready(), "token ready");
                return this.buffer.remove(0);
            }
        });
    }

    public static boolean isValidVarPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    public static boolean isValidVarStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static <T> Stream<T> iterToStream(Iterator<T> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 0), false);
    }

    public static String toStringOrEmpty(Object any) {
        if (any == null) {
            return "";
        }
        return any.toString();
    }

    public static String[] stacktraceArray(Throwable th) {
        try {
            String line;
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                th.printStackTrace(pw);
            }
            BufferedReader br = new BufferedReader(new StringReader(sw.toString()));
            ArrayList<String> s = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                s.add(line);
            }
            return s.toArray(new String[0]);
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static String stacktrace(Throwable th) {
        try {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                th.printStackTrace(pw);
            }
            return sw.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static int lastIndexOf(String string, char[] chars) {
        if (string == null || chars == null || chars.length == 0) {
            return -1;
        }
        char[] value = string.toCharArray();
        for (int i = value.length - 1; i >= 0; --i) {
            for (char aChar : chars) {
                if (value[i] != aChar) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(String string, char[] chars) {
        if (string == null || chars == null || chars.length == 0) {
            return -1;
        }
        char[] value = string.toCharArray();
        for (int i = 0; i < value.length; ++i) {
            for (char aChar : chars) {
                if (value[i] != aChar) continue;
                return i;
            }
        }
        return -1;
    }

    public static String levenshteinClosest(double threshold, String str1, String ... dictionary) {
        if (threshold > 1.0) {
            threshold = 1.0;
        }
        if (threshold < 0.0) {
            threshold = 0.0;
        }
        double bestRelativeDistance = -1.0;
        String bestResult = null;
        if (str1 == null) {
            str1 = "";
        }
        for (String s : dictionary) {
            double relativeDistance;
            if (s == null) {
                s = "";
            }
            int l = Math.max(s.length(), str1.length());
            int u = NStringUtils.levenshteinDistance(str1, s);
            double d = l == 0 ? (double)(u != 0 ? 1 : 0) : (relativeDistance = (double)u / (double)l);
            if (!(relativeDistance >= threshold) || bestResult != null && !(relativeDistance < bestRelativeDistance)) continue;
            bestResult = s;
            bestRelativeDistance = relativeDistance;
        }
        return bestResult;
    }

    public static int levenshteinDistance(String str1, String str2) {
        if (str1 == null) {
            str1 = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        if (str1.isEmpty()) {
            return str2.length();
        }
        if (str2.isEmpty()) {
            return str1.length();
        }
        int[][] dp = new int[str1.length() + 1][str2.length() + 1];
        for (int i = 0; i <= str1.length(); ++i) {
            for (int j = 0; j <= str2.length(); ++j) {
                if (i == 0) {
                    dp[i][j] = j;
                    continue;
                }
                if (j == 0) {
                    dp[i][j] = i;
                    continue;
                }
                int v1 = dp[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1);
                int v2 = dp[i - 1][j] + 1;
                int v3 = dp[i][j - 1] + 1;
                if (v2 < v1) {
                    v1 = v2;
                }
                if (v3 < v1) {
                    v1 = v3;
                }
                dp[i][j] = v1;
            }
        }
        return dp[str1.length()][str2.length()];
    }

    public static List<String> splitLines(String data) {
        if (data == null) {
            return new ArrayList<String>();
        }
        return NStringUtils.readLines(new StringBuilder(data));
    }

    public static List<String> readLines(StringBuilder data) {
        if (data == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> all = new ArrayList<String>();
        while (data.length() > 0) {
            all.add(NStringUtils.readLine(data));
        }
        return all;
    }

    public static String readLine(StringBuilder data) {
        if (data == null) {
            return null;
        }
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c == '\n') {
                if (i == 0) {
                    data.delete(0, i + 1);
                    return "";
                }
                String l = data.substring(0, i);
                data.delete(0, i + 1);
                return l;
            }
            if (c != '\r') continue;
            if (i + 1 < data.length() && data.charAt(i + 1) == '\n') {
                String l = data.substring(0, ++i - 1);
                data.delete(0, i + 1);
                return l;
            }
            if (i == 0) {
                data.delete(0, i + 1);
                return "";
            }
            String l = data.substring(0, i);
            data.delete(0, i + 1);
            return l;
        }
        String l = data.toString();
        data.setLength(0);
        return l;
    }

    public static String pjoin(String delimiter, String ... items) {
        StringBuilder builder = new StringBuilder();
        if (delimiter == null) {
            delimiter = "";
        }
        if (delimiter.isEmpty()) {
            for (String item : items) {
                if (item == null || item.isEmpty()) continue;
                builder.append(item);
            }
        } else {
            for (String item : items) {
                if (item == null || item.isEmpty()) continue;
                int length = builder.length();
                if (length > 0 && !builder.substring(length - delimiter.length(), length).equals(delimiter) && !item.startsWith(delimiter)) {
                    builder.append(delimiter);
                }
                builder.append(item);
            }
        }
        return builder.toString();
    }

    public static String truncate(String s, int maxLength) {
        return NStringUtils.truncate(s, maxLength, null);
    }

    public static String truncate(String s, int maxLength, String suffix) {
        if (s == null || maxLength < 0) {
            return s;
        }
        if (s.length() <= maxLength) {
            return s;
        }
        if (NBlankable.isBlank(suffix)) {
            return s.substring(0, maxLength);
        }
        int l2 = maxLength - suffix.length();
        if (l2 >= 0) {
            return s.substring(0, l2) + suffix;
        }
        return suffix.substring(0, maxLength);
    }

    public static String replaceTail(String s, String oldTail, String newTail) {
        NAssert.requireNonNull(s, "string");
        NAssert.requireNonNull(s, "oldTail");
        NAssert.requireTrue(!oldTail.isEmpty(), "oldTail not empty");
        if (s.endsWith(oldTail)) {
            return s.substring(0, s.length() - oldTail.length()) + (newTail == null ? "" : newTail);
        }
        return s;
    }

    public static String replaceHead(String s, String oldHead, String newHead) {
        NAssert.requireNonNull(s, "string");
        NAssert.requireNonNull(s, "oldTail");
        NAssert.requireTrue(!oldHead.isEmpty(), "oldHead not empty");
        if (s.startsWith(oldHead)) {
            return newHead + s.substring(oldHead.length());
        }
        return s;
    }

    public static StringBuilder trim(StringBuilder sb) {
        NStringUtils.trimLeft(sb);
        NStringUtils.trimRight(sb);
        return sb;
    }

    public static StringBuilder trimLeft(StringBuilder sb) {
        int start;
        int len = sb.length();
        for (start = 0; start < len && Character.isWhitespace(sb.charAt(start)); ++start) {
        }
        if (start > 0) {
            sb.delete(0, start);
        }
        return sb;
    }

    public static String escapeChar(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c < ' ' || c > '~') {
            String s = "0000" + Integer.toString(c, 16);
            return "\\u" + s.substring(s.length() - 4);
        }
        return String.valueOf(c);
    }

    public static StringBuilder trimRight(StringBuilder sb) {
        int end;
        for (end = sb.length() - 1; end >= 0 && Character.isWhitespace(sb.charAt(end)); --end) {
        }
        if (end < sb.length() - 1) {
            sb.delete(end + 1, sb.length());
        }
        return sb;
    }
}

