/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.regex.Matcher;
import net.thevpc.nuts.util.NImmutable;
import net.thevpc.nuts.util.NMatchType;

public abstract class NStringMatchResult
implements NImmutable {
    private static final NStringMatchResult NO_MATCH = new NStringMatchResultAsNoMatch();
    private final NMatchType mode;

    public static NStringMatchResult ofNoMatch() {
        return NO_MATCH;
    }

    public static NStringMatchResult ofMatch(Matcher value) {
        return new YesPattern(NMatchType.MATCH, value);
    }

    public static NStringMatchResult ofPartialMatch(String value) {
        return new NStringMatchResultAsPartial(value);
    }

    public static NStringMatchResult ofFullMatch(Matcher value) {
        return new YesPattern(NMatchType.FULL_MATCH, value);
    }

    public static NStringMatchResult ofFullMatch(String value) {
        return new YesString(NMatchType.FULL_MATCH, value);
    }

    private NStringMatchResult(NMatchType mode) {
        this.mode = mode;
    }

    public NMatchType mode() {
        return this.mode;
    }

    public int count() {
        String s = this.get();
        return s == null ? 0 : s.length();
    }

    public abstract String get();

    public abstract String get(String var1);

    public String toString() {
        StringBuilder sb = new StringBuilder(this.mode.toString());
        if (this.mode == NMatchType.FULL_MATCH || this.mode == NMatchType.MATCH || this.mode == NMatchType.PARTIAL_MATCH) {
            sb.append("(");
            sb.append(this.get());
            sb.append(")");
        }
        return sb.toString();
    }

    private static class YesPattern
    extends NStringMatchResult {
        private Matcher value;

        public YesPattern(NMatchType mode, Matcher value) {
            super(mode);
            this.value = value;
        }

        @Override
        public String get() {
            return this.value.group();
        }

        @Override
        public String get(String name) {
            return this.value.group(name);
        }
    }

    private static class NStringMatchResultAsPartial
    extends NStringMatchResult {
        private String value;

        public NStringMatchResultAsPartial(String value) {
            super(NMatchType.PARTIAL_MATCH);
            this.value = value;
        }

        @Override
        public String get() {
            return this.value;
        }

        @Override
        public String get(String name) {
            return this.value;
        }
    }

    private static class YesString
    extends NStringMatchResult {
        private String value;

        public YesString(NMatchType mode, String value) {
            super(mode);
            this.value = value;
        }

        @Override
        public String get() {
            return this.value;
        }

        @Override
        public String get(String name) {
            return this.value;
        }
    }

    private static class NStringMatchResultAsNoMatch
    extends NStringMatchResult {
        public NStringMatchResultAsNoMatch() {
            super(NMatchType.NO_MATCH);
        }

        @Override
        public String get() {
            return null;
        }

        @Override
        public String get(String name) {
            return null;
        }
    }
}

