/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.function.Function;
import net.thevpc.nuts.util.NStringMapFormat;

public class NStringMapFormatBuilder {
    private String equalsChars = "=";
    private String separatorChars = "&";
    private String escapeChars = "?";
    private boolean sort = true;
    private Function<String, String> decoder;
    private Function<String, String> encoder;
    private boolean doubleQuoteSupported;
    private boolean simpleQuoteSupported;
    private boolean acceptNullKeys;

    public static NStringMapFormatBuilder of() {
        return new NStringMapFormatBuilder();
    }

    public boolean isAcceptNullKeys() {
        return this.acceptNullKeys;
    }

    public NStringMapFormatBuilder setAcceptNullKeys(boolean acceptNullKeys) {
        this.acceptNullKeys = acceptNullKeys;
        return this;
    }

    public boolean isDoubleQuoteSupported() {
        return this.doubleQuoteSupported;
    }

    public NStringMapFormatBuilder setDoubleQuoteSupported(boolean doubleQuoteSupported) {
        this.doubleQuoteSupported = doubleQuoteSupported;
        return this;
    }

    public boolean isSimpleQuoteSupported() {
        return this.simpleQuoteSupported;
    }

    public NStringMapFormatBuilder setSimpleQuoteSupported(boolean simpleQuoteSupported) {
        this.simpleQuoteSupported = simpleQuoteSupported;
        return this;
    }

    public NStringMapFormatBuilder setQuoteSupported(boolean quoteSupported) {
        this.setDoubleQuoteSupported(quoteSupported);
        this.setSimpleQuoteSupported(quoteSupported);
        return this;
    }

    public String getEqualsChars() {
        return this.equalsChars;
    }

    public NStringMapFormatBuilder setEqualsChars(String equalsChars) {
        this.equalsChars = equalsChars;
        return this;
    }

    public String getSeparatorChars() {
        return this.separatorChars;
    }

    public NStringMapFormatBuilder setSeparatorChars(String separatorChars) {
        this.separatorChars = separatorChars;
        return this;
    }

    public String getEscapeChars() {
        return this.escapeChars;
    }

    public NStringMapFormatBuilder setEscapeChars(String escapeChars) {
        this.escapeChars = escapeChars;
        return this;
    }

    public boolean isSort() {
        return this.sort;
    }

    public NStringMapFormatBuilder setSort(boolean sort) {
        this.sort = sort;
        return this;
    }

    public Function<String, String> getDecoder() {
        return this.decoder;
    }

    public NStringMapFormatBuilder setDecoder(Function<String, String> decoder) {
        this.decoder = decoder;
        return this;
    }

    public Function<String, String> getEncoder() {
        return this.encoder;
    }

    public NStringMapFormatBuilder setEncoder(Function<String, String> encoder) {
        this.encoder = encoder;
        return this;
    }

    public NStringMapFormat build() {
        return new NStringMapFormat(this);
    }

    public NStringMapFormatBuilder copyFrom(NStringMapFormatBuilder other) {
        if (other != null) {
            this.equalsChars = other.getEqualsChars();
            this.separatorChars = other.getSeparatorChars();
            this.escapeChars = other.getEscapeChars();
            this.sort = other.isSort();
            this.encoder = other.getEncoder();
            this.decoder = other.getDecoder();
        }
        return this;
    }

    public NStringMapFormatBuilder copyFrom(NStringMapFormat other) {
        if (other != null) {
            this.equalsChars = other.getEqualsChars();
            this.separatorChars = other.getSeparatorChars();
            this.escapeChars = other.getEscapeChars();
            this.sort = other.isSort();
            this.encoder = other.getEncoder();
            this.decoder = other.getDecoder();
        }
        return this;
    }
}

