/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;

public class NStringMap<V> {
    private Map<String, V> map;
    private char separator;

    public NStringMap(Map<String, V> map, char separator) {
        NAssert.requireNonNull(map, "map");
        this.map = map;
        this.separator = separator;
    }

    public NStringMap<V> clear() {
        this.map.clear();
        return this;
    }

    public int size() {
        return this.map.size();
    }

    public char getSeparator() {
        return this.separator;
    }

    public Map<String, V> toMap(String prefix) {
        NAssert.requireNonNull(prefix, "prefix");
        if (prefix.isEmpty()) {
            return new LinkedHashMap<String, V>(this.map);
        }
        LinkedHashMap<String, V> result = new LinkedHashMap<String, V>();
        for (Map.Entry<String, V> e : this.map.entrySet()) {
            String k = e.getKey();
            if (!k.startsWith(prefix)) continue;
            if (k.length() == prefix.length()) {
                result.put("", e.getValue());
                continue;
            }
            if (k.charAt(prefix.length()) != this.separator) continue;
            result.put(k.substring(prefix.length() + 1), e.getValue());
        }
        return result;
    }

    public Map<String, V> toMap() {
        return new LinkedHashMap<String, V>(this.map);
    }

    public NStringMap<V> removeAll(String prefix) {
        NAssert.requireNonNull(prefix, "prefix");
        if (prefix.isEmpty()) {
            return this;
        }
        Iterator<Map.Entry<String, V>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, V> e = iterator.next();
            String k = e.getKey();
            if (!k.startsWith(prefix)) continue;
            if (k.length() == prefix.length()) {
                iterator.remove();
                continue;
            }
            if (k.charAt(prefix.length()) != this.separator) continue;
            iterator.remove();
        }
        return this;
    }

    public NStringMap<V> putAll(Map<String, V> values) {
        NAssert.requireNonNull(values, "values");
        this.map.putAll(values);
        return this;
    }

    public V put(String prefix, String key, V value) {
        NAssert.requireNonNull(prefix, "prefix");
        return this.map.put(this.keyOf(prefix, key), value);
    }

    public V put(String key, V value) {
        return this.map.put(key, value);
    }

    public V get(String key) {
        return this.map.get(key);
    }

    public NOptional<V> getOptional(String prefix, String key) {
        return this.getOptional(this.keyOf(prefix, key));
    }

    public NOptional<V> getOptional(String key) {
        V v = this.map.get(key);
        if (v == null) {
            if (this.map.containsKey(key)) {
                return NOptional.ofNull();
            }
            return NOptional.ofNamedEmpty(key);
        }
        return NOptional.of(v);
    }

    public V set(String prefix, String key, V value) {
        NAssert.requireNonNull(prefix, "prefix");
        if (value == null) {
            return this.map.remove(this.keyOf(prefix, key));
        }
        return this.map.put(this.keyOf(prefix, key), value);
    }

    public V set(String key, V value) {
        if (value == null) {
            return this.map.remove(key);
        }
        return this.map.put(key, value);
    }

    public V remove(String prefix, String key) {
        NAssert.requireNonNull(prefix, "prefix");
        return this.map.remove(this.keyOf(prefix, key));
    }

    public Set<String> nextKeys(String prefix) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        NAssert.requireNonNull(prefix, "prefix");
        for (Map.Entry<String, V> e : this.map.entrySet()) {
            String k = e.getKey();
            if (!k.startsWith(prefix) || k.length() == prefix.length() || k.charAt(prefix.length()) != this.separator) continue;
            String n = k.substring(prefix.length() + 1);
            int d = n.indexOf(this.separator);
            if (d >= 0) {
                keys.add(n.substring(0, d));
                continue;
            }
            keys.add(n);
        }
        return keys;
    }

    public NStringMap<V> putAll(String prefix, Map<String, V> values) {
        NAssert.requireNonNull(prefix, "prefix");
        NAssert.requireNonNull(values, "values");
        for (Map.Entry<String, V> e : values.entrySet()) {
            String k = e.getKey();
            this.map.put(this.keyOf(prefix, k), e.getValue());
        }
        return this;
    }

    private String keyOf(String prefix, String k) {
        return k.isEmpty() ? prefix : prefix + this.separator + k;
    }

    public NStringMap<V> copy() {
        return new NStringMap<V>(new LinkedHashMap<String, V>(this.map), this.separator);
    }
}

