/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.thevpc.nuts.util.CharPredicate;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class NStringBuilder
implements CharSequence,
NBlankable {
    private StringBuilder data;

    public NStringBuilder() {
        this.data = new StringBuilder();
    }

    public NStringBuilder(String value) {
        this.data = new StringBuilder(value == null ? "" : value);
    }

    public NStringBuilder(CharSequence value) {
        this.data = value == null ? new StringBuilder() : new StringBuilder(value);
    }

    public NStringBuilder(int capacity) {
        this.data = new StringBuilder(capacity);
    }

    public NStringBuilder append(String value) {
        this.data.append(value);
        return this;
    }

    public NStringBuilder append(Object value) {
        this.data.append(value);
        return this;
    }

    public NStringBuilder append(int value) {
        this.data.append(value);
        return this;
    }

    public NStringBuilder append(boolean value) {
        this.data.append(value);
        return this;
    }

    public NStringBuilder append(byte value) {
        this.data.append(value);
        return this;
    }

    public NStringBuilder append(short value) {
        this.data.append(value);
        return this;
    }

    public NStringBuilder append(float value) {
        this.data.append(value);
        return this;
    }

    public NStringBuilder append(double value) {
        this.data.append(value);
        return this;
    }

    public NStringBuilder append(char value) {
        this.data.append(value);
        return this;
    }

    public NStringBuilder insert(int offset, String value) {
        this.data.insert(offset, value);
        return this;
    }

    public NStringBuilder insert(int offset, Object value) {
        this.data.insert(offset, value);
        return this;
    }

    public NStringBuilder insert(int offset, int value) {
        this.data.insert(offset, value);
        return this;
    }

    public NStringBuilder insert(int offset, boolean value) {
        this.data.insert(offset, value);
        return this;
    }

    public NStringBuilder insert(int offset, byte value) {
        this.data.insert(offset, value);
        return this;
    }

    public NStringBuilder insert(int offset, short value) {
        this.data.insert(offset, value);
        return this;
    }

    public NStringBuilder insert(int offset, float value) {
        this.data.insert(offset, value);
        return this;
    }

    public NStringBuilder insert(int offset, double value) {
        this.data.insert(offset, value);
        return this;
    }

    public NStringBuilder insert(int offset, char value) {
        this.data.insert(offset, value);
        return this;
    }

    public NStringBuilder insertFirst(Object value) {
        this.data.insert(0, value);
        return this;
    }

    public NStringBuilder insertFirst(int value) {
        this.data.insert(0, value);
        return this;
    }

    public NStringBuilder insertFirst(boolean value) {
        this.data.insert(0, value);
        return this;
    }

    public NStringBuilder insertFirst(byte value) {
        this.data.insert(0, value);
        return this;
    }

    public NStringBuilder insertFirst(short value) {
        this.data.insert(0, value);
        return this;
    }

    public NStringBuilder insertFirst(float value) {
        this.data.insert(0, value);
        return this;
    }

    public NStringBuilder insertFirst(double value) {
        this.data.insert(0, value);
        return this;
    }

    public NStringBuilder insertFirst(char value) {
        this.data.insert(0, value);
        return this;
    }

    @Override
    public int length() {
        return this.data.length();
    }

    @Override
    public boolean isEmpty() {
        return this.data.length() == 0;
    }

    private int wiseIndex(int index, int length) {
        int rIndex;
        if (index < 0 && (rIndex = length + index) >= 0 && rIndex < length) {
            return rIndex;
        }
        return index;
    }

    private int wiseIndex(int index) {
        return this.wiseIndex(index, this.data.length());
    }

    private int wiseIndexOther(int index, CharSequence other) {
        return this.wiseIndex(index, other.length());
    }

    private int wiseIndexOther(int index, char[] other) {
        return this.wiseIndex(index, other.length);
    }

    private int wiseIndexOther(int index, byte[] other) {
        return this.wiseIndex(index, other.length);
    }

    @Override
    public char charAt(int index) {
        return this.data.charAt(this.wiseIndex(index));
    }

    public int indexOf(String str) {
        return this.data.indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this.data.indexOf(str, this.wiseIndex(fromIndex));
    }

    public int lastIndexOf(String str) {
        return this.data.lastIndexOf(str);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.data.lastIndexOf(str, this.wiseIndex(fromIndex));
    }

    public int indexOf(CharSequence str) {
        return this.data.indexOf(str.toString());
    }

    public int indexOf(CharSequence str, int fromIndex) {
        return this.data.indexOf(str.toString(), this.wiseIndex(fromIndex));
    }

    public int lastIndexOf(CharSequence str) {
        return this.data.lastIndexOf(str.toString());
    }

    public int lastIndexOf(CharSequence str, int fromIndex) {
        return this.data.lastIndexOf(str.toString(), fromIndex);
    }

    public int indexOf(char[] str) {
        return this.data.indexOf(new String(str));
    }

    public int indexOf(char[] str, int fromIndex) {
        return this.data.indexOf(new String(str), this.wiseIndex(fromIndex));
    }

    public int lastIndexOf(char[] str) {
        return this.data.lastIndexOf(new String(str));
    }

    public int lastIndexOf(char[] str, int fromIndex) {
        return this.data.lastIndexOf(new String(str), this.wiseIndex(fromIndex));
    }

    public NStringBuilder println(Object str) {
        return this.println(String.valueOf(str));
    }

    public NStringBuilder println() {
        this.newLine();
        return this;
    }

    public NStringBuilder println(String str) {
        this.append(str);
        this.newLine();
        return this;
    }

    public NStringBuilder replace(int start, int end, String str) {
        this.data.replace(this.wiseIndex(start), this.wiseIndex(end), str);
        return this;
    }

    @Override
    public boolean isBlank() {
        return NBlankable.isBlank(this.data.toString());
    }

    public NStringBuilder reverse() {
        this.data.reverse();
        return this;
    }

    public NStringBuilder clear() {
        this.data.setLength(0);
        return this;
    }

    public NStringBuilder deleteCharAt(int index) {
        this.data.deleteCharAt(this.wiseIndex(index));
        return this;
    }

    public NStringBuilder delete(int start, int end) {
        this.data.delete(this.wiseIndex(start), this.wiseIndex(end));
        return this;
    }

    public char get(int index) {
        return this.data.charAt(this.wiseIndex(index));
    }

    public char getFirst() {
        return this.data.charAt(0);
    }

    public char getLast() {
        return this.data.charAt(this.data.length());
    }

    public char removeFirst() {
        char c = this.data.charAt(0);
        this.data.deleteCharAt(0);
        return c;
    }

    public char removeLast() {
        int len = this.data.length();
        char c = this.data.charAt(len - 1);
        this.data.deleteCharAt(len - 1);
        return c;
    }

    public String build() {
        return this.data.toString();
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public char[] toCharArray() {
        int length = this.length();
        char[] c = new char[length];
        this.data.getChars(0, length, c, 0);
        return c;
    }

    public NStringBuilder copy() {
        return new NStringBuilder().append(this.data);
    }

    public NStringBuilder trim() {
        int st;
        int len0;
        int len = len0 = this.length();
        char[] val = this.toString().toCharArray();
        for (st = 0; st < len && val[st] <= ' '; ++st) {
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        if (st > 0 || len < len0) {
            String v = this.data.substring(st, len);
            this.setContent(v);
        }
        return this;
    }

    public String substring(int start, int end) {
        return this.data.substring(this.wiseIndex(start), this.wiseIndex(end));
    }

    public String head(int size) {
        return this.data.substring(0, size);
    }

    public String tail(int size) {
        int length = this.data.length();
        return this.data.substring(length - size, length);
    }

    public boolean startsWith(String other) {
        int olength = other.length();
        return this.length() > olength && this.subSequence(0, olength).equals(other);
    }

    public boolean startsWith(String other, int toffset) {
        toffset = this.wiseIndex(toffset);
        int olength = other.length();
        int length = this.length() - toffset;
        return length >= olength && this.subSequence(toffset, toffset + olength).equals(other);
    }

    public boolean startWith(char other) {
        int length = this.length();
        return length > 0 && this.charAt(0) == other;
    }

    public boolean contains(char other) {
        return this.indexOf(other) >= 0;
    }

    public int indexOf(char other) {
        return this.data.indexOf(String.valueOf(other));
    }

    public boolean endsWith(char other) {
        int length = this.length();
        return length > 0 && this.charAt(length - 1) == other;
    }

    public boolean endsWith(String other) {
        int olength;
        int length = this.length();
        return length >= (olength = other.length()) && this.subSequence(length - olength, length).equals(other);
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        return this.data.toString().regionMatches(ignoreCase, this.wiseIndex(toffset), other, this.wiseIndexOther(ooffset, other), len);
    }

    public boolean regionMatches(int toffset, String other, int ooffset, int len) {
        return this.data.toString().regionMatches(this.wiseIndex(toffset), other, this.wiseIndexOther(ooffset, other), len);
    }

    public NStringBuilder setUpperCaseAt(int index) {
        index = this.wiseIndex(index);
        this.data.setCharAt(index, Character.toUpperCase(this.data.charAt(index)));
        return this;
    }

    public NStringBuilder setLowerCaseAt(int index) {
        index = this.wiseIndex(index);
        this.data.setCharAt(index, Character.toLowerCase(this.data.charAt(index)));
        return this;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.data.subSequence(this.wiseIndex(start), this.wiseIndex(end));
    }

    @Override
    public IntStream chars() {
        return this.data.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.data.codePoints();
    }

    public NStringBuilder append(CharSequence value) {
        this.data.append(value);
        return this;
    }

    public NStringBuilder insert(int index, CharSequence value) {
        this.data.insert(this.wiseIndex(index), value);
        return this;
    }

    public NStringBuilder insertFirst(CharSequence value) {
        this.data.insert(0, value);
        return this;
    }

    public NStringBuilder append(CharSequence value, int from, int to) {
        this.data.append(value, this.wiseIndexOther(from, value), this.wiseIndexOther(to, value));
        return this;
    }

    public NStringBuilder insert(int index, CharSequence value, int from, int to) {
        this.data.insert(index, value, this.wiseIndexOther(from, value), this.wiseIndexOther(to, value));
        return this;
    }

    public NStringBuilder insertFirst(CharSequence value, int from, int to) {
        this.data.insert(0, value, this.wiseIndexOther(from, value), this.wiseIndexOther(to, value));
        return this;
    }

    public NStringBuilder append(char[] value, int from, int to) {
        this.data.append(value, this.wiseIndexOther(from, value), this.wiseIndexOther(to, value));
        return this;
    }

    public NStringBuilder insert(int index, char[] value, int from, int to) {
        this.data.insert(this.wiseIndex(index), value, this.wiseIndexOther(from, value), this.wiseIndexOther(to, value));
        return this;
    }

    public NStringBuilder insertFirst(char[] value, int from, int to) {
        this.data.insert(0, value, this.wiseIndexOther(from, value), this.wiseIndexOther(to, value));
        return this;
    }

    public NStringBuilder append(StringBuilder value, int from, int to) {
        this.data.append(value, this.wiseIndexOther(from, value), this.wiseIndexOther(to, value));
        return this;
    }

    public NStringBuilder insert(int index, StringBuilder value, int from, int to) {
        this.data.insert(this.wiseIndex(index), value, this.wiseIndexOther(from, value), this.wiseIndexOther(to, value));
        return this;
    }

    public NStringBuilder insertFirst(StringBuilder value, int from, int to) {
        this.data.insert(0, value, this.wiseIndexOther(from, value), this.wiseIndexOther(to, value));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NStringBuilder that = (NStringBuilder)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public int indexOf(int ch, int fromIndex) {
        return this.data.indexOf(String.valueOf(ch), this.wiseIndex(fromIndex));
    }

    public int lastIndexOf(int ch, int fromIndex) {
        return this.data.lastIndexOf(String.valueOf(ch), this.wiseIndex(fromIndex));
    }

    public int codePointAt(int index) {
        return this.data.codePointAt(this.wiseIndex(index));
    }

    public int codePointBefore(int index) {
        return this.data.codePointBefore(this.wiseIndex(index));
    }

    public int codePointCount(int begin, int end) {
        return this.data.codePointCount(this.wiseIndex(begin), this.wiseIndex(end));
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return this.data.offsetByCodePoints(this.wiseIndex(index), codePointOffset);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.data.getChars(this.wiseIndex(srcBegin), this.wiseIndex(srcEnd), dst, this.wiseIndexOther(dstBegin, dst));
    }

    public void setCharAt(int index, char ch) {
        this.data.setCharAt(this.wiseIndex(index), ch);
    }

    public String substring(int start) {
        return this.data.substring(this.wiseIndex(start));
    }

    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        this.data.toString().getBytes(this.wiseIndex(srcBegin), this.wiseIndex(srcEnd), dst, this.wiseIndexOther(dstBegin, dst));
    }

    public byte[] getBytes(String charsetName) {
        try {
            return this.data.toString().getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] getBytes() {
        return this.data.toString().getBytes();
    }

    public byte[] getBytes(Charset charset) {
        return this.data.toString().getBytes(charset);
    }

    public boolean contentEquals(StringBuffer sb) {
        return sb != null && this.toString().equals(sb.toString());
    }

    public boolean contentEquals(CharSequence sb) {
        return sb != null && this.toString().equals(sb.toString());
    }

    public boolean contentEquals(String sb) {
        return sb != null && this.toString().equals(sb.toString());
    }

    public boolean contentEquals(char[] chars) {
        return chars != null && this.toString().equals(new String(chars));
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return anotherString != null && this.toString().equals(anotherString);
    }

    public boolean equalsIgnoreCase(CharSequence anotherString) {
        return anotherString != null && this.toString().equals(anotherString.toString());
    }

    public boolean equalsIgnoreCase(char[] anotherString) {
        return anotherString != null && this.toString().equals(new String(anotherString));
    }

    public int compareTo(String anotherString) {
        return anotherString == null ? 1 : this.toString().compareTo(anotherString);
    }

    public int compareTo(char[] anotherString) {
        return anotherString == null ? 1 : this.toString().compareTo(new String(anotherString));
    }

    public int compareTo(CharSequence anotherString) {
        return anotherString == null ? 1 : this.toString().compareTo(anotherString.toString());
    }

    public int compareToIgnoreCase(String anotherString) {
        return anotherString == null ? 1 : this.toString().compareToIgnoreCase(anotherString);
    }

    public int compareToIgnoreCase(char[] anotherString) {
        return anotherString == null ? 1 : this.toString().compareToIgnoreCase(new String(anotherString));
    }

    public int compareToIgnoreCase(CharSequence anotherString) {
        return anotherString == null ? 1 : this.toString().compareToIgnoreCase(anotherString.toString());
    }

    public NStringBuilder replace(char oldChar, char newChar) {
        char[] chars = this.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c != oldChar) continue;
            this.data.setCharAt(i, newChar);
        }
        return this;
    }

    public boolean matches(String regex) {
        return this.toString().matches(regex);
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s) >= 0;
    }

    public boolean contains(char[] s) {
        return this.indexOf(s) >= 0;
    }

    public NStringBuilder replaceFirst(String regex, String replacement) {
        String s = Pattern.compile(regex).matcher(this).replaceFirst(replacement);
        if (!s.equals(this.data.toString())) {
            this.setContent(s);
        }
        return this;
    }

    public NStringBuilder setContent(String s) {
        this.data.setLength(0);
        this.data.append(s);
        return this;
    }

    public NStringBuilder replaceAll(String regex, String replacement) {
        return this.setContent(Pattern.compile(regex).matcher(this).replaceAll(replacement));
    }

    public NStringBuilder replace(CharSequence target, CharSequence replacement) {
        return this.setContent(this.toString().replace(target, replacement));
    }

    public String[] split(String regex, int limit) {
        return this.toString().split(regex, limit);
    }

    public String[] split(String regex) {
        return this.toString().split(regex);
    }

    public NStringBuilder toLowerCase(Locale locale) {
        return this.setContent(this.toString().toLowerCase(locale));
    }

    public NStringBuilder toLowerCase() {
        return this.setContent(this.toString().toLowerCase());
    }

    public NStringBuilder toUpperCase(Locale locale) {
        return this.setContent(this.toString().toUpperCase(locale));
    }

    public NStringBuilder toUpperCase() {
        return this.setContent(this.toString().toUpperCase());
    }

    public NStringBuilder toNameFormat(NNameFormat format) {
        NAssert.requireNonNull(format, "format");
        return this.setContent(format.format(this.toString()));
    }

    public String removeAll() {
        String s = this.data.toString();
        this.data.setLength(0);
        return s;
    }

    public NStringBuilder ensureCapacity(int minimumCapacity) {
        this.data.ensureCapacity(minimumCapacity);
        return this;
    }

    public NStringBuilder trimToSize() {
        this.data.trimToSize();
        return this;
    }

    public NStringBuilder newLine() {
        this.data.append("\n");
        return this;
    }

    public NStringBuilder appendRandom(int count, String patternChars) {
        if (count > 0) {
            NAssert.requireNonNull(patternChars, "patternChars");
            NAssert.requireTrue(!patternChars.isEmpty(), "patternChars.length>0");
            SecureRandom random = new SecureRandom();
            for (int i = 0; i < count; ++i) {
                int randomIndex = random.nextInt(patternChars.length());
                char randomChar = patternChars.charAt(randomIndex);
                this.append(randomChar);
            }
        }
        return this;
    }

    public NStringBuilder indent(String prefix) {
        return this.indent(prefix, false);
    }

    public NStringBuilder indent(String prefix, boolean skipFirstLine) {
        if (prefix == null || prefix.isEmpty()) {
            return this;
        }
        char[] charArray = this.data.toString().toCharArray();
        boolean wasNewLine = true;
        this.data.setLength(0);
        boolean firstLine = true;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\r') {
                if (i + 1 < charArray.length && charArray[i + 1] == '\n') {
                    ++i;
                    this.data.append('\r');
                    this.data.append('\n');
                } else {
                    this.data.append('\r');
                }
                wasNewLine = true;
                firstLine = false;
                continue;
            }
            if (c == '\n') {
                this.data.append('\n');
                wasNewLine = true;
                firstLine = false;
                continue;
            }
            if (!(!wasNewLine || firstLine && skipFirstLine)) {
                this.data.append(prefix);
            }
            this.data.append(c);
            wasNewLine = false;
        }
        return this;
    }

    public NStream<String> lines() {
        final StringBuilder data2 = new StringBuilder(this.data);
        return NStream.ofIterator(new Iterator<String>(){
            String nextLine = null;

            @Override
            public boolean hasNext() {
                if (data2.length() == 0) {
                    return false;
                }
                this.nextLine = NStringUtils.readLine(data2);
                return this.nextLine != null;
            }

            @Override
            public String next() {
                return this.nextLine;
            }
        });
    }

    public String readUntil(CharPredicate predicate) {
        for (int i = 0; i < this.data.length(); ++i) {
            char c = this.data.charAt(i);
            if (!predicate.test(c)) continue;
            String l = this.data.substring(0, i);
            this.data.delete(0, i);
            return l;
        }
        String l = this.data.toString();
        this.data.setLength(0);
        return l;
    }

    public String readWhile(CharPredicate predicate) {
        for (int i = 0; i < this.data.length(); ++i) {
            char c = this.data.charAt(i);
            if (predicate.test(c)) continue;
            String l = this.data.substring(0, i);
            this.data.delete(0, i);
            return l;
        }
        String l = this.data.toString();
        this.data.setLength(0);
        return l;
    }

    public String readLine() {
        return NStringUtils.readLine(this.data);
    }

    public String readCount(int count) {
        if (count <= 0) {
            return "";
        }
        if (this.data.length() <= count) {
            String s = this.data.toString();
            this.data.setLength(0);
            return s;
        }
        String s = this.data.substring(0, count);
        this.data.delete(0, count);
        return s;
    }

    public boolean isMultiLine() {
        return this.lines().count() > 1L;
    }
}

