/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import net.thevpc.nuts.io.NIOException;

public class NStreamTokenizer {
    private static final int NEED_CHAR = Integer.MAX_VALUE;
    private static final int SKIP_LF = 0x7FFFFFFE;
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_DIGIT = 2;
    private static final byte CT_ALPHA = 4;
    private static final byte CT_QUOTE = 8;
    private static final byte CT_COMMENT = 16;
    private final StringBuilder bufImage = new StringBuilder();
    private final byte[] commonCharTypes = new byte[256];
    private final boolean[] parsableTokenTypes = new boolean[256];
    public int ttype = -4;
    public String sval;
    public String image;
    public Number nval;
    public boolean returnComments = true;
    public boolean returnSpaces = true;
    private Reader reader = null;
    private char[] buf = new char[20];
    private int peekc = Integer.MAX_VALUE;
    private int c;
    private int ctype;
    private boolean pushedBack;
    private boolean forceLower;
    private int LINENO = 1;
    private boolean eolIsSignificantP = false;

    private NStreamTokenizer() {
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.quoteChar(34);
        this.quoteChar(39);
        this.quoteChar(96);
        this.parseNumbers(true);
    }

    public NStreamTokenizer(Reader r) {
        this();
        this.reader = r == null ? new StringReader("") : r;
    }

    public NStreamTokenizer(String r) {
        this(new StringReader(r == null ? "" : r));
    }

    public void resetSyntax() {
        int i = this.commonCharTypes.length;
        while (--i >= 0) {
            this.commonCharTypes[i] = 0;
        }
    }

    public void wordChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.commonCharTypes.length) {
            hi = this.commonCharTypes.length - 1;
        }
        while (low <= hi) {
            int n = low++;
            this.commonCharTypes[n] = (byte)(this.commonCharTypes[n] | 4);
        }
    }

    public void wordChar(int c) {
        int n = c;
        this.commonCharTypes[n] = (byte)(this.commonCharTypes[n] | 4);
    }

    public void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.commonCharTypes.length) {
            hi = this.commonCharTypes.length - 1;
        }
        while (low <= hi) {
            this.commonCharTypes[low++] = 1;
        }
    }

    public void ordinaryChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.commonCharTypes.length) {
            hi = this.commonCharTypes.length - 1;
        }
        while (low <= hi) {
            this.commonCharTypes[low++] = 0;
        }
    }

    public void ordinaryChar(int ch) {
        if (ch >= 0 && ch < this.commonCharTypes.length) {
            this.commonCharTypes[ch] = 0;
        }
    }

    public void commentChar(int ch) {
        if (ch >= 0 && ch < this.commonCharTypes.length) {
            this.commonCharTypes[ch] = 16;
        }
    }

    public void quoteChar(int ch) {
        if (ch >= 0 && ch < this.commonCharTypes.length) {
            this.commonCharTypes[ch] = 8;
        }
    }

    public void parseNumbers(boolean parse) {
        if (parse) {
            int i = 48;
            while (i <= 57) {
                int n = i++;
                this.commonCharTypes[n] = (byte)(this.commonCharTypes[n] | 2);
            }
            this.commonCharTypes[46] = (byte)(this.commonCharTypes[46] | 2);
            this.commonCharTypes[45] = (byte)(this.commonCharTypes[45] | 2);
        } else {
            int i = 48;
            while (i <= 57) {
                int n = i++;
                this.commonCharTypes[n] = (byte)(this.commonCharTypes[n] & 0xFFFFFFFD);
            }
            this.commonCharTypes[46] = (byte)(this.commonCharTypes[46] & 0xFFFFFFFD);
            this.commonCharTypes[45] = (byte)(this.commonCharTypes[45] & 0xFFFFFFFD);
        }
    }

    public boolean isParsable(int tt) {
        return tt <= 0 && tt > -this.parsableTokenTypes.length && this.parsableTokenTypes[-tt];
    }

    public void parseOperators(boolean parse) {
        this.parsableTokenTypes[40] = parse;
        this.parsableTokenTypes[41] = parse;
        this.parsableTokenTypes[42] = parse;
        this.parsableTokenTypes[43] = parse;
        this.parsableTokenTypes[44] = parse;
        this.parsableTokenTypes[45] = parse;
        this.parsableTokenTypes[46] = parse;
        this.parsableTokenTypes[47] = parse;
        this.parsableTokenTypes[48] = parse;
        this.parsableTokenTypes[49] = parse;
        this.parsableTokenTypes[79] = parse;
        this.parsableTokenTypes[50] = parse;
        this.parsableTokenTypes[51] = parse;
        this.parsableTokenTypes[52] = parse;
        this.parsableTokenTypes[62] = parse;
        this.parsableTokenTypes[63] = parse;
        this.parsableTokenTypes[61] = parse;
        this.parsableTokenTypes[64] = parse;
        this.parsableTokenTypes[65] = parse;
        this.parsableTokenTypes[66] = parse;
        this.parsableTokenTypes[67] = parse;
        this.parsableTokenTypes[68] = parse;
        this.parsableTokenTypes[69] = parse;
        this.parsableTokenTypes[70] = parse;
        this.parsableTokenTypes[71] = parse;
        this.parsableTokenTypes[72] = parse;
    }

    public void doNotParseNumbers() {
    }

    public void acceptTokenType(int tt) {
        this.acceptTokenType(tt, true);
    }

    public void acceptTokenType(int tt, boolean b) {
        if (tt <= 0 && tt > -this.parsableTokenTypes.length) {
            this.parsableTokenTypes[-tt] = b;
            return;
        }
        throw new IllegalArgumentException("unsupported");
    }

    public void eolIsSignificant(boolean flag) {
        this.eolIsSignificantP = flag;
    }

    public void slashStarComments(boolean flag) {
        this.acceptTokenType(-59, flag);
    }

    public void slashSlashComments(boolean flag) {
        this.acceptTokenType(-57, flag);
    }

    public NStreamTokenizer xmlComments(boolean flag) {
        this.acceptTokenType(-60, flag);
        this.slashSlashComments(false);
        this.slashStarComments(false);
        return this;
    }

    public NStreamTokenizer javaComments() {
        this.commentChar(47);
        this.slashSlashComments(true);
        this.slashStarComments(true);
        return this;
    }

    public NStreamTokenizer pythonComments() {
        this.acceptTokenType(-58, true);
        this.commentChar(35);
        this.slashSlashComments(false);
        this.slashStarComments(false);
        return this;
    }

    public void lowerCaseMode(boolean fl) {
        this.forceLower = fl;
    }

    private int readChar() {
        try {
            return this.reader.read();
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    private void markChar(int count) {
        try {
            this.reader.mark(count);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    private void resetChar() {
        try {
            this.reader.reset();
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public boolean hasNext() {
        if (this.pushedBack) {
            return true;
        }
        this.markChar(1);
        this.c = this.readChar();
        if (this.c < 0) {
            return false;
        }
        this.resetChar();
        return true;
    }

    public int nextToken() {
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.ttype;
        }
        byte[] ct = this.commonCharTypes;
        this.image = null;
        this.sval = null;
        this.c = this.peekc;
        if (this.c < 0) {
            this.c = Integer.MAX_VALUE;
        }
        if (this.c == 0x7FFFFFFE) {
            this.c = this.readChar();
            if (this.c < 0) {
                this.ttype = -1;
                return -1;
            }
            if (this.c == 10) {
                this.c = Integer.MAX_VALUE;
            }
        }
        if (this.c == Integer.MAX_VALUE) {
            this.c = this.readChar();
            if (this.c < 0) {
                this.ttype = -1;
                return -1;
            }
        }
        this.ttype = this.c;
        this.peekc = Integer.MAX_VALUE;
        this.ctype = this.c < 256 ? ct[this.c] : 4;
        this.bufImage.setLength(0);
        if (this._read_spaces()) {
            return this.ttype;
        }
        if (this._read_number()) {
            return this.ttype;
        }
        if (this._read_word()) {
            return this.ttype;
        }
        if (this._read_string()) {
            return this.ttype;
        }
        if (this._read_slashComments()) {
            return this.ttype;
        }
        if (this._read_xmlComments()) {
            return this.ttype;
        }
        if ((this.ctype & 0x10) != 0) {
            StringBuilder sb = new StringBuilder();
            while ((this.c = this.readChar()) != 10 && this.c != 13 && this.c >= 0) {
                sb.append((char)this.c);
            }
            this.peekc = this.c;
            return this.nextToken();
        }
        switch (this.c) {
            case 38: {
                if (!this.isParsable(-40)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 38) {
                    this.image = "&&";
                    this.ttype = -40;
                    return -40;
                }
                this.resetChar();
                break;
            }
            case 124: {
                if (this.isParsable(-41)) {
                    this.markChar(1);
                    int n = this.readChar();
                    if (n < 0) break;
                    if (n == 124) {
                        this.image = "||";
                        this.ttype = -41;
                        return -41;
                    }
                    this.resetChar();
                    break;
                }
                this.image = String.valueOf((char)this.c);
                this.ttype = this.c;
                return this.ttype;
            }
            case 60: {
                if (!this.isParsable(-44) && !this.isParsable(-42) && !this.isParsable(-46) && !this.isParsable(-48)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 60 && (this.isParsable(-44) || this.isParsable(-42))) {
                    this.markChar(1);
                    int n2 = this.readChar();
                    if (n2 == 60 && this.isParsable(-44)) {
                        this.image = "<<<";
                        this.ttype = -44;
                        return -44;
                    }
                    if (this.isParsable(-42)) {
                        this.resetChar();
                        this.image = "<<";
                        this.ttype = -42;
                        return -42;
                    }
                    this.resetChar();
                    break;
                }
                if (n == 61 && this.isParsable(-46)) {
                    this.image = "<=";
                    this.ttype = -46;
                    return -46;
                }
                if (n == 62 && this.isParsable(-48)) {
                    this.image = "<>";
                    this.ttype = -48;
                    return -48;
                }
                this.resetChar();
                break;
            }
            case 62: {
                if (!this.isParsable(-45) && !this.isParsable(-43) && !this.isParsable(-47)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 62 && (this.isParsable(-45) || this.isParsable(-43))) {
                    this.markChar(1);
                    int n2 = this.readChar();
                    if (n2 == 62 && this.isParsable(-45)) {
                        this.image = ">>>";
                        this.ttype = -45;
                        return -45;
                    }
                    if (this.isParsable(-43)) {
                        this.resetChar();
                        this.image = ">>";
                        this.ttype = -43;
                        return -43;
                    }
                    this.resetChar();
                    break;
                }
                if (n == 61 && this.isParsable(-47)) {
                    this.image = ">=";
                    this.ttype = -47;
                    return -47;
                }
                this.resetChar();
                break;
            }
            case 61: {
                if (!this.isParsable(-52) && !this.isParsable(-49) && !this.isParsable(-79)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 62 && this.isParsable(-52)) {
                    this.resetChar();
                    this.image = "=>";
                    this.ttype = -52;
                    return -52;
                }
                if (n == 61 && (this.isParsable(-49) || this.isParsable(-79))) {
                    this.markChar(1);
                    int n2 = this.readChar();
                    if (n2 == 61 && this.isParsable(-79)) {
                        this.image = "===";
                        this.ttype = -79;
                        return -79;
                    }
                    if (this.isParsable(-49)) {
                        this.image = "==";
                        this.ttype = -49;
                        return -49;
                    }
                    this.resetChar();
                    break;
                }
                this.resetChar();
                break;
            }
            case 33: {
                if (!this.isParsable(-51) && !this.isParsable(-50)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 61) {
                    if (this.isParsable(-51)) {
                        this.markChar(1);
                        int n2 = this.readChar();
                        if (n2 == 61) {
                            this.image = "!==";
                            this.ttype = -51;
                            return -51;
                        }
                        this.resetChar();
                        this.image = "!=";
                        this.ttype = -50;
                        return -50;
                    }
                    this.image = "!=";
                    this.ttype = -50;
                    return -50;
                }
                this.resetChar();
                break;
            }
            case 43: {
                if (!this.isParsable(-62) && !this.isParsable(-68)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 43) {
                    if (this.isParsable(-62)) {
                        this.image = "++";
                        this.ttype = -62;
                        return -62;
                    }
                    this.image = "+";
                    this.ttype = 43;
                    return 43;
                }
                if (n == 61) {
                    if (this.isParsable(-62)) {
                        this.image = "+=";
                        this.ttype = -62;
                        return -62;
                    }
                    this.image = "+";
                    this.ttype = 43;
                    return 43;
                }
                this.image = "+";
                this.resetChar();
                break;
            }
            case 45: {
                if (!this.isParsable(-63) && !this.isParsable(-69)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 45) {
                    if (this.isParsable(-63)) {
                        this.image = "--";
                        this.ttype = -63;
                        return -63;
                    }
                    this.image = "-";
                    this.ttype = 45;
                    return 45;
                }
                if (n == 61) {
                    if (this.isParsable(-69)) {
                        this.image = "-=";
                        this.ttype = -69;
                        return -69;
                    }
                    this.image = "-";
                    this.ttype = 45;
                    return 45;
                }
                this.image = "-";
                this.resetChar();
                break;
            }
            case 42: {
                if (!this.isParsable(-61) && !this.isParsable(-67)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 42) {
                    if (this.isParsable(-61)) {
                        this.image = "**";
                        this.ttype = -61;
                        return -61;
                    }
                    this.image = "*";
                    this.ttype = 42;
                    return 42;
                }
                if (n == 61) {
                    if (this.isParsable(-67)) {
                        this.image = "*=";
                        this.ttype = -67;
                        return -67;
                    }
                    this.image = "*";
                    this.ttype = 42;
                    return 42;
                }
                this.image = "*";
                this.resetChar();
                break;
            }
            case 47: {
                if (!this.isParsable(-64) && !this.isParsable(-70)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 47) {
                    if (this.isParsable(-64)) {
                        this.image = "//";
                        this.ttype = -64;
                        return -64;
                    }
                    this.image = "/";
                    this.ttype = 47;
                    return 47;
                }
                if (n == 61) {
                    if (this.isParsable(-70)) {
                        this.image = "/=";
                        this.ttype = -70;
                        return -70;
                    }
                    this.image = "/";
                    this.ttype = 47;
                    return 47;
                }
                this.image = "/";
                this.resetChar();
                break;
            }
            case 94: {
                if (!this.isParsable(-65) && !this.isParsable(-71)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 94) {
                    if (this.isParsable(-65)) {
                        this.image = "^^";
                        this.ttype = -65;
                        return -65;
                    }
                    this.image = "^";
                    this.ttype = 94;
                    return 94;
                }
                if (n == 61) {
                    if (this.isParsable(-71)) {
                        this.image = "^=";
                        this.ttype = -71;
                        return -71;
                    }
                    this.image = "^";
                    this.ttype = 94;
                    return 94;
                }
                this.image = "^";
                this.resetChar();
                break;
            }
            case 37: {
                if (!this.isParsable(-66) && !this.isParsable(-72)) break;
                this.markChar(1);
                int n = this.readChar();
                if (n < 0) break;
                if (n == 37) {
                    if (this.isParsable(-66)) {
                        this.image = "%%";
                        this.ttype = -66;
                        return -66;
                    }
                    this.image = "%";
                    this.ttype = 37;
                    return 37;
                }
                if (n == 61) {
                    if (this.isParsable(-72)) {
                        this.image = "%=";
                        this.ttype = -72;
                        return -72;
                    }
                    this.image = "%";
                    this.ttype = 37;
                    return 37;
                }
                this.image = "%";
                this.resetChar();
            }
        }
        this.image = String.valueOf((char)this.c);
        this.ttype = this.c;
        return this.ttype;
    }

    private boolean _read_word() {
        if ((this.ctype & 4) != 0) {
            int i = 0;
            do {
                if (i >= this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
                }
                this.buf[i++] = (char)this.c;
                this.c = this.readChar();
                int n = this.c < 0 ? 1 : (this.ctype = this.c < 256 ? this.commonCharTypes[this.c] : 4);
            } while ((this.ctype & 6) != 0);
            this.peekc = this.c;
            this.image = this.sval = String.copyValueOf(this.buf, 0, i);
            if (this.forceLower) {
                this.sval = this.sval.toLowerCase();
            }
            this.ttype = -3;
            return true;
        }
        return false;
    }

    private boolean _read_number() {
        if ((this.ctype & 2) != 0) {
            StringBuilder image = new StringBuilder();
            image.append((char)this.c);
            boolean neg = false;
            boolean intType = true;
            if (this.c == 45) {
                this.c = this.readChar();
                image.append((char)this.c);
                if (this.c != 46 && (this.c < 48 || this.c > 57)) {
                    this.peekc = this.c;
                    this.ttype = 45;
                    this.image = "-";
                    return true;
                }
                neg = true;
            }
            double dv = 0.0;
            long iv = 0L;
            int decexp = 0;
            int seendot = 0;
            boolean loop = true;
            if (this.c == 46 && seendot == 0) {
                seendot = 1;
                intType = false;
            } else if (48 <= this.c && this.c <= 57) {
                dv = dv * 10.0 + (double)(this.c - 48);
                iv = iv * 10L + (long)(this.c - 48);
                decexp += seendot;
            } else {
                loop = false;
            }
            if (loop) {
                this.c = this.readChar();
                while (true) {
                    if (this.c == 46 && seendot == 0) {
                        seendot = 1;
                        intType = false;
                        image.append((char)this.c);
                    } else {
                        if (48 > this.c || this.c > 57) break;
                        dv = dv * 10.0 + (double)(this.c - 48);
                        iv = iv * 10L + (long)(this.c - 48);
                        decexp += seendot;
                        image.append((char)this.c);
                    }
                    this.c = this.readChar();
                }
            }
            this.peekc = this.c;
            this.image = image.toString();
            if (intType) {
                try {
                    this.nval = Integer.parseInt(image.toString());
                    this.ttype = -10;
                }
                catch (Exception ex) {
                    try {
                        this.nval = Long.parseLong(image.toString());
                        this.ttype = -11;
                    }
                    catch (Exception ex2) {
                        this.nval = new BigInteger(image.toString());
                        this.ttype = -12;
                    }
                }
                return true;
            }
            try {
                this.nval = Float.valueOf(Float.parseFloat(image.toString()));
                this.ttype = -13;
            }
            catch (Exception ex) {
                try {
                    this.nval = Double.parseDouble(image.toString());
                    this.ttype = -14;
                }
                catch (Exception ex2) {
                    this.nval = new BigDecimal(image.toString());
                    this.ttype = -15;
                }
            }
            return true;
        }
        return false;
    }

    private boolean _read_spaces() {
        while ((this.ctype & 1) != 0) {
            this.bufImage.append((char)this.c);
            if (this.c == 13) {
                ++this.LINENO;
                if (this.eolIsSignificantP) {
                    this.peekc = 0x7FFFFFFE;
                    this.ttype = 10;
                    return true;
                }
                this.c = this.readChar();
                if (this.c == 10) {
                    this.bufImage.append((char)this.c);
                    this.c = this.readChar();
                }
            } else {
                if (this.c == 10) {
                    ++this.LINENO;
                    if (this.eolIsSignificantP) {
                        this.ttype = 10;
                        return true;
                    }
                }
                this.c = this.readChar();
            }
            if (this.bufImage.length() > 0 && this.returnSpaces) {
                this.peekc = this.c;
                this.image = this.bufImage.toString();
                this.ttype = -17;
                return true;
            }
            if (this.c < 0) {
                this.ttype = -1;
                return true;
            }
            this.ctype = this.c < 256 ? this.commonCharTypes[this.c] : 4;
        }
        return false;
    }

    private boolean _read_xmlComments() {
        if (this.c == 60 && this.isParsable(-60)) {
            StringBuilder sb = new StringBuilder();
            sb.append((char)this.c);
            this.markChar(4);
            int a = this.readChar();
            if (a == 33) {
                sb.append((char)this.c);
                a = this.readChar();
                if (a == 45) {
                    sb.append((char)this.c);
                    a = this.readChar();
                    if (a == 45) {
                        sb.append((char)this.c);
                        while (true) {
                            this.c = this.readChar();
                            boolean wasEnd = false;
                            if (this.c == 45) {
                                sb.append((char)this.c);
                                a = this.readChar();
                                if (a == 45 && (a = this.readChar()) == 62) {
                                    wasEnd = true;
                                }
                                if (wasEnd) break;
                                this.resetChar();
                                continue;
                            }
                            sb.append((char)this.c);
                        }
                        sb.append("->");
                        if (this.returnComments) {
                            this.image = sb.toString();
                            this.ttype = -16;
                            return true;
                        }
                        this.nextToken();
                        return true;
                    }
                }
            }
            this.resetChar();
        }
        return false;
    }

    private boolean _read_slashComments() {
        boolean slashStarCommentsP = this.isParsable(-59);
        boolean slashSlashCommentsP = this.isParsable(-57);
        if (this.c == 47 && (slashSlashCommentsP || slashStarCommentsP)) {
            StringBuilder sb = new StringBuilder();
            sb.append((char)this.c);
            this.c = this.readChar();
            if (this.c == 42 && slashStarCommentsP) {
                sb.append((char)this.c);
                int prevc = 0;
                while ((this.c = this.readChar()) != 47 || prevc != 42) {
                    if (this.c == 13) {
                        sb.append((char)this.c);
                        ++this.LINENO;
                        this.c = this.readChar();
                        if (this.c == 10) {
                            sb.append((char)this.c);
                            this.c = this.readChar();
                        }
                    } else if (this.c == 10) {
                        ++this.LINENO;
                        sb.append((char)this.c);
                        this.c = this.readChar();
                    }
                    if (this.c < 0) {
                        this.ttype = -1;
                        return true;
                    }
                    prevc = this.c;
                }
                if (this.returnComments) {
                    this.image = sb.toString();
                    this.ttype = -16;
                    return true;
                }
                this.ttype = this.nextToken();
                return true;
            }
            if (this.c == 47 && slashSlashCommentsP) {
                sb.append((char)this.c);
                while ((this.c = this.readChar()) != 10 && this.c != 13 && this.c >= 0) {
                    sb.append((char)this.c);
                }
                this.peekc = this.c;
                if (this.returnComments) {
                    this.image = sb.toString();
                    this.ttype = -16;
                    return true;
                }
                this.ctype = this.nextToken();
                return true;
            }
            if ((this.commonCharTypes[47] & 0x10) != 0) {
                sb.append((char)this.c);
                while ((this.c = this.readChar()) != 10 && this.c != 13 && this.c >= 0) {
                    sb.append((char)this.c);
                }
                if (this.returnComments) {
                    this.image = sb.toString();
                    this.ttype = -16;
                    return true;
                }
                this.peekc = this.c;
                this.nextToken();
                return true;
            }
            this.peekc = this.c;
            this.ttype = 47;
            return true;
        }
        return false;
    }

    private boolean _read_string() {
        boolean interpolatedString = false;
        if (this.c == 36) {
            int ctype2;
            this.markChar(1);
            this.c = this.readChar();
            int n = ctype2 = this.c < 256 ? this.commonCharTypes[this.c] : 4;
            if ((ctype2 & 8) != 0) {
                this.ctype = ctype2;
                interpolatedString = true;
            } else {
                this.resetChar();
                return false;
            }
        }
        if ((this.ctype & 8) != 0) {
            this.bufImage.setLength(0);
            if (interpolatedString) {
                switch (this.c) {
                    case 34: {
                        this.ttype = -73;
                        break;
                    }
                    case 39: {
                        this.ttype = -74;
                        break;
                    }
                    case 96: {
                        this.ttype = -75;
                    }
                }
                this.bufImage.append('$');
            } else {
                this.ttype = this.c;
            }
            this.bufImage.append((char)this.c);
            int i = 0;
            int c0 = this.c;
            int d = this.readChar();
            while (d >= 0 && d != c0 && d != 10 && d != 13) {
                this.bufImage.append((char)d);
                if (d == 92) {
                    int first = this.c = this.readChar();
                    if (this.c >= 48 && this.c <= 55) {
                        this.bufImage.append((char)d);
                        this.c -= 48;
                        int c2 = this.readChar();
                        if (48 <= c2 && c2 <= 55) {
                            this.bufImage.append((char)d);
                            this.c = (this.c << 3) + (c2 - 48);
                            c2 = this.readChar();
                            this.bufImage.append((char)d);
                            if (48 <= c2 && c2 <= 55 && first <= 51) {
                                this.c = (this.c << 3) + (c2 - 48);
                                d = this.readChar();
                            } else {
                                d = c2;
                            }
                        } else {
                            d = c2;
                        }
                    } else {
                        this.bufImage.append((char)d);
                        switch (this.c) {
                            case 97: {
                                this.c = 7;
                                break;
                            }
                            case 98: {
                                this.c = 8;
                                break;
                            }
                            case 102: {
                                this.c = 12;
                                break;
                            }
                            case 110: {
                                this.c = 10;
                                break;
                            }
                            case 114: {
                                this.c = 13;
                                break;
                            }
                            case 116: {
                                this.c = 9;
                                break;
                            }
                            case 118: {
                                this.c = 11;
                            }
                        }
                        d = this.readChar();
                    }
                } else {
                    this.c = d;
                    d = this.readChar();
                }
                if (i >= this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
                }
                this.buf[i++] = (char)this.c;
            }
            int n = this.peekc = d == c0 ? Integer.MAX_VALUE : d;
            if (d == c0) {
                this.bufImage.append((char)d);
            }
            this.sval = String.copyValueOf(this.buf, 0, i);
            this.image = this.bufImage.toString();
            return true;
        }
        return false;
    }

    public void pushBack() {
        if (this.ttype != -4) {
            this.pushedBack = true;
        }
    }

    public int lineno() {
        return this.LINENO;
    }

    public String toString() {
        String ret;
        switch (this.ttype) {
            case -1: {
                ret = "EOF";
                break;
            }
            case 10: {
                ret = "EOL";
                break;
            }
            case -3: {
                ret = this.sval;
                break;
            }
            case -10: {
                ret = "I=" + this.nval;
                break;
            }
            case -11: {
                ret = "L=" + this.nval;
                break;
            }
            case -12: {
                ret = "BI=" + this.nval;
                break;
            }
            case -13: {
                ret = "F=" + this.nval;
                break;
            }
            case -14: {
                ret = "D=" + this.nval;
                break;
            }
            case -15: {
                ret = "BD=" + this.nval;
                break;
            }
            case -4: {
                ret = "NOTHING";
                break;
            }
            default: {
                if (this.ttype < 256 && (this.commonCharTypes[this.ttype] & 8) != 0) {
                    ret = this.sval;
                    break;
                }
                char[] s = new char[3];
                s[2] = 39;
                s[0] = 39;
                s[1] = (char)this.ttype;
                ret = new String(s);
                break;
            }
        }
        return "NToken[" + ret + "], line " + this.LINENO;
    }
}

