/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementRedescribable;
import net.thevpc.nuts.internal.rpi.NCollectionsRPI;
import net.thevpc.nuts.util.NComparator;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.UnsafeFunction;

public interface NStream<T>
extends Iterable<T>,
NElementRedescribable<NStream<T>>,
AutoCloseable {
    public static <T> NStream<T> ofArray(T ... str) {
        return NCollectionsRPI.of().arrayToStream(str);
    }

    public static <T> NStream<T> ofArray(int ... items) {
        return (NStream)NStream.ofStream(Stream.of(items)).redescribe(() -> NElement.ofIntArray(items));
    }

    public static <T> NStream<T> ofArray(long ... items) {
        return (NStream)NStream.ofStream(Stream.of(items)).redescribe(() -> NElement.ofLongArray(items));
    }

    public static <T> NStream<T> ofArray(boolean ... items) {
        return (NStream)NStream.ofStream(Stream.of(items)).redescribe(() -> NElement.ofBooleanArray(items));
    }

    public static <T> NStream<T> ofArray(byte ... items) {
        return (NStream)NStream.ofStream(Stream.of(items)).redescribe(() -> NElement.ofByteArray(items));
    }

    public static <T> NStream<T> ofArray(short ... items) {
        return (NStream)NStream.ofStream(Stream.of(items)).redescribe(() -> NElement.ofShortArray(items));
    }

    public static <T> NStream<T> ofArray(float ... items) {
        return (NStream)NStream.ofStream(Stream.of(items)).redescribe(() -> NElement.ofFloatArray(items));
    }

    public static <T> NStream<T> ofArray(double ... items) {
        return (NStream)NStream.ofStream(Stream.of(items)).redescribe(() -> NElement.ofDoubleArray(items));
    }

    public static <T> NStream<T> ofOptional(NOptional<T> str) {
        return NCollectionsRPI.of().optionalToStream(str);
    }

    public static <T> NStream<T> ofOptional(Optional<T> str) {
        return NCollectionsRPI.of().optionalToStream(str);
    }

    public static <T> NStream<T> ofIterable(Iterable<T> str) {
        return NCollectionsRPI.of().iterableToStream(str);
    }

    public static <T> NStream<T> ofIterator(Iterator<T> str) {
        return NCollectionsRPI.of().iteratorToStream(str);
    }

    public static <T> NStream<T> ofStream(Stream<T> str) {
        return NCollectionsRPI.of().toStream(str);
    }

    public static <T> NStream<T> ofEmpty() {
        return NCollectionsRPI.of().emptyStream();
    }

    public static <T> NStream<T> ofSingleton(T element) {
        return NStream.ofIterable(Arrays.asList(element));
    }

    public List<T> toList();

    public Set<T> toSet();

    public Set<T> toSortedSet();

    public Set<T> toOrderedSet();

    public NOptional<T> findLast();

    public NOptional<T> findSingleton();

    public Stream<T> stream();

    public NStream<T> skip(long var1);

    public long count();

    public <R> NStream<R> map(Function<? super T, ? extends R> var1);

    public <R> NStream<R> mapUnsafe(UnsafeFunction<? super T, ? extends R> var1);

    public <R> NStream<R> mapUnsafe(UnsafeFunction<? super T, ? extends R> var1, Function<Exception, ? extends R> var2);

    public <V> NStream<V> instanceOf(Class<V> var1);

    public NStream<T> sorted();

    public NStream<T> sorted(NComparator<T> var1);

    public NStream<T> distinct();

    public <R> NStream<T> distinctBy(Function<T, R> var1);

    public NStream<T> nonNull();

    public NStream<T> nonBlank();

    public NStream<T> filter(Predicate<? super T> var1);

    public NStream<T> filterNonNull();

    public NStream<T> filterNonBlank();

    public NStream<T> concat(NIterator<? extends T> var1);

    public NStream<T> coalesce(NIterator<? extends T> var1);

    public NStream<T> concat(NStream<? extends T> var1);

    public NStream<T> coalesce(NStream<? extends T> var1);

    public boolean[] toBooleanArray();

    public byte[] toByteArray();

    public char[] toCharArray();

    public short[] toShortArray();

    public float[] toFloatArray();

    public int[] toIntArray();

    public long[] toLongArray();

    public double[] toDoubleArray();

    public IntStream mapToInt(ToIntFunction<? super T> var1);

    public LongStream mapToLong(ToLongFunction<? super T> var1);

    public DoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    public <A> A[] toArray(IntFunction<A[]> var1);

    public <K, U> Map<K, U> toMap(Function<? super T, ? extends K> var1, Function<? super T, ? extends U> var2);

    public <K, U> Map<K, U> toOrderedMap(Function<? super T, ? extends K> var1, Function<? super T, ? extends U> var2);

    public <K, U> Map<K, U> toSortedMap(Function<? super T, ? extends K> var1, Function<? super T, ? extends U> var2);

    public <R> NStream<R> flatMapIter(Function<? super T, ? extends Iterator<? extends R>> var1);

    public <R> NStream<R> flatMapList(Function<? super T, ? extends List<? extends R>> var1);

    public <R> NStream<R> flatMapArray(Function<? super T, ? extends R[]> var1);

    public <R> NStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    public <R> NStream<R> flatMapStream(Function<? super T, ? extends NStream<? extends R>> var1);

    public <K> Map<K, List<T>> groupBy(Function<? super T, ? extends K> var1);

    public <K> NStream<Map.Entry<K, List<T>>> groupedBy(Function<? super T, ? extends K> var1);

    public NOptional<T> findAny();

    public NOptional<T> findFirst();

    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    public boolean allMatch(Predicate<? super T> var1);

    public boolean noneMatch(Predicate<? super T> var1);

    public boolean anyMatch(Predicate<? super T> var1);

    public NStream<T> limit(long var1);

    @Override
    public NIterator<T> iterator();

    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    public <R, A> R collect(Collector<? super T, A, R> var1);

    public NOptional<T> min(Comparator<? super T> var1);

    public NOptional<T> max(Comparator<? super T> var1);

    @Override
    public void close();
}

