/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Objects;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NRef;

public class NObjectRef<T>
implements NRef<T> {
    private T value;
    private boolean set;

    public NObjectRef(T value) {
        this.value = value;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public T orElse(T other) {
        if (this.value == null) {
            return other;
        }
        return this.value;
    }

    @Override
    public void setNonNull(T value) {
        if (value != null) {
            this.set(value);
        }
    }

    @Override
    public void set(T value) {
        this.value = value;
        this.set = true;
    }

    @Override
    public void unset() {
        this.value = null;
        this.set = false;
    }

    @Override
    public boolean isNotNull() {
        return this.value != null;
    }

    @Override
    public boolean isBlank() {
        return NBlankable.isBlank(this.value);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null || String.valueOf(this.value).isEmpty();
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isSet() {
        return this.set;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean isValue(Object o) {
        return Objects.equals(this.value, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NObjectRef nRef = (NObjectRef)o;
        return this.set == nRef.set && Objects.equals(this.value, nRef.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.set);
    }
}

