/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.ArrayList;
import net.thevpc.nuts.elem.NMapBy;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NWordFormat;

public class NNameFormat {
    public static final NNameFormat LOWER_CAMEL_CASE = new NNameFormat(NWordFormat.LOWERCASE, NWordFormat.CAPITALIZED, null);
    public static final NNameFormat UPPER_CAMEL_CASE;
    public static final NNameFormat CAMEL_CASE;
    public static final NNameFormat LOWER_KEBAB_CASE;
    public static final NNameFormat UPPER_KEBAB_CASE;
    public static final NNameFormat KEBAB_CASE;
    public static final NNameFormat LOWER_SNAKE_CASE;
    public static final NNameFormat UPPER_SNAKE_CASE;
    public static final NNameFormat SNAKE_CASE;
    public static final NNameFormat LOWER_SPACE_CASE;
    public static final NNameFormat UPPER_SPACE_CASE;
    public static final NNameFormat SPACE_CASE;
    public static final NNameFormat UPPER_TITLE_CASE;
    public static final NNameFormat LOWER_TITLE_CASE;
    public static final NNameFormat TITLE_CASE;
    public static final NNameFormat TITLE_NAME;
    public static final NNameFormat ID_NAME;
    public static final NNameFormat CONST_NAME;
    public static final NNameFormat CLASS_NAME;
    public static final NNameFormat VAR_NAME;
    private NWordFormat leading;
    private NWordFormat next;
    private String sep;

    @NMapBy
    public NNameFormat(@NMapBy(name="leading") NWordFormat leading, @NMapBy(name="next") NWordFormat next, @NMapBy(name="sep") String sep) {
        NAssert.requireNonNull(leading, "leading");
        NAssert.requireNonNull(next, "next");
        this.leading = leading;
        this.next = next;
        this.sep = sep;
    }

    public static boolean equalsIgnoreFormat(String a, String b) {
        int length;
        String[] aa = NNameFormat.parse(NStringUtils.trim(a));
        String[] bb = NNameFormat.parse(NStringUtils.trim(b));
        if (bb.length != (length = aa.length)) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            String o1 = aa[i];
            String o2 = bb[i];
            if (o1 != null ? o1.equalsIgnoreCase(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public NWordFormat getLeading() {
        return this.leading;
    }

    public NWordFormat getNext() {
        return this.next;
    }

    public String getSep() {
        return this.sep;
    }

    public static String[] parse(CharSequence value) {
        return NNameFormat.parse(value, false);
    }

    public static String[] parse(CharSequence value, boolean sep) {
        if (value == null) {
            return new String[]{""};
        }
        return NNameFormat.parse(value.toString(), sep);
    }

    public static String[] parse(String value) {
        return NNameFormat.parse(value, false);
    }

    public static boolean isSeparator(char c) {
        int t = Character.getType(c);
        return NNameFormat.isSeparator(c, t);
    }

    private static boolean isSeparator(char c, int codeType) {
        switch (c) {
            case ' ': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '\\': 
            case '_': {
                return true;
            }
        }
        if (c <= ' ') {
            return true;
        }
        switch (codeType) {
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    public static String[] parse(String value, boolean sep) {
        if (NBlankable.isBlank(value)) {
            return new String[]{""};
        }
        String aValue = value.trim();
        ArrayList<String> all = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean wasSep = true;
        int wasUpper = 2;
        int wasLower = 3;
        int wasOther = 4;
        int was = 1;
        block4: for (char c : aValue.toCharArray()) {
            int t = Character.getType(c);
            if (NNameFormat.isSeparator(c, t)) {
                if (sb.length() > 0) {
                    all.add(sb.toString());
                    sb.setLength(0);
                }
                if (sep) {
                    all.add(String.valueOf(c));
                }
                was = 1;
                continue;
            }
            switch (t) {
                case 1: {
                    if (was == 3 && sb.length() > 0) {
                        all.add(sb.toString());
                        sb.setLength(0);
                    }
                    sb.append(c);
                    was = 2;
                    continue block4;
                }
                case 2: {
                    sb.append(c);
                    was = 3;
                    continue block4;
                }
                default: {
                    was = 4;
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            all.add(sb.toString());
            sb.setLength(0);
        }
        return all.toArray(new String[0]);
    }

    public boolean equals(String a, String b) {
        return this.format(a).equals(this.format(b));
    }

    public String format(String value) {
        return this.format(NNameFormat.parse(value));
    }

    public String format(CharSequence value) {
        return this.format(NNameFormat.parse(value));
    }

    public String format(String[] value) {
        StringBuilder sb = new StringBuilder();
        if (value.length > 0) {
            sb.append(this.leading.formatWord(value[0]));
            for (int i = 1; i < value.length; ++i) {
                if (this.sep != null) {
                    sb.append(this.sep);
                }
                sb.append(this.next.formatWord(value[i]));
            }
        }
        return sb.toString();
    }

    static {
        CAMEL_CASE = UPPER_CAMEL_CASE = new NNameFormat(NWordFormat.CAPITALIZED, NWordFormat.CAPITALIZED, null);
        LOWER_KEBAB_CASE = new NNameFormat(NWordFormat.LOWERCASE, NWordFormat.LOWERCASE, "-");
        UPPER_KEBAB_CASE = new NNameFormat(NWordFormat.UPPERCASE, NWordFormat.UPPERCASE, "-");
        KEBAB_CASE = LOWER_KEBAB_CASE;
        LOWER_SNAKE_CASE = new NNameFormat(NWordFormat.LOWERCASE, NWordFormat.LOWERCASE, "_");
        UPPER_SNAKE_CASE = new NNameFormat(NWordFormat.UPPERCASE, NWordFormat.UPPERCASE, "_");
        SNAKE_CASE = LOWER_SNAKE_CASE;
        LOWER_SPACE_CASE = new NNameFormat(NWordFormat.LOWERCASE, NWordFormat.LOWERCASE, " ");
        UPPER_SPACE_CASE = new NNameFormat(NWordFormat.UPPERCASE, NWordFormat.UPPERCASE, " ");
        SPACE_CASE = LOWER_SPACE_CASE;
        UPPER_TITLE_CASE = new NNameFormat(NWordFormat.CAPITALIZED, NWordFormat.CAPITALIZED, " ");
        LOWER_TITLE_CASE = new NNameFormat(NWordFormat.CAPITALIZED, NWordFormat.LOWERCASE, " ");
        TITLE_NAME = TITLE_CASE = UPPER_TITLE_CASE;
        ID_NAME = LOWER_KEBAB_CASE;
        CONST_NAME = UPPER_SNAKE_CASE;
        CLASS_NAME = UPPER_CAMEL_CASE;
        VAR_NAME = LOWER_CAMEL_CASE;
    }
}

