/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class NListBuilder<T> {
    private List<T> base;
    private boolean ignoreNulls;

    public static NListBuilder of() {
        return new NListBuilder(new ArrayList());
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public NListBuilder<T> setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
        return this;
    }

    public NListBuilder(List<T> base) {
        this.base = base == null ? new ArrayList() : base;
    }

    public NListBuilder<T> add(T t) {
        if (this.ignoreNulls) {
            if (t != null) {
                this.base.add(t);
            }
        } else {
            this.base.add(t);
        }
        return this;
    }

    public NListBuilder<T> addAll(T ... t) {
        if (this.ignoreNulls) {
            if (t != null) {
                for (T t1 : t) {
                    if (t1 == null) continue;
                    this.base.add(t1);
                }
            }
        } else {
            this.base.addAll(Arrays.asList(t));
        }
        return this;
    }

    public NListBuilder<T> addAll(Collection<T> t) {
        if (this.ignoreNulls) {
            if (t != null) {
                for (T t1 : t) {
                    if (t1 == null) continue;
                    this.base.add(t1);
                }
            }
        } else {
            this.base.addAll(t);
        }
        return this;
    }

    public int size() {
        return this.base.size();
    }

    public List<T> build() {
        return this.base;
    }
}

