/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Iterator;
import net.thevpc.nuts.core.NIndexerNotAccessibleException;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIteratorBase;

public class NIndexFirstIterator<T>
extends NIteratorBase<T> {
    private Iterator<T> index;
    private Iterator<T> other;
    private long readFromIndex;
    private T nextItem;
    private boolean hasNextItem;

    public NIndexFirstIterator(Iterator<T> index, Iterator<T> other) {
        this.index = index;
        this.other = other;
    }

    @Override
    public NElement describe() {
        return NElement.ofObjectBuilder().name("IndexFirst").set("index", NElementDescribables.describeResolveOrDestruct(this.index)).set("nonIndex", NElementDescribables.describeResolveOrDestruct(this.other)).build();
    }

    @Override
    public boolean hasNext() {
        if (this.index != null) {
            if (this.readFromIndex == 0L) {
                try {
                    boolean v = this.index.hasNext();
                    if (v) {
                        this.hasNextItem = true;
                        this.nextItem = this.index.next();
                        ++this.readFromIndex;
                    }
                    return v;
                }
                catch (NIndexerNotAccessibleException ex) {
                    this.index = null;
                }
            } else {
                try {
                    if (this.index.hasNext()) {
                        return true;
                    }
                    this.index = null;
                }
                catch (NIndexerNotAccessibleException ex) {
                    NLog.of(NIndexFirstIterator.class).log(NMsg.ofC("error evaluating Iterator 'hasNext()' : %s", ex).asDebug().withThrowable(ex));
                    this.other = null;
                    return false;
                }
            }
        }
        if (this.other != null) {
            return this.other.hasNext();
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNextItem) {
            this.hasNextItem = false;
            T t = this.nextItem;
            this.nextItem = null;
            return t;
        }
        if (this.index != null) {
            return this.index.next();
        }
        return this.other.next();
    }

    @Override
    public void remove() {
        if (this.index != null) {
            this.index.remove();
        } else if (this.other != null) {
            this.other.remove();
        }
    }

    public String toString() {
        return "IndexFirstIterator(" + this.other + ")";
    }
}

