/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.nio.charset.StandardCharsets;

public class NHex {
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
    private static final char[] BASE16_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte toByte(String v) {
        return NHex.toBytes(v, 1)[0];
    }

    public static short toShort(String v) {
        byte[] b = NHex.toBytes(v, 2);
        byte ch1 = b[0];
        byte ch2 = b[1];
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public static int toUShort(String v) {
        byte[] b = NHex.toBytes(v, 2);
        byte ch1 = b[0];
        byte ch2 = b[1];
        return (ch1 << 8) + (ch2 << 0);
    }

    public static int toInt(String v) {
        byte[] b = NHex.toBytes(v, 4);
        byte ch1 = b[0];
        byte ch2 = b[1];
        byte ch3 = b[2];
        byte ch4 = b[3];
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static long toLong(String v) {
        byte[] b = NHex.toBytes(v, 8);
        return ((long)b[0] << 56) + ((long)(b[1] & 0xFF) << 48) + ((long)(b[2] & 0xFF) << 40) + ((long)(b[3] & 0xFF) << 32) + ((long)(b[4] & 0xFF) << 24) + (long)((b[5] & 0xFF) << 16) + (long)((b[6] & 0xFF) << 8) + (long)((b[7] & 0xFF) << 0);
    }

    public static String fromByte(byte a) {
        return NHex.fromBytes(new byte[]{a});
    }

    public static String fromInt(int v) {
        return NHex.fromBytes(new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)});
    }

    public static String fromLong(long v) {
        return NHex.fromBytes(new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)});
    }

    public static String fromShort(short v) {
        return NHex.fromBytes(new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)});
    }

    public static String fromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    public static String fromBytes(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        byte[] hexChars = new byte[length * 2];
        for (int j = offset; j < offset + length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(String s, int size) {
        if (s == null) {
            return null;
        }
        byte[] a = NHex.toBytes(s);
        if (a.length != size) {
            throw new IllegalArgumentException("invalid hex " + a.length + " <> " + size);
        }
        return a;
    }

    public static byte[] toBytes(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return new byte[0];
        }
        if (len % 2 == 1) {
            s = s + "0";
            ++len;
        }
        byte[] result = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            char b;
            char a = s.charAt(i);
            if (Character.isUpperCase(a)) {
                a = Character.toLowerCase(a);
            }
            if (Character.isUpperCase(b = s.charAt(i + 1))) {
                b = Character.toLowerCase(b);
            }
            result[i / 2] = (byte)((Character.digit(a, 16) << 4) + Character.digit(b, 16));
        }
        return result;
    }

    public static char toHexChar(int nibble) {
        return BASE16_CHARS[nibble & 0xF];
    }
}

