/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Iterator;
import java.util.function.Predicate;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.util.NIteratorBase;
import net.thevpc.nuts.util.NIteratorBuilder;

public class NFilteredIterator<T>
extends NIteratorBase<T> {
    private final Iterator<T> base;
    private final Predicate<? super T> filter;
    private T last;

    public NFilteredIterator(Iterator<T> base, Predicate<? super T> filter) {
        this.base = base == null ? NIteratorBuilder.emptyIterator() : base;
        this.filter = filter;
    }

    @Override
    public NElement describe() {
        return NElement.ofObjectBuilder().name("Filter").set("base", NElementDescribables.describeResolveOrDestruct(this.base)).set("accept", NElementDescribables.describeResolveOrToString(this.filter)).build();
    }

    @Override
    public boolean hasNext() {
        while (this.base.hasNext()) {
            this.last = this.base.next();
            if (!this.filter.test(this.last)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        return this.last;
    }

    @Override
    public void remove() {
        this.base.remove();
    }

    public String toString() {
        return this.filter.toString() + "(" + this.base + ')';
    }
}

