/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Iterator;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIndexFirstIterator;
import net.thevpc.nuts.util.NIteratorBase;
import net.thevpc.nuts.util.NIteratorErrorHandlerType;

public class NErrorHandlerIterator<T>
extends NIteratorBase<T> {
    private NIteratorErrorHandlerType type;
    private Iterator<T> base;
    private RuntimeException ex;

    public NErrorHandlerIterator(NIteratorErrorHandlerType type, Iterator<T> base) {
        this.base = base;
        this.type = type;
    }

    @Override
    public NElement describe() {
        return NElementDescribables.describeResolveOrDestructAsObject(this.base).builder().set("onError", this.type.toString().toLowerCase()).build();
    }

    @Override
    public boolean hasNext() {
        try {
            boolean v = this.base.hasNext();
            this.ex = null;
            return v;
        }
        catch (RuntimeException ex) {
            NLog.of(NIndexFirstIterator.class).log(NMsg.ofC("error evaluating Iterator 'hasNext()' : %s", ex).asDebug().withThrowable(ex));
            switch (this.type) {
                case IGNORE: {
                    return false;
                }
                case POSTPONE: {
                    this.ex = ex;
                    return true;
                }
                case THROW: {
                    throw ex;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public T next() {
        if (this.ex != null) {
            throw this.ex;
        }
        return this.base.next();
    }

    @Override
    public void remove() {
        if (this.ex != null) {
            throw this.ex;
        }
        this.base.remove();
    }

    public String toString() {
        switch (this.type) {
            case THROW: {
                return "ThrowOnError(" + this.base + ")";
            }
            case POSTPONE: {
                return "PostponeError(" + this.base + ")";
            }
            case IGNORE: {
                return "IgnoreError(" + this.base + ")";
            }
        }
        return "ErrorHandlerIterator(type=" + this.type + ", base=" + this.base + ')';
    }
}

