/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NConcurrentReadWriteLRUMap<K, V>
extends LinkedHashMap<K, V> {
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Lock readLock = this.readWriteLock.readLock();
    private Lock writeLock = this.readWriteLock.writeLock();
    private int maxSize;

    public NConcurrentReadWriteLRUMap(int maxSize) {
        super(maxSize + 1, 1.0f, true);
        this.maxSize = maxSize;
    }

    @Override
    public V get(Object key) {
        this.readLock.lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getOrDefault(Object key, V defaultValue) {
        this.readLock.lock();
        try {
            V v = super.getOrDefault(key, defaultValue);
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.writeLock.lock();
        try {
            V v = super.put(key, value);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry eldest) {
        return this.size() > this.maxSize;
    }
}

