/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public class NColor {
    private static final List<NColor> _ALL_REGISTERED = new ArrayList<NColor>();
    private static final List<NColor> _ALL_CANONICAL = new ArrayList<NColor>();
    private static final Map<String, NColor> _ALL_BY_NAME = new LinkedHashMap<String, NColor>();
    private static final Map<String, List<NColor>> _ALL_BY_CANONICAL_NAME = new LinkedHashMap<String, List<NColor>>();
    public static final NColor BLACK = NColor._reg("Black", "Black", 0, 0, 0);
    public static final NColor MAROON = NColor._reg("Maroon", "Maroon", 128, 0, 0);
    public static final NColor GREEN = NColor._reg("Green", "Green", 0, 128, 0);
    public static final NColor OLIVE = NColor._reg("Olive", "Olive", 128, 128, 0);
    public static final NColor NAVY = NColor._reg("Navy", "Navy", 0, 0, 128);
    public static final NColor PURPLE = NColor._reg("Purple", "Purple", 128, 0, 128);
    public static final NColor TEAL = NColor._reg("Teal", "Teal", 0, 128, 128);
    public static final NColor SILVER = NColor._reg("Silver", "Silver", 192, 192, 192);
    public static final NColor RED = NColor._reg("Red", "Red", 255, 0, 0);
    public static final NColor LIME = NColor._reg("Lime", "Lime", 0, 255, 0);
    public static final NColor YELLOW = NColor._reg("Yellow", "Yellow", 255, 255, 0);
    public static final NColor DARK_YELLOW = NColor._reg("DarkYellow", "Yellow", 186, 142, 35);
    public static final NColor BLUE = NColor._reg("Blue", "Blue", 0, 0, 255);
    public static final NColor FUCHSIA = NColor._reg("Fuchsia", "Fuchsia", 255, 0, 255);
    public static final NColor AQUA = NColor._reg("Aqua", "Aqua", 0, 255, 255);
    public static final NColor WHITE = NColor._reg("White", "White", 255, 255, 255);
    public static final NColor NAVY_BLUE = NColor._reg("NavyBlue", "NavyBlue", 0, 0, 95);
    public static final NColor DARK_BLUE = NColor._reg("DarkBlue", "Blue", 0, 0, 135);
    public static final NColor LIGHT_BLUE = NColor._reg("LightBlue", "Blue", 173, 216, 230);
    public static final NColor BLUE_2 = NColor._reg("Blue2", "Blue", 0, 0, 175);
    public static final NColor BLUE_3 = NColor._reg("Blue3", "Blue", 0, 0, 215);
    public static final NColor BLUE_4 = NColor._reg("Blue4", "Blue", 0, 0, 255);
    public static final NColor DARK_GREEN = NColor._reg("DarkGreen", "Green", 0, 95, 0);
    public static final NColor DEEP_SKY_BLUE = NColor._reg("DeepSkyBlue", "DeepSkyBlue", 0, 95, 95);
    public static final NColor DEEP_SKY_BLUE_2 = NColor._reg("DeepSkyBlue2", "DeepSkyBlue", 0, 95, 135);
    public static final NColor DEEP_SKY_BLUE_3 = NColor._reg("DeepSkyBlue3", "DeepSkyBlue", 0, 95, 175);
    public static final NColor DODGER_BLUE = NColor._reg("DodgerBlue", "DodgerBlue", 0, 95, 215);
    public static final NColor DODGER_BLUE_2 = NColor._reg("DodgerBlue2", "DodgerBlue", 0, 95, 255);
    public static final NColor GREEN_2 = NColor._reg("Green2", "Green", 0, 135, 0);
    public static final NColor SPRING_GREEN = NColor._reg("SpringGreen", "SpringGreen", 0, 135, 95);
    public static final NColor LIGHT_SPRING_GREEN = NColor._reg("LightSpringGreen", "SpringGreen", 139, 231, 185);
    public static final NColor DARK_SPRING_GREEN = NColor._reg("DarkSpringGreen", "SpringGreen", 23, 114, 69);
    public static final NColor TURQUOISE = NColor._reg("Turquoise", "Turquoise", 0, 135, 135);
    public static final NColor DEEP_SKY_BLUE_4 = NColor._reg("DeepSkyBlue4", "DeepSkyBlue", 0, 135, 175);
    public static final NColor DEEP_SKY_BLUE_5 = NColor._reg("DeepSkyBlue5", "DeepSkyBlue", 0, 135, 215);
    public static final NColor DODGER_BLUE_3 = NColor._reg("DodgerBlue3", "DodgerBlue", 0, 135, 255);
    public static final NColor GREEN_3 = NColor._reg("Green3", "Green", 0, 175, 0);
    public static final NColor SPRING_GREEN_2 = NColor._reg("SpringGreen2", "SpringGreen", 0, 175, 95);
    public static final NColor DARK_CYAN = NColor._reg("DarkCyan", "Cyan", 0, 175, 135);
    public static final NColor LIGHT_SEA_GREEN = NColor._reg("LightSeaGreen", "SeaGreen", 0, 175, 175);
    public static final NColor DEEP_SKY_BLUE_6 = NColor._reg("DeepSkyBlue6", "DeepSkyBlue", 0, 175, 215);
    public static final NColor DEEP_SKY_BLUE_7 = NColor._reg("DeepSkyBlue7", "DeepSkyBlue", 0, 175, 255);
    public static final NColor GREEN_4 = NColor._reg("Green4", "Green", 0, 215, 0);
    public static final NColor SPRING_GREEN_3 = NColor._reg("SpringGreen3", "SpringGreen", 0, 215, 95);
    public static final NColor SPRING_GREEN_4 = NColor._reg("SpringGreen4", "SpringGreen", 0, 215, 135);
    public static final NColor CYAN = NColor._reg("Cyan", "Cyan", 0, 215, 175);
    public static final NColor DARK_TURQUOISE = NColor._reg("DarkTurquoise", "Turquoise", 0, 215, 215);
    public static final NColor LIGHT_TURQUOISE = NColor._reg("LightTurquoise", "Turquoise", 175, 228, 222);
    public static final NColor TURQUOISE_2 = NColor._reg("Turquoise2", "Turquoise", 0, 215, 255);
    public static final NColor GREEN_5 = NColor._reg("Green5", "Green", 0, 255, 0);
    public static final NColor SPRING_GREEN_5 = NColor._reg("SpringGreen5", "SpringGreen", 0, 255, 95);
    public static final NColor SPRING_GREEN_6 = NColor._reg("SpringGreen6", "SpringGreen", 0, 255, 135);
    public static final NColor MEDIUM_SPRING_GREEN = NColor._reg("MediumSpringGreen", "SpringGreen", 0, 255, 175);
    public static final NColor CYAN_2 = NColor._reg("Cyan2", "Cyan", 0, 255, 215);
    public static final NColor CYAN_3 = NColor._reg("Cyan3", "Cyan", 0, 255, 255);
    public static final NColor DARK_RED = NColor._reg("DarkRed", "Red", 95, 0, 0);
    public static final NColor LIGHT_RED = NColor._reg("LightRed", "Red", 255, 114, 118);
    public static final NColor CERISE = NColor._reg("Cerise", "Cerise", 223, 70, 97);
    public static final NColor STRAWBERRY = NColor._reg("Strawberry", "Strawberry", 197, 70, 68);
    public static final NColor MANGO = NColor._reg("Mango", "Mango", 183, 94, 74);
    public static final NColor SCARLET = NColor._reg("Scarlet", "Scarlet", 255, 36, 0);
    public static final NColor BEIGE = NColor._reg("Beige", "Beige", 245, 245, 220);
    public static final NColor BRICK = NColor._reg("Brick", "Brick", 188, 74, 60);
    public static final NColor DEEP_PINK = NColor._reg("DeepPink", "DeepPink", 95, 0, 95);
    public static final NColor PURPLE_2 = NColor._reg("Purple2", "Purple", 95, 0, 135);
    public static final NColor PURPLE_3 = NColor._reg("Purple3", "Purple", 95, 0, 175);
    public static final NColor PURPLE_4 = NColor._reg("Purple4", "Purple", 95, 0, 215);
    public static final NColor BLUE_VIOLET = NColor._reg("BlueViolet", "BlueViolet", 95, 0, 255);
    public static final NColor ORANGE = NColor._reg("Orange", "Orange", 95, 95, 0);
    public static final NColor LIGHT_ORANGE = NColor._reg("LightOrange", "Orange", 252, 210, 153);
    public static final NColor MEDIUM_PURPLE = NColor._reg("MediumPurple", "Purple", 95, 95, 135);
    public static final NColor DARK_SLATE_BLUE = NColor._reg("DarkSlateBlue", "SlateBlue", 72, 61, 139);
    public static final NColor SLATE_BLUE = NColor._reg("SlateBlue", "SlateBlue", 95, 95, 175);
    public static final NColor SLATE_BLUE_2 = NColor._reg("SlateBlue2", "SlateBlue", 95, 95, 215);
    public static final NColor ROYAL_BLUE = NColor._reg("RoyalBlue", "RoyalBlue", 95, 95, 255);
    public static final NColor CHARTREUSE = NColor._reg("Chartreuse", "Chartreuse", 95, 135, 0);
    public static final NColor DARK_SEA_GREEN = NColor._reg("DarkSeaGreen", "SeaGreen", 95, 135, 95);
    public static final NColor PALE_TURQUOISE = NColor._reg("PaleTurquoise", "PaleTurquoise", 95, 135, 135);
    public static final NColor DARK_STEEL_BLUE = NColor._reg("DarkSteelBlue", "SteelBlue", 41, 93, 138);
    public static final NColor STEEL_BLUE = NColor._reg("SteelBlue", "SteelBlue", 95, 135, 175);
    public static final NColor STEEL_BLUE_2 = NColor._reg("SteelBlue2", "SteelBlue", 95, 135, 215);
    public static final NColor CORNFLOWER_BLUE = NColor._reg("CornflowerBlue", "CornflowerBlue", 95, 135, 255);
    public static final NColor CHARTREUSE_2 = NColor._reg("Chartreuse2", "Chartreuse", 95, 175, 0);
    public static final NColor DARK_SEA_GREEN_2 = NColor._reg("DarkSeaGreen2", "SeaGreen", 95, 175, 95);
    public static final NColor CADET_BLUE = NColor._reg("CadetBlue", "CadetBlue", 95, 175, 135);
    public static final NColor CADET_BLUE_2 = NColor._reg("CadetBlue2", "CadetBlue", 95, 175, 175);
    public static final NColor SKY_BLUE = NColor._reg("SkyBlue", "Blue", 95, 175, 215);
    public static final NColor STEEL_BLUE_3 = NColor._reg("SteelBlue3", "SteelBlue", 95, 175, 255);
    public static final NColor CHARTREUSE_3 = NColor._reg("Chartreuse3", "Chartreuse", 95, 215, 0);
    public static final NColor PALE_GREEN = NColor._reg("PaleGreen", "PaleGreen", 95, 215, 95);
    public static final NColor SEA_GREEN = NColor._reg("SeaGreen", "SeaGreen", 95, 215, 135);
    public static final NColor AQUAMARINE = NColor._reg("Aquamarine", "Aquamarine", 95, 215, 175);
    public static final NColor MEDIUM_TURQUOISE = NColor._reg("MediumTurquoise", "Turquoise", 95, 215, 215);
    public static final NColor STEEL_BLUE_4 = NColor._reg("SteelBlue4", "SteelBlue", 95, 215, 255);
    public static final NColor CHARTREUSE_4 = NColor._reg("Chartreuse4", "Chartreuse", 95, 255, 0);
    public static final NColor SEA_GREEN_2 = NColor._reg("SeaGreen2", "SeaGreen", 95, 255, 95);
    public static final NColor SEA_GREEN_3 = NColor._reg("SeaGreen3", "SeaGreen", 95, 255, 135);
    public static final NColor SEA_GREEN_4 = NColor._reg("SeaGreen4", "SeaGreen", 95, 255, 175);
    public static final NColor AQUAMARINE_2 = NColor._reg("Aquamarine2", "Aquamarine", 95, 255, 215);
    public static final NColor DARK_SLATE_GRAY = NColor._reg("DarkSlateGray", "SlateGray", 95, 255, 255);
    public static final NColor DARK_RED_2 = NColor._reg("DarkRed2", "Red", 135, 0, 0);
    public static final NColor DEEP_PINK_2 = NColor._reg("DeepPink2", "DeepPink", 135, 0, 95);
    public static final NColor LIGHT_MAGENTA = NColor._reg("LightMagenta", "Magenta", 255, 119, 255);
    public static final NColor DARK_MAGENTA = NColor._reg("DarkMagenta", "Magenta", 135, 0, 135);
    public static final NColor DARK_MAGENTA_2 = NColor._reg("DarkMagenta2", "Magenta", 135, 0, 175);
    public static final NColor DARK_VIOLET = NColor._reg("DarkViolet", "Violet", 135, 0, 215);
    public static final NColor PURPLE_5 = NColor._reg("Purple5", "Purple", 135, 0, 255);
    public static final NColor ORANGE_2 = NColor._reg("Orange2", "Orange", 135, 95, 0);
    public static final NColor LIGHT_PINK = NColor._reg("LightPink", "Pink", 135, 95, 95);
    public static final NColor PLUM = NColor._reg("Plum", "Plum", 135, 95, 135);
    public static final NColor MEDIUM_PURPLE_2 = NColor._reg("MediumPurple2", "Purple", 135, 95, 175);
    public static final NColor MEDIUM_PURPLE_3 = NColor._reg("MediumPurple3", "Purple", 135, 95, 215);
    public static final NColor SLATE_BLUE_3 = NColor._reg("SlateBlue3", "SlateBlue", 135, 95, 255);
    public static final NColor YELLOW_2 = NColor._reg("Yellow2", "Yellow", 135, 135, 0);
    public static final NColor WHEAT = NColor._reg("Wheat", "Wheat", 135, 135, 95);
    public static final NColor LIGHT_SLATE_GRAY = NColor._reg("LightSlateGray", "SlateGray", 135, 135, 175);
    public static final NColor MEDIUM_PURPLE_4 = NColor._reg("MediumPurple4", "Purple", 135, 135, 215);
    public static final NColor LIGHT_SLATE_BLUE = NColor._reg("LightSlateBlue", "SlateBlue", 135, 135, 255);
    public static final NColor YELLOW_3 = NColor._reg("Yellow3", "Yellow", 135, 175, 0);
    public static final NColor DARK_OLIVE_GREEN = NColor._reg("DarkOliveGreen", "OliveGreen", 135, 175, 95);
    public static final NColor DARK_SEA_GREEN_3 = NColor._reg("DarkSeaGreen3", "SeaGreen", 135, 175, 135);
    public static final NColor LIGHT_SKY_BLUE = NColor._reg("LightSkyBlue", "SkyBlue", 135, 175, 175);
    public static final NColor LIGHT_SKY_BLUE_2 = NColor._reg("LightSkyBlue2", "SkyBlue", 135, 175, 215);
    public static final NColor SKY_BLUE_2 = NColor._reg("SkyBlue2", "SkyBlue", 135, 175, 255);
    public static final NColor CHARTREUSE_5 = NColor._reg("Chartreuse5", "Chartreuse", 135, 215, 0);
    public static final NColor DARK_OLIVE_GREEN_2 = NColor._reg("DarkOliveGreen2", "OliveGreen", 135, 215, 95);
    public static final NColor PALE_GREEN_2 = NColor._reg("PaleGreen2", "PaleGreen", 135, 215, 135);
    public static final NColor DARK_SEA_GREEN_4 = NColor._reg("DarkSeaGreen4", "SeaGreen", 135, 215, 175);
    public static final NColor DARK_SLATE_GRAY_2 = NColor._reg("DarkSlateGray2", "SlateGray", 135, 215, 215);
    public static final NColor SKY_BLUE_3 = NColor._reg("SkyBlue3", "SkyBlue", 135, 215, 255);
    public static final NColor CHARTREUSE_6 = NColor._reg("Chartreuse6", "Chartreuse", 135, 255, 0);
    public static final NColor LIGHT_GREEN = NColor._reg("LightGreen", "Green", 135, 255, 95);
    public static final NColor LIGHT_GREEN_2 = NColor._reg("LightGreen2", "Green", 135, 255, 135);
    public static final NColor PALE_GREEN_3 = NColor._reg("PaleGreen3", "PaleGreen", 135, 255, 175);
    public static final NColor AQUAMARINE_3 = NColor._reg("Aquamarine3", "Aquamarine", 135, 255, 215);
    public static final NColor DARK_SLATE_GRAY_3 = NColor._reg("DarkSlateGray3", "SlateGray", 135, 255, 255);
    public static final NColor RED_2 = NColor._reg("Red2", "Red", 175, 0, 0);
    public static final NColor DEEP_PINK_3 = NColor._reg("DeepPink3", "DeepPink", 175, 0, 95);
    public static final NColor MEDIUM_VIOLET_RED = NColor._reg("MediumVioletRed", "VioletRed", 175, 0, 135);
    public static final NColor LIGHT_VIOLET = NColor._reg("LightViolet", "Violet", 207, 159, 255);
    public static final NColor MAGENTA = NColor._reg("Magenta", "Magenta", 175, 0, 175);
    public static final NColor DARK_VIOLET_2 = NColor._reg("DarkViolet2", "Violet", 175, 0, 215);
    public static final NColor PURPLE_6 = NColor._reg("Purple6", "Purple", 175, 0, 255);
    public static final NColor LIGHT_PURPLE = NColor._reg("LightPurple", "Purple", 203, 195, 227);
    public static final NColor DARK_PURPLE = NColor._reg("DarkPurple", "Purple", 152, 29, 151);
    public static final NColor DARK_ORANGE = NColor._reg("DarkOrange", "Orange", 175, 95, 0);
    public static final NColor INDIAN_RED = NColor._reg("IndianRed", "IndianRed", 175, 95, 95);
    public static final NColor HOT_PINK = NColor._reg("HotPink", "HotPink", 175, 95, 135);
    public static final NColor LIGHT_ORCHID = NColor._reg("LightOrchid", "Orchid", 230, 168, 215);
    public static final NColor DARK_ORCHID = NColor._reg("DarkOrchid", "Orchid", 153, 50, 204);
    public static final NColor MEDIUM_ORCHID = NColor._reg("MediumOrchid", "Orchid", 175, 95, 175);
    public static final NColor MEDIUM_ORCHID_2 = NColor._reg("MediumOrchid2", "Orchid", 175, 95, 215);
    public static final NColor MEDIUM_PURPLE_5 = NColor._reg("MediumPurple5", "Purple", 175, 95, 255);
    public static final NColor GOLDENROD = NColor._reg("Goldenrod", "Goldenrod", 218, 165, 32);
    public static final NColor DARK_GOLDENROD = NColor._reg("DarkGoldenrod", "Goldenrod", 175, 135, 0);
    public static final NColor LIGHT_SALMON = NColor._reg("LightSalmon", "Salmon", 175, 135, 95);
    public static final NColor LIGHT_BROWN = NColor._reg("LightBrown", "Brown", 196, 164, 132);
    public static final NColor BROWN = NColor._reg("Brown", "Brown", 150, 75, 0);
    public static final NColor DARK_BROWN = NColor._reg("DarkBrown", "Brown", 101, 67, 33);
    public static final NColor ROSY_BROWN = NColor._reg("RosyBrown", "RosyBrown", 175, 135, 135);
    public static final NColor MEDIUM_PURPLE_6 = NColor._reg("MediumPurple6", "Purple", 175, 135, 215);
    public static final NColor MEDIUM_PURPLE_7 = NColor._reg("MediumPurple7", "Purple", 175, 135, 255);
    public static final NColor GOLD = NColor._reg("Gold", "Gold", 175, 175, 0);
    public static final NColor LIGHT_KHAKI = NColor._reg("LightKhaki", "Khaki", 240, 230, 140);
    public static final NColor DARK_KHAKI = NColor._reg("DarkKhaki", "Khaki", 175, 175, 95);
    public static final NColor NAVAJO_WHITE = NColor._reg("NavajoWhite", "NavajoWhite", 175, 175, 135);
    public static final NColor LIGHT_STEEL_BLUE = NColor._reg("LightSteelBlue", "SteelBlue", 175, 175, 215);
    public static final NColor LIGHT_STEEL_BLUE_2 = NColor._reg("LightSteelBlue2", "SteelBlue", 175, 175, 255);
    public static final NColor YELLOW_4 = NColor._reg("Yellow4", "Yellow", 175, 215, 0);
    public static final NColor DARK_OLIVE_GREEN_3 = NColor._reg("DarkOliveGreen3", "OliveGreen", 175, 215, 95);
    public static final NColor DARK_SEA_GREEN_5 = NColor._reg("DarkSeaGreen5", "SeaGreen", 175, 215, 135);
    public static final NColor DARK_SEA_GREEN_6 = NColor._reg("DarkSeaGreen6", "SeaGreen", 175, 215, 175);
    public static final NColor LIGHT_CYAN = NColor._reg("LightCyan", "Cyan", 175, 215, 215);
    public static final NColor LIGHT_SKY_BLUE_3 = NColor._reg("LightSkyBlue3", "SkyBlue", 175, 215, 255);
    public static final NColor GREEN_YELLOW = NColor._reg("GreenYellow", "GreenYellow", 175, 255, 0);
    public static final NColor DARK_OLIVE_GREEN_4 = NColor._reg("DarkOliveGreen4", "OliveGreen", 175, 255, 95);
    public static final NColor PALE_GREEN_4 = NColor._reg("PaleGreen4", "PaleGreen", 175, 255, 135);
    public static final NColor DARK_SEA_GREEN_7 = NColor._reg("DarkSeaGreen7", "SeaGreen", 175, 255, 175);
    public static final NColor DARK_SEA_GREEN_8 = NColor._reg("DarkSeaGreen8", "SeaGreen", 175, 255, 215);
    public static final NColor PALE_TURQUOISE_2 = NColor._reg("PaleTurquoise2", "PaleTurquoise", 175, 255, 255);
    public static final NColor RED_3 = NColor._reg("Red3", "Red", 215, 0, 0);
    public static final NColor DEEP_PINK_4 = NColor._reg("DeepPink4", "DeepPink", 215, 0, 95);
    public static final NColor DEEP_PINK_5 = NColor._reg("DeepPink5", "DeepPink", 215, 0, 135);
    public static final NColor MAGENTA_2 = NColor._reg("Magenta2", "Magenta", 215, 0, 175);
    public static final NColor MAGENTA_3 = NColor._reg("Magenta3", "Magenta", 215, 0, 215);
    public static final NColor MAGENTA_4 = NColor._reg("Magenta4", "Magenta", 215, 0, 255);
    public static final NColor DARK_ORANGE_2 = NColor._reg("DarkOrange2", "Orange", 215, 95, 0);
    public static final NColor INDIAN_RED_2 = NColor._reg("IndianRed2", "IndianRed", 215, 95, 95);
    public static final NColor HOT_PINK_2 = NColor._reg("HotPink2", "HotPink", 215, 95, 135);
    public static final NColor HOT_PINK_3 = NColor._reg("HotPink3", "HotPink", 215, 95, 175);
    public static final NColor ORCHID = NColor._reg("Orchid", "Orchid", 215, 95, 215);
    public static final NColor MEDIUM_ORCHID_3 = NColor._reg("MediumOrchid3", "Orchid", 215, 95, 255);
    public static final NColor ORANGE_3 = NColor._reg("Orange3", "Orange", 215, 135, 0);
    public static final NColor DARK_SALMON = NColor._reg("DarkSalmon", "Salmon", 233, 150, 122);
    public static final NColor LIGHT_SALMON_2 = NColor._reg("LightSalmon2", "Salmon", 215, 135, 95);
    public static final NColor LIGHT_PINK_2 = NColor._reg("LightPink2", "Pink", 215, 135, 135);
    public static final NColor DARK_PINK = NColor._reg("DarkPink", "Pink", 231, 84, 128);
    public static final NColor PINK = NColor._reg("Pink", "Pink", 215, 135, 175);
    public static final NColor PLUM_2 = NColor._reg("Plum2", "Plum", 215, 135, 215);
    public static final NColor VIOLET = NColor._reg("Violet", "Violet", 215, 135, 255);
    public static final NColor GOLD_2 = NColor._reg("Gold2", "Gold", 215, 175, 0);
    public static final NColor LIGHT_GOLDENROD = NColor._reg("LightGoldenrod", "Goldenrod", 215, 175, 95);
    public static final NColor TAN = NColor._reg("Tan", "Tan", 215, 175, 135);
    public static final NColor LIGHT_TAN = NColor._reg("LightTan", "Tan", 236, 222, 201);
    public static final NColor DARK_TAN = NColor._reg("DarkTan", "Tan", 145, 129, 81);
    public static final NColor TUSCAN_TAN = NColor._reg("TuscanTan", "TuscanTan", 166, 123, 91);
    public static final NColor ALMOND = NColor._reg("Almond", "Almond", 239, 222, 205);
    public static final NColor BONE = NColor._reg("Bone", "Bone", 227, 218, 201);
    public static final NColor BISCUIT = NColor._reg("Biscuit", "Biscuit", 239, 204, 162);
    public static final NColor BRANDY = NColor._reg("Brandy", "Brandy", 218, 188, 148);
    public static final NColor CALICO = NColor._reg("Calico", "Calico", 224, 141, 91);
    public static final NColor CAMEL = NColor._reg("Camel", "Camel", 193, 154, 107);
    public static final NColor CAMEO = NColor._reg("Cameo", "Cameo", 238, 215, 185);
    public static final NColor CARAMEL = NColor._reg("Caramel", "Caramel", 255, 213, 154);
    public static final NColor CASHMERE = NColor._reg("Cashmere", "Cashmere", 230, 200, 160);
    public static final NColor CREAM = NColor._reg("Cream", "Cream", 255, 253, 208);
    public static final NColor CHALKY = NColor._reg("Chalky", "Chalky", 239, 201, 144);
    public static final NColor DEER = NColor._reg("Deer", "Deer", 186, 135, 89);
    public static final NColor DESERT = NColor._reg("Desert", "Desert", 250, 213, 165);
    public static final NColor DIRT = NColor._reg("Dirt", "Dirt", 155, 118, 83);
    public static final NColor EQUATOR = NColor._reg("Equator", "Equator", 227, 197, 101);
    public static final NColor MISTY_ROSE = NColor._reg("MistyRose", "Rose", 215, 175, 175);
    public static final NColor THISTLE = NColor._reg("Thistle", "Thistle", 215, 175, 215);
    public static final NColor PLUM_3 = NColor._reg("Plum3", "Plum", 215, 175, 255);
    public static final NColor YELLOW_5 = NColor._reg("Yellow5", "Yellow", 215, 215, 0);
    public static final NColor KHAKI = NColor._reg("Khaki", "Khaki", 215, 215, 95);
    public static final NColor LIGHT_GOLDENROD_2 = NColor._reg("LightGoldenrod2", "Goldenrod", 215, 215, 135);
    public static final NColor LIGHT_YELLOW = NColor._reg("LightYellow", "Yellow", 215, 215, 175);
    public static final NColor LIGHT_STEEL_BLUE_3 = NColor._reg("LightSteelBlue3", "SteelBlue", 215, 215, 255);
    public static final NColor YELLOW_6 = NColor._reg("Yellow6", "Yellow", 215, 255, 0);
    public static final NColor DARK_OLIVE_GREEN_5 = NColor._reg("DarkOliveGreen5", "OliveGreen", 215, 255, 95);
    public static final NColor DARK_OLIVE_GREEN_6 = NColor._reg("DarkOliveGreen6", "OliveGreen", 215, 255, 135);
    public static final NColor DARK_SEA_GREEN_9 = NColor._reg("DarkSeaGreen9", "SeaGreen", 215, 255, 175);
    public static final NColor HONEY = NColor._reg("Honey", "Honey", 224, 172, 105);
    public static final NColor HONEYDEW = NColor._reg("Honeydew", "Honeydew", 215, 255, 215);
    public static final NColor HUSK = NColor._reg("Husk", "Husk", 189, 165, 93);
    public static final NColor IVORY = NColor._reg("Ivory", "Ivory", 255, 255, 240);
    public static final NColor LIGHT_CYAN_2 = NColor._reg("LightCyan2", "Cyan", 215, 255, 255);
    public static final NColor RED_4 = NColor._reg("Red4", "Red", 255, 0, 0);
    public static final NColor DEEP_PINK_6 = NColor._reg("DeepPink6", "DeepPink", 255, 0, 95);
    public static final NColor DEEP_PINK_7 = NColor._reg("DeepPink7", "DeepPink", 255, 0, 135);
    public static final NColor DEEP_PINK_8 = NColor._reg("DeepPink8", "DeepPink", 255, 0, 175);
    public static final NColor MAGENTA_5 = NColor._reg("Magenta5", "Magenta", 255, 0, 215);
    public static final NColor MAGENTA_6 = NColor._reg("Magenta6", "Magenta", 255, 0, 255);
    public static final NColor ORANGE_RED = NColor._reg("OrangeRed", "OrangeRed", 255, 95, 0);
    public static final NColor INDIAN_RED_3 = NColor._reg("IndianRed3", "IndianRed", 255, 95, 95);
    public static final NColor INDIAN_RED_4 = NColor._reg("IndianRed4", "IndianRed", 255, 95, 135);
    public static final NColor HOT_PINK_4 = NColor._reg("HotPink4", "HotPink", 255, 95, 175);
    public static final NColor HOT_PINK_5 = NColor._reg("HotPink5", "HotPink", 255, 95, 215);
    public static final NColor MEDIUM_ORCHID_4 = NColor._reg("MediumOrchid4", "Orchid", 255, 95, 255);
    public static final NColor DARK_ORANGE_3 = NColor._reg("DarkOrange3", "Orange", 255, 135, 0);
    public static final NColor SALMON = NColor._reg("Salmon", "Salmon", 255, 135, 95);
    public static final NColor LIGHT_CORAL = NColor._reg("LightCoral", "Coral", 255, 135, 135);
    public static final NColor PALE_VIOLET_RED = NColor._reg("PaleVioletRed", "VioletRed", 255, 135, 175);
    public static final NColor ORCHID_2 = NColor._reg("Orchid2", "Orchid", 255, 135, 215);
    public static final NColor ORCHID_3 = NColor._reg("Orchid3", "Orchid", 255, 135, 255);
    public static final NColor ORANGE_4 = NColor._reg("Orange4", "Orange", 255, 175, 0);
    public static final NColor SAND = NColor._reg("Sand", "Sand", 194, 178, 128);
    public static final NColor SANDY_BROWN = NColor._reg("SandyBrown", "SandyBrown", 255, 175, 95);
    public static final NColor LIGHT_SALMON_3 = NColor._reg("LightSalmon3", "Salmon", 255, 175, 135);
    public static final NColor LIGHT_PINK_3 = NColor._reg("LightPink3", "Pink", 255, 175, 175);
    public static final NColor PINK_2 = NColor._reg("Pink2", "Pink", 255, 175, 215);
    public static final NColor PLUM_4 = NColor._reg("Plum4", "Plum", 255, 175, 255);
    public static final NColor GOLD_3 = NColor._reg("Gold3", "Gold", 255, 215, 0);
    public static final NColor LIGHT_GOLDENROD_3 = NColor._reg("LightGoldenrod3", "Goldenrod", 255, 215, 95);
    public static final NColor LIGHT_GOLDENROD_4 = NColor._reg("LightGoldenrod4", "Goldenrod", 255, 215, 135);
    public static final NColor NAVAJO_WHITE_2 = NColor._reg("NavajoWhite2", "NavajoWhite", 255, 215, 175);
    public static final NColor MISTY_ROSE_2 = NColor._reg("MistyRose2", "MistyRose", 255, 215, 215);
    public static final NColor THISTLE_2 = NColor._reg("Thistle2", "Thistle", 255, 215, 255);
    public static final NColor YELLOW_7 = NColor._reg("Yellow7", "Yellow", 255, 255, 0);
    public static final NColor LIGHT_GOLDENROD_5 = NColor._reg("LightGoldenrod5", "Goldenrod", 255, 255, 95);
    public static final NColor KHAKI_2 = NColor._reg("Khaki2", "Khaki", 255, 255, 135);
    public static final NColor WHEAT_2 = NColor._reg("Wheat2", "Wheat", 255, 255, 175);
    public static final NColor CORNSILK = NColor._reg("Cornsilk", "Cornsilk", 255, 255, 215);
    public static final NColor TUMBLEWEED = NColor._reg("Tumbleweed", "Tumbleweed", 220, 173, 141);
    public static final NColor TACHA = NColor._reg("Tacha", "Tacha", 214, 183, 90);
    public static final NColor SHADOW = NColor._reg("Shadow", "Shadow", 138, 121, 93);
    public static final NColor MOCASSIN = NColor._reg("Moccasin", "Moccasin", 255, 228, 181);
    public static final NColor GRAY = NColor._reg("Gray", "Gray", 128, 128, 128);
    public static final NColor GRAY_0 = NColor._regGray(0);
    public static final NColor GRAY_1 = NColor._regGray(1);
    public static final NColor GRAY_2 = NColor._regGray(2);
    public static final NColor GRAY_3 = NColor._reg("Gray3", "Gray", 8, 8, 8);
    public static final NColor GRAY_4 = NColor._regGray(4);
    public static final NColor GRAY_5 = NColor._regGray(5);
    public static final NColor GRAY_6 = NColor._regGray(6);
    public static final NColor GRAY_7 = NColor._reg("Gray7", "Gray", 18, 18, 18);
    public static final NColor GRAY_8 = NColor._regGray(8);
    public static final NColor GRAY_9 = NColor._regGray(9);
    public static final NColor GRAY_10 = NColor._regGray(10);
    public static final NColor GRAY_11 = NColor._reg("Gray11", "Gray", 28, 28, 28);
    public static final NColor GRAY_12 = NColor._regGray(12);
    public static final NColor GRAY_13 = NColor._regGray(13);
    public static final NColor GRAY_14 = NColor._regGray(14);
    public static final NColor GRAY_15 = NColor._reg("Gray15", "Gray", 38, 38, 38);
    public static final NColor GRAY_16 = NColor._regGray(16);
    public static final NColor GRAY_17 = NColor._regGray(17);
    public static final NColor GRAY_18 = NColor._regGray(18);
    public static final NColor GRAY_19 = NColor._reg("Gray19", "Gray", 48, 48, 48);
    public static final NColor GRAY_20 = NColor._regGray(20);
    public static final NColor GRAY_21 = NColor._regGray(21);
    public static final NColor GRAY_22 = NColor._regGray(22);
    public static final NColor GRAY_23 = NColor._reg("Gray23", "Gray", 58, 58, 58);
    public static final NColor GRAY_24 = NColor._regGray(24);
    public static final NColor GRAY_25 = NColor._regGray(25);
    public static final NColor GRAY_26 = NColor._regGray(26);
    public static final NColor GRAY_27 = NColor._reg("Gray27", "Gray", 68, 68, 68);
    public static final NColor GRAY_28 = NColor._regGray(28);
    public static final NColor GRAY_29 = NColor._regGray(29);
    public static final NColor GRAY_30 = NColor._reg("Gray30", "Gray", 78, 78, 78);
    public static final NColor GRAY_31 = NColor._regGray(31);
    public static final NColor GRAY_32 = NColor._regGray(32);
    public static final NColor GRAY_33 = NColor._regGray(33);
    public static final NColor GRAY_34 = NColor._regGray(34);
    public static final NColor GRAY_35 = NColor._reg("Gray35", "Gray", 88, 88, 88);
    public static final NColor GRAY_36 = NColor._regGray(36);
    public static final NColor GRAY_37 = NColor._reg("Gray37", "Gray", 95, 95, 95);
    public static final NColor GRAY_38 = NColor._regGray(38);
    public static final NColor GRAY_39 = NColor._reg("Gray39", "Gray", 98, 98, 98);
    public static final NColor GRAY_40 = NColor._regGray(40);
    public static final NColor GRAY_41 = NColor._regGray(41);
    public static final NColor GRAY_42 = NColor._reg("Gray42", "Gray", 108, 108, 108);
    public static final NColor GRAY_43 = NColor._regGray(43);
    public static final NColor GRAY_44 = NColor._regGray(44);
    public static final NColor GRAY_45 = NColor._regGray(45);
    public static final NColor GRAY_46 = NColor._reg("Gray46", "Gray", 118, 118, 118);
    public static final NColor GRAY_47 = NColor._regGray(47);
    public static final NColor GRAY_48 = NColor._regGray(48);
    public static final NColor GRAY_49 = NColor._regGray(49);
    public static final NColor GRAY_50 = NColor._reg("Gray50", "Gray", 128, 128, 128);
    public static final NColor GRAY_51 = NColor._regGray(51);
    public static final NColor GRAY_52 = NColor._regGray(52);
    public static final NColor GRAY_53 = NColor._reg("Gray53", "Gray", 135, 135, 135);
    public static final NColor GRAY_54 = NColor._reg("Gray54", "Gray", 138, 138, 138);
    public static final NColor GRAY_55 = NColor._regGray(55);
    public static final NColor GRAY_56 = NColor._regGray(56);
    public static final NColor GRAY_57 = NColor._regGray(57);
    public static final NColor GRAY_58 = NColor._reg("Gray58", "Gray", 148, 148, 148);
    public static final NColor GRAY_59 = NColor._regGray(59);
    public static final NColor GRAY_60 = NColor._regGray(60);
    public static final NColor GRAY_61 = NColor._regGray(61);
    public static final NColor GRAY_62 = NColor._reg("Gray62", "Gray", 158, 158, 158);
    public static final NColor GRAY_63 = NColor._reg("Gray63", "Gray", 175, 135, 175);
    public static final NColor GRAY_64 = NColor._regGray(64);
    public static final NColor GRAY_65 = NColor._regGray(65);
    public static final NColor GRAY_66 = NColor._reg("Gray66", "Gray", 168, 168, 168);
    public static final NColor GRAY_67 = NColor._regGray(67);
    public static final NColor GRAY_68 = NColor._regGray(68);
    public static final NColor GRAY_69 = NColor._reg("Gray69", "Gray", 175, 175, 175);
    public static final NColor GRAY_70 = NColor._reg("Gray70", "Gray", 178, 178, 178);
    public static final NColor GRAY_71 = NColor._regGray(71);
    public static final NColor GRAY_72 = NColor._regGray(72);
    public static final NColor GRAY_73 = NColor._regGray(73);
    public static final NColor GRAY_74 = NColor._reg("Gray74", "Gray", 188, 188, 188);
    public static final NColor GRAY_75 = NColor._regGray(75);
    public static final NColor GRAY_76 = NColor._regGray(76);
    public static final NColor GRAY_77 = NColor._regGray(77);
    public static final NColor GRAY_78 = NColor._reg("Gray78", "Gray", 198, 198, 198);
    public static final NColor GRAY_79 = NColor._regGray(79);
    public static final NColor GRAY_80 = NColor._regGray(80);
    public static final NColor GRAY_81 = NColor._regGray(81);
    public static final NColor GRAY_82 = NColor._reg("Gray82", "Gray", 208, 208, 208);
    public static final NColor GRAY_83 = NColor._regGray(83);
    public static final NColor GRAY_84 = NColor._reg("Gray84", "Gray", 215, 215, 215);
    public static final NColor GRAY_85 = NColor._reg("Gray85", "Gray", 218, 218, 218);
    public static final NColor GRAY_86 = NColor._regGray(86);
    public static final NColor GRAY_87 = NColor._regGray(87);
    public static final NColor GRAY_88 = NColor._regGray(88);
    public static final NColor GRAY_89 = NColor._reg("Gray89", "Gray", 228, 228, 228);
    public static final NColor GRAY_90 = NColor._regGray(90);
    public static final NColor GRAY_91 = NColor._regGray(91);
    public static final NColor GRAY_92 = NColor._regGray(92);
    public static final NColor GRAY_93 = NColor._reg("Gray93", "Gray", 238, 238, 238);
    public static final NColor GRAY_94 = NColor._regGray(94);
    public static final NColor GRAY_95 = NColor._regGray(95);
    public static final NColor GRAY_96 = NColor._regGray(96);
    public static final NColor GRAY_97 = NColor._regGray(97);
    public static final NColor GRAY_98 = NColor._regGray(98);
    public static final NColor GRAY_99 = NColor._regGray(99);
    public static final NColor GRAY_100 = NColor._reg("Gray100", "Gray", 255, 255, 255);
    public static final NColor LIGHT_GRAY = NColor._reg("LightGray", "Gray", 192, 192, 192);
    public static final NColor DARK_GRAY = NColor._reg("DarkGray", "Gray", 64, 64, 64);
    public static final List<NColor> ALL = Collections.unmodifiableList(_ALL_REGISTERED);
    public static final List<NColor> ALL_CANONICAL = Collections.unmodifiableList(_ALL_CANONICAL);
    public static final Map<String, NColor> BY_NAME = Collections.unmodifiableMap(_ALL_BY_NAME);
    public static List<NColor> ANSI_COLORS_16 = Collections.unmodifiableList(Arrays.asList(NColor.of32(0, 0, 0), NColor.of32(128, 0, 0), NColor.of32(0, 128, 0), NColor.of32(128, 128, 0), NColor.of32(0, 0, 128), NColor.of32(128, 0, 128), NColor.of32(0, 128, 128), NColor.of32(192, 192, 192), NColor.of32(128, 128, 128), NColor.of32(255, 0, 0), NColor.of32(0, 255, 0), NColor.of32(255, 255, 0), NColor.of32(0, 0, 255), NColor.of32(255, 0, 255), NColor.of32(0, 255, 255), NColor.of32(255, 255, 255)));
    public static final List<NColor> ANSI_COLORS_256;
    private final Bits bits;
    private final long color;
    private final String name;

    public static NColor pickColor(int hashCode) {
        int a = Math.abs(hashCode);
        NColor c = _ALL_CANONICAL.get(a % _ALL_CANONICAL.size());
        List<NColor> li = _ALL_BY_CANONICAL_NAME.get(c.getName());
        return li.get(a % li.size());
    }

    private static NColor _reg2(String canonicalName, NColor color) {
        NColor namedColor = color;
        _ALL_REGISTERED.add(namedColor);
        _ALL_BY_NAME.put(namedColor.getName(), namedColor);
        _ALL_BY_CANONICAL_NAME.computeIfAbsent(canonicalName, v -> new ArrayList()).add(namedColor);
        if (canonicalName.equals(namedColor.getName())) {
            _ALL_CANONICAL.add(namedColor);
        }
        return namedColor;
    }

    private static NColor _reg(String name, String canonicalName, int r, int g, int b) {
        return NColor._reg2(canonicalName, NColor.of32(r, g, b, name));
    }

    private static NColor _regGray(int percent) {
        int v = Math.round((float)(percent * 255) / 100.0f);
        return NColor._reg2("Gray", NColor.of32(v, v, v, "Gray" + percent));
    }

    public static NOptional<NColor> ofName(String name) {
        return NOptional.ofNamed(BY_NAME.get(name == null ? null : NNameFormat.CLASS_NAME.format(name.trim()).toLowerCase()), "color " + name);
    }

    public static NOptional<List<NColor>> ofCanonicalName(String name) {
        return NOptional.ofNamed(_ALL_BY_CANONICAL_NAME.get(name == null ? null : NNameFormat.CLASS_NAME.format(name.trim()).toLowerCase()), "color " + name);
    }

    public static String toHtmlHex(NColor cl) {
        return String.format("#%02X%02X%02X", cl.getRed(), cl.getGreen(), cl.getBlue());
    }

    public static NColor ansiToColor(int index) {
        if (index < 0 || index > 255) {
            throw new IllegalArgumentException("ANSI color index must be between 0 and 255");
        }
        if (index < 16) {
            int[] basicColors = new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0xC0C0C0, 0x808080, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF};
            return NColor.of32(basicColors[index]);
        }
        if (index < 232) {
            int level = index - 16;
            int r = level / 36 % 6 * 51;
            int g = level / 6 % 6 * 51;
            int b = level % 6 * 51;
            return NColor.of32(r, g, b);
        }
        int gray = (index - 232) * 10 + 8;
        return NColor.of32(gray, gray, gray);
    }

    public NColor(Bits bits, long color, String name) {
        this.bits = bits;
        this.name = name;
        switch (bits.ordinal()) {
            case 0: {
                this.color = color & 0xFL;
                break;
            }
            case 1: {
                this.color = color & 0xFFL;
                break;
            }
            case 2: {
                this.color = color & 0xFFFFL;
                break;
            }
            case 3: {
                this.color = color & 0xFFFFFFL;
                break;
            }
            case 4: {
                this.color = (int)color;
                break;
            }
            default: {
                this.color = color;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public static NColor of4(int color) {
        return new NColor(Bits.BITS_4, color, null);
    }

    public static NColor of8(int color) {
        return new NColor(Bits.BITS_8, color, null);
    }

    public static NColor of24(int color) {
        return new NColor(Bits.BITS_24, color, null);
    }

    public static NColor of32(int r, int g, int b, String name) {
        return new NColor(Bits.BITS_32, (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0, name);
    }

    public static NColor of32(int r, int g, int b) {
        return new NColor(Bits.BITS_32, (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0, null);
    }

    public static NColor of32(int r, int g, int b, int a) {
        return new NColor(Bits.BITS_32, (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0, null);
    }

    public static NColor of32(int r, int g, int b, int a, String name) {
        return new NColor(Bits.BITS_32, (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0, name);
    }

    public static NColor of32(int color) {
        return new NColor(Bits.BITS_32, color, null);
    }

    public static NColor of64(long color) {
        return new NColor(Bits.BITS_64, color, null);
    }

    public NColor withName(String name) {
        return new NColor(this.bits, this.color, name);
    }

    public Bits getBits() {
        return this.bits;
    }

    public NColor toColor32() {
        switch (this.bits.ordinal()) {
            case 0: {
                int c = (int)this.color;
                if (c >= 0 && c < 16) {
                    return ANSI_COLORS_16.get(c);
                }
                return ANSI_COLORS_16.get(0);
            }
            case 2: 
            case 3: {
                int c = (int)this.color;
                if (c >= 0 && c < 255) {
                    return ANSI_COLORS_256.get(c);
                }
                return ANSI_COLORS_256.get(0);
            }
            case 4: {
                return this;
            }
            case 5: {
                return NColor.of32((int)this.color);
            }
        }
        return NColor.of32((int)this.color);
    }

    public int getIntColor() {
        return (int)this.color;
    }

    public long getLongColor() {
        return this.color;
    }

    public int getRGB() {
        if (this.bits == Bits.BITS_32) {
            return (int)this.color;
        }
        return this.toColor32().getRGB();
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    static {
        ArrayList<NColor> ansiColors = new ArrayList<NColor>(256);
        ansiColors.addAll(ANSI_COLORS_16);
        int[] levels = new int[]{0, 95, 135, 175, 215, 255};
        int index = 16;
        for (int r = 0; r < 6; ++r) {
            for (int g = 0; g < 6; ++g) {
                for (int b = 0; b < 6; ++b) {
                    ansiColors.add(NColor.of32(levels[r], levels[g], levels[b]));
                }
            }
        }
        for (int i = 0; i < 24; ++i) {
            int gray = 8 + i * 10;
            ansiColors.add(NColor.of32(gray, gray, gray));
        }
        ANSI_COLORS_256 = Collections.unmodifiableList(ansiColors);
    }

    public static enum Bits implements NEnum
    {
        BITS_4(4),
        BITS_8(8),
        BITS_16(16),
        BITS_24(24),
        BITS_32(32),
        BITS_64(64);

        private final int bits;
        private final String id;

        private Bits(int bits) {
            this.bits = bits;
            this.id = NNameFormat.ID_NAME.format(this.name());
        }

        public int bits() {
            return this.bits;
        }

        @Override
        public String id() {
            return this.id;
        }

        public static NOptional<Bits> parse(String value) {
            return NEnumUtils.parseEnum(value, Bits.class, enumValue -> {
                switch (enumValue.getNormalizedValue()) {
                    case "STANDARD": {
                        return NOptional.of(BITS_32);
                    }
                    case "BITS4": {
                        return NOptional.of(BITS_4);
                    }
                    case "BITS8": {
                        return NOptional.of(BITS_8);
                    }
                    case "BITS16": {
                        return NOptional.of(BITS_16);
                    }
                    case "BITS24": {
                        return NOptional.of(BITS_24);
                    }
                    case "BITS32": {
                        return NOptional.of(BITS_32);
                    }
                    case "BITS64": {
                        return NOptional.of(BITS_64);
                    }
                }
                return NOptional.ofNamedEmpty(value);
            });
        }
    }
}

