/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.artifact.NIdLocation;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class NCollections {
    public static <A> List<A> append(Collection<A> a1, A b1) {
        ArrayList<A> li = new ArrayList<A>(a1);
        li.add(b1);
        return li;
    }

    public static <A> List<A> appendAll(Collection<A> a1, Collection<A> b1) {
        ArrayList<A> li = new ArrayList<A>(a1);
        li.addAll(b1);
        return li;
    }

    public static <A> List<A> prepend(A b1, Collection<A> a1) {
        ArrayList<A> li = new ArrayList<A>();
        li.add(b1);
        li.addAll(a1);
        return li;
    }

    public static <T> List<T> list(Collection<T> it) {
        return new ArrayList<T>(it);
    }

    public static <T> List<T> list(Iterable<T> it) {
        return NCollections.list(it.iterator());
    }

    public static <T> List<T> list(Iterator<T> it) {
        ArrayList<T> all = new ArrayList<T>();
        while (it.hasNext()) {
            all.add(it.next());
        }
        return all;
    }

    public static <T> List<T> list(Enumeration<T> it) {
        ArrayList<T> all = new ArrayList<T>();
        while (it.hasMoreElements()) {
            all.add(it.nextElement());
        }
        return all;
    }

    public static <T> Stream<T> stream(Iterable<T> it) {
        return StreamSupport.stream(it.spliterator(), false);
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> distinctMapper) {
        ConcurrentHashMap visited = new ConcurrentHashMap();
        return t -> visited.putIfAbsent(distinctMapper.apply(t), Boolean.TRUE) == null;
    }

    public static List<String> toDistinctTrimmedNonEmptyList(List<String> values0) {
        Set<String> set = NCollections.toTrimmedNonEmptySet(values0 == null ? null : values0.toArray(new String[0]));
        return new ArrayList<String>(set);
    }

    public static List<String> toDistinctTrimmedNonEmptyList(List<String> values0, List<String> ... values) {
        Set<String> set = NCollections.toTrimmedNonEmptySet(values0 == null ? null : values0.toArray(new String[0]));
        if (values != null) {
            for (List<String> value : values) {
                set.addAll(NCollections.toTrimmedNonEmptySet(values0 == null ? null : values0.toArray(new String[0])));
            }
        }
        return new ArrayList<String>(set);
    }

    public static <T> boolean addAllNonNull(Collection<T> container, Collection<T> newElements) {
        boolean someAdded = false;
        if (newElements != null) {
            for (T t : newElements) {
                if (t == null) continue;
                container.add(t);
                someAdded = true;
            }
        }
        return someAdded;
    }

    public static <T> List<T> unmodifiableList(Collection<T> other) {
        return other == null ? Collections.emptyList() : Collections.unmodifiableList(NCollections.nonNullList(other));
    }

    public static <T, V> Map<T, V> nonNullMap(Map<T, V> other) {
        if (other == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap<T, V>(other);
    }

    public static <T> List<T> nonNullList(Collection<T> other) {
        if (other == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(other);
    }

    public static Set<String> toTrimmedNonEmptySet(String[] values0) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (values0 != null) {
            for (String a : values0) {
                if (NBlankable.isBlank(a = NStringUtils.trim(a))) continue;
                set.add(a);
            }
        }
        return set;
    }

    public static ArrayList<String> toDistinctTrimmedNonEmptyList(String[] values0) {
        return new ArrayList<String>(NCollections.toTrimmedNonEmptySet(values0));
    }

    public static Set<NIdLocation> toSet(NIdLocation[] classifierMappings) {
        LinkedHashSet<NIdLocation> set = new LinkedHashSet<NIdLocation>();
        if (classifierMappings != null) {
            for (NIdLocation a : classifierMappings) {
                if (a == null) continue;
                set.add(a);
            }
        }
        return set;
    }

    public static <T, V> Map<T, V> unmodifiableMap(Map<T, V> other) {
        return other == null ? Collections.emptyMap() : Collections.unmodifiableMap(NCollections.nonNullMap(other));
    }

    public static <T> List<T> nonNullListFromArray(T[] other) {
        return NCollections.nonNullList(Arrays.asList(other));
    }

    public static <T> Stream<T> finiteStream(Supplier<T> supplier) {
        return NCollections.stream(supplier, null);
    }

    public static <T> Stream<T> stream(final Supplier<T> supplier, Predicate<T> stopCondition) {
        if (stopCondition == null) {
            stopCondition = Objects::isNull;
        }
        final Predicate<T> finalStopCondition = stopCondition;
        return NCollections.stream(new Iterator<T>(){
            T value;

            @Override
            public boolean hasNext() {
                this.value = supplier.get();
                return !finalStopCondition.test(this.value);
            }

            @Override
            public T next() {
                return this.value;
            }
        });
    }
}

