/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import net.thevpc.nuts.util.NMatchType;
import net.thevpc.nuts.util.NMultiPattern;
import net.thevpc.nuts.util.NPatternInfo;
import net.thevpc.nuts.util.NStringMatchResult;

public class NCharQueue
implements CharSequence {
    private char[] content;
    private int increment;
    private int from;
    private int to;
    private boolean eof;
    private Map<String, Pattern> cachedPatterns = new HashMap<String, Pattern>();

    public NCharQueue() {
        this(256);
    }

    public NCharQueue(int initial) {
        this(initial, Math.min(initial, 256));
    }

    public NCharQueue(int initial, int increment) {
        this.content = new char[initial];
        this.increment = increment;
    }

    public int write(Reader reader, int max) {
        char[] all = new char[max];
        int count = 0;
        try {
            count = reader.read(all);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (count > 0) {
            this.write(all, 0, count);
        }
        return count;
    }

    public void write(String c) {
        if (this.isEOF()) {
            throw new IllegalArgumentException("end");
        }
        int n = c.length();
        this.ensureAvailable(n);
        c.getChars(0, n, this.content, this.to);
        this.to += n;
    }

    public void write(CharSequence c) {
        this.write(c.toString());
    }

    public void write(CharBuffer c) {
        if (this.isEOF()) {
            throw new IllegalArgumentException("end");
        }
        int n = c.length();
        this.ensureAvailable(n);
        c.get(this.content, this.to, n);
        this.to += n;
    }

    public synchronized void write(char[] c) {
        this.write(c, 0, c.length);
    }

    public synchronized void write(char[] c, int offset, int len) {
        if (this.isEOF()) {
            throw new IllegalArgumentException("end");
        }
        this.ensureAvailable(len);
        System.arraycopy(c, offset, this.content, this.to, len);
        this.to += len;
    }

    public synchronized void write(char c) {
        if (this.isEOF()) {
            throw new IllegalArgumentException("end");
        }
        this.ensureAvailable(1);
        this.content[this.to++] = c;
    }

    @Override
    public int length() {
        return this.to - this.from;
    }

    public char peek() {
        if (this.to > this.from) {
            return this.content[this.from];
        }
        throw new UncheckedIOException(new EOFException());
    }

    public String peek(int count) {
        int c = this.length();
        if (count < c) {
            return new String(this.content, this.from, count);
        }
        return new String(this.content, this.from, c);
    }

    public boolean canRead() {
        return this.from < this.to;
    }

    public boolean canReadByCount(int count) {
        return this.from + count - 1 < this.to;
    }

    public String read(int count) {
        if (this.from + count < this.to) {
            String s = new String(this.content, this.from, count);
            this.from += count;
            return s;
        }
        String s = new String(this.content, this.from, this.to - this.from);
        this.from = 0;
        this.to = 0;
        return s;
    }

    public void skip(int count) {
        if (this.from + count < this.to) {
            this.from += count;
        } else {
            this.from = 0;
            this.to = 0;
        }
    }

    public NMatchType skipValue(String value) {
        int count = value.length();
        if (this.from + count < this.to) {
            for (int i = 0; i < count; ++i) {
                if (value.charAt(i) == this.content[this.from + i]) continue;
                return NMatchType.NO_MATCH;
            }
            this.skip(count);
            return NMatchType.FULL_MATCH;
        }
        for (int i = 0; i < this.to; ++i) {
            if (value.charAt(i) == this.content[this.from + i]) continue;
            return NMatchType.NO_MATCH;
        }
        return NMatchType.PARTIAL_MATCH;
    }

    private Pattern pattern(String pattern) {
        return Pattern.compile("^" + pattern);
    }

    public NStringMatchResult peekPattern(String pattern) {
        return this.peekPattern(pattern, this.isEOF());
    }

    public void clear() {
        this.from = 0;
        this.to = 0;
    }

    public NStringMatchResult doWithPattern(NMultiPattern pattern) {
        ArrayList<NPatternInfo> all = new ArrayList<NPatternInfo>(pattern.map.values());
        if (all.isEmpty()) {
            throw new IllegalArgumentException("missing pattern");
        }
        for (NPatternInfo patternInfo : all) {
            patternInfo.setResult(this.peekPattern(patternInfo.getPattern(), pattern.fully));
        }
        NPatternInfo p = (NPatternInfo)all.stream().min(NPatternInfo::compareTo).get();
        NStringMatchResult r = p.getResult();
        switch (r.mode()) {
            case NO_MATCH: {
                if (pattern.noMatch == null) break;
                pattern.noMatch.run();
                break;
            }
            case PARTIAL_MATCH: {
                if (pattern.partialMatch != null) {
                    pattern.partialMatch.accept(r);
                }
                if (p.getPartialMatchAction() != null) {
                    p.getPartialMatchAction().accept(r);
                }
                if (p.getAction() == null) break;
                p.getAction().accept(r);
                break;
            }
            case MATCH: {
                if (pattern.match != null) {
                    pattern.match.accept(r);
                }
                if (p.getMatchAction() != null) {
                    p.getMatchAction().accept(r);
                }
                if (p.getAction() == null) break;
                p.getAction().accept(r);
                break;
            }
            case FULL_MATCH: {
                if (pattern.fullMatch != null) {
                    pattern.fullMatch.accept(r);
                }
                if (p.getFullMatchAction() != null) {
                    p.getFullMatchAction().accept(r);
                }
                if (p.getAction() == null) break;
                p.getAction().accept(r);
            }
        }
        return r;
    }

    public NStringMatchResult peekPattern(String pattern, boolean fully) {
        Pattern p = this.pattern(pattern);
        Matcher matcher = p.matcher(this);
        if (matcher.find()) {
            if (matcher.hitEnd() && !fully) {
                return NStringMatchResult.ofMatch(matcher);
            }
            return NStringMatchResult.ofFullMatch(matcher);
        }
        if (matcher.hitEnd() && !fully) {
            return NStringMatchResult.ofPartialMatch(this.toString());
        }
        return NStringMatchResult.ofNoMatch();
    }

    public NStringMatchResult peekString(String value) {
        return this.peekString(value, this.isEOF());
    }

    public NStringMatchResult peekString(String value, boolean fully) {
        int count = value.length();
        if (this.from + count <= this.to) {
            for (int i = 0; i < count; ++i) {
                if (value.charAt(i) == this.content[this.from + i]) continue;
                return NStringMatchResult.ofNoMatch();
            }
            return NStringMatchResult.ofFullMatch(value);
        }
        if (!fully) {
            int length = this.length();
            for (int i = 0; i < length; ++i) {
                if (value.charAt(i) == this.content[this.from + i]) continue;
                return NStringMatchResult.ofNoMatch();
            }
            return NStringMatchResult.ofPartialMatch(this.toString());
        }
        return NStringMatchResult.ofNoMatch();
    }

    public String readBlank() {
        char c;
        StringBuilder sb = new StringBuilder();
        while (this.hasNext() && Character.isWhitespace(c = this.peek())) {
            sb.append(this.read());
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public String readNewLine(boolean fully) {
        if (this.hasNext()) {
            char c = this.peek();
            switch (c) {
                case '\n': {
                    this.read();
                    return "" + c;
                }
                case '\r': {
                    this.read();
                    if (this.hasNext()) {
                        if (this.peek() == '\n') {
                            return "" + c + this.read();
                        }
                        return "" + c;
                    }
                    if (!fully) break;
                    return "" + c;
                }
            }
        }
        return null;
    }

    public char read() {
        if (this.canRead()) {
            return this.content[this.from++];
        }
        throw new UncheckedIOException(new EOFException());
    }

    public void ensureAvailable(int z) {
        int currentEffLen = this.length();
        int newEffLen = currentEffLen + z;
        if (newEffLen > this.content.length) {
            char[] n = new char[newEffLen + this.increment];
            System.arraycopy(this.content, this.from, n, 0, currentEffLen);
            this.content = n;
            this.from = 0;
            this.to = currentEffLen;
            return;
        }
        int rightAvailable = this.content.length - this.to;
        if (z <= rightAvailable) {
            return;
        }
        System.arraycopy(this.content, this.from, this.content, 0, currentEffLen);
        this.from = 0;
        this.to = currentEffLen;
    }

    @Override
    public String toString() {
        int c = this.length();
        return new String(this.content, this.from, c);
    }

    @Override
    public char charAt(int index) {
        if (index >= 0 && index < this.length()) {
            return this.content[this.from + index];
        }
        throw new IndexOutOfBoundsException("invalid index " + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int c2 = end - start;
        int c = this.length();
        if (c2 > c) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.content, this.from + start, c2);
    }

    @Override
    public IntStream chars() {
        return this.toString().chars();
    }

    @Override
    public IntStream codePoints() {
        return this.toString().codePoints();
    }

    public boolean hasNext() {
        return this.to > this.from;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public void eof(boolean eof) {
        this.eof = eof;
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getAllocatedSize() {
        return this.content.length;
    }
}

