/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.util.NBPlusTree;

public class NBPlusTreeHelper {
    public static <K extends Comparable<K>, V> int compareEntries(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        Comparable k1 = (Comparable)o1.getKey();
        Comparable k2 = (Comparable)o2.getKey();
        if (k1 == null && k2 == null) {
            return 0;
        }
        if (k1 == null) {
            return -1;
        }
        if (k2 == null) {
            return 1;
        }
        return k1.compareTo(k2);
    }

    public static <K extends Comparable<K>> int compareKey(K k1, K k2) {
        if (k1 == k2) {
            return 0;
        }
        if (k1 == null) {
            return -1;
        }
        if (k2 == null) {
            return 1;
        }
        return k1.compareTo(k2);
    }

    public static <K extends Comparable<K>, V> boolean isDeficient(NBPlusTree.Node<K, V> node) {
        return node.size() < node.minSize();
    }

    public static <K extends Comparable<K>, V> boolean isEmpty(NBPlusTree.Node<K, V> node) {
        return node.size() == 0;
    }

    public static <K extends Comparable<K>, V> boolean isFull(NBPlusTree.LeafNode<K, V> node) {
        return node.size() == node.maxSize();
    }

    public static <K extends Comparable<K>, V> boolean isLendable(NBPlusTree.Node<K, V> node) {
        return node.size() > node.minSize();
    }

    public static <K extends Comparable<K>, V> boolean isMergeable(NBPlusTree.LeafNode<K, V> node) {
        return node.size() == node.minSize();
    }

    public static <K extends Comparable<K>, V> boolean isMergeable(NBPlusTree.IntermediateNode<K, V> node) {
        return node.size() == node.minSize();
    }

    public static <K extends Comparable<K>, V> boolean isOverfull(NBPlusTree.IntermediateNode<K, V> node) {
        return node.size() == node.maxSize() + 1;
    }

    public static boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static <K extends Comparable<K>> int binarySearchKeys(List<K> a, int numPairs, K key) {
        Comparator c = new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                return NBPlusTreeHelper.compareKey(o1, o2);
            }
        };
        int fromIndex = 0;
        int toIndex = numPairs;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Comparable midVal = (Comparable)a.get(mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int linearNullSearch(Map.Entry[] dps) {
        for (int i = 0; i < dps.length; ++i) {
            if (dps[i] != null) continue;
            return i;
        }
        return -1;
    }
}

