/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.time;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.elem.NMapBy;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.DefaultNDurationFormat;
import net.thevpc.nuts.time.NDurationFormatMode;
import net.thevpc.nuts.util.NOptional;

public class NDuration
implements Serializable {
    public static final NDuration ZERO = NDuration.ofMillis(0L);
    private long nanos;
    private long micros;
    private long milliSeconds;
    private long seconds;
    private long minutes;
    private long hours;
    private long days;
    private long weeks;
    private long months;
    private long years;
    private final ChronoUnit smallestUnit;
    private final ChronoUnit largestUnit;
    private final long timeMillis;
    private final int timeNanos;

    @NMapBy
    public NDuration(@NMapBy(name="years") long years, @NMapBy(name="months") long months, @NMapBy(name="weeks") long weeks, @NMapBy(name="days") long days, @NMapBy(name="hours") long hours, @NMapBy(name="minutes") long minutes, @NMapBy(name="seconds") long seconds, @NMapBy(name="milliSeconds") long milliSeconds, @NMapBy(name="micros") long micros, @NMapBy(name="nanos") long nanos, @NMapBy(name="smallestUnit") ChronoUnit smallestUnit, @NMapBy(name="largestUnit") ChronoUnit largestUnit) {
        this.nanos = nanos;
        this.micros = micros;
        this.milliSeconds = milliSeconds;
        this.seconds = seconds;
        this.minutes = minutes;
        this.hours = hours;
        this.days = days;
        this.weeks = weeks;
        this.months = months;
        this.years = years;
        this.timeMillis = this.rebuildTimeMillis();
        this.timeNanos = this.rebuildTimeNanos();
        this.smallestUnit = smallestUnit == null ? this.detectSmallestUnit() : NDuration.normalize(smallestUnit);
        ChronoUnit chronoUnit = largestUnit = largestUnit == null ? this.detectLargestUnit() : NDuration.normalize(largestUnit);
        if (largestUnit.ordinal() < this.smallestUnit.ordinal()) {
            largestUnit = this.smallestUnit;
        }
        this.largestUnit = largestUnit;
        this.applyUnits();
    }

    public NDuration(long[] values, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        this.nanos = values[ChronoUnit.NANOS.ordinal()];
        this.micros = values[ChronoUnit.MICROS.ordinal()];
        this.milliSeconds = values[ChronoUnit.MILLIS.ordinal()];
        this.seconds = values[ChronoUnit.SECONDS.ordinal()];
        this.minutes = values[ChronoUnit.MINUTES.ordinal()];
        this.hours = values[ChronoUnit.HOURS.ordinal()];
        this.days = values[ChronoUnit.DAYS.ordinal()];
        this.weeks = values[ChronoUnit.WEEKS.ordinal()];
        this.months = values[ChronoUnit.MONTHS.ordinal()];
        this.years = values[ChronoUnit.YEARS.ordinal()];
        this.timeMillis = this.rebuildTimeMillis();
        this.timeNanos = this.rebuildTimeNanos();
        this.smallestUnit = smallestUnit == null ? this.detectSmallestUnit() : NDuration.normalize(smallestUnit);
        ChronoUnit chronoUnit = largestUnit = largestUnit == null ? this.detectLargestUnit() : NDuration.normalize(largestUnit);
        if (largestUnit.ordinal() < this.smallestUnit.ordinal()) {
            largestUnit = this.smallestUnit;
        }
        this.largestUnit = largestUnit;
        this.applyUnits();
    }

    public NDuration(long timeMillis, int timeNanos) {
        this.timeMillis = timeMillis;
        this.timeNanos = timeNanos;
        this.nanos = (int)((long)timeNanos % 1000L);
        this.micros = (int)((long)timeNanos / 1000L);
        this.milliSeconds = (int)(timeMillis % 1000L);
        this.seconds = (int)(timeMillis / 1000L % 60L);
        this.minutes = (int)(timeMillis / 60000L % 60L);
        this.hours = (int)(timeMillis / 3600000L % 24L);
        long dd = timeMillis / 3600000L / 24L;
        this.years = dd / 365L;
        this.months = (dd %= 365L) / 30L;
        this.weeks = (dd %= 30L) / 7L;
        this.days = dd %= 7L;
        this.smallestUnit = this.detectSmallestUnit();
        this.largestUnit = this.detectLargestUnit();
    }

    public NDuration(long timeMillis, int timeNanos, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        this.timeMillis = timeMillis;
        this.timeNanos = timeNanos;
        if (smallestUnit != null && largestUnit != null) {
            this.smallestUnit = NDuration.normalize(smallestUnit);
            if ((largestUnit = NDuration.normalize(largestUnit)).ordinal() < this.smallestUnit.ordinal()) {
                largestUnit = this.smallestUnit;
            }
            this.largestUnit = largestUnit;
            int largestUnitOrdinal = this.largestUnit.ordinal();
            int smallestUnitOrdinal = this.smallestUnit.ordinal();
            if (smallestUnitOrdinal <= ChronoUnit.NANOS.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.NANOS.ordinal()) {
                    this.nanos = (int)((long)timeNanos % 1000L);
                } else {
                    this.nanos = (long)timeNanos + timeMillis * 1000000L;
                    return;
                }
            }
            if (smallestUnitOrdinal <= ChronoUnit.MICROS.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.MICROS.ordinal()) {
                    this.micros = (int)((long)timeNanos / 1000L);
                } else {
                    this.micros = (long)((int)((long)timeNanos / 1000L)) + timeMillis * 1000L;
                    return;
                }
            }
            if (smallestUnitOrdinal <= ChronoUnit.MILLIS.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.MILLIS.ordinal()) {
                    this.milliSeconds = (int)(timeMillis % 1000L);
                } else {
                    this.milliSeconds = timeMillis;
                    return;
                }
            }
            if (smallestUnitOrdinal <= ChronoUnit.SECONDS.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.SECONDS.ordinal()) {
                    this.seconds = (int)(timeMillis / 1000L % 60L);
                } else {
                    this.seconds = timeMillis / 1000L;
                    return;
                }
            }
            if (smallestUnitOrdinal <= ChronoUnit.MINUTES.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.MINUTES.ordinal()) {
                    this.minutes = (int)(timeMillis / 60000L % 60L);
                } else {
                    this.minutes = timeMillis / 60000L;
                    return;
                }
            }
            if (smallestUnitOrdinal <= ChronoUnit.HOURS.ordinal()) {
                if (largestUnitOrdinal > ChronoUnit.HOURS.ordinal()) {
                    this.hours = (int)(timeMillis / 3600000L % 24L);
                } else {
                    this.hours = (int)(timeMillis / 3600000L);
                    return;
                }
            }
            long dd = timeMillis / 3600000L / 24L;
            if (largestUnitOrdinal >= ChronoUnit.YEARS.ordinal()) {
                if (smallestUnitOrdinal <= ChronoUnit.YEARS.ordinal()) {
                    this.years = dd / 365L;
                }
                dd %= 365L;
            }
            if (largestUnitOrdinal >= ChronoUnit.MONTHS.ordinal()) {
                if (smallestUnitOrdinal <= ChronoUnit.MONTHS.ordinal()) {
                    this.months = dd / 30L;
                }
                dd %= 30L;
            }
            if (largestUnitOrdinal >= ChronoUnit.WEEKS.ordinal()) {
                if (smallestUnitOrdinal <= ChronoUnit.WEEKS.ordinal()) {
                    this.weeks = dd / 7L;
                }
                dd %= 7L;
            }
            if (smallestUnitOrdinal <= ChronoUnit.DAYS.ordinal()) {
                this.days = dd;
            }
        } else {
            this.nanos = (int)((long)timeNanos % 1000L);
            this.micros = (int)((long)timeNanos / 1000L);
            this.milliSeconds = (int)(timeMillis % 1000L);
            this.seconds = (int)(timeMillis / 1000L % 60L);
            this.minutes = (int)(timeMillis / 60000L % 60L);
            this.hours = (int)(timeMillis / 3600000L % 24L);
            long dd = timeMillis / 3600000L / 24L;
            this.years = dd / 365L;
            this.months = (dd %= 365L) / 30L;
            this.weeks = (dd %= 30L) / 7L;
            this.days = dd %= 7L;
            this.smallestUnit = smallestUnit == null ? this.detectSmallestUnit() : NDuration.normalize(smallestUnit);
            ChronoUnit chronoUnit = largestUnit = largestUnit == null ? this.detectLargestUnit() : NDuration.normalize(largestUnit);
            if (largestUnit.ordinal() < this.smallestUnit.ordinal()) {
                largestUnit = this.smallestUnit;
            }
            this.largestUnit = largestUnit;
            this.applyUnits();
        }
    }

    public static NDuration between(Instant start, Instant end) {
        return NDuration.ofDuration(Duration.between(start, end));
    }

    private int rebuildTimeNanos() {
        return (int)(this.nanos + this.micros * 1000L);
    }

    private long rebuildTimeMillis() {
        return this.milliSeconds + this.seconds * 1000L + this.minutes * 1000L * 60L + this.hours * 1000L * 60L * 60L + this.days * 1000L * 60L * 60L * 24L + this.weeks * 1000L * 60L * 60L * 24L * 7L + this.months * 1000L * 60L * 60L * 24L * 30L + this.years * 1000L * 60L * 60L * 24L * 365L;
    }

    private void applyUnits() {
        int uo = this.smallestUnit.ordinal();
        if (uo > ChronoUnit.NANOS.ordinal()) {
            this.nanos = 0L;
        }
        if (uo > ChronoUnit.MICROS.ordinal()) {
            this.micros = 0L;
        }
        if (uo > ChronoUnit.MILLIS.ordinal()) {
            this.milliSeconds = 0L;
        }
        if (uo > ChronoUnit.SECONDS.ordinal()) {
            this.seconds = 0L;
        }
        if (uo > ChronoUnit.MINUTES.ordinal()) {
            this.minutes = 0L;
        }
        if (uo > ChronoUnit.HOURS.ordinal()) {
            this.hours = 0L;
        }
        if (uo > ChronoUnit.DAYS.ordinal()) {
            this.days = 0L;
        }
        if (uo > ChronoUnit.WEEKS.ordinal()) {
            this.weeks = 0L;
        }
        if (uo > ChronoUnit.MONTHS.ordinal()) {
            this.months = 0L;
        }
        if (uo > ChronoUnit.MONTHS.ordinal()) {
            this.months = 0L;
        }
        if (uo > ChronoUnit.YEARS.ordinal()) {
            this.years = 0L;
        }
        switch (this.largestUnit) {
            case YEARS: {
                break;
            }
            case MONTHS: {
                this.months += 12L * this.years;
                this.years = 0L;
                break;
            }
            case WEEKS: {
                this.weeks += 4L * this.months + 52L * this.years;
                this.years = 0L;
                this.months = 0L;
                break;
            }
            case DAYS: {
                this.days += 7L * this.weeks + 30L * this.months + 365L * this.years;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                break;
            }
            case HOURS: {
                this.hours += (7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                break;
            }
            case MINUTES: {
                this.minutes += ((7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L + this.hours) * 60L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                this.hours = 0L;
                break;
            }
            case SECONDS: {
                this.seconds += (((7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L + this.hours) * 60L + this.minutes) * 60L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                this.hours = 0L;
                this.minutes = 0L;
                break;
            }
            case MILLIS: {
                this.milliSeconds += ((((7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L + this.hours) * 60L + this.minutes) * 60L + this.seconds) * 1000L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                this.hours = 0L;
                this.minutes = 0L;
                this.seconds = 0L;
                break;
            }
            case MICROS: {
                this.micros += (((((7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L + this.hours) * 60L + this.minutes) * 60L + this.seconds) * 1000L + this.milliSeconds) * 1000L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                this.hours = 0L;
                this.minutes = 0L;
                this.seconds = 0L;
                this.milliSeconds = 0L;
                break;
            }
            case NANOS: {
                this.nanos += ((((((7L * this.weeks + 30L * this.months + 365L * this.years + this.days) * 24L + this.hours) * 60L + this.minutes) * 60L + this.seconds) * 1000L + this.milliSeconds) * 1000L + this.micros) * 1000L;
                this.years = 0L;
                this.months = 0L;
                this.weeks = 0L;
                this.days = 0L;
                this.hours = 0L;
                this.minutes = 0L;
                this.seconds = 0L;
                this.milliSeconds = 0L;
                this.micros = 0L;
            }
        }
    }

    private ChronoUnit detectSmallestUnit() {
        if ((this.nanos | this.micros | this.milliSeconds | this.seconds | this.minutes | this.hours | this.days | this.weeks | this.months | this.years) == 0L) {
            return ChronoUnit.NANOS;
        }
        return this.nanos != 0L ? ChronoUnit.NANOS : (this.micros != 0L ? ChronoUnit.MICROS : (this.milliSeconds != 0L ? ChronoUnit.MILLIS : (this.seconds != 0L ? ChronoUnit.SECONDS : (this.minutes != 0L ? ChronoUnit.MINUTES : (this.hours != 0L ? ChronoUnit.HOURS : (this.days != 0L ? ChronoUnit.DAYS : (this.weeks != 0L ? ChronoUnit.WEEKS : (this.months != 0L ? ChronoUnit.MONTHS : (this.years != 0L ? ChronoUnit.YEARS : NDuration.normalize(ChronoUnit.FOREVER))))))))));
    }

    private ChronoUnit detectLargestUnit() {
        if ((this.nanos | this.micros | this.milliSeconds | this.seconds | this.minutes | this.hours | this.days | this.weeks | this.months | this.years) == 0L) {
            return ChronoUnit.NANOS;
        }
        return this.years != 0L ? ChronoUnit.YEARS : (this.months != 0L ? ChronoUnit.MONTHS : (this.weeks != 0L ? ChronoUnit.WEEKS : (this.days != 0L ? ChronoUnit.DAYS : (this.hours != 0L ? ChronoUnit.HOURS : (this.minutes != 0L ? ChronoUnit.MINUTES : (this.seconds != 0L ? ChronoUnit.SECONDS : (this.milliSeconds != 0L ? ChronoUnit.MILLIS : (this.micros != 0L ? ChronoUnit.MICROS : (this.nanos != 0L ? ChronoUnit.NANOS : NDuration.normalize(ChronoUnit.FOREVER))))))))));
    }

    static ChronoUnit normalize(ChronoUnit smallestUnit) {
        switch (smallestUnit) {
            case YEARS: 
            case WEEKS: 
            case DAYS: 
            case HOURS: 
            case MINUTES: 
            case SECONDS: 
            case MILLIS: 
            case MICROS: 
            case NANOS: {
                return smallestUnit;
            }
            case HALF_DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        return ChronoUnit.YEARS;
    }

    public static NDuration ofNanos(long durationNanos) {
        long ms = durationNanos / 1000000L;
        int ns = (int)(durationNanos % 1000000L);
        return new NDuration(ms, ns);
    }

    public static NDuration ofNanos(long durationNanos, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        long ms = durationNanos / 1000000L;
        int ns = (int)(durationNanos % 1000000L);
        return new NDuration(ms, ns, smallestUnit, largestUnit);
    }

    public static NDuration ofNanosOnly(long durationNanos) {
        return NDuration.ofUnitOnly(durationNanos, ChronoUnit.MILLIS);
    }

    public static NDuration ofMillisOnly(long durationMillis) {
        return NDuration.ofUnitOnly(durationMillis, ChronoUnit.MILLIS);
    }

    public static NDuration ofSecondsOnly(long durationSeconds) {
        return NDuration.ofUnitOnly(durationSeconds, ChronoUnit.SECONDS);
    }

    public static NDuration ofMinutesOnly(long durationMinutes) {
        return NDuration.ofUnitOnly(durationMinutes, ChronoUnit.MINUTES);
    }

    public static NDuration ofHoursOnly(long durationHours) {
        return NDuration.ofUnitOnly(durationHours, ChronoUnit.HOURS);
    }

    public static NDuration ofDaysOnly(long durationDays) {
        return NDuration.ofUnitOnly(durationDays, ChronoUnit.DAYS);
    }

    public static NDuration ofWeeksOnly(long durationWeeks) {
        return NDuration.ofUnitOnly(durationWeeks, ChronoUnit.WEEKS);
    }

    public static NDuration ofMonthOnly(long durationMonths) {
        return NDuration.ofUnitOnly(durationMonths, ChronoUnit.MONTHS);
    }

    public static NDuration ofYearsOnly(long durationYears) {
        return NDuration.ofUnitOnly(durationYears, ChronoUnit.YEARS);
    }

    public static NDuration ofSeconds(long durationSeconds) {
        return NDuration.ofUnit(durationSeconds, ChronoUnit.SECONDS);
    }

    public static NDuration ofMinutes(long durationMinutes) {
        return NDuration.ofUnit(durationMinutes, ChronoUnit.MINUTES);
    }

    public static NDuration ofHours(long durationHours) {
        return NDuration.ofUnit(durationHours, ChronoUnit.HOURS);
    }

    public static NDuration ofDays(long durationDays) {
        return NDuration.ofUnit(durationDays, ChronoUnit.DAYS);
    }

    public static NDuration ofWeeks(long durationWeeks) {
        return NDuration.ofUnit(durationWeeks, ChronoUnit.WEEKS);
    }

    public static NDuration ofMonth(long durationMonths) {
        return NDuration.ofUnit(durationMonths, ChronoUnit.MONTHS);
    }

    public static NDuration ofYears(long durationYears) {
        return NDuration.ofUnit(durationYears, ChronoUnit.YEARS);
    }

    public static NDuration ofUnitOnly(long durationInUnit, ChronoUnit unit) {
        long[] values = new long[ChronoUnit.values().length];
        values[unit.ordinal()] = durationInUnit;
        return new NDuration(values, null, null);
    }

    public static NDuration ofUnit(long durationInUnit, ChronoUnit unit) {
        return NDuration.ofUnitOnly(durationInUnit, unit).normalize();
    }

    public static NDuration ofMillis(long durationMillis) {
        return new NDuration(durationMillis, 0);
    }

    public static NDuration ofMillis(long durationMillis, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        return new NDuration(durationMillis, 0, smallestUnit, largestUnit);
    }

    public static NDuration ofDuration(Duration duration) {
        return NDuration.ofSecondsAndNanos(duration.getSeconds(), duration.getNano());
    }

    public static NDuration ofMillisAndNanos(long durationMillis, int nanos) {
        return new NDuration(durationMillis, nanos);
    }

    public static NDuration of(long[] values, ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        return new NDuration(values, smallestUnit, largestUnit);
    }

    public static NDuration of(long[] values) {
        return NDuration.of(values, null, null);
    }

    public static NDuration ofSecondsAndNanos(long durationSeconds, long nanos) {
        long millis = durationSeconds * 1000L + nanos / 1000000L;
        int ns = (int)(nanos % 1000000L);
        return NDuration.ofMillisAndNanos(millis, ns);
    }

    public long getNanos() {
        return this.nanos;
    }

    public ChronoUnit firstNonZeroUp(ChronoUnit unit) {
        ChronoUnit[] values = ChronoUnit.values();
        for (int o = unit.ordinal(); o < values.length; ++o) {
            if (this.get(values[o]) == 0L) continue;
            return values[o];
        }
        return null;
    }

    public ChronoUnit firstNonZeroDown(ChronoUnit unit) {
        ChronoUnit[] values = ChronoUnit.values();
        for (int o = unit.ordinal(); o > 0; --o) {
            if (this.get(values[o]) == 0L) continue;
            return values[o];
        }
        return null;
    }

    public boolean isZeroDown(ChronoUnit unit) {
        switch (unit) {
            case YEARS: 
            case CENTURIES: 
            case ERAS: 
            case FOREVER: 
            case MILLENNIA: 
            case DECADES: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case MONTHS: {
                return (this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case WEEKS: {
                return (this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case DAYS: {
                return (this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case HOURS: {
                return (this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case MINUTES: {
                return (this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case SECONDS: {
                return (this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case MILLIS: {
                return (this.milliSeconds | this.micros | this.nanos) == 0L;
            }
            case MICROS: {
                return (this.micros | this.nanos) == 0L;
            }
            case NANOS: {
                return this.nanos == 0L;
            }
        }
        return false;
    }

    public boolean isZeroUp(ChronoUnit unit) {
        switch (unit) {
            case YEARS: 
            case CENTURIES: 
            case ERAS: 
            case FOREVER: 
            case MILLENNIA: 
            case DECADES: {
                return this.years == 0L;
            }
            case MONTHS: {
                return (this.years | this.months) == 0L;
            }
            case WEEKS: {
                return (this.years | this.months | this.weeks) == 0L;
            }
            case DAYS: {
                return (this.years | this.months | this.weeks | this.days) == 0L;
            }
            case HOURS: {
                return (this.years | this.months | this.weeks | this.days | this.hours) == 0L;
            }
            case MINUTES: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes) == 0L;
            }
            case SECONDS: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds) == 0L;
            }
            case MILLIS: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds) == 0L;
            }
            case MICROS: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros) == 0L;
            }
            case NANOS: {
                return (this.years | this.months | this.weeks | this.days | this.hours | this.minutes | this.seconds | this.milliSeconds | this.micros | this.nanos) == 0L;
            }
        }
        return false;
    }

    public long to(ChronoUnit unit) {
        switch (unit) {
            case YEARS: {
                return this.toYears();
            }
            case MONTHS: {
                return this.toMonths();
            }
            case WEEKS: {
                return this.toWeeks();
            }
            case DAYS: {
                return this.toDays();
            }
            case HOURS: {
                return this.toHours();
            }
            case MINUTES: {
                return this.toMinutes();
            }
            case SECONDS: {
                return this.toSeconds();
            }
            case MILLIS: {
                return this.toMillis();
            }
            case MICROS: {
                return this.toMicros();
            }
            case NANOS: {
                return this.toNanos();
            }
        }
        return 0L;
    }

    public long get(ChronoUnit unit) {
        switch (unit) {
            case YEARS: {
                return this.years;
            }
            case MONTHS: {
                return this.months;
            }
            case WEEKS: {
                return this.weeks;
            }
            case DAYS: {
                return this.days;
            }
            case HOURS: {
                return this.hours;
            }
            case MINUTES: {
                return this.minutes;
            }
            case SECONDS: {
                return this.seconds;
            }
            case MILLIS: {
                return this.milliSeconds;
            }
            case MICROS: {
                return this.micros;
            }
            case NANOS: {
                return this.nanos;
            }
        }
        return 0L;
    }

    public long getMicros() {
        return this.micros;
    }

    public long getMilliSeconds() {
        return this.milliSeconds;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public long getHours() {
        return this.hours;
    }

    public long getDays() {
        return this.days;
    }

    public long getYears() {
        return this.years;
    }

    public long getMonths() {
        return this.months;
    }

    public long getWeeks() {
        return this.weeks;
    }

    public ChronoUnit getLargestUnit() {
        return this.largestUnit;
    }

    public ChronoUnit getSmallestUnit() {
        return this.smallestUnit;
    }

    public long toYears() {
        return this.timeMillis / 1000L / 3600L / 24L / 365L;
    }

    public long toMonths() {
        return this.timeMillis / 1000L / 3600L / 24L / 30L;
    }

    public long toWeeks() {
        return this.timeMillis / 1000L / 3600L / 24L / 7L;
    }

    public long toDays() {
        return this.timeMillis / 1000L / 3600L / 24L;
    }

    public long toHours() {
        return this.timeMillis / 1000L / 3600L;
    }

    public long toMinutes() {
        return this.timeMillis / 1000L / 60L;
    }

    public long toSeconds() {
        return this.timeMillis / 1000L;
    }

    public double getTimeAsDoubleSeconds() {
        return (double)this.timeMillis / 1000.0 + (double)this.timeNanos / 1.0E9;
    }

    public long toMillis() {
        return this.timeMillis;
    }

    public long toMicros() {
        return this.timeMillis * 1000L + (long)(this.timeNanos / 1000);
    }

    public long toNanos() {
        return this.timeMillis * 1000000L + (long)this.timeNanos;
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public int getTimeNanos() {
        return this.timeNanos;
    }

    public Duration toDuration() {
        long millis = this.timeMillis;
        long nanos = this.timeNanos;
        long secondsFromMillis = millis / 1000L;
        long remainingMillis = millis % 1000L;
        long nanosFromMillis = remainingMillis * 1000000L;
        long totalNanos = nanosFromMillis + nanos;
        long secondsFromNanos = totalNanos / 1000000000L;
        long remainingNanos = totalNanos % 1000000000L;
        return Duration.ofSeconds(secondsFromMillis + secondsFromNanos, remainingNanos);
    }

    public NDuration withSmallestUnit(ChronoUnit smallestUnit) {
        NDuration d = new NDuration(this.toUnitsArray(), smallestUnit, this.largestUnit);
        if (this.timeMillis != d.timeMillis || this.timeNanos != d.timeNanos) {
            throw new IllegalArgumentException("unexpected");
        }
        return d;
    }

    public NDuration withLargestUnit(ChronoUnit largestUnit) {
        NDuration d = new NDuration(this.toUnitsArray(), this.smallestUnit, largestUnit);
        if (this.timeMillis != d.timeMillis || this.timeNanos != d.timeNanos) {
            throw new IllegalArgumentException("unexpected");
        }
        return d;
    }

    public NDuration withUnits(ChronoUnit smallestUnit, ChronoUnit largestUnit) {
        NDuration d = new NDuration(this.toUnitsArray(), smallestUnit, largestUnit);
        if (this.timeMillis != d.timeMillis || this.timeNanos != d.timeNanos) {
            throw new IllegalArgumentException("unexpected");
        }
        return d;
    }

    private boolean normalizeNegativeUnit(long[] values, ChronoUnit curr, ChronoUnit next, long multiplier) {
        if (values[curr.ordinal()] < 0L) {
            if (values[curr.ordinal()] > 0L) {
                long requiredMicros = -values[next.ordinal()] / multiplier;
                if (requiredMicros * multiplier < -values[next.ordinal()]) {
                    ++requiredMicros;
                }
                if ((requiredMicros = Math.min(requiredMicros, values[next.ordinal()])) > 0L) {
                    int n = curr.ordinal();
                    values[n] = values[n] + requiredMicros * multiplier;
                    int n2 = next.ordinal();
                    values[n2] = values[n2] - requiredMicros;
                }
                return values[curr.ordinal()] < 0L;
            }
            return true;
        }
        return false;
    }

    public NDuration neg() {
        long[] a = this.toUnitsArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = -a[i];
        }
        return NDuration.of(a, this.smallestUnit, this.largestUnit);
    }

    public NDuration add(NDuration other) {
        long[] a = this.toUnitsArray();
        long[] b = other.toUnitsArray();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
        return NDuration.of(a, this.smallestUnit.compareTo(other.getSmallestUnit()) < 0 ? this.smallestUnit : other.smallestUnit, this.largestUnit.compareTo(other.getSmallestUnit()) > 0 ? this.largestUnit : other.smallestUnit);
    }

    public NDuration mul(double other) {
        double ms = (double)this.timeMillis * other;
        long msL = (long)((double)this.timeMillis * other);
        long ns = (long)((double)this.timeNanos * other + (ms - (double)msL) * 1000000.0);
        return NDuration.ofMillisAndNanos(msL, (int)ns).withUnits(this.smallestUnit, this.largestUnit);
    }

    public NDuration mul(long other) {
        long[] a = this.toUnitsArray();
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * other;
        }
        return NDuration.of(a, this.smallestUnit, this.largestUnit);
    }

    public NDuration subtract(NDuration other) {
        long[] a = this.toUnitsArray();
        long[] b = other.toUnitsArray();
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] - b[i];
        }
        return NDuration.of(a, this.smallestUnit.compareTo(other.getSmallestUnit()) < 0 ? this.smallestUnit : other.smallestUnit, this.largestUnit.compareTo(other.getSmallestUnit()) > 0 ? this.largestUnit : other.smallestUnit);
    }

    public NDuration normalize() {
        long[] values = this.toUnitsArray();
        if (this.shouldNormalizeUnit(ChronoUnit.NANOS, ChronoUnit.MICROS)) {
            this.carryOverflow(values, ChronoUnit.NANOS, ChronoUnit.MICROS, 1000L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.MICROS, ChronoUnit.MILLIS)) {
            this.carryOverflow(values, ChronoUnit.MICROS, ChronoUnit.MILLIS, 1000L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.MILLIS, ChronoUnit.SECONDS)) {
            this.carryOverflow(values, ChronoUnit.MILLIS, ChronoUnit.SECONDS, 1000L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.SECONDS, ChronoUnit.MINUTES)) {
            this.carryOverflow(values, ChronoUnit.SECONDS, ChronoUnit.MINUTES, 60L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.MINUTES, ChronoUnit.HOURS)) {
            this.carryOverflow(values, ChronoUnit.MINUTES, ChronoUnit.HOURS, 60L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.HOURS, ChronoUnit.DAYS)) {
            this.carryOverflow(values, ChronoUnit.HOURS, ChronoUnit.DAYS, 24L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.DAYS, ChronoUnit.WEEKS)) {
            this.carryOverflow(values, ChronoUnit.DAYS, ChronoUnit.WEEKS, 7L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.WEEKS, ChronoUnit.MONTHS)) {
            this.carryOverflow(values, ChronoUnit.WEEKS, ChronoUnit.MONTHS, 4L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.MONTHS, ChronoUnit.YEARS)) {
            this.carryOverflow(values, ChronoUnit.MONTHS, ChronoUnit.YEARS, 12L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.NANOS, ChronoUnit.MICROS)) {
            this.normalizeMixedSigns(values, ChronoUnit.NANOS, ChronoUnit.MICROS, 1000L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.MICROS, ChronoUnit.MILLIS)) {
            this.normalizeMixedSigns(values, ChronoUnit.MICROS, ChronoUnit.MILLIS, 1000L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.MILLIS, ChronoUnit.SECONDS)) {
            this.normalizeMixedSigns(values, ChronoUnit.MILLIS, ChronoUnit.SECONDS, 1000L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.SECONDS, ChronoUnit.MINUTES)) {
            this.normalizeMixedSigns(values, ChronoUnit.SECONDS, ChronoUnit.MINUTES, 60L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.MINUTES, ChronoUnit.HOURS)) {
            this.normalizeMixedSigns(values, ChronoUnit.MINUTES, ChronoUnit.HOURS, 60L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.HOURS, ChronoUnit.DAYS)) {
            this.normalizeMixedSigns(values, ChronoUnit.HOURS, ChronoUnit.DAYS, 24L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.DAYS, ChronoUnit.WEEKS)) {
            this.normalizeMixedSigns(values, ChronoUnit.DAYS, ChronoUnit.WEEKS, 7L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.WEEKS, ChronoUnit.MONTHS)) {
            this.normalizeMixedSigns(values, ChronoUnit.WEEKS, ChronoUnit.MONTHS, 4L);
        }
        if (this.shouldNormalizeUnit(ChronoUnit.MONTHS, ChronoUnit.YEARS)) {
            this.normalizeMixedSigns(values, ChronoUnit.MONTHS, ChronoUnit.YEARS, 12L);
        }
        for (ChronoUnit unit : ChronoUnit.values()) {
            if (unit.ordinal() >= this.smallestUnit.ordinal() && unit.ordinal() <= this.largestUnit.ordinal()) continue;
            values[unit.ordinal()] = 0L;
        }
        NDuration d = new NDuration(values, this.smallestUnit, this.largestUnit);
        if (this.timeMillis != d.timeMillis || this.timeNanos != d.timeNanos) {
            throw new IllegalArgumentException(NI18n.of("unexpected chronometer value: expected " + this.timeMillis + "ms " + this.timeNanos + "ns, got " + d.timeMillis + "ms " + d.timeNanos + "ns"));
        }
        return d;
    }

    private boolean shouldNormalizeUnit(ChronoUnit current, ChronoUnit next) {
        int currentOrd = current.ordinal();
        int nextOrd = next.ordinal();
        int smallestOrd = this.smallestUnit.ordinal();
        int largestOrd = this.largestUnit.ordinal();
        return currentOrd >= smallestOrd && currentOrd <= largestOrd && nextOrd >= smallestOrd && nextOrd <= largestOrd;
    }

    private void carryOverflow(long[] values, ChronoUnit current, ChronoUnit next, long multiplier) {
        long currentValue = values[current.ordinal()];
        if (currentValue >= multiplier || currentValue <= -multiplier) {
            long carry = currentValue / multiplier;
            long remainder = currentValue % multiplier;
            int n = next.ordinal();
            values[n] = values[n] + carry;
            values[current.ordinal()] = remainder;
        }
    }

    private void normalizeMixedSigns(long[] values, ChronoUnit current, ChronoUnit next, long multiplier) {
        long currentValue = values[current.ordinal()];
        long nextValue = values[next.ordinal()];
        if (currentValue != 0L && nextValue != 0L) {
            boolean nextNegative;
            boolean currentNegative = currentValue < 0L;
            boolean bl = nextNegative = nextValue < 0L;
            if (currentNegative != nextNegative) {
                if (nextNegative) {
                    int n = next.ordinal();
                    values[n] = values[n] + 1L;
                    int n2 = current.ordinal();
                    values[n2] = values[n2] - multiplier;
                } else {
                    int n = next.ordinal();
                    values[n] = values[n] - 1L;
                    int n3 = current.ordinal();
                    values[n3] = values[n3] + multiplier;
                }
            }
        }
    }

    public boolean isZero() {
        return (this.timeMillis | (long)this.timeNanos) == 0L;
    }

    public long[] toUnitsArray() {
        long[] arr = new long[ChronoUnit.values().length];
        arr[ChronoUnit.NANOS.ordinal()] = this.nanos;
        arr[ChronoUnit.MICROS.ordinal()] = this.micros;
        arr[ChronoUnit.MILLIS.ordinal()] = this.milliSeconds;
        arr[ChronoUnit.SECONDS.ordinal()] = this.seconds;
        arr[ChronoUnit.MINUTES.ordinal()] = this.minutes;
        arr[ChronoUnit.HOURS.ordinal()] = this.hours;
        arr[ChronoUnit.DAYS.ordinal()] = this.days;
        arr[ChronoUnit.WEEKS.ordinal()] = this.weeks;
        arr[ChronoUnit.MONTHS.ordinal()] = this.months;
        arr[ChronoUnit.YEARS.ordinal()] = this.years;
        return arr;
    }

    public String toString(NDurationFormatMode formatMode) {
        return DefaultNDurationFormat.of(formatMode).format(this);
    }

    public String toString() {
        return DefaultNDurationFormat.DEFAULT.format(this);
    }

    public static NOptional<NDuration> parse(String any) {
        if (any == null || any.trim().isEmpty()) {
            return NOptional.ofEmpty();
        }
        String input = any.trim().toLowerCase();
        try {
            if (input.startsWith("p")) {
                try {
                    Duration jdkDuration = Duration.parse(input);
                    long[] durationValues = new long[ChronoUnit.values().length];
                    long totalSeconds = jdkDuration.getSeconds();
                    long nanos = jdkDuration.getNano();
                    durationValues[ChronoUnit.SECONDS.ordinal()] = totalSeconds;
                    if (nanos > 0L) {
                        durationValues[ChronoUnit.MILLIS.ordinal()] = nanos / 1000000L;
                    }
                    return NOptional.of(NDuration.of(durationValues));
                }
                catch (Exception e) {
                    return NOptional.ofEmpty();
                }
            }
            long[] durationValues = new long[ChronoUnit.values().length];
            input = input.replace(',', '.').replace("  ", " ").trim();
            String pattern = "(\\d+(?:\\.\\d+)?)\\s*([a-z]+)";
            Pattern regex = Pattern.compile(pattern);
            Matcher matcher = regex.matcher(input);
            boolean found = false;
            block57: while (matcher.find()) {
                String unit;
                found = true;
                double value = Double.parseDouble(matcher.group(1));
                switch (unit = matcher.group(2)) {
                    case "ns": 
                    case "nano": 
                    case "nanos": {
                        int n = ChronoUnit.NANOS.ordinal();
                        durationValues[n] = durationValues[n] + (long)value;
                        continue block57;
                    }
                    case "us": 
                    case "micro": 
                    case "micros": {
                        int n = ChronoUnit.MICROS.ordinal();
                        durationValues[n] = durationValues[n] + (long)value;
                        continue block57;
                    }
                    case "ms": 
                    case "milli": 
                    case "millis": {
                        int n = ChronoUnit.MILLIS.ordinal();
                        durationValues[n] = durationValues[n] + (long)value;
                        continue block57;
                    }
                    case "s": 
                    case "sec": 
                    case "secs": 
                    case "second": 
                    case "seconds": {
                        int n = ChronoUnit.SECONDS.ordinal();
                        durationValues[n] = durationValues[n] + (long)value;
                        continue block57;
                    }
                    case "m": 
                    case "mn": 
                    case "min": 
                    case "mins": 
                    case "minute": 
                    case "minutes": {
                        int n = ChronoUnit.MINUTES.ordinal();
                        durationValues[n] = durationValues[n] + (long)value;
                        continue block57;
                    }
                    case "h": 
                    case "hr": 
                    case "hrs": 
                    case "hour": 
                    case "hours": {
                        int n = ChronoUnit.HOURS.ordinal();
                        durationValues[n] = durationValues[n] + (long)value;
                        continue block57;
                    }
                    case "d": 
                    case "day": 
                    case "days": {
                        int n = ChronoUnit.DAYS.ordinal();
                        durationValues[n] = durationValues[n] + (long)value;
                        continue block57;
                    }
                    case "w": 
                    case "week": 
                    case "weeks": {
                        int n = ChronoUnit.WEEKS.ordinal();
                        durationValues[n] = durationValues[n] + (long)value;
                        continue block57;
                    }
                    case "mon": 
                    case "month": 
                    case "months": {
                        int n = ChronoUnit.MONTHS.ordinal();
                        durationValues[n] = durationValues[n] + (long)value;
                        continue block57;
                    }
                    case "y": 
                    case "year": 
                    case "years": {
                        int n = ChronoUnit.YEARS.ordinal();
                        durationValues[n] = durationValues[n] + (long)value;
                        continue block57;
                    }
                }
                return NOptional.ofNamedEmpty(NMsg.ofC("invalid unit value: %s", unit));
            }
            if (!found) {
                try {
                    double millis = Double.parseDouble(input);
                    durationValues[ChronoUnit.MILLIS.ordinal()] = (long)millis;
                    return NOptional.of(NDuration.of(durationValues));
                }
                catch (NumberFormatException e) {
                    return NOptional.ofNamedEmpty(NMsg.ofC("invalid millis value: %s", input));
                }
            }
            return NOptional.of(NDuration.of(durationValues));
        }
        catch (Exception e) {
            return NOptional.ofNamedEmpty(NMsg.ofC("invalid value: %s", any));
        }
    }
}

