/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NTextStyleType implements NEnum
{
    PLAIN(true),
    UNDERLINED(true),
    ITALIC(true),
    STRIKED(true),
    REVERSED(true),
    BOLD(true),
    BLINK(true),
    FORE_COLOR(true),
    BACK_COLOR(true),
    FORE_TRUE_COLOR(true),
    BACK_TRUE_COLOR(true),
    PRIMARY(false),
    SECONDARY(false),
    ERROR(false),
    WARN(false),
    INFO(false),
    CONFIG(false),
    COMMENTS(false),
    STRING(false),
    NUMBER(false),
    DATE(false),
    BOOLEAN(false),
    KEYWORD(false),
    OPTION(false),
    INPUT(false),
    SEPARATOR(false),
    OPERATOR(false),
    SUCCESS(false),
    FAIL(false),
    DANGER(false),
    VAR(false),
    PALE(false),
    PATH(false),
    VERSION(false),
    TITLE(false);

    private final boolean basic;
    private final String id;

    private NTextStyleType(boolean basic) {
        this.basic = basic;
        this.id = NNameFormat.ID_NAME.format(this.name());
    }

    public static NOptional<NTextStyleType> parse(String value) {
        return NEnumUtils.parseEnum(value, NTextStyleType.class, s -> {
            switch (s.getNormalizedValue()) {
                case "F": 
                case "FOREGROUND": 
                case "FOREGROUNDCOLOR": 
                case "FORE_COLOR": 
                case "FOREGROUND_COLOR": {
                    return NOptional.of(FORE_COLOR);
                }
                case "PLAIN": {
                    return NOptional.of(PLAIN);
                }
                case "FX": 
                case "FOREGROUNDX": 
                case "FOREGROUNDTRUECOLOR": 
                case "FOREGROUND_TRUE_COLOR": {
                    return NOptional.of(FORE_TRUE_COLOR);
                }
                case "B": 
                case "BACKGROUND": 
                case "BACK_COLOR": 
                case "BACKCOLOR": 
                case "BACKGROUNDCOLOR": 
                case "BACKGROUND_COLOR": {
                    return NOptional.of(BACK_COLOR);
                }
                case "BX": 
                case "BACKTRUECOLOR": 
                case "BACK_TRUE_COLOR": 
                case "BACKGROUNDX": 
                case "BACKGROUNDTRUECOLOR": 
                case "BACKGROUND_TRUE_COLOR": {
                    return NOptional.of(BACK_TRUE_COLOR);
                }
                case "P": 
                case "PRIMARY": {
                    return NOptional.of(PRIMARY);
                }
                case "S": 
                case "SECONDARY": {
                    return NOptional.of(SECONDARY);
                }
                case "UNDERLINED": {
                    return NOptional.of(UNDERLINED);
                }
                case "BOLD": {
                    return NOptional.of(BOLD);
                }
                case "BOOLEAN": 
                case "BOOL": {
                    return NOptional.of(BOOLEAN);
                }
                case "BLINK": {
                    return NOptional.of(BLINK);
                }
                case "COMMENT": 
                case "COMMENTS": {
                    return NOptional.of(COMMENTS);
                }
                case "CONFIG": {
                    return NOptional.of(CONFIG);
                }
                case "DANGER": {
                    return NOptional.of(DANGER);
                }
                case "DATE": {
                    return NOptional.of(DATE);
                }
                case "NUMBER": {
                    return NOptional.of(NUMBER);
                }
                case "ERROR": {
                    return NOptional.of(ERROR);
                }
                case "WARNING": 
                case "WARN": {
                    return NOptional.of(WARN);
                }
                case "VERSION": {
                    return NOptional.of(VERSION);
                }
                case "VAR": 
                case "VARIABLE": {
                    return NOptional.of(VAR);
                }
                case "INPUT": {
                    return NOptional.of(INPUT);
                }
                case "TITLE": {
                    return NOptional.of(TITLE);
                }
                case "SUCCESS": {
                    return NOptional.of(SUCCESS);
                }
                case "STRING": {
                    return NOptional.of(STRING);
                }
                case "STRIKE": 
                case "STRIKED": {
                    return NOptional.of(STRIKED);
                }
                case "SEP": 
                case "SEPARATOR": {
                    return NOptional.of(SEPARATOR);
                }
                case "REVERSED": {
                    return NOptional.of(REVERSED);
                }
                case "PATH": {
                    return NOptional.of(PATH);
                }
                case "OPTION": {
                    return NOptional.of(OPTION);
                }
                case "PALE": {
                    return NOptional.of(PALE);
                }
                case "OPERATOR": {
                    return NOptional.of(OPERATOR);
                }
                case "KW": 
                case "KEYWORD": {
                    return NOptional.of(KEYWORD);
                }
                case "ITALIC": {
                    return NOptional.of(ITALIC);
                }
                case "INFORMATION": 
                case "INFO": {
                    return NOptional.of(INFO);
                }
                case "FAIL": {
                    return NOptional.of(FAIL);
                }
            }
            return null;
        });
    }

    @Override
    public String id() {
        return this.id;
    }

    public boolean isBasic(boolean trueBasic) {
        if (trueBasic) {
            if (this.basic) {
                switch (this.ordinal()) {
                    case 7: 
                    case 8: {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return this.basic;
    }

    public boolean basic() {
        return this.basic;
    }

    public boolean trueBasic() {
        if (this.basic) {
            switch (this.ordinal()) {
                case 7: 
                case 8: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

