/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.util.Objects;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextStyleType;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NColor;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;

public class NTextStyle
implements NEnum {
    private final NTextStyleType type;
    private final int variant;

    public NTextStyle(NTextStyleType type, int variant) {
        this.type = type;
        this.variant = variant;
    }

    public static NTextStyle of(NTextStyleType style) {
        return NTextStyle.of(style, 0);
    }

    public static NTextStyle of(NTextStyleType style, int variant) {
        return new NTextStyle(style, variant);
    }

    public static NTextStyle primary1() {
        return NTextStyle.primary(1);
    }

    public static NTextStyle primary2() {
        return NTextStyle.primary(2);
    }

    public static NTextStyle primary3() {
        return NTextStyle.primary(3);
    }

    public static NTextStyle primary4() {
        return NTextStyle.primary(4);
    }

    public static NTextStyle primary5() {
        return NTextStyle.primary(5);
    }

    public static NTextStyle primary6() {
        return NTextStyle.primary(6);
    }

    public static NTextStyle primary7() {
        return NTextStyle.primary(7);
    }

    public static NTextStyle primary8() {
        return NTextStyle.primary(8);
    }

    public static NTextStyle primary9() {
        return NTextStyle.primary(9);
    }

    public static NTextStyle primary(int variant) {
        return NTextStyle.of(NTextStyleType.PRIMARY, variant);
    }

    public static NTextStyle fail(int variant) {
        return NTextStyle.of(NTextStyleType.FAIL, variant);
    }

    public static NTextStyle fail() {
        return NTextStyle.of(NTextStyleType.FAIL);
    }

    public static NTextStyle danger(int variant) {
        return NTextStyle.of(NTextStyleType.DANGER, variant);
    }

    public static NTextStyle danger() {
        return NTextStyle.of(NTextStyleType.DANGER);
    }

    public static NTextStyle title(int variant) {
        return NTextStyle.of(NTextStyleType.TITLE, variant);
    }

    public static NTextStyle title1() {
        return NTextStyle.title(1);
    }

    public static NTextStyle title2() {
        return NTextStyle.title(2);
    }

    public static NTextStyle title3() {
        return NTextStyle.title(3);
    }

    public static NTextStyle title4() {
        return NTextStyle.title(4);
    }

    public static NTextStyle title5() {
        return NTextStyle.title(5);
    }

    public static NTextStyle title6() {
        return NTextStyle.title(6);
    }

    public static NTextStyle title7() {
        return NTextStyle.title(7);
    }

    public static NTextStyle title8() {
        return NTextStyle.title(8);
    }

    public static NTextStyle title9() {
        return NTextStyle.title(9);
    }

    public static NTextStyle secondary(int variant) {
        return NTextStyle.of(NTextStyleType.SECONDARY, variant);
    }

    public static NTextStyle secondary1() {
        return NTextStyle.secondary(1);
    }

    public static NTextStyle secondary2() {
        return NTextStyle.secondary(2);
    }

    public static NTextStyle secondary3() {
        return NTextStyle.secondary(3);
    }

    public static NTextStyle secondary4() {
        return NTextStyle.secondary(4);
    }

    public static NTextStyle secondary5() {
        return NTextStyle.secondary(5);
    }

    public static NTextStyle secondary6() {
        return NTextStyle.secondary(6);
    }

    public static NTextStyle secondary7() {
        return NTextStyle.secondary(7);
    }

    public static NTextStyle secondary8() {
        return NTextStyle.secondary(8);
    }

    public static NTextStyle secondary9() {
        return NTextStyle.secondary(9);
    }

    public static NTextStyle error() {
        return NTextStyle.of(NTextStyleType.ERROR);
    }

    public static NTextStyle error(int variant) {
        return NTextStyle.of(NTextStyleType.ERROR, variant);
    }

    public static NTextStyle option() {
        return NTextStyle.of(NTextStyleType.OPTION);
    }

    public static NTextStyle option(int variant) {
        return NTextStyle.of(NTextStyleType.OPTION, variant);
    }

    public static NTextStyle separator() {
        return NTextStyle.of(NTextStyleType.SEPARATOR);
    }

    public static NTextStyle separator(int variant) {
        return NTextStyle.of(NTextStyleType.SEPARATOR, variant);
    }

    public static NTextStyle version() {
        return NTextStyle.of(NTextStyleType.VERSION);
    }

    public static NTextStyle version(int variant) {
        return NTextStyle.of(NTextStyleType.VERSION, variant);
    }

    public static NTextStyle keyword() {
        return NTextStyle.of(NTextStyleType.KEYWORD);
    }

    public static NTextStyle keyword(int variant) {
        return NTextStyle.of(NTextStyleType.KEYWORD, variant);
    }

    public static NTextStyle reversed() {
        return NTextStyle.of(NTextStyleType.REVERSED);
    }

    public static NTextStyle reversed(int variant) {
        return NTextStyle.of(NTextStyleType.REVERSED, variant);
    }

    public static NTextStyle underlined() {
        return NTextStyle.of(NTextStyleType.UNDERLINED);
    }

    public static NTextStyle striked() {
        return NTextStyle.striked(0);
    }

    public static NTextStyle striked(int variant) {
        return NTextStyle.of(NTextStyleType.STRIKED, variant);
    }

    public static NTextStyle italic() {
        return NTextStyle.of(NTextStyleType.ITALIC);
    }

    public static NTextStyle italic(int variant) {
        return NTextStyle.of(NTextStyleType.ITALIC, variant);
    }

    public static NTextStyle bold() {
        return NTextStyle.of(NTextStyleType.BOLD);
    }

    public static NTextStyle bool() {
        return NTextStyle.of(NTextStyleType.BOOLEAN);
    }

    public static NTextStyle bool(int variant) {
        return NTextStyle.of(NTextStyleType.BOOLEAN, variant);
    }

    public static NTextStyle blink() {
        return NTextStyle.of(NTextStyleType.BLINK);
    }

    public static NTextStyle pale() {
        return NTextStyle.of(NTextStyleType.PALE);
    }

    public static NTextStyle pale(int variant) {
        return NTextStyle.of(NTextStyleType.PALE, variant);
    }

    public static NTextStyle success() {
        return NTextStyle.of(NTextStyleType.SUCCESS);
    }

    public static NTextStyle success(int variant) {
        return NTextStyle.of(NTextStyleType.SUCCESS, variant);
    }

    public static NTextStyle path() {
        return NTextStyle.of(NTextStyleType.PATH);
    }

    public static NTextStyle path(int variant) {
        return NTextStyle.of(NTextStyleType.PATH, variant);
    }

    public static NTextStyle warn() {
        return NTextStyle.of(NTextStyleType.WARN);
    }

    public static NTextStyle warn(int variant) {
        return NTextStyle.of(NTextStyleType.WARN, variant);
    }

    public static NTextStyle config() {
        return NTextStyle.of(NTextStyleType.CONFIG);
    }

    public static NTextStyle config(int variant) {
        return NTextStyle.of(NTextStyleType.CONFIG, variant);
    }

    public static NTextStyle info() {
        return NTextStyle.of(NTextStyleType.INFO);
    }

    public static NTextStyle info(int variant) {
        return NTextStyle.of(NTextStyleType.INFO, variant);
    }

    public static NTextStyle string() {
        return NTextStyle.of(NTextStyleType.STRING);
    }

    public static NTextStyle string(int variant) {
        return NTextStyle.of(NTextStyleType.STRING, variant);
    }

    public static NTextStyle operator() {
        return NTextStyle.of(NTextStyleType.OPERATOR);
    }

    public static NTextStyle operator(int variant) {
        return NTextStyle.of(NTextStyleType.OPERATOR, variant);
    }

    public static NTextStyle input() {
        return NTextStyle.of(NTextStyleType.INPUT);
    }

    public static NTextStyle input(int variant) {
        return NTextStyle.of(NTextStyleType.INPUT, variant);
    }

    public static NTextStyle comments() {
        return NTextStyle.of(NTextStyleType.COMMENTS);
    }

    public static NTextStyle comments(int variant) {
        return NTextStyle.of(NTextStyleType.COMMENTS, variant);
    }

    public static NTextStyle variable() {
        return NTextStyle.of(NTextStyleType.VAR);
    }

    public static NTextStyle variable(int variant) {
        return NTextStyle.of(NTextStyleType.VAR, variant);
    }

    public static NTextStyle number() {
        return NTextStyle.of(NTextStyleType.NUMBER);
    }

    public static NTextStyle date() {
        return NTextStyle.of(NTextStyleType.DATE);
    }

    public static NTextStyle date(int variant) {
        return NTextStyle.of(NTextStyleType.DATE, variant);
    }

    public static NTextStyle number(int variant) {
        return NTextStyle.of(NTextStyleType.VAR, variant);
    }

    public static NTextStyle foregroundColor(int variant) {
        return NTextStyle.of(NTextStyleType.FORE_COLOR, variant);
    }

    public static NTextStyle foregroundTrueColor(int variant) {
        return NTextStyle.of(NTextStyleType.FORE_TRUE_COLOR, variant);
    }

    public static NTextStyle foregroundTrueColor(NColor variant) {
        return NTextStyle.of(NTextStyleType.FORE_TRUE_COLOR, variant == null ? 0 : variant.getRGB());
    }

    public static NTextStyle backgroundColor(int variant) {
        return NTextStyle.of(NTextStyleType.BACK_COLOR, variant);
    }

    public static NTextStyle backgroundTrueColor(int variant) {
        return NTextStyle.of(NTextStyleType.BACK_TRUE_COLOR, variant);
    }

    public static NTextStyle backgroundTrueColor(NColor variant) {
        return NTextStyle.of(NTextStyleType.BACK_TRUE_COLOR, variant == null ? 0 : variant.getRGB());
    }

    public static NTextStyle backgroundColor(NColor variant) {
        if (variant == null) {
            return NTextStyle.backgroundColor(0);
        }
        switch (variant.getBits()) {
            case BITS_4: 
            case BITS_8: {
                return NTextStyle.secondary(variant.getIntColor());
            }
            case BITS_16: 
            case BITS_24: {
                return NTextStyle.backgroundColor(variant.getIntColor());
            }
            case BITS_32: 
            case BITS_64: {
                return NTextStyle.backgroundTrueColor(variant.getIntColor());
            }
        }
        return NTextStyle.of(NTextStyleType.BACK_TRUE_COLOR, variant.getRGB());
    }

    public static NTextStyle foregroundColor(NColor variant) {
        if (variant == null) {
            return NTextStyle.foregroundColor(0);
        }
        switch (variant.getBits()) {
            case BITS_4: 
            case BITS_8: {
                return NTextStyle.primary(variant.getIntColor());
            }
            case BITS_16: 
            case BITS_24: {
                return NTextStyle.foregroundColor(variant.getIntColor());
            }
            case BITS_32: 
            case BITS_64: {
                return NTextStyle.foregroundTrueColor(variant.getIntColor());
            }
        }
        return NTextStyle.of(NTextStyleType.FORE_TRUE_COLOR, variant.getRGB());
    }

    public static NOptional<NTextStyle> parse(String value) {
        NTextStyleType t;
        int len;
        String string = value = value == null ? "" : value.trim();
        if (value.isEmpty()) {
            return NOptional.ofEmpty(() -> NMsg.ofC("%s is empty", NTextStyle.class.getSimpleName()));
        }
        switch (value) {
            case "/": {
                return NOptional.of(NTextStyle.italic());
            }
            case "_": {
                return NOptional.of(NTextStyle.underlined());
            }
            case "%": {
                return NOptional.of(NTextStyle.blink());
            }
            case "!": {
                return NOptional.of(NTextStyle.reversed());
            }
            case "+": {
                return NOptional.of(NTextStyle.bold());
            }
            case "-": {
                return NOptional.of(NTextStyle.striked());
            }
        }
        String finalValue = value;
        int par = value.indexOf(40);
        String nbr = "";
        String key = value;
        if (par > 0) {
            int b = value.indexOf(41, par);
            if (b > 0) {
                nbr = value.substring(par + 1, b);
                key = value.substring(0, par);
            }
        } else if (value.trim().startsWith("fx") || value.trim().startsWith("bx")) {
            key = value.trim().substring(0, 2);
            nbr = value.trim().substring(2);
        } else if (value.trim().startsWith("foregroundx")) {
            len = "foregroundx".length();
            key = value.trim().substring(0, len);
            nbr = value.trim().substring(len);
        } else if (value.trim().startsWith("backgroundx")) {
            len = "backgroundx".length();
            key = value.trim().substring(0, len);
            nbr = value.trim().substring(len);
        } else {
            int x = len = value.length();
            while (x - 1 >= 0 && Character.isDigit(value.charAt(x - 1))) {
                --x;
            }
            if (x < len) {
                nbr = value.substring(x, len);
                key = value.substring(0, x);
            }
        }
        nbr = nbr.trim();
        key = key.trim();
        if (nbr.isEmpty()) {
            nbr = "0";
        }
        if (key.isEmpty()) {
            key = "p";
        }
        if ((t = NTextStyleType.parse(key).orNull()) == null) {
            if (NBlankable.isBlank(key)) {
                return NOptional.ofEmpty(() -> NMsg.ofC("%s is empty", NTextStyle.class.getSimpleName()));
            }
            NOptional<NColor> u = NColor.ofName(key);
            if (u.isPresent()) {
                return NOptional.of(NTextStyle.of(NTextStyleType.FORE_TRUE_COLOR, u.get().getIntColor()));
            }
            if (NBlankable.isBlank(key) && (u = NColor.ofName("fg_" + key.trim())).isPresent()) {
                return NOptional.of(NTextStyle.of(NTextStyleType.FORE_TRUE_COLOR, u.get().getIntColor()));
            }
            if (NBlankable.isBlank(key) && (u = NColor.ofName("fore_" + key.trim())).isPresent()) {
                return NOptional.of(NTextStyle.of(NTextStyleType.FORE_TRUE_COLOR, u.get().getIntColor()));
            }
            if (NBlankable.isBlank(key) && (u = NColor.ofName("bg_" + key.trim())).isPresent()) {
                return NOptional.of(NTextStyle.of(NTextStyleType.BACK_TRUE_COLOR, u.get().getIntColor()));
            }
            if (NBlankable.isBlank(key) && (u = NColor.ofName("back_" + key.trim())).isPresent()) {
                return NOptional.of(NTextStyle.of(NTextStyleType.BACK_TRUE_COLOR, u.get().getIntColor()));
            }
            return NOptional.ofError(() -> NMsg.ofC("%s invalid value : %s", NTextStyle.class.getSimpleName(), finalValue));
        }
        switch (t) {
            case FORE_TRUE_COLOR: 
            case BACK_TRUE_COLOR: {
                Integer ii = NLiteral.of("0x" + nbr).asInt().orNull();
                if (ii == null) {
                    if (NBlankable.isBlank(key)) {
                        ii = 0;
                    } else {
                        return NOptional.ofError(() -> NMsg.ofC(NTextStyle.class.getSimpleName() + " invalid value : %s", finalValue));
                    }
                }
                return NOptional.of(NTextStyle.of(t, ii));
            }
        }
        Integer ii = NLiteral.of(nbr).asInt().orNull();
        if (ii == null) {
            if (NBlankable.isBlank(key)) {
                ii = 0;
            } else {
                return NOptional.ofError(() -> NMsg.ofC(NTextStyle.class.getSimpleName() + " invalid value : %s", finalValue));
            }
        }
        return NOptional.of(NTextStyle.of(t, ii));
    }

    public NTextStyles append(NTextStyle other) {
        return NTextStyles.of(this, other);
    }

    public NTextStyles append(NTextStyles other) {
        return NTextStyles.of(this).append(other);
    }

    public NTextStyleType getType() {
        return this.type;
    }

    public int getVariant() {
        return this.variant;
    }

    @Override
    public String id() {
        switch (this.type) {
            case PLAIN: {
                return "";
            }
            case PRIMARY: {
                return "p" + (this.variant <= 0 ? "" : String.valueOf(this.variant));
            }
            case SECONDARY: {
                return "s" + (this.variant <= 0 ? "" : String.valueOf(this.variant));
            }
            case UNDERLINED: {
                return "_" + (this.variant <= 0 ? "" : String.valueOf(this.variant));
            }
            case STRIKED: {
                return "-" + (this.variant <= 0 ? "" : String.valueOf(this.variant));
            }
            case BLINK: {
                return "%" + (this.variant <= 0 ? "" : String.valueOf(this.variant));
            }
            case ITALIC: {
                return "/" + (this.variant <= 0 ? "" : String.valueOf(this.variant));
            }
            case BOLD: {
                return "+" + (this.variant <= 0 ? "" : String.valueOf(this.variant));
            }
            case REVERSED: {
                return "!" + (this.variant <= 0 ? "" : String.valueOf(this.variant));
            }
            case FORE_COLOR: {
                return "f" + (this.variant <= 0 ? "0" : String.valueOf(this.variant));
            }
            case BACK_COLOR: {
                return "b" + (this.variant <= 0 ? "0" : String.valueOf(this.variant));
            }
            case FORE_TRUE_COLOR: {
                StringBuilder s = new StringBuilder(Integer.toString(this.variant, 16));
                while (s.length() < 8) {
                    s.insert(0, '0');
                }
                return "fx" + s;
            }
            case BACK_TRUE_COLOR: {
                StringBuilder s = new StringBuilder(Integer.toString(this.variant, 16));
                while (s.length() < 8) {
                    s.insert(0, '0');
                }
                return "bx" + s;
            }
        }
        return this.type.id() + (this.variant <= 0 ? "" : String.valueOf(this.variant));
    }

    public int hashCode() {
        return Objects.hash(this.type, this.variant);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NTextStyle that = (NTextStyle)o;
        return this.variant == that.variant && this.type == that.type;
    }

    public String toString() {
        if (this.variant == 0) {
            return String.valueOf(this.type);
        }
        return this.type + "(" + this.variant + ")";
    }
}

