/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NNormalizedText;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyleGenerator;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTextTransformer;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class NTextBuilderPlain
implements NTextBuilder {
    private StringBuilder sb = new StringBuilder();

    public NTextBuilderPlain() {
    }

    public NTextBuilderPlain(String data) {
        if (data != null) {
            this.sb.append(data);
        }
    }

    @Override
    public Iterator<NText> iterator() {
        return Collections.unmodifiableList(this.getChildren()).iterator();
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    @Override
    public NTextType type() {
        return NTextType.BUILDER;
    }

    @Override
    public NTextBuilder builder() {
        return new NTextBuilderPlain(this.sb.toString());
    }

    @Override
    public NTextStyleGenerator getStyleGenerator() {
        return new NTextStyleGenerator(){
            private boolean includePlain = false;

            @Override
            public NTextStyles hash(Object i) {
                return NTextStyles.of(new NTextStyle[0]);
            }

            @Override
            public NTextStyles hash(int i) {
                return NTextStyles.of(new NTextStyle[0]);
            }

            @Override
            public NTextStyles random() {
                return NTextStyles.of(new NTextStyle[0]);
            }

            @Override
            public boolean isIncludePlain() {
                return this.includePlain;
            }

            @Override
            public NTextStyleGenerator setIncludePlain(boolean includePlain) {
                this.includePlain = includePlain;
                return this;
            }

            @Override
            public boolean isIncludeBold() {
                return false;
            }

            @Override
            public NTextStyleGenerator setIncludeBold(boolean includeBold) {
                return this;
            }

            @Override
            public boolean isIncludeBlink() {
                return false;
            }

            @Override
            public NTextStyleGenerator setIncludeBlink(boolean includeBlink) {
                return this;
            }

            @Override
            public boolean isIncludeReversed() {
                return false;
            }

            @Override
            public NTextStyleGenerator setIncludeReversed(boolean includeReversed) {
                return this;
            }

            @Override
            public boolean isIncludeItalic() {
                return false;
            }

            @Override
            public NTextStyleGenerator setIncludeItalic(boolean includeItalic) {
                return this;
            }

            @Override
            public boolean isIncludeUnderlined() {
                return false;
            }

            @Override
            public NTextStyleGenerator setIncludeUnderlined(boolean includeUnderlined) {
                return this;
            }

            @Override
            public boolean isIncludeStriked() {
                return false;
            }

            @Override
            public NTextStyleGenerator setIncludeStriked(boolean includeStriked) {
                return this;
            }

            @Override
            public boolean isIncludeForeground() {
                return false;
            }

            @Override
            public NTextStyleGenerator setIncludeForeground(boolean includeForeground) {
                return this;
            }

            @Override
            public boolean isIncludeBackground() {
                return false;
            }

            @Override
            public NTextStyleGenerator setIncludeBackground(boolean includeBackground) {
                return this;
            }

            @Override
            public boolean isUseThemeColors() {
                return false;
            }

            @Override
            public boolean isUsePaletteColors() {
                return false;
            }

            @Override
            public boolean isUseTrueColors() {
                return false;
            }

            @Override
            public NTextStyleGenerator setUseThemeColors() {
                return this;
            }

            @Override
            public NTextStyleGenerator setUsePaletteColors() {
                return this;
            }

            @Override
            public NTextStyleGenerator setUseTrueColors() {
                return this;
            }
        };
    }

    @Override
    public boolean isNormalized() {
        return false;
    }

    @Override
    public NNormalizedText normalize() {
        return (NNormalizedText)this.build();
    }

    @Override
    public NNormalizedText normalize(NTextTransformConfig config) {
        return (NNormalizedText)this.build();
    }

    @Override
    public NNormalizedText normalize(NTextTransformer transformer, NTextTransformConfig config) {
        return (NNormalizedText)this.build();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public NTextBuilder setStyleGenerator(NTextStyleGenerator styleGenerator) {
        return this;
    }

    @Override
    public NTextBuilder appendCommand(NTerminalCmd command) {
        return this;
    }

    @Override
    public NTextBuilder appendCode(String lang, String text) {
        this.sb.append(text == null ? "" : text);
        return this;
    }

    @Override
    public NTextBuilder appendHashStyle(Object text) {
        this.sb.append(text == null ? "" : text);
        return this;
    }

    @Override
    public NTextBuilder appendRandomStyle(Object text) {
        this.sb.append(text == null ? "" : text);
        return this;
    }

    @Override
    public NTextBuilder appendHashStyle(Object text, Object hash) {
        this.sb.append(text == null ? "" : text);
        return this;
    }

    @Override
    public NTextBuilder append(Object text, NTextStyle style) {
        this.sb.append(text == null ? "" : text);
        return this;
    }

    @Override
    public NTextBuilder append(Object text, NTextStyles styles) {
        this.sb.append(text == null ? "" : text);
        return this;
    }

    @Override
    public NTextBuilder append(Object node) {
        this.sb.append(node == null ? "" : node);
        return this;
    }

    @Override
    public NTextBuilder append(NText node) {
        this.sb.append(node == null ? "" : node);
        return this;
    }

    @Override
    public NTextBuilder appendJoined(Object separator, Collection<?> others) {
        if (others != null) {
            boolean first = true;
            for (Object other : others) {
                if (first) {
                    first = false;
                } else {
                    this.append(separator);
                }
                this.append(other);
            }
        }
        return this;
    }

    @Override
    public NTextBuilder appendAll(NText[] others) {
        if (others != null) {
            for (NText node : others) {
                if (node == null) continue;
                this.append(node);
            }
        }
        return this;
    }

    @Override
    public NTextBuilder appendAll(Collection<?> others) {
        if (others != null) {
            for (Object other : others) {
                this.append(other);
            }
        }
        return this;
    }

    @Override
    public NTextBuilder delete(int start, int end) {
        this.sb.delete(start, end);
        return this;
    }

    @Override
    public NText build() {
        return new ImmutableNTextPlain(this.sb.toString());
    }

    @Override
    public List<NText> getChildren() {
        return Arrays.asList(this.build());
    }

    @Override
    public NText substring(int start, int end) {
        return new ImmutableNTextPlain(this.sb.substring(start, end));
    }

    @Override
    public boolean isString(String anyString) {
        return anyString != null && anyString.equals(this.sb.toString());
    }

    @Override
    public NTextBuilder insert(int at, NText ... newTexts) {
        StringBuilder sb2 = new StringBuilder();
        for (NText newText : newTexts) {
            sb2.append(newText);
        }
        this.sb.insert(at, sb2);
        return this;
    }

    @Override
    public NTextBuilder replace(int from, int to, NText ... newTexts) {
        StringBuilder sb2 = new StringBuilder();
        for (NText newText : newTexts) {
            sb2.append(newText);
        }
        this.sb.replace(from, to, sb2.toString());
        return this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public NText get(int index) {
        if (index == 0) {
            return this.build();
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public NTextBuilder flatten() {
        NTextBuilderPlain b = new NTextBuilderPlain();
        this.sb.append((CharSequence)this.sb);
        return b;
    }

    @Override
    public NTextBuilder removeAt(int index) {
        return this;
    }

    @Override
    public NStream<NTextBuilder> lines() {
        throw new IllegalArgumentException(NMsg.ofC(NI18n.of("not supported method %s"), "lines()").toString());
    }

    @Override
    public NTextBuilder readLine() {
        String line = NStringUtils.readLine(this.sb);
        if (line == null) {
            return null;
        }
        return new NTextBuilderPlain(line);
    }

    @Override
    public boolean isNewLine() {
        String s = this.filteredText();
        return s.equals("\n") || s.equals("\r") || s.equals("\r\n");
    }

    @Override
    public List<NPrimitiveText> toCharList() {
        return this.sb.codePoints().mapToObj(c -> new ImmutableNTextPlain(new String(Character.toChars(c)))).collect(Collectors.toList());
    }

    @Override
    public NStream<NPrimitiveText> toCharStream() {
        return NStream.ofStream(this.sb.codePoints().mapToObj(c -> new ImmutableNTextPlain(new String(Character.toChars(c)))));
    }

    @Override
    public boolean isWhitespace() {
        String s = this.sb.toString();
        return !s.isEmpty() && s.trim().isEmpty();
    }

    @Override
    public NTextBuilder newLine() {
        return this.append("\n");
    }

    @Override
    public NText immutable() {
        return new ImmutableNTextPlain(this.sb.toString());
    }

    @Override
    public String filteredText() {
        return this.sb.toString();
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public boolean isEmpty() {
        return this.sb.length() == 0;
    }

    @Override
    public boolean isBlank() {
        return NBlankable.isBlank(this.sb.toString());
    }

    @Override
    public NText simplify() {
        return this;
    }

    @Override
    public NPrimitiveText[] toCharArray() {
        return this.toCharList().toArray(new NPrimitiveText[0]);
    }

    @Override
    public List<NText> split(char c) {
        return this.split(String.valueOf(c), false);
    }

    @Override
    public List<NText> split(char c, boolean returnSeparator) {
        return this.split(String.valueOf(c), returnSeparator);
    }

    @Override
    public List<NText> split(String separator) {
        return this.split(separator, false);
    }

    @Override
    public List<NText> split(String separator, boolean returnSeparator) {
        StringTokenizer st = new StringTokenizer(this.toString(), separator, true);
        ArrayList<NText> all = new ArrayList<NText>();
        while (st.hasMoreElements()) {
            all.add(new ImmutableNTextPlain(st.nextToken()));
        }
        return all;
    }

    @Override
    public NTextBuilder clear() {
        this.sb.delete(0, this.sb.length());
        return this;
    }

    @Override
    public NTextBuilder trim() {
        NStringUtils.trim(this.sb);
        return this;
    }

    @Override
    public NTextBuilder trimLeft() {
        NStringUtils.trimLeft(this.sb);
        return this;
    }

    @Override
    public NTextBuilder trimRight() {
        NStringUtils.trimRight(this.sb);
        return this;
    }

    @Override
    public NText repeat(int times) {
        if (times <= 0) {
            return NText.ofPlain("");
        }
        if (times == 1) {
            return this;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            b.append(this.sb.toString());
        }
        return new ImmutableNTextPlain(b.toString());
    }

    @Override
    public NText repeatln(int times) {
        if (times <= 0) {
            return NText.ofPlain("");
        }
        if (times == 1) {
            return this;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            if (i > 0) {
                b.append("\n");
            }
            b.append(this.sb.toString());
        }
        return new ImmutableNTextPlain(b.toString());
    }

    @Override
    public NText concat(NText other) {
        if (other == null) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.sb);
        sb.append(other);
        return new ImmutableNTextPlain(sb.toString());
    }

    @Override
    public NText concat(NText ... others) {
        if (others == null) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.sb);
        for (NText other : others) {
            sb.append(other);
        }
        return new ImmutableNTextPlain(sb.toString());
    }

    private static class ImmutableNTextPlain
    implements NTextPlain {
        private final String str;

        public ImmutableNTextPlain(String str) {
            this.str = str == null ? "" : str;
        }

        @Override
        public String getValue() {
            return this.str.toString();
        }

        @Override
        public NTextType type() {
            return NTextType.PLAIN;
        }

        @Override
        public NText immutable() {
            return this;
        }

        @Override
        public String filteredText() {
            return this.str;
        }

        @Override
        public int length() {
            return this.str.length();
        }

        @Override
        public boolean isEmpty() {
            return this.str.isEmpty();
        }

        @Override
        public NTextBuilder builder() {
            NTextBuilderPlain b = new NTextBuilderPlain();
            b.sb.append(this.str);
            return b;
        }

        @Override
        public NText simplify() {
            return this;
        }

        @Override
        public boolean isBlank() {
            return this.str.trim().isEmpty();
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public boolean isNewLine() {
            String s = this.filteredText();
            return s.equals("\n") || s.equals("\r") || s.equals("\r\n");
        }

        @Override
        public boolean isWhitespace() {
            return !this.str.isEmpty() && this.str.trim().isEmpty();
        }

        @Override
        public List<NPrimitiveText> toCharList() {
            return this.str.codePoints().mapToObj(c -> new ImmutableNTextPlain(new String(Character.toChars(c)))).collect(Collectors.toList());
        }

        @Override
        public NStream<NPrimitiveText> toCharStream() {
            return NStream.ofStream(this.str.codePoints().mapToObj(c -> new ImmutableNTextPlain(new String(Character.toChars(c)))));
        }

        @Override
        public NText substring(int start, int end) {
            return new ImmutableNTextPlain(this.str.substring(start, end));
        }

        @Override
        public List<NText> split(char c) {
            return this.split(String.valueOf(c), false);
        }

        @Override
        public List<NText> split(char c, boolean returnSeparator) {
            return this.split(String.valueOf(c), returnSeparator);
        }

        @Override
        public List<NText> split(String separator) {
            return this.split(separator, false);
        }

        @Override
        public List<NText> split(String separator, boolean returnSeparator) {
            StringTokenizer st = new StringTokenizer(this.str, separator, true);
            ArrayList<NText> all = new ArrayList<NText>();
            while (st.hasMoreElements()) {
                all.add(new ImmutableNTextPlain(st.nextToken()));
            }
            return all;
        }

        @Override
        public NText trim() {
            return new ImmutableNTextPlain(this.str.trim());
        }

        @Override
        public NText trimLeft() {
            return new ImmutableNTextPlain(NStringUtils.trimLeft(this.str));
        }

        @Override
        public NText trimRight() {
            return new ImmutableNTextPlain(NStringUtils.trimRight(this.str));
        }

        @Override
        public NText repeat(int times) {
            if (times <= 0) {
                return NText.ofPlain("");
            }
            if (times == 1) {
                return this;
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                b.append(this.str);
            }
            return new ImmutableNTextPlain(b.toString());
        }

        @Override
        public NText repeatln(int times) {
            if (times <= 0) {
                return NText.ofPlain("");
            }
            if (times == 1) {
                return this;
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                if (i > 0) {
                    b.append("\n");
                }
                b.append(this.str);
            }
            return new ImmutableNTextPlain(b.toString());
        }

        @Override
        public NText concat(NText other) {
            if (other == null) {
                return this;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.str);
            sb.append(other);
            return new ImmutableNTextPlain(sb.toString());
        }

        @Override
        public NText concat(NText ... others) {
            if (others == null) {
                return this;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.str);
            for (NText other : others) {
                sb.append(other);
            }
            return new ImmutableNTextPlain(sb.toString());
        }

        @Override
        public boolean isNormalized() {
            return true;
        }

        @Override
        public NNormalizedText normalize() {
            return this;
        }

        @Override
        public NNormalizedText normalize(NTextTransformConfig config) {
            return this;
        }

        @Override
        public NNormalizedText normalize(NTextTransformer transformer, NTextTransformConfig config) {
            return this;
        }

        @Override
        public NPrimitiveText[] toCharArray() {
            return this.toCharList().toArray(new NPrimitiveText[0]);
        }

        @Override
        public boolean isString(String anyString) {
            return anyString != null && anyString.equals(this.str);
        }
    }
}

