/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.util.NLiteral;

public final class NTerminalCmd {
    public static final NTerminalCmd LATER_RESET_LINE = new NTerminalCmd("later-reset-line");
    public static final NTerminalCmd MOVE_LINE_START = new NTerminalCmd("move-line-start");
    public static final NTerminalCmd CLEAR_SCREEN = new NTerminalCmd("clear-screen");
    public static final NTerminalCmd CLEAR_SCREEN_TO_CURSOR = new NTerminalCmd("clear-screen-from-cursor");
    public static final NTerminalCmd CLEAR_SCREEN_FROM_CURSOR = new NTerminalCmd("clear-screen-from-cursor");
    public static final NTerminalCmd CLEAR_LINE = new NTerminalCmd("clear-line");
    public static final NTerminalCmd CLEAR_LINE_TO_CURSOR = new NTerminalCmd("clear-line-from-cursor");
    public static final NTerminalCmd CLEAR_LINE_FROM_CURSOR = new NTerminalCmd("clear-line-from-cursor");
    public static final NTerminalCmd GET_SIZE = new NTerminalCmd("get-size");
    public static final NTerminalCmd GET_CURSOR = new NTerminalCmd("get-cursor");
    public static final NTerminalCmd MOVE_UP = NTerminalCmd.MOVE_UP(1);
    public static final NTerminalCmd MOVE_DOWN = NTerminalCmd.MOVE_DOWN(1);
    public static final NTerminalCmd MOVE_LEFT = NTerminalCmd.MOVE_LEFT(1);
    public static final NTerminalCmd MOVE_RIGHT = NTerminalCmd.MOVE_RIGHT(1);
    private final String name;
    private final List<String> args;

    public NTerminalCmd(String name) {
        this(name, Collections.emptyList());
    }

    public NTerminalCmd(String name, List<String> args) {
        this.name = name;
        this.args = NReservedLangUtils.unmodifiableList(args);
    }

    public static NTerminalCmd MOVE_TO(int col, int row) {
        return new NTerminalCmd("move-to", Arrays.asList(String.valueOf(col), String.valueOf(row)));
    }

    public static NTerminalCmd MOVE_RIGHT(int count) {
        return new NTerminalCmd("move-right", Arrays.asList(count <= 0 ? "1" : String.valueOf(count)));
    }

    public static NTerminalCmd MOVE_LEFT(int count) {
        return new NTerminalCmd("move-left", Arrays.asList(count <= 0 ? "1" : String.valueOf(count)));
    }

    public static NTerminalCmd MOVE_UP(int count) {
        return new NTerminalCmd("move-up", Arrays.asList(count <= 0 ? "1" : String.valueOf(count)));
    }

    public static NTerminalCmd MOVE_DOWN(int count) {
        return new NTerminalCmd("move-down", Arrays.asList(count <= 0 ? "1" : String.valueOf(count)));
    }

    public static NTerminalCmd of(String name) {
        return NTerminalCmd.of(name, "");
    }

    public static NTerminalCmd of(String name, String ... args) {
        if (args == null || args.length == 0) {
            switch (name) {
                case "later-reset-line": {
                    return LATER_RESET_LINE;
                }
                case "move-line-start": {
                    return MOVE_LINE_START;
                }
                case "clear-screen": {
                    return CLEAR_SCREEN;
                }
                case "clear-screen-to-cursor": {
                    return CLEAR_SCREEN_TO_CURSOR;
                }
                case "clear-screen-from-cursor": {
                    return CLEAR_SCREEN_FROM_CURSOR;
                }
                case "clear-line": {
                    return CLEAR_LINE;
                }
                case "clear-line-to-cursor": {
                    return CLEAR_LINE_TO_CURSOR;
                }
                case "clear-line-from-cursor": {
                    return CLEAR_LINE_FROM_CURSOR;
                }
                case "move-up": {
                    return MOVE_UP;
                }
                case "move-down": {
                    return MOVE_DOWN;
                }
                case "move-left": {
                    return MOVE_LEFT;
                }
                case "move-right": {
                    return MOVE_RIGHT;
                }
            }
        }
        switch (name) {
            case "later-reset-line": {
                return LATER_RESET_LINE;
            }
            case "move-line-start": {
                return MOVE_LINE_START;
            }
            case "clear-screen": {
                return CLEAR_SCREEN;
            }
            case "clear-screen-to-cursor": {
                return CLEAR_SCREEN_TO_CURSOR;
            }
            case "clear-screen-from-cursor": {
                return CLEAR_SCREEN_FROM_CURSOR;
            }
            case "clear-line": {
                return CLEAR_LINE;
            }
            case "clear-line-to-cursor": {
                return CLEAR_LINE_TO_CURSOR;
            }
            case "clear-line-from-cursor": {
                return CLEAR_LINE_FROM_CURSOR;
            }
            case "move-up": {
                return NTerminalCmd.MOVE_UP(NLiteral.of(args[0]).asInt().orElse(1));
            }
            case "move-down": {
                return NTerminalCmd.MOVE_DOWN(NLiteral.of(args[0]).asInt().orElse(1));
            }
            case "move-left": {
                return NTerminalCmd.MOVE_LEFT(NLiteral.of(args[0]).asInt().orElse(1));
            }
            case "move-right": {
                return NTerminalCmd.MOVE_RIGHT(NLiteral.of(args[0]).asInt().orElse(1));
            }
        }
        return new NTerminalCmd(name, args == null ? null : Arrays.asList(args));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.args);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NTerminalCmd that = (NTerminalCmd)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.args, that.args);
    }

    public String toString() {
        return "NutsTerminalCommand{name=" + this.name + ", args=" + this.args + '}';
    }

    public static final class Ids {
        public static final String LATER_RESET_LINE = "later-reset-line";
        public static final String MOVE_LINE_START = "move-line-start";
        public static final String MOVE_TO = "move-to";
        public static final String MOVE_UP = "move-up";
        public static final String MOVE_DOWN = "move-down";
        public static final String MOVE_LEFT = "move-left";
        public static final String MOVE_RIGHT = "move-right";
        public static final String CLEAR_SCREEN = "clear-screen";
        public static final String CLEAR_SCREEN_TO_CURSOR = "clear-screen-to-cursor";
        public static final String CLEAR_SCREEN_FROM_CURSOR = "clear-screen-from-cursor";
        public static final String CLEAR_LINE = "clear-line";
        public static final String CLEAR_LINE_TO_CURSOR = "clear-line-to-cursor";
        public static final String CLEAR_LINE_FROM_CURSOR = "clear-line-from-cursor";
        public static final String GET_SIZE = "get-size";
        public static final String GET_CURSOR = "get-cursor";

        private Ids() {
        }
    }
}

