/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgParam;
import net.thevpc.nuts.text.NTextFormatType;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStringUtils;

public class NMsgTemplate {
    private String message;
    private NTextFormatType format;

    public static NMsgTemplate ofC(String message) {
        return NMsgTemplate.of(message, NTextFormatType.CFORMAT);
    }

    public static NMsgTemplate ofJ(String message) {
        return NMsgTemplate.of(message, NTextFormatType.JFORMAT);
    }

    public static NMsgTemplate ofV(String message) {
        return NMsgTemplate.of(message, NTextFormatType.VFORMAT);
    }

    public static NMsgTemplate of(String message, NTextFormatType format) {
        return new NMsgTemplate(message, format);
    }

    public NMsgTemplate(String message, NTextFormatType format) {
        NAssert.requireNonNull(message, "message");
        NAssert.requireNonNull(format, "format");
        switch (format) {
            case CFORMAT: 
            case JFORMAT: 
            case VFORMAT: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid format. only Cformat, JFormat and VFormat are allowed");
            }
        }
        this.message = message;
        this.format = format;
    }

    public String getMessage() {
        return this.message;
    }

    /*
     * Unable to fully structure code
     */
    public String[] getParamNames() {
        try {
            paramSet = new HashSet<String>();
            params = new ArrayList<String>();
            switch (1.$SwitchMap$net$thevpc$nuts$text$NTextFormatType[this.format.ordinal()]) {
                case 1: {
                    r = new StringReader(this.message);
                    while ((i = r.read()) >= 0) {
                        c = (char)i;
                        if (c != '%' || (i = r.read()) < 0 || (c2 = (char)i) == 'n') continue;
                        params.add("");
                    }
                    break;
                }
                case 2: {
                    r = new StringReader(this.message);
                    maxElems = 0;
                    currentIndex = -1;
                    while ((i = r.read()) >= 0) {
                        c = (char)i;
                        if (c == '{') {
                            n = new StringBuilder();
                            while ((i = r.read()) >= 0) {
                                c = (char)i;
                                if (c == '\\') {
                                    i = r.read();
                                    if (i < 0) break;
                                    c = (char)i;
                                    n.append(c);
                                    continue;
                                }
                                if (c == '}') break;
                                n.append(c);
                            }
                            ++currentIndex;
                            ns = n.toString();
                            sep = ns.indexOf(58);
                            nsIntString = "";
                            nsInt = null;
                            nsIntString = sep < 0 ? ns.trim() : ns.substring(0, sep).trim();
                            if (nsIntString.isEmpty()) {
                                nsIntString = String.valueOf(currentIndex);
                            }
                            if ((lit = NLiteral.of(nsIntString)).asInt().isPresent()) {
                                nsInt = lit.asInt().get();
                            }
                            if (nsInt != null) {
                                while (maxElems <= nsInt) {
                                    if (paramSet.add(String.valueOf(maxElems))) {
                                        params.add(String.valueOf(maxElems));
                                    }
                                    ++maxElems;
                                }
                                continue;
                            }
                            if (!paramSet.add(nsIntString)) continue;
                            params.add(nsIntString);
                            continue;
                        }
                        if (c != '\\') continue;
                        r.read();
                    }
                    break;
                }
                case 3: {
                    r = new StringReader(this.message);
                    while ((i = r.read()) >= 0) {
                        c = (char)i;
                        if (c != '$') ** GOTO lbl109
                        i = r.read();
                        if (i < 0) {
                            if (!paramSet.add("")) continue;
                            params.add("");
                            continue;
                        }
                        c = (char)i;
                        if (c == '{') {
                            n = new StringBuilder();
                            while ((i = r.read()) >= 0 && (c = (char)i) != '}') {
                                n.append(c);
                            }
                            ns = n.toString();
                            if (!paramSet.add(ns)) continue;
                            params.add(ns);
                            continue;
                        }
                        n = new StringBuilder();
                        start = true;
                        while (true) {
                            r.mark(1);
                            i = r.read();
                            if (i < 0) ** GOTO lbl105
                            c = (char)i;
                            if (!start) ** GOTO lbl100
                            if (NStringUtils.isValidVarStart(c)) {
                                n.append(c);
                                start = false;
                                continue;
                            }
                            r.reset();
                            ** GOTO lbl105
lbl100:
                            // 1 sources

                            if (!NStringUtils.isValidVarPart(c)) break;
                            n.append(c);
                        }
                        r.reset();
lbl105:
                        // 3 sources

                        if (!paramSet.add(ns = n.toString())) continue;
                        params.add(ns);
                        continue;
lbl109:
                        // 1 sources

                        if (c != '\\') continue;
                        r.read();
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid format. only Cformat, JFormat and VFormat are allowed");
                }
            }
            return params.toArray(new String[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NTextFormatType getFormat() {
        return this.format;
    }

    public NMsg build(NMsgParam ... params) {
        switch (this.format) {
            case CFORMAT: {
                return NMsg.ofC(this.message, params);
            }
            case VFORMAT: {
                return NMsg.ofV(this.message, params);
            }
            case JFORMAT: {
                return NMsg.ofJ(this.message, params);
            }
        }
        throw new IllegalArgumentException("invalid format. only Cformat, JFormat and VFormat are allowed");
    }
}

