/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgParam;

public class NMsgBuilder {
    private Level level;
    private NMsgIntent intent;
    private NMsg msg;
    private long time;
    private Supplier<NMsg> msgSupplier;

    public static NMsgBuilder of() {
        return new NMsgBuilder();
    }

    public NMsgBuilder withIntent(NMsgIntent verb) {
        this.intent = verb;
        return this;
    }

    public NMsgBuilder withLevel(Level level) {
        this.level = level;
        return this;
    }

    public NMsgBuilder withMsgPlain(String plain) {
        return this.withMsg(NMsg.ofPlain(plain));
    }

    public NMsgBuilder withMsgNtf(String plain) {
        return this.withMsg(NMsg.ofNtf(plain));
    }

    public NMsgBuilder withMsgC(String plain) {
        return this.withMsg(NMsg.ofC(plain));
    }

    public NMsgBuilder withMsgC(String plain, Object ... params) {
        return this.withMsg(NMsg.ofC(plain, params));
    }

    public NMsgBuilder withMsgV(String message, NMsgParam ... params) {
        return this.withMsg(NMsg.ofV(message, params));
    }

    public NMsgBuilder withMsgV(String message, Map<String, ?> vars) {
        return this.withMsg(NMsg.ofV(message, vars));
    }

    public NMsgBuilder withMsgV(String message, Function<String, ?> vars) {
        return this.withMsg(NMsg.ofV(message, vars));
    }

    public NMsgBuilder withMsgJ(String message, NMsgParam ... params) {
        return this.withMsg(NMsg.ofJ(message, params));
    }

    public NMsgBuilder withMsgJ(String message, Object ... params) {
        return this.withMsg(NMsg.ofJ(message, params));
    }

    public NMsgBuilder withMsg(NMsg message) {
        this.msg = message;
        if (this.msg != null) {
            this.msgSupplier = null;
        }
        return this;
    }

    public NMsgBuilder withMsg(Supplier<NMsg> msgSupplier) {
        this.msgSupplier = msgSupplier;
        if (msgSupplier != null) {
            this.msg = null;
        }
        return this;
    }

    public NMsgBuilder withTimeMillis(long time) {
        this.time = time < 0L ? -1L : time * 1000000L;
        return this;
    }

    public NMsgBuilder withTimeNanos(long time) {
        this.time = time < 0L ? -1L : time;
        return this;
    }

    public NMsg build() {
        NMsg newMsg;
        NMsg m;
        Level level = this.level;
        NMsg msgOk = null;
        if (level == null) {
            m = this.msg;
            if (this.msgSupplier != null) {
                m = this.msgSupplier.get();
            }
            if (m == null) {
                level = Level.FINEST;
            } else {
                msgOk = m;
                level = msgOk.getLevel();
            }
        }
        if (msgOk == null) {
            m = this.msg;
            if (this.msgSupplier != null) {
                m = this.msgSupplier.get();
            }
            msgOk = m;
        }
        if ((newMsg = msgOk) == null) {
            newMsg = NMsg.ofPlain("");
        }
        if (this.intent != null) {
            newMsg = newMsg.withIntent(this.intent);
        }
        newMsg = newMsg.withLevel(level);
        if (this.intent == null && newMsg.getIntent() == null) {
            switch (this.level.intValue()) {
                case 1000: {
                    newMsg = newMsg.withIntent(NMsgIntent.FAIL);
                    break;
                }
                case 900: {
                    newMsg = newMsg.withIntent(NMsgIntent.ALERT);
                    break;
                }
                case 800: {
                    newMsg = newMsg.withIntent(NMsgIntent.NOTICE);
                    break;
                }
                case 700: {
                    newMsg = newMsg.withIntent(NMsgIntent.INIT);
                    break;
                }
                case 300: 
                case 400: 
                case 500: {
                    newMsg = newMsg.withIntent(NMsgIntent.DEBUG);
                }
            }
        }
        if (this.time >= 0L) {
            newMsg = newMsg.withDurationNanos(this.time);
        }
        return newMsg;
    }
}

