/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.text.NMsgFormattable;
import net.thevpc.nuts.text.NMsgParam;
import net.thevpc.nuts.text.NMsgSupplier;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextFormatType;
import net.thevpc.nuts.text.NTextFormattable;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NColor;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NMaps;
import net.thevpc.nuts.util.NStringUtils;

public class NMsg
implements NBlankable {
    public static final Object[] NO_PARAMS = new Object[0];
    private final String codeLang;
    private final Object message;
    private final Level level;
    private final NTextFormatType format;
    private final NMsgIntent intent;
    private final Object[] params;
    private final Function<String, ?> placeholderBindings;
    private final NTextStyles styles;
    private final Throwable throwable;
    private final long durationNano;

    public static Placeholder placeholder(String name) {
        NAssert.requireNonBlank(name, "name");
        return new Placeholder(name.trim());
    }

    public static NMsg ofMissingValue() {
        return NMsg.ofMissingValue((String)null);
    }

    public static NMsg ofMissingValue(String valueName) {
        if (NBlankable.isBlank(valueName)) {
            return NMsg.ofPlain("missing value");
        }
        return NMsg.ofC("missing %s", valueName);
    }

    public static NMsg ofMissingValue(NMsg valueName) {
        if (NBlankable.isBlank(valueName)) {
            return NMsg.ofPlain("missing value");
        }
        return NMsg.ofC("missing %s", valueName);
    }

    public static NMsg ofInvalidValue() {
        return NMsg.ofInvalidValue(null, (String)null);
    }

    public static NMsg ofInvalidValue(Throwable throwable) {
        return NMsg.ofInvalidValue(throwable, (String)null);
    }

    public static NMsg ofInvalidValue(String valueName) {
        return NMsg.ofInvalidValue(null, valueName);
    }

    public static NMsg ofInvalidValue(Throwable throwable, String valueName) {
        if (throwable == null) {
            if (NBlankable.isBlank(valueName)) {
                return NMsg.ofPlain("invalid value");
            }
            return NMsg.ofC("invalid %s", valueName);
        }
        if (NBlankable.isBlank(valueName)) {
            return NMsg.ofC("invalid value : %s", NExceptions.getErrorMessage(throwable));
        }
        return NMsg.ofC("invalid %s : %s", valueName, NExceptions.getErrorMessage(throwable));
    }

    public static NMsg ofInvalidValue(Throwable throwable, NMsg valueName) {
        if (throwable == null) {
            if (NBlankable.isBlank(valueName)) {
                return NMsg.ofPlain("invalid value");
            }
            return NMsg.ofC("invalid %s", valueName);
        }
        if (NBlankable.isBlank(valueName)) {
            return NMsg.ofC("invalid value : %s", NExceptions.getErrorMessage(throwable));
        }
        return NMsg.ofC("invalid %s : %s", valueName, NExceptions.getErrorMessage(throwable));
    }

    private static NMsg of(NTextFormatType format, Object message, Object[] params, NTextStyles styles, String codeLang, Level level, Throwable throwable, NMsgIntent intent, long time, Function<String, ?> placeholderBindings) {
        return new NMsg(format, message, params, styles, codeLang, level, throwable, intent, time, placeholderBindings);
    }

    private NMsg(NTextFormatType format, Object message, Object[] params, NTextStyles styles, String codeLang, Level level, Throwable throwable, NMsgIntent intent, long durationNano, Function<String, ?> placeholderBindings) {
        NAssert.requireNonNull(message, "message");
        NAssert.requireNonNull(format, "format");
        NAssert.requireNonNull(params, "params");
        this.level = level == null ? Level.INFO : level;
        this.format = format;
        this.throwable = throwable;
        this.styles = styles;
        if ((format == NTextFormatType.PLAIN || format == NTextFormatType.NTF || format == NTextFormatType.STYLED || format == NTextFormatType.CODE) && params.length > 0) {
            throw new IllegalArgumentException("arguments are not supported for " + format);
        }
        if (format == NTextFormatType.STYLED) {
            NAssert.requireNonNull(styles, "styles for " + format);
        } else {
            NAssert.requireNull((Object)styles, "styles for " + format + " (not supported)");
        }
        this.codeLang = NStringUtils.trimToNull(codeLang);
        this.message = message;
        this.params = params;
        this.intent = intent;
        this.durationNano = durationNano < 0L ? -1L : durationNano;
        this.placeholderBindings = placeholderBindings;
    }

    public static NMsg ofNtf(String message) {
        return NMsg.of(NTextFormatType.NTF, NStringUtils.firstNonNull(message, ""), NO_PARAMS, null, null, null, null, null, -1L, null);
    }

    public static NMsg ofCode(String lang, String text) {
        return NMsg.of(NTextFormatType.CODE, NStringUtils.firstNonNull(text, ""), NO_PARAMS, null, lang, null, null, null, -1L, null);
    }

    public static NMsg ofCode(String text) {
        return NMsg.of(NTextFormatType.CODE, NStringUtils.firstNonNull(text, ""), NO_PARAMS, null, null, null, null, null, -1L, null);
    }

    public static NMsg ofStringLiteral(String literal) {
        if (literal == null) {
            return NMsg.ofStyled("null", NTextStyle.primary1());
        }
        return NMsg.ofStyled(NStringUtils.formatStringLiteral(literal), NTextStyle.string());
    }

    public static NMsg ofStyled(String message, NTextStyle style) {
        return NMsg.of(NTextFormatType.STYLED, NStringUtils.firstNonNull(message, ""), NO_PARAMS, style == null ? null : NTextStyles.of(style), null, null, null, null, -1L, null);
    }

    public static NMsg ofStyled(String message, NTextStyles styles) {
        return NMsg.of(NTextFormatType.STYLED, NStringUtils.firstNonNull(message, ""), NO_PARAMS, styles, null, null, null, null, -1L, null);
    }

    public static NMsg ofStyled(NMsg message, NTextStyle style) {
        return NMsg.of(NTextFormatType.STYLED, message, NO_PARAMS, style == null ? null : NTextStyles.of(style), null, null, null, null, -1L, null);
    }

    public static NMsg ofStyled(NMsg message, NTextStyles styles) {
        return NMsg.of(NTextFormatType.STYLED, message, NO_PARAMS, styles, null, null, null, null, -1L, null);
    }

    public static NMsg ofStyled(NText message, NTextStyle style) {
        return NMsg.of(NTextFormatType.STYLED, message, NO_PARAMS, style == null ? null : NTextStyles.of(style), null, null, null, null, -1L, null);
    }

    public static NMsg ofStyled(NText message, NTextStyles styles) {
        return NMsg.of(NTextFormatType.STYLED, message, NO_PARAMS, styles, null, null, null, null, -1L, null);
    }

    public static NMsg ofNtf(NText message) {
        return NMsg.of(NTextFormatType.NTF, message, NO_PARAMS, null, null, null, null, null, -1L, null);
    }

    public static NMsg ofBlank() {
        return NMsg.of(NTextFormatType.PLAIN, "", NO_PARAMS, null, null, null, null, null, -1L, null);
    }

    public static NMsg ofPlain(String message) {
        return NMsg.of(NTextFormatType.PLAIN, NStringUtils.firstNonNull(message, ""), NO_PARAMS, null, null, null, null, null, -1L, null);
    }

    public static NMsg ofC(String message) {
        return NMsg.of(NTextFormatType.CFORMAT, NStringUtils.firstNonNull(message, ""), NO_PARAMS, null, null, null, null, null, -1L, null);
    }

    public static NMsg ofC(String message, Object ... params) {
        return NMsg.of(NTextFormatType.CFORMAT, NStringUtils.firstNonNull(message, ""), params, null, null, null, null, null, -1L, null);
    }

    public static NMsg ofV(String message, NMsgParam ... params) {
        if (params == null || params.length == 0) {
            return NMsg.ofV(message, (String s) -> null);
        }
        return NMsg.ofV(message, new MapAsSupplier2(params));
    }

    public static NMsg ofV(String message, Map<String, ?> vars) {
        return NMsg.of(NTextFormatType.VFORMAT, NStringUtils.firstNonNull(message, ""), new Object[]{vars}, null, null, null, null, null, -1L, null);
    }

    public static NMsg ofV(String message, Function<String, ?> vars) {
        return NMsg.of(NTextFormatType.VFORMAT, NStringUtils.firstNonNull(message, ""), new Object[]{vars}, null, null, null, null, null, -1L, null);
    }

    public static NMsg ofJ(String message, NMsgParam ... params) {
        if (params == null) {
            return NMsg.ofJ(message, new Object[]{null});
        }
        Object[] paramsAsObjects = Arrays.stream(params).map(NMsgParam::getValue).toArray();
        return NMsg.ofJ(message, paramsAsObjects);
    }

    public static NMsg ofC(String message, NMsgParam ... params) {
        if (params == null) {
            return NMsg.ofC(message, new Object[]{null});
        }
        Object[] paramsAsObjects = Arrays.stream(params).map(NMsgParam::getValue).toArray();
        return NMsg.ofC(message, paramsAsObjects);
    }

    @Deprecated
    public static NMsg ofJ(String message) {
        return NMsg.of(NTextFormatType.JFORMAT, NStringUtils.firstNonNull(message, ""), NO_PARAMS, null, null, null, null, null, -1L, null);
    }

    public static NMsg ofJ(String message, Object ... params) {
        return NMsg.of(NTextFormatType.JFORMAT, NStringUtils.firstNonNull(message, ""), params, null, null, null, null, null, -1L, null);
    }

    public NTextFormatType getFormat() {
        return this.format;
    }

    public NTextStyles getStyles() {
        return this.styles;
    }

    public Object getMessage() {
        return this.message;
    }

    public Function<String, ?> getPlaceholders() {
        return this.placeholderBindings;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String getCodeLang() {
        return this.codeLang;
    }

    public Level getNormalizedLevel() {
        if (this.level == null) {
            return Level.INFO;
        }
        int v = this.level.intValue();
        switch (v) {
            case -2147483648: {
                return Level.ALL;
            }
            case 300: {
                return Level.FINEST;
            }
            case 400: {
                return Level.FINER;
            }
            case 500: {
                return Level.FINE;
            }
            case 700: {
                return Level.CONFIG;
            }
            case 800: {
                return Level.INFO;
            }
            case 900: {
                return Level.WARNING;
            }
            case 1000: {
                return Level.SEVERE;
            }
            case 0x7FFFFFFF: {
                return Level.OFF;
            }
        }
        switch (v / 100) {
            case 3: {
                return Level.FINEST;
            }
            case 4: {
                return Level.FINER;
            }
            case 5: 
            case 6: {
                return Level.FINE;
            }
            case 7: {
                return Level.CONFIG;
            }
            case 8: {
                return Level.INFO;
            }
            case 9: {
                return Level.WARNING;
            }
            case 10: {
                return Level.SEVERE;
            }
        }
        if (v < Level.FINEST.intValue()) {
            return Level.ALL;
        }
        return Level.SEVERE;
    }

    public boolean isError() {
        return this.level != null && this.level.intValue() >= Level.SEVERE.intValue() && this.level.intValue() < Integer.MAX_VALUE;
    }

    public boolean isWarning() {
        return this.level != null && this.level.intValue() >= Level.WARNING.intValue() && this.level.intValue() < Level.SEVERE.intValue();
    }

    public boolean isInfo() {
        return this.level == null || this.level.intValue() >= Level.INFO.intValue() && this.level.intValue() < Level.WARNING.intValue();
    }

    public Level getLevel() {
        return this.level;
    }

    private Object _preFormatOne(Object o) {
        Object v;
        if (o == null) {
            return null;
        }
        if (o instanceof Placeholder && this.placeholderBindings != null && (v = this.placeholderBindings.apply(((Placeholder)o).getName())) != null) {
            o = v;
        }
        if (o instanceof Supplier && o.getClass().isSynthetic()) {
            o = ((Supplier)o).get();
        }
        if (o instanceof NMsgSupplier) {
            o = ((NMsgSupplier)o).apply(this);
        }
        if (o instanceof NTextFormattable) {
            return ((NTextFormattable)o).toText();
        }
        if (o instanceof NMsgFormattable) {
            return ((NMsgFormattable)o).toMsg();
        }
        if (o instanceof NMsg) {
            return ((NMsg)o).withPlaceholders(this.placeholderBindings);
        }
        if (o instanceof Throwable) {
            return NExceptions.getErrorMessage((Throwable)o);
        }
        return o;
    }

    private Object[] _preFormatArr(Object[] o) {
        if (o == null) {
            return o;
        }
        Object[] r = new Object[o.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this._preFormatOne(o[i]);
        }
        return r;
    }

    public String toFullString() {
        if (this.throwable == null) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this).append("\n").append(NStringUtils.stacktrace(this.throwable));
        return sb.toString();
    }

    public String toString() {
        try {
            switch (this.format) {
                case CFORMAT: {
                    StringBuilder sb = new StringBuilder();
                    new Formatter(sb).format((String)this.message, this._preFormatArr(this.params));
                    return sb.toString();
                }
                case JFORMAT: {
                    String sMsg = (String)this.message;
                    if (sMsg.contains("{}")) {
                        StringBuilder sb = new StringBuilder();
                        char[] chars = sMsg.toCharArray();
                        int currentIndex = 0;
                        for (int i = 0; i < chars.length; ++i) {
                            char c = chars[i];
                            if (c == '{') {
                                char c2;
                                StringBuilder sb2 = new StringBuilder();
                                ++i;
                                while (i < chars.length && (c2 = chars[i]) != '}') {
                                    if (c2 == '\\') {
                                        sb2.append(c2);
                                        if (++i >= chars.length) continue;
                                        c2 = chars[i];
                                        sb2.append(c2);
                                        continue;
                                    }
                                    sb2.append(c2);
                                }
                                String s2 = sb2.toString();
                                if (s2.isEmpty()) {
                                    s2 = String.valueOf(currentIndex);
                                } else if (s2.trim().startsWith(":")) {
                                    s2 = String.valueOf(currentIndex) + s2;
                                }
                                sb.append("{").append(s2).append("}");
                                ++currentIndex;
                                continue;
                            }
                            if (c == '\\') {
                                sb.append(c);
                                if (++i >= chars.length) continue;
                                sb.append(c);
                                continue;
                            }
                            sb.append(c);
                        }
                        sMsg = sb.toString();
                    }
                    return MessageFormat.format(sMsg, this._preFormatArr(this.params));
                }
                case VFORMAT: {
                    return this.formatAsV();
                }
                case NTF: 
                case STYLED: 
                case CODE: 
                case PLAIN: {
                    return String.valueOf(this.message);
                }
            }
            return "NMsg{message=" + this.message + ", style=" + this.format + ", params=" + Arrays.toString(this._preFormatArr(this.params)) + '}';
        }
        catch (Exception e) {
            ArrayList<List<Object>> a = new ArrayList<List<Object>>();
            if (this.params != null) {
                a.add(Arrays.asList(this.params));
            }
            return NMsg.ofC("[ERROR] Invalid %s message %s with params %s : %s", this.format, this.message, a, e).toString();
        }
    }

    private String formatAsV() {
        return NStringUtils.replaceDollarPlaceHolder((String)this.message, s -> {
            Object param = this.params[0];
            Function m = null;
            m = param instanceof Map ? x -> ((Map)param).get(x) : (Function)param;
            Object v = m.apply(s);
            if (v != null) {
                return String.valueOf(v);
            }
            return null;
        });
    }

    public NMsg asSevere() {
        return this.withLevelAndDefaultIntent(Level.SEVERE, NMsgIntent.FAIL);
    }

    public NMsg asError() {
        return this.withLevelAndDefaultIntent(Level.SEVERE, NMsgIntent.FAIL);
    }

    public NMsg asError(Throwable throwable) {
        return this.withLevelAndDefaultIntent(Level.SEVERE, NMsgIntent.FAIL, throwable);
    }

    public NMsg asErrorAlert() {
        return this.withLevelAndIntent(Level.SEVERE, NMsgIntent.ALERT);
    }

    public NMsg asErrorAlert(Throwable throwable) {
        return this.withLevelAndIntent(Level.SEVERE, NMsgIntent.ALERT, throwable);
    }

    public NMsg asSevere(Throwable throwable) {
        return this.withLevelAndDefaultIntent(Level.SEVERE, NMsgIntent.FAIL, throwable);
    }

    public NMsg asWarning(Throwable throwable) {
        return this.withLevelAndDefaultIntent(Level.WARNING, NMsgIntent.ALERT, throwable);
    }

    public NMsg asFine(Throwable throwable) {
        return this.withLevelAndDefaultIntent(Level.FINE, NMsgIntent.DEBUG, throwable);
    }

    public NMsg asFinest(Throwable throwable) {
        return this.withLevelAndDefaultIntent(Level.FINEST, NMsgIntent.DEBUG, throwable);
    }

    private NMsg asLevelWithThrowable(Level level, Throwable throwable) {
        if (level == null) {
            level = Level.FINEST;
        }
        if (level == this.level && throwable == this.throwable) {
            return this;
        }
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, level, throwable, this.intent, this.durationNano, this.placeholderBindings);
    }

    public NMsg asInfo() {
        return this.withLevelAndDefaultIntent(Level.INFO, NMsgIntent.NOTICE);
    }

    public NMsg asConfig() {
        return this.withLevelAndDefaultIntent(Level.CONFIG, NMsgIntent.INIT);
    }

    public NMsg asWarning() {
        return this.withLevelAndDefaultIntent(Level.WARNING, NMsgIntent.ALERT);
    }

    public NMsg asFinest() {
        return this.withLevelAndDefaultIntent(Level.FINEST, NMsgIntent.DEBUG);
    }

    public NMsg asFinestFail() {
        return this.withLevelAndDefaultIntent(Level.FINEST, NMsgIntent.FAIL);
    }

    public NMsg asFineFail() {
        return this.withLevelAndIntent(Level.FINE, NMsgIntent.FAIL);
    }

    public NMsg asFinestFail(Throwable throwable) {
        return this.withLevelAndIntent(Level.FINEST, NMsgIntent.FAIL, throwable);
    }

    public NMsg asFineFail(Throwable throwable) {
        return this.withLevelAndIntent(Level.FINE, NMsgIntent.FAIL, throwable);
    }

    public NMsg asInfoFail(Throwable throwable) {
        return this.withLevelAndIntent(Level.INFO, NMsgIntent.FAIL, throwable);
    }

    public NMsg asInfoFail() {
        return this.withLevelAndIntent(Level.INFO, NMsgIntent.FAIL);
    }

    public NMsg asFinerFail(Throwable throwable) {
        return this.withLevelAndIntent(Level.FINER, NMsgIntent.FAIL, throwable);
    }

    public NMsg asFinerFail() {
        return this.withLevelAndIntent(Level.FINER, NMsgIntent.FAIL);
    }

    public NMsg asWarningFail(Throwable throwable) {
        return this.withLevelAndIntent(Level.WARNING, NMsgIntent.FAIL, throwable);
    }

    public NMsg asWarningFail() {
        return this.withLevelAndIntent(Level.WARNING, NMsgIntent.FAIL);
    }

    public NMsg asFinestAlert() {
        return this.withLevelAndDefaultIntent(Level.FINEST, NMsgIntent.ALERT);
    }

    public NMsg asFineAlert() {
        return this.withLevelAndIntent(Level.FINE, NMsgIntent.ALERT);
    }

    public NMsg asFinestAlert(Throwable throwable) {
        return this.withLevelAndIntent(Level.FINEST, NMsgIntent.ALERT, throwable);
    }

    public NMsg asFineAlert(Throwable throwable) {
        return this.withLevelAndIntent(Level.FINE, NMsgIntent.ALERT, throwable);
    }

    public NMsg asInfoAlert(Throwable throwable) {
        return this.withLevelAndIntent(Level.INFO, NMsgIntent.ALERT, throwable);
    }

    public NMsg asInfoAlert() {
        return this.withLevelAndIntent(Level.INFO, NMsgIntent.ALERT);
    }

    public NMsg asFinerAlert(Throwable throwable) {
        return this.withLevelAndIntent(Level.FINER, NMsgIntent.ALERT, throwable);
    }

    public NMsg asFinerAlert() {
        return this.withLevelAndIntent(Level.FINER, NMsgIntent.ALERT);
    }

    public NMsg asWarningAlert(Throwable throwable) {
        return this.withLevelAndIntent(Level.WARNING, NMsgIntent.ALERT, throwable);
    }

    public NMsg asWarningAlert() {
        return this.withLevelAndIntent(Level.WARNING, NMsgIntent.ALERT);
    }

    public NMsg asFine() {
        return this.withLevelAndDefaultIntent(Level.FINE, NMsgIntent.DEBUG);
    }

    public NMsg asFiner() {
        return this.withLevelAndDefaultIntent(Level.FINER, NMsgIntent.DEBUG);
    }

    public NMsg asDebug() {
        return this.withLevelAndDefaultIntent(Level.FINEST, NMsgIntent.DEBUG);
    }

    public NMsg withoutPlaceholders() {
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, this.level, null, this.intent, this.durationNano, null);
    }

    public NMsg withPlaceholders(Function<String, ?> placeholderSupplier) {
        if (placeholderSupplier == null) {
            return this;
        }
        Function<String, ?> oldPlaceholderBindings = this.placeholderBindings;
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, this.level, null, this.intent, this.durationNano, s -> {
            Object r = placeholderSupplier.apply((String)s);
            if (r != null) {
                return r;
            }
            if (oldPlaceholderBindings != null) {
                return oldPlaceholderBindings.apply((String)s);
            }
            return null;
        });
    }

    public NMsg withPlaceholders(NMsgParam ... params) {
        if (params == null || params.length == 0) {
            return this;
        }
        if (this.placeholderBindings == null) {
            return NMsg.of(this.format, this.message, params, this.styles, this.codeLang, this.level, null, this.intent, this.durationNano, new MapAsSupplier2(params));
        }
        if (this.placeholderBindings instanceof MapAsSupplier2) {
            LinkedHashMap newMap = new LinkedHashMap(((MapAsSupplier2)this.placeholderBindings).content);
            for (NMsgParam param : params) {
                NAssert.requireNonNull(param, "param");
                NAssert.requireNonNull(param.getName(), "param.name");
                newMap.put(param.getName(), new ConstSupplier(param.getValue()));
            }
            return NMsg.of(this.format, this.message, params, this.styles, this.codeLang, this.level, null, this.intent, this.durationNano, new MapAsSupplier2(newMap));
        }
        if (this.placeholderBindings instanceof MapAsSupplier) {
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry<String, ?> e : ((MapAsSupplier)this.placeholderBindings).content.entrySet()) {
                newMap.put(e.getKey(), e::getValue);
            }
            for (NMsgParam param : params) {
                NAssert.requireNonNull(param, "param");
                NAssert.requireNonNull(param.getName(), "param.name");
                newMap.put(param.getName(), new ConstSupplier(param.getValue()));
            }
            return NMsg.of(this.format, this.message, params, this.styles, this.codeLang, this.level, null, this.intent, this.durationNano, new MapAsSupplier2(newMap));
        }
        MapAsSupplier2 p2 = new MapAsSupplier2(params);
        Function<String, ?> oldPlaceholderBindings = this.placeholderBindings;
        return NMsg.of(this.format, this.message, params, this.styles, this.codeLang, this.level, null, this.intent, this.durationNano, s -> {
            if (p2.content.containsKey(s)) {
                return p2.apply((String)s);
            }
            if (oldPlaceholderBindings != null) {
                return oldPlaceholderBindings.apply((String)s);
            }
            return null;
        });
    }

    public NMsg withPlaceholder(String key, Object value) {
        return this.withPlaceholders(NMaps.of(key, value));
    }

    public NMsg withPlaceholders(Map<String, ?> placeholderMap) {
        if (placeholderMap == null) {
            return this;
        }
        if (this.placeholderBindings == null) {
            return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, this.level, null, this.intent, this.durationNano, new MapAsSupplier(new LinkedHashMap(placeholderMap)));
        }
        if (this.placeholderBindings instanceof MapAsSupplier2) {
            LinkedHashMap newMap = new LinkedHashMap(((MapAsSupplier2)this.placeholderBindings).content);
            for (Map.Entry<String, ?> e : placeholderMap.entrySet()) {
                NAssert.requireNonNull(e.getKey(), "param.name");
                newMap.put(e.getKey(), new ConstSupplier(e.getValue()));
            }
            return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, this.level, null, this.intent, this.durationNano, new MapAsSupplier2(newMap));
        }
        if (this.placeholderBindings instanceof MapAsSupplier) {
            LinkedHashMap newMap = new LinkedHashMap(((MapAsSupplier)this.placeholderBindings).content);
            for (Map.Entry<String, ?> e : placeholderMap.entrySet()) {
                Object v = e.getValue();
                if (v == null) {
                    newMap.remove(e.getKey());
                    continue;
                }
                newMap.put(e.getKey(), v);
            }
            return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, this.level, null, this.intent, this.durationNano, new MapAsSupplier(newMap));
        }
        Function<String, ?> oldPlaceholderBindings = this.placeholderBindings;
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, this.level, null, this.intent, this.durationNano, s -> {
            if (placeholderMap.containsKey(s)) {
                return placeholderMap.get(s);
            }
            if (oldPlaceholderBindings != null) {
                return oldPlaceholderBindings.apply((String)s);
            }
            return null;
        });
    }

    public NMsg withLevel(Level level) {
        if (level == this.level) {
            return this;
        }
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, level, null, this.intent, this.durationNano, this.placeholderBindings);
    }

    private NMsg withLevelAndDefaultIntent(Level level, NMsgIntent intent) {
        if (this.intent != null) {
            intent = this.intent;
        }
        if (level == this.level && Objects.equals(intent, this.intent)) {
            return this;
        }
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, level, null, intent, this.durationNano, this.placeholderBindings);
    }

    private NMsg withLevelAndIntent(Level level, NMsgIntent intent) {
        if (level == this.level && Objects.equals(intent, this.intent)) {
            return this;
        }
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, level, null, intent, this.durationNano, this.placeholderBindings);
    }

    private NMsg withLevelAndDefaultIntent(Level level, NMsgIntent intent, Throwable throwable) {
        if (this.intent != null) {
            intent = this.intent;
        }
        if (level == this.level && Objects.equals(intent, this.intent) && this.throwable == throwable) {
            return this;
        }
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, level, throwable, intent, this.durationNano, this.placeholderBindings);
    }

    private NMsg withLevelAndIntent(Level level, NMsgIntent intent, Throwable throwable) {
        if (level == this.level && Objects.equals(intent, this.intent) && this.throwable == throwable) {
            return this;
        }
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, level, throwable, intent, this.durationNano, this.placeholderBindings);
    }

    public NMsg withIntent(NMsgIntent intent) {
        if (Objects.equals(intent, this.intent)) {
            return this;
        }
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, this.level, null, intent, this.durationNano, this.placeholderBindings);
    }

    public NMsg withDefaultIntent(NMsgIntent intent) {
        if (this.intent != intent) {
            return this;
        }
        if (Objects.equals(intent, this.intent)) {
            return this;
        }
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, this.level, null, intent, this.durationNano, this.placeholderBindings);
    }

    public NMsg withThrowable(Throwable throwable) {
        if (throwable == this.throwable) {
            return this;
        }
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, this.level, throwable, this.intent, this.durationNano, this.placeholderBindings);
    }

    public NMsg withDurationMillis(long elapsedTimeMillis) {
        if (elapsedTimeMillis < 0L) {
            elapsedTimeMillis = -1L;
        }
        return this.withDurationNanos(elapsedTimeMillis * 1000000L);
    }

    public NMsg withDurationNanos(long elapsedTimeNanos) {
        if (elapsedTimeNanos < 0L) {
            elapsedTimeNanos = -1L;
        }
        if (elapsedTimeNanos == this.durationNano) {
            return this;
        }
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, this.level, this.throwable, this.intent, elapsedTimeNanos, this.placeholderBindings);
    }

    public NMsg withPrefix(NMsg prefixMessage) {
        if (NBlankable.isBlank(prefixMessage)) {
            return this;
        }
        if (NBlankable.isBlank(this)) {
            return prefixMessage;
        }
        return NMsg.of(NTextFormatType.CFORMAT, "%s %s", new Object[]{prefixMessage, this.cloneWithoutMeta()}, null, null, this.level, this.throwable, this.intent, this.durationNano, null);
    }

    public NMsg withSuffix(NMsg suffixMessage) {
        if (NBlankable.isBlank(suffixMessage)) {
            return this;
        }
        if (NBlankable.isBlank(this)) {
            return suffixMessage;
        }
        return NMsg.of(NTextFormatType.CFORMAT, "%s %s", new Object[]{this.cloneWithoutMeta(), suffixMessage}, null, null, this.level, this.throwable, this.intent, this.durationNano, null);
    }

    public NMsg withPrefix(NMsgSupplier<NMsg> prefixMessage) {
        if (prefixMessage == null) {
            return this;
        }
        Supplier<NMsg> prefixSupplier = () -> (NMsg)prefixMessage.apply(this);
        return NMsg.of(NTextFormatType.CFORMAT, "%s %s", new Object[]{prefixSupplier, this.cloneWithoutMeta()}, null, null, this.level, this.throwable, this.intent, this.durationNano, null);
    }

    public NMsg withSuffix(NMsgSupplier<NMsg> suffixMessage) {
        if (NBlankable.isBlank(suffixMessage)) {
            return this;
        }
        Supplier<NMsg> suffixSupplier = () -> (NMsg)suffixMessage.apply(this);
        return NMsg.of(NTextFormatType.CFORMAT, "%s %s", new Object[]{this.cloneWithoutMeta(), suffixSupplier}, null, null, this.level, this.throwable, this.intent, this.durationNano, null);
    }

    private NMsg cloneWithoutMeta() {
        return NMsg.of(this.format, this.message, this.params, this.styles, this.codeLang, null, null, null, -1L, this.placeholderBindings);
    }

    public long getDurationNanos() {
        return this.durationNano;
    }

    public long getDurationMillis() {
        return this.durationNano < 0L ? -1L : this.durationNano / 1000000L;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public NMsgIntent getIntent() {
        return this.intent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NMsg that = (NMsg)o;
        return Objects.equals(this.codeLang, that.codeLang) && Objects.equals(this.message, that.message) && this.format == that.format && Arrays.deepEquals(this.params, that.params) && Objects.equals(this.styles, that.styles) && Objects.equals(this.level, that.level) && Objects.equals(this.throwable, that.throwable);
    }

    public int hashCode() {
        int result = Objects.hash(this.codeLang, this.message, this.format, this.styles, this.level, this.throwable);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    public static NMsg ofStyledKeyword(String message) {
        return NMsg.ofStyled(message, NTextStyle.keyword());
    }

    public static NMsg ofStyledPath(String message) {
        return NMsg.ofStyled(message, NTextStyle.path());
    }

    public static NMsg ofStyledPale(String message) {
        return NMsg.ofStyled(message, NTextStyle.pale());
    }

    public static NMsg ofStyledSeparator(String message) {
        return NMsg.ofStyled(message, NTextStyle.separator());
    }

    public static NMsg ofStyledString(String message) {
        return NMsg.ofStyled(message, NTextStyle.string());
    }

    public static NMsg ofStyledBlink(String message) {
        return NMsg.ofStyled(message, NTextStyle.blink());
    }

    public static NMsg ofStyledBold(String message) {
        return NMsg.ofStyled(message, NTextStyle.bold());
    }

    public static NMsg ofStyledBool(String message) {
        return NMsg.ofStyled(message, NTextStyle.bool());
    }

    public static NMsg ofStyledComments(String message) {
        return NMsg.ofStyled(message, NTextStyle.comments());
    }

    public static NMsg ofStyledConfig(String message) {
        return NMsg.ofStyled(message, NTextStyle.config());
    }

    public static NMsg ofStyledDanger(String message) {
        return NMsg.ofStyled(message, NTextStyle.danger());
    }

    public static NMsg ofStyledDate(String message) {
        return NMsg.ofStyled(message, NTextStyle.date());
    }

    public static NMsg ofStyledError(String message) {
        return NMsg.ofStyled(message, NTextStyle.error());
    }

    public static NMsg ofStyledFail(String message) {
        return NMsg.ofStyled(message, NTextStyle.fail());
    }

    public static NMsg ofStyledInfo(String message) {
        return NMsg.ofStyled(message, NTextStyle.info());
    }

    public static NMsg ofStyledInput(String message) {
        return NMsg.ofStyled(message, NTextStyle.input());
    }

    public static NMsg ofStyledItalic(String message) {
        return NMsg.ofStyled(message, NTextStyle.italic());
    }

    public static NMsg ofStyledNumber(String message) {
        return NMsg.ofStyled(message, NTextStyle.number());
    }

    public static NMsg ofStyledOperator(String message) {
        return NMsg.ofStyled(message, NTextStyle.operator());
    }

    public static NMsg ofStyledOption(String message) {
        return NMsg.ofStyled(message, NTextStyle.option());
    }

    public static NMsg ofStyledPrimary1(String message) {
        return NMsg.ofStyled(message, NTextStyle.primary1());
    }

    public static NMsg ofStyledPrimary2(String message) {
        return NMsg.ofStyled(message, NTextStyle.primary2());
    }

    public static NMsg ofStyledPrimary3(String message) {
        return NMsg.ofStyled(message, NTextStyle.primary3());
    }

    public static NMsg ofStyledPrimary4(String message) {
        return NMsg.ofStyled(message, NTextStyle.primary4());
    }

    public static NMsg ofStyledPrimary5(String message) {
        return NMsg.ofStyled(message, NTextStyle.primary5());
    }

    public static NMsg ofStyledPrimary6(String message) {
        return NMsg.ofStyled(message, NTextStyle.primary6());
    }

    public static NMsg ofStyledPrimary7(String message) {
        return NMsg.ofStyled(message, NTextStyle.primary7());
    }

    public static NMsg ofStyledPrimary8(String message) {
        return NMsg.ofStyled(message, NTextStyle.primary8());
    }

    public static NMsg ofStyledPrimary9(String message) {
        return NMsg.ofStyled(message, NTextStyle.primary9());
    }

    public static NMsg ofStyledSecondary1(String message) {
        return NMsg.ofStyled(message, NTextStyle.secondary1());
    }

    public static NMsg ofStyledSecondary2(String message) {
        return NMsg.ofStyled(message, NTextStyle.secondary2());
    }

    public static NMsg ofStyledSecondary3(String message) {
        return NMsg.ofStyled(message, NTextStyle.secondary3());
    }

    public static NMsg ofStyledSecondary4(String message) {
        return NMsg.ofStyled(message, NTextStyle.secondary4());
    }

    public static NMsg ofStyledSecondary5(String message) {
        return NMsg.ofStyled(message, NTextStyle.secondary5());
    }

    public static NMsg ofStyledSecondary6(String message) {
        return NMsg.ofStyled(message, NTextStyle.secondary6());
    }

    public static NMsg ofStyledSecondary7(String message) {
        return NMsg.ofStyled(message, NTextStyle.secondary7());
    }

    public static NMsg ofStyledSecondary8(String message) {
        return NMsg.ofStyled(message, NTextStyle.secondary8());
    }

    public static NMsg ofStyledSecondary9(String message) {
        return NMsg.ofStyled(message, NTextStyle.secondary9());
    }

    public static NMsg ofStyledTitle1(String message) {
        return NMsg.ofStyled(message, NTextStyle.title1());
    }

    public static NMsg ofStyledTitle2(String message) {
        return NMsg.ofStyled(message, NTextStyle.title2());
    }

    public static NMsg ofStyledTitle3(String message) {
        return NMsg.ofStyled(message, NTextStyle.title3());
    }

    public static NMsg ofStyledTitle4(String message) {
        return NMsg.ofStyled(message, NTextStyle.title4());
    }

    public static NMsg ofStyledTitle5(String message) {
        return NMsg.ofStyled(message, NTextStyle.title5());
    }

    public static NMsg ofStyledTitle6(String message) {
        return NMsg.ofStyled(message, NTextStyle.title6());
    }

    public static NMsg ofStyledTitle7(String message) {
        return NMsg.ofStyled(message, NTextStyle.title7());
    }

    public static NMsg ofStyledTitle8(String message) {
        return NMsg.ofStyled(message, NTextStyle.title8());
    }

    public static NMsg ofStyledTitle9(String message) {
        return NMsg.ofStyled(message, NTextStyle.title9());
    }

    public static NMsg ofStyledSuccess(String message) {
        return NMsg.ofStyled(message, NTextStyle.success());
    }

    public static NMsg ofStyledStriked(String message) {
        return NMsg.ofStyled(message, NTextStyle.striked());
    }

    public static NMsg ofStyledVariable(String message) {
        return NMsg.ofStyled(message, NTextStyle.variable());
    }

    public static NMsg ofStyledWarn(String message) {
        return NMsg.ofStyled(message, NTextStyle.warn());
    }

    public static NMsg ofStyledForegroundColor(String message, int color) {
        return NMsg.ofStyled(message, NTextStyle.foregroundColor(color));
    }

    public static NMsg ofStyledForegroundTrueColor(String message, int color) {
        return NMsg.ofStyled(message, NTextStyle.foregroundTrueColor(color));
    }

    public static NMsg ofStyledBackgroundColor(String message, int color) {
        return NMsg.ofStyled(message, NTextStyle.backgroundColor(color));
    }

    public static NMsg ofStyledBackgroundTrueColor(String message, int color) {
        return NMsg.ofStyled(message, NTextStyle.backgroundTrueColor(color));
    }

    public static NMsg ofStyledForegroundTrueColor(String message, NColor color) {
        return NMsg.ofStyled(message, NTextStyle.foregroundTrueColor(color));
    }

    public static NMsg ofStyledForegroundTrueColor(NMsg message, NColor color) {
        return NMsg.ofStyled(message, NTextStyle.foregroundTrueColor(color));
    }

    public static NMsg ofStyledBackgroundTrueColor(String message, NColor color) {
        return NMsg.ofStyled(message, NTextStyle.backgroundTrueColor(color));
    }

    public static NMsg ofStyledBackgroundTrueColor(NMsg message, NColor color) {
        return NMsg.ofStyled(message, NTextStyle.backgroundTrueColor(color));
    }

    public static NMsg ofStyledBackgroundColor(String message, NColor color) {
        return NMsg.ofStyled(message, NTextStyle.backgroundColor(color));
    }

    public static NMsg ofStyledBackgroundColor(NMsg message, NColor color) {
        return NMsg.ofStyled(message, NTextStyle.backgroundColor(color));
    }

    public static NMsg ofStyledForegroundColor(String message, NColor color) {
        return NMsg.ofStyled(message, NTextStyle.foregroundColor(color));
    }

    public static NMsg ofStyledForegroundColor(NMsg message, NColor color) {
        return NMsg.ofStyled(message, NTextStyle.foregroundColor(color));
    }

    public static NMsg ofStyledKeyword(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.keyword());
    }

    public static NMsg ofStyledPath(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.path());
    }

    public static NMsg ofStyledPale(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.pale());
    }

    public static NMsg ofStyledSeparator(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.separator());
    }

    public static NMsg ofStyledString(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.string());
    }

    public static NMsg ofStyledBlink(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.blink());
    }

    public static NMsg ofStyledBold(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.bold());
    }

    public static NMsg ofStyledBool(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.bool());
    }

    public static NMsg ofStyledComments(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.comments());
    }

    public static NMsg ofStyledConfig(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.config());
    }

    public static NMsg ofStyledDanger(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.danger());
    }

    public static NMsg ofStyledDate(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.date());
    }

    public static NMsg ofStyledError(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.error());
    }

    public static NMsg ofStyledFail(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.fail());
    }

    public static NMsg ofStyledInfo(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.info());
    }

    public static NMsg ofStyledInput(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.input());
    }

    public static NMsg ofStyledItalic(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.italic());
    }

    public static NMsg ofStyledNumber(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.number());
    }

    public static NMsg ofStyledOperator(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.operator());
    }

    public static NMsg ofStyledOption(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.option());
    }

    public static NMsg ofStyledPrimary1(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.primary1());
    }

    public static NMsg ofStyledPrimary2(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.primary2());
    }

    public static NMsg ofStyledPrimary3(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.primary3());
    }

    public static NMsg ofStyledPrimary4(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.primary4());
    }

    public static NMsg ofStyledPrimary5(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.primary5());
    }

    public static NMsg ofStyledPrimary6(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.primary6());
    }

    public static NMsg ofStyledPrimary7(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.primary7());
    }

    public static NMsg ofStyledPrimary8(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.primary8());
    }

    public static NMsg ofStyledPrimary9(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.primary9());
    }

    public static NMsg ofStyledSecondary1(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.secondary1());
    }

    public static NMsg ofStyledSecondary2(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.secondary2());
    }

    public static NMsg ofStyledSecondary3(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.secondary3());
    }

    public static NMsg ofStyledSecondary4(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.secondary4());
    }

    public static NMsg ofStyledSecondary5(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.secondary5());
    }

    public static NMsg ofStyledSecondary6(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.secondary6());
    }

    public static NMsg ofStyledSecondary7(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.secondary7());
    }

    public static NMsg ofStyledSecondary8(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.secondary8());
    }

    public static NMsg ofStyledSecondary9(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.secondary9());
    }

    public static NMsg ofStyledTitle1(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.title1());
    }

    public static NMsg ofStyledTitle2(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.title2());
    }

    public static NMsg ofStyledTitle3(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.title3());
    }

    public static NMsg ofStyledTitle4(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.title4());
    }

    public static NMsg ofStyledTitle5(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.title5());
    }

    public static NMsg ofStyledTitle6(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.title6());
    }

    public static NMsg ofStyledTitle7(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.title7());
    }

    public static NMsg ofStyledTitle8(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.title8());
    }

    public static NMsg ofStyledTitle9(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.title9());
    }

    public static NMsg ofStyledSuccess(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.success());
    }

    public static NMsg ofStyledStriked(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.striked());
    }

    public static NMsg ofStyledVariable(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.variable());
    }

    public static NMsg ofStyledWarn(NMsg message) {
        return NMsg.ofStyled(message, NTextStyle.warn());
    }

    public static NMsg ofStyledForegroundColor(NMsg message, int color) {
        return NMsg.ofStyled(message, NTextStyle.foregroundColor(color));
    }

    public static NMsg ofStyledForegroundTrueColor(NMsg message, int color) {
        return NMsg.ofStyled(message, NTextStyle.foregroundTrueColor(color));
    }

    public static NMsg ofStyledBackgroundColor(NMsg message, int color) {
        return NMsg.ofStyled(message, NTextStyle.backgroundColor(color));
    }

    public static NMsg ofStyledBackgroundTrueColor(NMsg message, int color) {
        return NMsg.ofStyled(message, NTextStyle.backgroundTrueColor(color));
    }

    @Override
    public boolean isBlank() {
        if (this.message == null) {
            return true;
        }
        switch (this.format) {
            case CFORMAT: 
            case JFORMAT: 
            case VFORMAT: 
            case CODE: 
            case PLAIN: {
                return NStringUtils.isEmpty((String)this.message);
            }
            case NTF: 
            case STYLED: {
                if (this.message instanceof NMsg) {
                    NMsg m = (NMsg)this.message;
                    return m == null || m.isBlank();
                }
                if (this.message instanceof NText) {
                    NText m = (NText)this.message;
                    return m.isBlank();
                }
                if (this.message instanceof String) {
                    return NStringUtils.isEmpty((String)this.message);
                }
                return false;
            }
        }
        return false;
    }

    public static final class Placeholder {
        private String name;

        private Placeholder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Placeholder that = (Placeholder)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        public String toString() {
            return "placeholder(" + this.name + ")";
        }
    }

    private static class MapAsSupplier2
    implements Function<String, Object> {
        Map<String, Supplier<?>> content;

        public MapAsSupplier2(Map<String, Supplier<?>> other) {
            this.content = other;
        }

        public MapAsSupplier2(NMsgParam ... params) {
            this.content = new LinkedHashMap();
            if (params != null) {
                for (NMsgParam param : params) {
                    NAssert.requireNonNull(param, "param");
                    String e = param.getName();
                    NAssert.requireNonNull(e, "param.name");
                    if (this.content.containsKey(e)) {
                        throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("duplicate key %s", e));
                    }
                    this.content.put(e, param.getValue());
                }
            }
        }

        @Override
        public Object apply(String key) {
            Supplier<?> p = this.content.get(key);
            if (p != null) {
                return p.get();
            }
            return null;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapAsSupplier2 that = (MapAsSupplier2)o;
            return Objects.equals(this.content, that.content);
        }

        public int hashCode() {
            return Objects.hashCode(this.content);
        }

        public String toString() {
            return "MapAsSupplier2{content=" + this.content + '}';
        }
    }

    private static class ConstSupplier<T>
    implements Supplier<T> {
        private T value;

        public ConstSupplier(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }
    }

    private static class MapAsSupplier
    implements Function<String, Object> {
        Map<String, ?> content;

        public MapAsSupplier(Map<String, ?> other) {
            this.content = other;
        }

        @Override
        public Object apply(String ker) {
            return this.content.get(ker);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapAsSupplier that = (MapAsSupplier)o;
            return Objects.equals(this.content, that.content);
        }

        public int hashCode() {
            return Objects.hashCode(this.content);
        }

        public String toString() {
            return "MapAsSupplier{content=" + this.content + '}';
        }
    }
}

