/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import net.thevpc.nuts.cmdline.NCmdLineConfigurable;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.spi.NComponent;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextFormat;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NAssert;

public interface NFormat
extends NCmdLineConfigurable,
NComponent {
    public static NFormat of(NFormatSPI spi) {
        return NTexts.of().createFormat(spi);
    }

    public static <T> NFormat of(T object, NTextFormat<T> format) {
        NTexts texts = NTexts.of();
        NAssert.requireNonNull(format, "format");
        return texts.createFormat(object, format);
    }

    public String toString();

    public NText format();

    default public String formatPlain() {
        boolean ntf = this.isNtf();
        try {
            String string = this.format().filteredText();
            return string;
        }
        finally {
            this.setNtf(ntf);
        }
    }

    public void print();

    public void println();

    public void print(NPrintStream var1);

    public void print(Writer var1);

    public void print(OutputStream var1);

    public void print(Path var1);

    public void print(NPath var1);

    public void print(File var1);

    public void print(NTerminal var1);

    public void println(Writer var1);

    public void println(NPrintStream var1);

    public void println(OutputStream var1);

    public void println(Path var1);

    public void println(NPath var1);

    public void println(NTerminal var1);

    public void println(File var1);

    @Override
    public NFormat configure(boolean var1, String ... var2);

    public boolean isNtf();

    public NFormat setNtf(boolean var1);
}

