/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.spi;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import net.thevpc.nuts.cmdline.NCmdLineAutoCompleteResolver;
import net.thevpc.nuts.cmdline.NCmdLineHistory;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.spi.NComponent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NTextStyles;

public interface NSystemTerminalBase
extends NComponent {
    public String readLine(NPrintStream var1, NMsg var2);

    public char[] readPassword(NPrintStream var1, NMsg var2);

    public InputStream getIn();

    public NPrintStream getOut();

    public NPrintStream getErr();

    default public NCmdLineAutoCompleteResolver getAutoCompleteResolver() {
        return null;
    }

    default public boolean isAutoCompleteSupported() {
        return false;
    }

    public NSystemTerminalBase setCommandAutoCompleteResolver(NCmdLineAutoCompleteResolver var1);

    public NCmdLineHistory getCommandHistory();

    public NSystemTerminalBase setCommandHistory(NCmdLineHistory var1);

    public String getCommandHighlighter();

    public NSystemTerminalBase setCommandHighlighter(String var1);

    public Object run(NTerminalCmd var1, NPrintStream var2);

    public Cursor getTerminalCursor();

    public Size getTerminalSize();

    public NSystemTerminalBase resetLine();

    public NSystemTerminalBase clearScreen();

    public void setStyles(NTextStyles var1, NPrintStream var2);

    public static class Size
    implements Serializable {
        private int columns;
        private int rows;

        private Size() {
        }

        public Size(int columns, int rows) {
            this.columns = columns;
            this.rows = rows;
        }

        public int getColumns() {
            return this.columns;
        }

        public int getRows() {
            return this.rows;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cursor cursor = (Cursor)o;
            return this.columns == cursor.x && this.rows == cursor.y;
        }

        public int hashCode() {
            return Objects.hash(this.columns, this.rows);
        }

        public String toString() {
            return "Cursor{x=" + this.columns + ", y=" + this.rows + '}';
        }
    }

    public static class Cursor
    implements Serializable {
        private int x;
        private int y;

        private Cursor() {
        }

        public Cursor(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cursor cursor = (Cursor)o;
            return this.x == cursor.x && this.y == cursor.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        public String toString() {
            return "Cursor{x=" + this.x + ", y=" + this.y + '}';
        }
    }
}

