/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.spi;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.util.NStringUtils;

public class NRepositoryURLList {
    private final List<NRepositoryLocation> all = new ArrayList<NRepositoryLocation>();

    public NRepositoryURLList(NRepositoryLocation[] all) {
        this.addAll(all);
    }

    public NRepositoryURLList() {
    }

    public NRepositoryLocation[] toArray() {
        return this.all.toArray(new NRepositoryLocation[0]);
    }

    public boolean containsName(String name) {
        return this.indexOfName(name, 0) >= 0;
    }

    public boolean containsURL(String url) {
        return this.indexOfURL(url, 0) >= 0;
    }

    public boolean containsSelection(NRepositoryLocation s) {
        return this.indexOf(s, 0) >= 0;
    }

    public int indexOfName(String name, int offset) {
        String trimmedName = NStringUtils.trim(name);
        for (int i = offset; i < this.all.size(); ++i) {
            if (!trimmedName.equals(NStringUtils.trim(this.all.get(i).getName()))) continue;
            return i;
        }
        return -1;
    }

    public int indexOfNames(String[] names, int offset) {
        for (int i = offset; i < this.all.size(); ++i) {
            NRepositoryLocation loc = this.all.get(i);
            String trimmedLocName = NStringUtils.trim(loc.getName());
            for (String name : names) {
                String trimmedName = NStringUtils.trim(name);
                if (!trimmedName.equals(trimmedLocName)) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfURL(String url, int offset) {
        String trimmedName = NStringUtils.trim(url);
        for (int i = offset; i < this.all.size(); ++i) {
            if (!trimmedName.equals(NStringUtils.trim(this.all.get(i).getPath()))) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(NRepositoryLocation other, int offset) {
        if (other == null) {
            return -1;
        }
        for (int i = offset; i < this.all.size(); ++i) {
            NRepositoryLocation o = this.all.get(i);
            if (!NStringUtils.trim(other.getName()).equals(NStringUtils.trim(o.getName())) || !NStringUtils.trim(other.getPath()).equals(NStringUtils.trim(o.getPath()))) continue;
            return i;
        }
        return -1;
    }

    public NRepositoryURLList addAll(NRepositoryLocation[] all) {
        if (all != null) {
            for (NRepositoryLocation a : all) {
                this.add(a);
            }
        }
        return this;
    }

    public NRepositoryURLList add(NRepositoryLocation a) {
        if (a != null) {
            String n = NStringUtils.trim(a.getName());
            if (n.isEmpty()) {
                if (this.indexOf(a, 0) < 0) {
                    this.all.add(a);
                }
            } else if (this.indexOfName(a.getName(), 0) < 0) {
                this.all.add(a);
            }
        }
        return this;
    }

    public NRepositoryLocation removeAt(int i) {
        return this.all.remove(i);
    }

    public NRepositoryURLList clear() {
        this.all.clear();
        return this;
    }
}

