/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.spi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NRepositorySelector;
import net.thevpc.nuts.spi.NRepositoryURLList;
import net.thevpc.nuts.spi.NSelectorOp;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class NRepositorySelectorList {
    private final List<NRepositorySelector> selectors = new ArrayList<NRepositorySelector>();

    public NRepositorySelectorList() {
    }

    public NRepositorySelectorList(NRepositorySelector[] a) {
        for (NRepositorySelector repoDefString : a) {
            if (repoDefString == null) continue;
            this.selectors.add(repoDefString);
        }
    }

    public static NOptional<NRepositorySelectorList> of(List<String> expressions) {
        return NRepositorySelectorList.of(expressions, NRepositoryDB.of());
    }

    public static NOptional<NRepositorySelectorList> of(List<String> expressions, NRepositoryDB db) {
        if (expressions == null) {
            return NOptional.of(new NRepositorySelectorList());
        }
        NRepositorySelectorList result = new NRepositorySelectorList();
        for (String t : expressions) {
            if (t == null || (t = t.trim()).isEmpty()) continue;
            NOptional<NRepositorySelectorList> r = NRepositorySelectorList.of(t, db);
            if (r.isNotPresent()) {
                String finalT = t;
                return NOptional.ofError(() -> NMsg.ofC("invalid selector list : %s", finalT));
            }
            result = result.merge(r.get());
        }
        return NOptional.of(result);
    }

    public static NOptional<NRepositorySelectorList> of(String expression, NRepositoryDB db) {
        if (NBlankable.isBlank(expression)) {
            return NOptional.of(new NRepositorySelectorList());
        }
        NSelectorOp op = NSelectorOp.INCLUDE;
        ArrayList<NRepositorySelector> all = new ArrayList<NRepositorySelector>();
        for (String s : NStringUtils.split(expression, ",;", true, true)) {
            if ((s = s.trim()).length() <= 0) continue;
            NOptional<NRepositorySelector> oe = NRepositorySelector.of(op, s, db);
            if (oe.isNotPresent()) {
                return NOptional.ofError(() -> NMsg.ofC("invalid selector list : %s", expression));
            }
            NRepositorySelector e = oe.get();
            op = e.getOp();
            all.add(e);
        }
        return NOptional.of(new NRepositorySelectorList(all.toArray(new NRepositorySelector[0])));
    }

    public NRepositorySelectorList merge(NRepositorySelectorList other) {
        if (other == null || other.selectors.isEmpty()) {
            return this;
        }
        ArrayList<NRepositorySelector> result = new ArrayList<NRepositorySelector>();
        result.addAll(this.selectors);
        result.addAll(other.selectors);
        return new NRepositorySelectorList(result.toArray(new NRepositorySelector[0]));
    }

    public NRepositoryLocation[] resolve(NRepositoryLocation[] available, NRepositoryDB db) {
        Set<String> allNames;
        NRepositoryURLList current = new NRepositoryURLList();
        if (available != null) {
            for (NRepositoryLocation entry : available) {
                NAddRepositoryOptions ro;
                if (entry == null) continue;
                String k = entry.getName();
                String v = entry.getFullLocation();
                if (NBlankable.isBlank(v) && !NBlankable.isBlank(k)) {
                    String u;
                    ro = db.getRepositoryOptionsByName(k).orNull();
                    String string = u = ro == null ? null : ro.getConfig().getLocation().getFullLocation();
                    v = u != null ? u : k;
                } else if (!NBlankable.isBlank(v) && NBlankable.isBlank(k)) {
                    String n;
                    ro = db.getRepositoryOptionsByLocation(k).orNull();
                    String string = n = ro == null ? null : ro.getName();
                    if (n != null) {
                        k = n;
                    }
                }
                current.add(NRepositoryLocation.of(k, v));
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HashSet<String> visited = new HashSet<String>();
        ArrayList<NRepositorySelector> selectorsExclude = new ArrayList<NRepositorySelector>();
        ArrayList<NRepositorySelector> selectorsInclude = new ArrayList<NRepositorySelector>();
        boolean exact = false;
        for (NRepositorySelector selector : this.selectors) {
            switch (selector.getOp()) {
                case EXACT: {
                    exact = true;
                    selectorsInclude.add(selector);
                    break;
                }
                case INCLUDE: {
                    selectorsInclude.add(selector);
                    break;
                }
                case EXCLUDE: {
                    selectorsExclude.add(selector);
                }
            }
        }
        if (exact) {
            current.clear();
        }
        for (NRepositorySelector r : selectorsExclude) {
            allNames = this.getAllNames(r, db);
            int n = current.indexOfNames(allNames.toArray(new String[0]), 0);
            if (n < 0) continue;
            current.removeAt(n);
        }
        for (NRepositorySelector r : selectorsInclude) {
            allNames = this.getAllNames(r, db);
            if (this.isVisitedFlag(allNames, visited)) continue;
            visited.addAll(allNames);
            result.add(NRepositoryLocation.of(r.getName(), r.getUrl()));
        }
        for (Iterator<NRepositorySelector> iterator : current.toArray()) {
            Set<String> allNames2;
            if (!this.acceptExisting((NRepositoryLocation)((Object)iterator)) || this.isVisitedFlag(allNames2 = db.findAllNamesByName(((NRepositoryLocation)((Object)iterator)).getName()), visited)) continue;
            visited.addAll(allNames2);
            result.add(iterator);
        }
        return result.toArray(new NRepositoryLocation[0]);
    }

    private Set<String> getAllNames(NRepositorySelector r, NRepositoryDB db) {
        if (!NBlankable.isBlank(r.getName())) {
            return db.findAllNamesByName(r.getName());
        }
        String name = db.getRepositoryOptionsByLocation(r.getUrl()).map(x -> x.getName()).orNull();
        return db.findAllNamesByName(name);
    }

    private boolean isVisitedFlag(Set<String> allNames, Set<String> visited) {
        boolean visitedFlag = false;
        for (String allName : allNames) {
            if (!visited.contains(allName)) continue;
            visitedFlag = true;
            break;
        }
        return visitedFlag;
    }

    public boolean acceptExisting(NRepositoryLocation location) {
        boolean includeOthers = true;
        for (NRepositorySelector s : this.selectors) {
            if (s.matches(location)) {
                switch (s.getOp()) {
                    case EXACT: 
                    case INCLUDE: {
                        return true;
                    }
                    case EXCLUDE: {
                        return false;
                    }
                }
            }
            if (s.getOp() != NSelectorOp.EXACT) continue;
            includeOthers = false;
        }
        return includeOthers;
    }

    public NRepositorySelector[] toArray() {
        return this.selectors.toArray(new NRepositorySelector[0]);
    }

    public String toString() {
        return this.selectors.stream().map(x -> String.valueOf(x)).collect(Collectors.joining(","));
    }
}

