/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.spi;

import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositoryLocation;
import net.thevpc.nuts.spi.NSelectorOp;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class NRepositorySelector {
    private final NRepositoryLocation location;
    private NSelectorOp op;

    public static NOptional<NRepositorySelector> of(String location, NRepositoryDB db) {
        return NRepositorySelector.of(null, location, db);
    }

    public static NOptional<NRepositorySelector> of(NSelectorOp op, String location, NRepositoryDB db) {
        location = NStringUtils.trim(location);
        if (op == null) {
            op = NSelectorOp.INCLUDE;
        }
        if (location.length() > 0) {
            if (location.startsWith("+")) {
                op = NSelectorOp.INCLUDE;
                location = location.substring(1).trim();
            } else if (location.startsWith("-")) {
                op = NSelectorOp.EXCLUDE;
                location = location.substring(1).trim();
            } else if (location.startsWith("=")) {
                op = NSelectorOp.EXACT;
                location = location.substring(1).trim();
            }
            NOptional<NRepositoryLocation> z = NRepositoryLocation.of(location, db);
            if (z.isPresent()) {
                return NOptional.of(new NRepositorySelector(op, z.get()));
            }
        }
        String finalLocation = location;
        return NOptional.ofEmpty(() -> NMsg.ofC("repository %s", finalLocation));
    }

    public NRepositorySelector(NSelectorOp op, NRepositoryLocation location) {
        NAssert.requireNonNull(op, "operator");
        NAssert.requireNonNull(location, "location");
        this.op = op;
        this.location = location;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.op == NSelectorOp.EXACT) {
            sb.append("=");
        } else if (this.op == NSelectorOp.EXCLUDE) {
            sb.append("-");
        } else if (this.op == NSelectorOp.INCLUDE) {
            sb.append("+");
        }
        sb.append(this.location);
        return sb.toString();
    }

    public NSelectorOp getOp() {
        return this.op;
    }

    public String getName() {
        return this.location.getName();
    }

    public String getUrl() {
        return this.location.getFullLocation();
    }

    public boolean matches(NRepositoryLocation other) {
        String otherName = other.getName();
        String otherURL = other.getFullLocation();
        String name0 = this.location.getName();
        String url0 = this.location.getFullLocation();
        otherName = otherName == null ? "" : otherName.trim();
        otherURL = otherURL == null ? "" : otherURL.trim();
        String _name = name0 == null ? "" : name0.trim();
        String _url = url0 == null ? "" : url0.trim();
        String string = otherURL = otherURL == null ? otherURL : otherURL.trim();
        if (_name.length() > 0 && _name.equals(otherName)) {
            return true;
        }
        return _url.length() > 0 && _url.equals(otherURL);
    }
}

