/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.spi;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.core.NAddRepositoryOptions;
import net.thevpc.nuts.spi.NRepositoryDB;
import net.thevpc.nuts.spi.NRepositorySelectorList;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class NRepositoryLocation
implements Comparable<NRepositoryLocation>,
NBlankable,
Cloneable {
    protected static final Pattern FULL_PATTERN = Pattern.compile("((?<n>[a-zA-Z][a-zA-Z0-9_-]*)?=)?((?<t>[a-zA-Z][a-zA-Z0-9_-]*)?@)?(?<r>.*)");
    private final String name;
    private final String locationType;
    private final String path;

    public NRepositoryLocation(String name, String locationType, String path) {
        this.name = NStringUtils.trimToNull(name);
        this.locationType = NStringUtils.trimToNull(locationType);
        this.path = NStringUtils.trimToNull(path);
    }

    protected NRepositoryLocation(String locationString) {
        Matcher nm;
        if (locationString == null) {
            locationString = "";
        }
        if ((nm = FULL_PATTERN.matcher(locationString)).find()) {
            this.name = NStringUtils.trimToNull(nm.group("n"));
            this.locationType = NStringUtils.trimToNull(nm.group("t"));
            this.path = NStringUtils.trimToNull(nm.group("r"));
        } else {
            this.name = null;
            this.locationType = null;
            this.path = NStringUtils.trimToNull(locationString);
        }
    }

    public static NRepositoryLocation of(String locationString) {
        return new NRepositoryLocation(locationString);
    }

    public static NRepositoryLocation ofName(String name) {
        return NRepositoryLocation.of(name, (String)null);
    }

    public static NRepositoryLocation of(String name, String fullLocation) {
        NRepositoryLocation q = NRepositoryLocation.of(fullLocation);
        if (name != null) {
            q = q.setName(name);
        }
        return q;
    }

    public static NOptional<NRepositoryLocation> of(String locationString, NRepositoryDB db) {
        String name = null;
        String url = null;
        if (locationString == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("repository location"));
        }
        if ((locationString = locationString.trim()).startsWith("-") || locationString.startsWith("+") || locationString.startsWith("=") || locationString.indexOf(44) >= 0 || locationString.indexOf(59) >= 0) {
            String finalLocationString = locationString;
            return NOptional.ofError(() -> NMsg.ofC("invalid selection syntax : %s", finalLocationString));
        }
        Matcher matcher = Pattern.compile("(?<name>[a-zA-Z-_]+)=(?<value>.+)").matcher(locationString);
        if (matcher.find()) {
            name = matcher.group("name");
            url = matcher.group("value");
        } else if (locationString.matches("[a-zA-Z][a-zA-Z0-9-_]+")) {
            String u;
            name = locationString;
            NAddRepositoryOptions ro = db.getRepositoryOptionsByName(name).orNull();
            String string = u = ro == null ? null : ro.getConfig().getLocation().getFullLocation();
            url = u == null ? name : u;
        } else {
            url = locationString;
            NAddRepositoryOptions ro = db.getRepositoryOptionsByLocation(name).orNull();
            String n = ro == null ? null : ro.getName();
            name = n == null ? null : n;
        }
        if (url.length() > 0) {
            return NOptional.of(NRepositoryLocation.of(name, url));
        }
        return NOptional.ofEmpty(() -> NMsg.ofPlain("repository location"));
    }

    public static NOptional<NRepositoryLocation[]> of(String repositorySelectionExpression, NRepositoryLocation[] available, NRepositoryDB db) {
        return NRepositorySelectorList.of(repositorySelectionExpression, db).map(x -> x.resolve(available, db));
    }

    public String getName() {
        return this.name;
    }

    public NRepositoryLocation setName(String name) {
        return new NRepositoryLocation(name, this.locationType, this.path);
    }

    public String getPath() {
        return this.path;
    }

    public NRepositoryLocation setPath(String path) {
        return new NRepositoryLocation(this.name, this.locationType, path);
    }

    public String getLocationType() {
        return this.locationType;
    }

    public NRepositoryLocation setLocationType(String locationType) {
        return new NRepositoryLocation(this.name, locationType, this.path);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NRepositoryLocation that = (NRepositoryLocation)o;
        return Objects.equals(this.toString(), that.toString());
    }

    public String getFullLocation() {
        StringBuilder sb = new StringBuilder();
        if (!NBlankable.isBlank(this.locationType)) {
            sb.append(this.locationType);
            sb.append("@");
        }
        if (!NBlankable.isBlank(this.path)) {
            sb.append(this.path);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!NBlankable.isBlank(this.name)) {
            sb.append(this.name);
            sb.append("=");
        }
        if (!NBlankable.isBlank(this.locationType)) {
            sb.append(this.locationType);
            sb.append("@");
        }
        if (!NBlankable.isBlank(this.path)) {
            sb.append(this.path);
        }
        return sb.toString();
    }

    @Override
    public boolean isBlank() {
        if (!NBlankable.isBlank(this.name)) {
            return false;
        }
        if (!NBlankable.isBlank(this.locationType)) {
            return false;
        }
        return NBlankable.isBlank(this.path);
    }

    @Override
    public int compareTo(NRepositoryLocation o) {
        if (o == null) {
            return 1;
        }
        return this.toString().compareTo(o.toString());
    }

    public NRepositoryLocation copy() {
        return this.clone();
    }

    protected NRepositoryLocation clone() {
        try {
            return (NRepositoryLocation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

