/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.core.NConfigItem;
import net.thevpc.nuts.internal.NReservedLangUtils;

public final class NUserConfig
extends NConfigItem
implements Cloneable {
    private static final long serialVersionUID = 2L;
    private String user;
    private String credentials;
    private List<String> groups;
    private List<String> permissions;
    private String remoteIdentity;
    private String remoteCredentials;

    public NUserConfig() {
    }

    public NUserConfig(NUserConfig other) {
        this.user = other.getUser();
        this.credentials = other.getCredentials();
        this.remoteIdentity = other.getRemoteIdentity();
        this.remoteCredentials = other.getRemoteCredentials();
        this.setGroups(other.getGroups());
        this.setPermissions(other.getPermissions());
    }

    public NUserConfig(String user, String credentials, List<String> groups, List<String> permissions) {
        this.user = user;
        this.credentials = credentials;
        this.setGroups(groups);
        this.setPermissions(permissions);
    }

    public NUserConfig copy() {
        return this.clone();
    }

    protected NUserConfig clone() {
        try {
            NUserConfig o = (NUserConfig)super.clone();
            if (o.groups != null) {
                o.groups = new ArrayList<String>(o.groups);
            }
            if (o.permissions != null) {
                o.permissions = new ArrayList<String>(o.permissions);
            }
            return o;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getRemoteIdentity() {
        return this.remoteIdentity;
    }

    public void setRemoteIdentity(String remoteIdentity) {
        this.remoteIdentity = remoteIdentity;
    }

    public String getRemoteCredentials() {
        return this.remoteCredentials;
    }

    public void setRemoteCredentials(String remoteCredentials) {
        this.remoteCredentials = remoteCredentials;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = NReservedLangUtils.nonNullList(permissions);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = NReservedLangUtils.nonNullList(groups);
    }

    public int hashCode() {
        int result = Objects.hash(this.user, this.credentials, this.remoteIdentity, this.remoteCredentials, this.groups, this.permissions);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NUserConfig that = (NUserConfig)o;
        return Objects.equals(this.user, that.user) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.groups, that.groups) && Objects.equals(this.permissions, that.permissions) && Objects.equals(this.remoteIdentity, that.remoteIdentity) && Objects.equals(this.remoteCredentials, that.remoteCredentials);
    }

    public String toString() {
        return "NutsUserConfig{user='" + this.user + '\'' + ", credentials='" + this.credentials + '\'' + ", groups=" + this.groups + ", permissions=" + this.permissions + ", remoteIdentity='" + this.remoteIdentity + '\'' + ", remoteCredentials='" + this.remoteCredentials + '\'' + '}';
    }
}

