/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.web;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputContentProvider;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NTempOutputStream;
import net.thevpc.nuts.net.NHttpMethod;
import net.thevpc.nuts.net.NHttpUrlEncoder;
import net.thevpc.nuts.net.NWebCookie;
import net.thevpc.nuts.net.NWebRequest;
import net.thevpc.nuts.net.NWebRequestBody;
import net.thevpc.nuts.net.NWebResponse;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebHeaders;
import net.thevpc.nuts.runtime.standalone.xtra.web.NWebRequestBodyImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class NWebRequestImpl
implements NWebRequest {
    private String url;
    private NHttpMethod method;
    private DefaultNWebHeaders headers = new DefaultNWebHeaders();
    private Map<String, List<String>> parameters;
    private NInputSource requestBody;
    private boolean oneWay;
    private Integer readTimeout;
    private Integer connectTimeout;
    private List<NWebRequestBody> parts = new ArrayList<NWebRequestBody>();
    private DefaultNWebCli cli;
    private Map<String, Object> formData;
    private Map<String, String> urlEncoded;
    private Mode mode = Mode.NONE;

    public NWebRequestImpl(DefaultNWebCli cli, NHttpMethod method) {
        this.cli = cli;
        this.method = method == null ? NHttpMethod.GET : method;
    }

    protected NWebRequestImpl setMode(Mode mode) {
        if (mode != null) {
            this.mode = mode;
        }
        switch (this.mode.ordinal()) {
            case 0: {
                this.requestBody = null;
                this.formData = null;
                this.urlEncoded = null;
                break;
            }
            case 1: {
                this.formData = null;
                this.urlEncoded = null;
                break;
            }
            case 2: {
                this.requestBody = null;
                this.urlEncoded = null;
                break;
            }
            case 3: {
                this.requestBody = null;
                this.formData = null;
            }
        }
        return this;
    }

    @Override
    public boolean isOneWay() {
        return this.oneWay;
    }

    @Override
    public NWebRequest setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public NWebRequestImpl setUrl(String url, Object ... vars) {
        NAssert.requireNonNull(url, "url");
        NAssert.requireNonNull(vars, "vars");
        NStringBuilder sb = new NStringBuilder();
        char[] charArray = url.toCharArray();
        int last = 0;
        int index = 0;
        boolean inParams = false;
        block12: for (int i = 0; i < charArray.length; ++i) {
            int c = charArray[i];
            switch (c) {
                case 63: {
                    inParams = true;
                    last = 63;
                    sb.append((char)c);
                    continue block12;
                }
                case 47: {
                    if (inParams) {
                        sb.append((char)c);
                        continue block12;
                    }
                    if (sb.endsWith(":/") || sb.endsWith('/')) continue block12;
                    sb.append('/');
                    last = c;
                    continue block12;
                }
                case 123: {
                    if (inParams) {
                        sb.append((char)c);
                        continue block12;
                    }
                    if (i + 1 < charArray.length) {
                        switch (charArray[i + 1]) {
                            case '}': {
                                last = 115;
                                if (index >= vars.length) {
                                    throw new IllegalArgumentException(NMsg.ofC("missing var at index %s in %s", index, url).toString());
                                }
                                if (!NBlankable.isBlank(vars[index])) {
                                    sb.append(NHttpUrlEncoder.encodeObject(vars[index]));
                                } else if (!sb.endsWith("://") && sb.endsWith('/')) {
                                    sb.removeLast();
                                }
                                ++i;
                                ++index;
                                continue block12;
                            }
                        }
                        sb.append('{').append(charArray[i + 1]);
                        ++i;
                        last = 97;
                        continue block12;
                    }
                    sb.append((char)c);
                    last = 97;
                    continue block12;
                }
                case 37: {
                    if (inParams) {
                        sb.append((char)c);
                        continue block12;
                    }
                    if (i + 1 < charArray.length) {
                        switch (charArray[i + 1]) {
                            case 's': {
                                last = 115;
                                if (index >= vars.length) {
                                    throw new IllegalArgumentException(NMsg.ofC("missing var at index %s in %s", index, url).toString());
                                }
                                if (!NBlankable.isBlank(vars[index])) {
                                    sb.append(NHttpUrlEncoder.encodeObject(vars[index]));
                                } else if (!sb.endsWith("://") && sb.endsWith('/')) {
                                    sb.removeLast();
                                }
                                ++i;
                                ++index;
                                continue block12;
                            }
                        }
                        sb.append('%').append(charArray[i + 1]);
                        ++i;
                        last = 97;
                        continue block12;
                    }
                    sb.append((char)c);
                    last = 97;
                    continue block12;
                }
                default: {
                    sb.append((char)c);
                    last = 97;
                }
            }
        }
        this.url = sb.toString();
        return this;
    }

    public NWebRequest addCookies(NWebCookie[] cookies) {
        if (cookies != null) {
            for (NWebCookie cookie : cookies) {
                this.addCookie(cookie);
            }
        }
        return this;
    }

    public NWebRequest addCookie(NWebCookie cookie) {
        if (cookie != null) {
            this.addHeader("Cookie", cookie.getName() + "=" + cookie.getValue());
        }
        return this;
    }

    @Override
    public NWebRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public NHttpMethod getMethod() {
        return this.method;
    }

    @Override
    public NWebRequestImpl setMethod(NHttpMethod method) {
        this.method = method == null ? NHttpMethod.GET : method;
        return this;
    }

    @Override
    public NWebRequest GET() {
        return this.setMethod(NHttpMethod.GET);
    }

    @Override
    public NWebRequest POST() {
        return this.setMethod(NHttpMethod.POST);
    }

    @Override
    public NWebRequest PATCH() {
        return this.setMethod(NHttpMethod.PATCH);
    }

    @Override
    public NWebRequest OPTIONS() {
        return this.setMethod(NHttpMethod.OPTIONS);
    }

    @Override
    public NWebRequest HEAD() {
        return this.setMethod(NHttpMethod.HEAD);
    }

    @Override
    public NWebRequest trace() {
        return this.setMethod(NHttpMethod.TRACE);
    }

    @Override
    public NWebRequest trace(String url) {
        return this.trace().setUrl(url);
    }

    @Override
    public NWebRequest connect() {
        return this.setMethod(NHttpMethod.CONNECT);
    }

    @Override
    public NWebRequest PUT() {
        return this.setMethod(NHttpMethod.PUT);
    }

    @Override
    public NWebRequest DELETE() {
        return this.setMethod(NHttpMethod.DELETE);
    }

    @Override
    public NWebRequest GET(String url) {
        return this.GET().setUrl(url);
    }

    @Override
    public NWebRequest POST(String url) {
        return this.POST().setUrl(url);
    }

    @Override
    public NWebRequest PATCH(String url) {
        return this.PATCH().setUrl(url);
    }

    @Override
    public NWebRequest OPTIONS(String url) {
        return this.OPTIONS().setUrl(url);
    }

    @Override
    public NWebRequest HEAD(String url) {
        return this.HEAD().setUrl(url);
    }

    @Override
    public NWebRequest connect(String url) {
        return this.connect().setUrl(url);
    }

    @Override
    public NWebRequest PUT(String url) {
        return this.PUT().setUrl(url);
    }

    @Override
    public NWebRequest DELETE(String url) {
        return this.DELETE().setUrl(url);
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.headers.getOrEmpty(name);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers.toMap();
    }

    @Override
    public NWebRequest setHeaders(Map<String, List<String>> headers) {
        this.headers.clear();
        return this;
    }

    @Override
    public NWebRequest addHeaders(Map<String, List<String>> headers) {
        if (headers != null) {
            for (Map.Entry<String, List<String>> e : headers.entrySet()) {
                String k = e.getKey();
                if (k == null || e.getValue() == null || e.getValue().isEmpty()) continue;
                for (String v : e.getValue()) {
                    this.addHeader(k, v);
                }
            }
        }
        return this;
    }

    @Override
    public NWebRequest addParameters(Map<String, List<String>> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, List<String>> e : parameters.entrySet()) {
                String k = e.getKey();
                if (k == null || e.getValue() == null || e.getValue().isEmpty()) continue;
                for (String v : e.getValue()) {
                    this.addHeader(k, v);
                }
            }
        }
        return this;
    }

    @Override
    public NWebRequest setPropsFileHeaders(NPath path) {
        this.setHeaders(NWebRequestImpl._mapFromPropsFile(path));
        return this;
    }

    @Override
    public NWebRequest addPropsFileHeaders(NPath path) {
        this.addHeaders(NWebRequestImpl._mapFromPropsFile(path));
        return this;
    }

    @Override
    public NWebRequest addJsonFileHeaders(NPath path) {
        Map<String, List<String>> newHeaders = this._mapFromJsonFile(path);
        this.addHeaders(newHeaders);
        return this;
    }

    @Override
    public NWebRequest setJsonFileHeaders(NPath path) {
        this.setHeaders(this._mapFromJsonFile(path));
        return this;
    }

    @Override
    public NWebRequest setPropsFileParameters(NPath path) {
        this.setParameters(NWebRequestImpl._mapFromPropsFile(path));
        return this;
    }

    @Override
    public NWebRequest addPropsFileParameters(NPath path) {
        this.addParameters(NWebRequestImpl._mapFromPropsFile(path));
        return this;
    }

    @Override
    public NWebRequest addJsonFileParameters(NPath path) {
        Map<String, List<String>> newHeaders = this._mapFromJsonFile(path);
        this.addParameters(newHeaders);
        return this;
    }

    @Override
    public NWebRequest setJsonFileParameters(NPath path) {
        this.setParameters(this._mapFromJsonFile(path));
        return this;
    }

    private static Map<String, List<String>> _mapFromPropsFile(NPath path) {
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        path.lines().forEach(x -> {
            if (!(x = x.trim()).startsWith("#")) {
                NArg a = NArg.of(x);
                m.computeIfAbsent(a.key(), r -> new ArrayList()).add(String.valueOf(a.key()));
            }
        });
        return m;
    }

    private Map<String, List<String>> _mapFromJsonFile(NPath path) {
        Map map = NElementParser.ofJson().parse(path.getReader(), Map.class);
        LinkedHashMap<String, List<String>> newHeaders = new LinkedHashMap<String, List<String>>();
        for (Map.Entry e : map.entrySet()) {
            String k = (String)e.getKey();
            Object v = e.getValue();
            if (v instanceof String) {
                newHeaders.computeIfAbsent(k, r -> new ArrayList()).add((String)v);
                continue;
            }
            if (v instanceof List) {
                for (Object o : (List)v) {
                    newHeaders.computeIfAbsent(k, r -> new ArrayList()).add(String.valueOf(o));
                }
                continue;
            }
            if (!(v instanceof Object[])) continue;
            for (Object o : (Object[])v) {
                newHeaders.computeIfAbsent(k, r -> new ArrayList()).add(String.valueOf(o));
            }
        }
        return newHeaders;
    }

    @Override
    public NWebRequestImpl addHeader(String name, String value) {
        this.headers.addHeader(name, value, DefaultNWebHeaders.Mode.ALWAYS);
        return this;
    }

    @Override
    public NWebRequestImpl setHeader(String name, String value) {
        if (name != null) {
            if (value != null) {
                this.headers.addHeader(name, value, DefaultNWebHeaders.Mode.ALWAYS);
            } else {
                this.headers.removeHeader(name);
            }
        }
        return this;
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    @Override
    public NWebRequest setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters == null ? new LinkedHashMap() : parameters;
        return this;
    }

    @Override
    public NWebRequest doWith(Consumer<NWebRequest> any) {
        if (any != null) {
            any.accept(this);
        }
        return this;
    }

    @Override
    public NWebRequest addParameter(String name, String value) {
        if (value != null) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, List<String>>();
            }
            this.parameters.computeIfAbsent(name, s -> new ArrayList()).add(value);
        }
        return this;
    }

    @Override
    public NWebRequest setParameter(String name, String value) {
        if (value != null) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, List<String>>();
            }
            List list = this.parameters.computeIfAbsent(name, s -> new ArrayList());
            list.clear();
            list.add(value);
        } else if (this.parameters != null) {
            List list = this.parameters.computeIfAbsent(name, s -> new ArrayList());
            list.clear();
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public NInputSource getRequestBody() {
        switch (this.mode.ordinal()) {
            case 1: {
                return this.requestBody;
            }
            case 3: {
                this.setContentType("application/x-www-form-urlencoded");
                sb = new StringBuilder();
                first = true;
                for (Map.Entry<String, String> e : this.urlEncoded.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append("&");
                    }
                    try {
                        sb.append(URLEncoder.encode(NStringUtils.trim(e.getKey()), "UTF-8")).append("=").append(URLEncoder.encode(NStringUtils.trim(e.getValue()), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return NInputSource.of(sb.toString().getBytes());
            }
            case 2: {
                sw = new SimpleWriter(NIO.of().ofTempOutputStream());
                if (this.formData == null || this.formData.isEmpty()) ** GOTO lbl59
                boundary = "-------------------------------" + UUID.randomUUID().toString();
                this.setContentType("multipart/form-data; boundary=" + boundary);
                try {
                    sw.println(boundary);
                    for (Map.Entry<String, Object> e : this.formData.entrySet()) {
                        if (!(e.getValue() instanceof String)) ** GOTO lbl36
                        sw.println("Content-Disposition: form-data; name=" + NLiteral.of(e.getKey()).toStringLiteral());
                        sw.println();
                        sw.println(e.getValue().toString());
                        ** GOTO lbl53
lbl36:
                        // 1 sources

                        if (!(e.getValue() instanceof NInputContentProvider)) ** GOTO lbl53
                        npath = (NInputContentProvider)e.getValue();
                        sw.println("Content-Disposition: form-data; name=" + NLiteral.of(e.getKey()).toStringLiteral() + " ; filename=" + NLiteral.of(npath.getName()).toStringLiteral());
                        sw.println("Content-Type: " + NStringUtils.firstNonBlank(npath.getContentType(), "application/octet-stream"));
                        sw.println();
                        if (!(npath instanceof NPath)) ** GOTO lbl44
                        ((NPath)npath).copyToOutputStream(SimpleWriter.access$000(sw), new NPathOption[0]);
                        ** GOTO lbl53
lbl44:
                        // 1 sources

                        tis = npath.getInputStream();
                        try {
                            NIOUtils.copy(tis, SimpleWriter.access$000(sw));
                        }
                        finally {
                            if (tis != null) {
                                tis.close();
                            }
                        }
lbl53:
                        // 4 sources

                        sw.println();
                        sw.println(boundary);
                    }
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
lbl59:
                // 2 sources

                return SimpleWriter.access$000(sw);
            }
        }
        return null;
    }

    @Override
    public NWebRequestImpl setJsonRequestBody(Object body) {
        if (body == null) {
            this.requestBody = null;
            this.setMode(Mode.NONE);
        } else {
            this.requestBody = NInputSource.of(NElementWriter.ofJson().toString(body).getBytes());
            this.setMode(Mode.BODY);
        }
        this.setContentType("application/json");
        return this;
    }

    @Override
    public NWebRequest setRequestBody(byte[] body) {
        this.requestBody = body == null ? null : NInputSource.of(body);
        this.setMode(body == null ? Mode.NONE : Mode.BODY);
        return this;
    }

    @Override
    public NWebRequest setRequestBody(String body) {
        this.requestBody = body == null ? null : NInputSource.of(new StringReader(body));
        this.setMode(body == null ? Mode.NONE : Mode.BODY);
        return null;
    }

    @Override
    public NWebRequest setRequestBody(NInputSource body) {
        this.requestBody = body;
        this.setMode(Mode.BODY);
        return this;
    }

    @Override
    public NWebRequestImpl setContentLanguage(String contentLanguage) {
        return this.setHeader("Content-Language", contentLanguage);
    }

    @Override
    public NWebRequestImpl setAuthorizationBearer(String authorizationBearer) {
        if ((authorizationBearer = NStringUtils.trimToNull(authorizationBearer)) != null) {
            authorizationBearer = "Bearer " + authorizationBearer;
        }
        return this.setAuthorization(authorizationBearer);
    }

    @Override
    public NWebRequestImpl setAuthorization(String authorization) {
        return this.setHeader("Authorization", NStringUtils.trimToNull(authorization));
    }

    @Override
    public String getAuthorization() {
        return this.getHeader("Authorization");
    }

    @Override
    public String getAuthorizationBearer() {
        String b = this.getHeader("Authorization");
        if (b != null && b.toLowerCase().startsWith("bearer ")) {
            return b.substring("bearer ".length()).trim();
        }
        return b;
    }

    @Override
    public String getContentLanguage() {
        return this.getHeader("Content-Language");
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public NWebRequest setContentTypeFormUrlEncoded() {
        return this.setContentType("application/x-www-form-urlencoded");
    }

    @Override
    public NWebRequest addFormUrlEncoded(String key, String value) {
        if (value == null) {
            return this;
        }
        if (this.urlEncoded == null) {
            this.urlEncoded = new LinkedHashMap<String, String>();
        }
        this.urlEncoded.put(key, value);
        this.setMode(Mode.URLENCODED);
        return this;
    }

    @Override
    public NWebRequest addFormUrlEncoded(Map<String, String> value) {
        if (value == null) {
            return this;
        }
        if (this.urlEncoded == null) {
            this.urlEncoded = new LinkedHashMap<String, String>();
        }
        this.setMode(Mode.URLENCODED);
        this.urlEncoded.putAll(value);
        return this;
    }

    @Override
    public NWebRequest addFormData(String key, NInputContentProvider value) {
        if (value == null) {
            return this;
        }
        if (this.formData == null) {
            this.formData = new LinkedHashMap<String, Object>();
        }
        this.formData.put(key, value);
        this.setMode(Mode.FORM_DATA);
        return this;
    }

    @Override
    public NWebRequest addFormData(String key, String value) {
        if (value == null) {
            return this;
        }
        if (this.formData == null) {
            this.formData = new LinkedHashMap<String, Object>();
        }
        this.formData.put(key, value);
        this.setMode(Mode.FORM_DATA);
        return this;
    }

    @Override
    public NWebRequest setFormData(String key, NInputContentProvider value) {
        return this.addFormData(key, value);
    }

    @Override
    public NWebRequest setFormData(String key, String value) {
        return this.addFormData(key, value);
    }

    @Override
    public NWebRequest setFormUrlEncoded(Map<String, String> m) {
        this.setContentTypeFormUrlEncoded();
        StringBuilder sb = new StringBuilder();
        if (m != null) {
            boolean first = true;
            for (Map.Entry<String, String> e : m.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("&");
                }
                try {
                    sb.append(URLEncoder.encode(NStringUtils.trim(e.getKey()), "UTF-8")).append("=").append(URLEncoder.encode(NStringUtils.trim(e.getValue()), "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        this.setRequestBody(sb.toString().getBytes());
        return this;
    }

    @Override
    public NWebRequest setContentType(String contentType) {
        return this.setHeader("Content-Type", contentType);
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public NWebRequest setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public NWebRequest setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public List<NWebRequestBody> getParts() {
        return this.parts;
    }

    @Override
    public NWebRequest addPart(NWebRequestBody body) {
        this.parts.add(body);
        return this;
    }

    @Override
    public NWebRequestBody addPart() {
        NWebRequestBodyImpl part = new NWebRequestBodyImpl(this);
        this.addPart(part);
        return part;
    }

    @Override
    public NWebRequestBody addPart(String name) {
        return this.addPart().setName(name);
    }

    @Override
    public NWebRequest addPart(String name, String value) {
        return this.addPart().setName(name).setStringValue(value).end();
    }

    @Override
    public NWebRequest addPart(String name, String fileName, String contentType, NInputSource body) {
        return this.addPart().setName(name).setContentType(contentType).setBody(body).end();
    }

    @Override
    public NWebResponse run() {
        return this.cli.run(this);
    }

    @Override
    public String getEffectiveUrl() {
        return this.cli.formatURL(this, true);
    }

    public String toString() {
        return this.getEffectiveUrl();
    }

    @Override
    public NMsg toMsg() {
        return NMsg.ofC("%s %s", this.method == null ? NHttpMethod.GET : this.method, NMsg.ofStyledPath(this.getEffectiveUrl()));
    }

    private static enum Mode {
        NONE,
        BODY,
        FORM_DATA,
        URLENCODED;

    }

    private static class SimpleWriter {
        private NTempOutputStream tos;

        public SimpleWriter(NTempOutputStream tos) {
            this.tos = tos;
        }

        public void println() {
            try {
                this.tos.write("\r\n".getBytes());
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
        }

        public void println(String text) {
            try {
                this.tos.write(text.getBytes());
                this.tos.write("\r\n".getBytes());
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
        }

        static /* synthetic */ NTempOutputStream access$000(SimpleWriter x0) {
            return x0.tos;
        }
    }
}

