/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NInputSourceBuilder;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.net.NHttpCode;
import net.thevpc.nuts.net.NHttpMethod;
import net.thevpc.nuts.net.NHttpUrlEncoder;
import net.thevpc.nuts.net.NWebCli;
import net.thevpc.nuts.net.NWebCookie;
import net.thevpc.nuts.net.NWebRequest;
import net.thevpc.nuts.net.NWebResponse;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCookie;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebHeaders;
import net.thevpc.nuts.runtime.standalone.xtra.web.NWebRequestImpl;
import net.thevpc.nuts.runtime.standalone.xtra.web.NWebResponseImpl;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

@NComponentScope(value=NScopeType.PROTOTYPE)
public class DefaultNWebCli
implements NWebCli {
    public static NBootLog log;
    private String prefix;
    private Function<NWebResponse, NWebResponse> responsePostProcessor;
    private Integer readTimeout;
    private Integer connectTimeout;
    private DefaultNWebHeaders headers = new DefaultNWebHeaders();

    public static URLConnection prepareGlobalConnection(URLConnection c) {
        int connectionTimout = DefaultNWebCli.getGlobalConnectionTimeoutOrDefault();
        int readTimout = DefaultNWebCli.getGlobalReadConnectionTimeoutOrDefault();
        c.setConnectTimeout(Math.max(connectionTimout, 0));
        c.setReadTimeout(Math.max(readTimout, 0));
        return c;
    }

    public static int getGlobalConnectionTimeoutOrDefault() {
        Integer v = DefaultNWebCli.getGlobalConnectionTimeout();
        if (v == null) {
            return 30000;
        }
        return v;
    }

    public static Integer getGlobalReadConnectionTimeoutOrDefault() {
        Integer v = DefaultNWebCli.getGlobalReadTimeout();
        if (v == null) {
            return 30000;
        }
        return v;
    }

    public static Integer getGlobalConnectionTimeout() {
        return NWorkspace.of().getBootOptions().getCustomOptionArg("---connection-timeout").flatMap(y -> y.getValue().asInt()).orElse(null);
    }

    public static Integer getGlobalReadTimeout() {
        return NWorkspace.of().getBootOptions().getCustomOptionArg("---connection-read-timeout").flatMap(y -> y.getValue().asInt()).orElse(null);
    }

    public DefaultNWebCli() {
        this.headers.addHeader("User-Agent", "nwebcli/" + NWorkspace.of().getRuntimeId().getVersion(), DefaultNWebHeaders.Mode.ALWAYS);
    }

    public static InputStream prepareGlobalOpenStream(URL url) throws IOException {
        URLConnection c = null;
        c = url.openConnection();
        DefaultNWebCli.prepareGlobalConnection(c);
        return c.getInputStream();
    }

    @Override
    public NWebCookie[] getCookies() {
        List<String> li = this.headers.getOrEmpty("Cookie");
        return (NWebCookie[])li.stream().map(x -> new DefaultNWebCookie((String)x)).toArray(NWebCookie[]::new);
    }

    @Override
    public NWebCli addHeader(String name, String value) {
        this.headers.addHeader(name, value, DefaultNWebHeaders.Mode.ALWAYS);
        return this;
    }

    @Override
    public NWebCli setHeader(String name, String value) {
        this.headers.addHeader(name, value, DefaultNWebHeaders.Mode.REPLACE);
        return this;
    }

    @Override
    public NWebCli removeHeader(String name, String value) {
        this.headers.removeHeader(name, value);
        return this;
    }

    @Override
    public NWebCli removeHeader(String name) {
        this.headers.removeHeader(name);
        return this;
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    @Override
    public boolean containsCookie(String cookieName) {
        List<String> li = this.headers.getOrEmpty("Cookie");
        return li.stream().map(x -> new DefaultNWebCookie((String)x)).anyMatch(x -> Objects.equals(x.getName(), cookieName));
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers.toMap();
    }

    @Override
    public NWebCli clearHeaders() {
        this.headers.clear();
        return this;
    }

    @Override
    public NWebCli clearCookies() {
        this.headers.removeHeader("Cookie");
        return this;
    }

    @Override
    public NWebCli removeCookies(NWebCookie[] cookies) {
        if (cookies != null) {
            for (NWebCookie cookie : cookies) {
                this.removeCookie(cookie);
            }
        }
        return this;
    }

    @Override
    public NWebCli removeCookie(NWebCookie cookie) {
        if (cookie != null) {
            for (String s : this.headers.getOrEmpty("Cookie")) {
                if (!Objects.equals(new DefaultNWebCookie(s).getName(), cookie.getName())) continue;
                this.headers.removeHeader("Cookie", s);
            }
        }
        return this;
    }

    @Override
    public NWebCli removeCookie(String cookieName) {
        if (cookieName != null) {
            for (String s : this.headers.getOrEmpty("Cookie")) {
                if (!Objects.equals(new DefaultNWebCookie(s).getName(), cookieName)) continue;
                this.headers.removeHeader("Cookie", s);
            }
        }
        return this;
    }

    @Override
    public NWebCli addCookie(NWebCookie cookie) {
        if (cookie != null) {
            for (String s : this.headers.getOrEmpty("Cookie")) {
                if (!Objects.equals(new DefaultNWebCookie(s).getName(), cookie.getName())) continue;
                this.headers.removeHeader("Cookie", s);
            }
            this.headers.addHeader("Cookie", DefaultNWebCookie.formatCookie(cookie), DefaultNWebHeaders.Mode.ALWAYS);
        }
        return this;
    }

    @Override
    public NWebCli addCookies(NWebCookie[] cookies) {
        if (cookies != null) {
            for (NWebCookie cookie : cookies) {
                this.addCookie(cookie);
            }
        }
        return this;
    }

    @Override
    public Function<NWebResponse, NWebResponse> getResponsePostProcessor() {
        return this.responsePostProcessor;
    }

    @Override
    public NWebCli setResponsePostProcessor(Function<NWebResponse, NWebResponse> responsePostProcessor) {
        this.responsePostProcessor = responsePostProcessor;
        return this;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public NWebCli setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public NWebRequest req() {
        return new NWebRequestImpl(this, NHttpMethod.GET);
    }

    @Override
    public NWebRequest req(NHttpMethod method) {
        return new NWebRequestImpl(this, method);
    }

    @Override
    public NWebRequest GET() {
        return this.req().GET();
    }

    @Override
    public NWebRequest POST() {
        return this.req().POST();
    }

    @Override
    public NWebRequest PUT() {
        return this.req().PUT();
    }

    @Override
    public NWebRequest DELETE() {
        return this.req().DELETE();
    }

    @Override
    public NWebRequest PATCH() {
        return this.req().PATCH();
    }

    @Override
    public NWebRequest OPTIONS() {
        return this.req().OPTIONS();
    }

    @Override
    public NWebRequest HEAD() {
        return this.req().HEAD();
    }

    @Override
    public NWebRequest CONNECT() {
        return this.req().connect();
    }

    @Override
    public NWebRequest TRACE() {
        return this.req().trace();
    }

    @Override
    public NWebRequest GET(String path) {
        return this.req().GET(path);
    }

    @Override
    public NWebRequest POST(String path) {
        return this.req().POST(path);
    }

    @Override
    public NWebRequest PUT(String path) {
        return this.req().PUT(path);
    }

    @Override
    public NWebRequest DELETE(String path) {
        return this.req().DELETE(path);
    }

    @Override
    public NWebRequest PATCH(String path) {
        return this.req().PATCH(path);
    }

    @Override
    public NWebRequest OPTIONS(String path) {
        return this.req().OPTIONS(path);
    }

    @Override
    public NWebRequest HEAD(String path) {
        return this.req().HEAD(path);
    }

    @Override
    public NWebRequest CONNECT(String path) {
        return this.req().connect(path);
    }

    @Override
    public NWebRequest TRACE(String path) {
        return this.req().trace(path);
    }

    public String formatURL(NWebRequest r, boolean safe) {
        String p = r.getUrl();
        StringBuilder u = new StringBuilder();
        if (this.prefix == null || p.startsWith("http:") || p.startsWith("https:")) {
            u.append(p);
        } else if (p.isEmpty() || p.equals("/")) {
            u.append(this.prefix);
        } else if (!p.startsWith("/") && !this.prefix.endsWith("/")) {
            u.append(this.prefix).append("/").append(p);
        } else {
            u.append(this.prefix).append(p);
        }
        String bu = u.toString().trim();
        if ((bu.isEmpty() || bu.equals("/")) && !safe) {
            throw new IllegalArgumentException("missing url : " + bu);
        }
        if (!(bu.startsWith("http://") || bu.startsWith("https://") || safe)) {
            throw new IllegalArgumentException("unsupported url : " + bu);
        }
        if (r.getParameters() != null && r.getParameters().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, List<String>> e : r.getParameters().entrySet()) {
                String k = e.getKey();
                List<String> values = e.getValue();
                if (values == null || values.size() <= 0) continue;
                for (String v : values) {
                    if (sb.length() > 0) {
                        sb.append("&");
                    }
                    sb.append(NHttpUrlEncoder.encode(k)).append("=").append(NHttpUrlEncoder.encode(v));
                }
            }
            if (sb.length() > 0) {
                if (u.indexOf("?") >= 0) {
                    u.append("&").append((CharSequence)sb);
                } else {
                    u.append("?").append((CharSequence)sb);
                }
            }
        }
        return u.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NWebResponse run(NWebRequest r) {
        NWebResponseImpl nWebResponseImpl;
        block31: {
            NAssert.requireNonNull(r, "request");
            NAssert.requireNonNull(r.getMethod(), "method");
            NHttpMethod method = r.getMethod();
            String spec = null;
            spec = this.formatURL(r, false);
            URL h = CoreIOUtils.urlOf(spec);
            HttpURLConnection uc = null;
            try {
                NWebResponse newResp;
                NHttpCode rCode;
                Exception seenError;
                HttpURLConnection finalUc;
                block32: {
                    long startTime;
                    block29: {
                        Integer connectTimeout1;
                        uc = (HttpURLConnection)h.openConnection();
                        Integer readTimeout1 = r.getReadTimeout();
                        if (readTimeout1 == null) {
                            readTimeout1 = this.getReadTimeout();
                        }
                        if (readTimeout1 == null) {
                            readTimeout1 = DefaultNWebCli.getGlobalReadConnectionTimeoutOrDefault();
                        }
                        if (readTimeout1 != null) {
                            uc.setReadTimeout(Math.max(readTimeout1, 0));
                        }
                        if ((connectTimeout1 = r.getConnectTimeout()) == null) {
                            connectTimeout1 = this.getConnectTimeout();
                        }
                        if (connectTimeout1 == null) {
                            connectTimeout1 = DefaultNWebCli.getGlobalConnectionTimeoutOrDefault();
                        }
                        if (connectTimeout1 != null) {
                            uc.setConnectTimeout(Math.max(connectTimeout1, 0));
                        }
                        DefaultNWebHeaders headers = new DefaultNWebHeaders();
                        NInputSource requestBody = r.getRequestBody();
                        headers.addHeadersMulti(r.getHeaders(), DefaultNWebHeaders.Mode.ALWAYS);
                        headers.addHeadersMulti(this.headers.toMap(), DefaultNWebHeaders.Mode.IF_EMPTY);
                        for (Map.Entry<String, List<String>> e : headers.toMap().entrySet()) {
                            this._writeHeader(uc, e.getKey(), e.getValue());
                        }
                        uc.setRequestMethod(method.toString());
                        uc.setUseCaches(false);
                        long bodyLength = requestBody == null ? -1L : requestBody.getContentLength();
                        boolean someBody = requestBody != null && bodyLength > 0L;
                        uc.setDoInput(!r.isOneWay());
                        uc.setDoOutput(someBody);
                        finalUc = uc;
                        startTime = System.nanoTime();
                        seenError = null;
                        rCode = null;
                        try {
                            if (someBody) {
                                uc.setRequestProperty("Content-Length", String.valueOf(bodyLength));
                                NCp.of().from(requestBody).to(uc.getOutputStream()).run();
                            }
                            rCode = NHttpCode.of(uc.getResponseCode());
                            if (seenError == null) break block29;
                        }
                        catch (Exception err) {
                            block30: {
                                try {
                                    seenError = err;
                                    if (seenError == null) break block30;
                                }
                                catch (Throwable throwable) {
                                    if (seenError != null) {
                                        NLog.of(DefaultNWebCli.class).debug(NMsg.ofC("[%s] %s %s (%s)", "FAILED", method, spec, seenError).withDurationNanos(System.nanoTime() - startTime).withIntent(NMsgIntent.FAIL).withThrowable(seenError));
                                    } else {
                                        NLog.of(DefaultNWebCli.class).debug(NMsg.ofC("[%s] %s %s", rCode == null ? "FAILED" : rCode, method, spec).withDurationNanos(System.nanoTime() - startTime).withIntent(rCode != null && rCode.isOk() ? NMsgIntent.READ : NMsgIntent.FAIL).withThrowable(seenError));
                                    }
                                    throw throwable;
                                }
                                NLog.of(DefaultNWebCli.class).debug(NMsg.ofC("[%s] %s %s (%s)", "FAILED", method, spec, seenError).withDurationNanos(System.nanoTime() - startTime).withIntent(NMsgIntent.FAIL).withThrowable(seenError));
                            }
                            NLog.of(DefaultNWebCli.class).debug(NMsg.ofC("[%s] %s %s", rCode == null ? "FAILED" : rCode, method, spec).withDurationNanos(System.nanoTime() - startTime).withIntent(rCode != null && rCode.isOk() ? NMsgIntent.READ : NMsgIntent.FAIL).withThrowable(seenError));
                        }
                        NLog.of(DefaultNWebCli.class).debug(NMsg.ofC("[%s] %s %s (%s)", "FAILED", method, spec, seenError).withDurationNanos(System.nanoTime() - startTime).withIntent(NMsgIntent.FAIL).withThrowable(seenError));
                        break block32;
                    }
                    NLog.of(DefaultNWebCli.class).debug(NMsg.ofC("[%s] %s %s", rCode == null ? "FAILED" : rCode, method, spec).withDurationNanos(System.nanoTime() - startTime).withIntent(rCode != null && rCode.isOk() ? NMsgIntent.READ : NMsgIntent.FAIL).withThrowable(seenError));
                }
                if (seenError != null) {
                    throw new NIOException(NMsg.ofC("error loading %s (%s)", spec, seenError), (Throwable)seenError);
                }
                NWebResponse httpResponse = new NWebResponseImpl(rCode, NMsg.ofPlain(NStringUtils.trim(uc.getResponseMessage())), uc.getHeaderFields(), () -> {
                    NInputSource bytes = null;
                    if (!r.isOneWay()) {
                        HttpURLConnection uc2 = finalUc;
                        try {
                            bytes = NInputSourceBuilder.of(finalUc.getInputStream()).setCloseAction(() -> {
                                if (uc2 != null) {
                                    try {
                                        uc2.disconnect();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }).createInputSource();
                        }
                        catch (IOException e) {
                            throw new NIOException(e);
                        }
                        long contentLength = finalUc.getContentLengthLong();
                        if (contentLength >= 0L) {
                            bytes.getMetaData().setContentLength(contentLength);
                        }
                    }
                    return bytes;
                });
                if (this.responsePostProcessor != null && (newResp = this.responsePostProcessor.apply(httpResponse)) != null) {
                    httpResponse = newResp;
                }
                this.addCookies(httpResponse.getCookies());
                nWebResponseImpl = httpResponse;
                if (!r.isOneWay() || uc == null) break block31;
            }
            catch (Throwable throwable) {
                try {
                    if (r.isOneWay() && uc != null) {
                        try {
                            uc.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (SocketTimeoutException ex) {
                    throw new UncheckedIOException("timed out loading " + spec + " (" + ex.getMessage() + ")", ex);
                }
                catch (InterruptedIOException | InterruptedByTimeoutException ex) {
                    throw new UncheckedIOException("interrupt loading " + spec + " (" + ex.getMessage() + ")", ex);
                }
                catch (UncheckedIOException ex) {
                    throw new UncheckedIOException(new IOException("error loading " + spec + " (" + ex.getMessage() + ")"));
                }
                catch (IOException ex) {
                    throw new UncheckedIOException("error loading " + spec + " (" + ex.getMessage() + ")", ex);
                }
            }
            try {
                uc.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nWebResponseImpl;
    }

    private void _writeHeader(HttpURLConnection uc, String name, List<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        switch (name.toUpperCase()) {
            case "COOKIE": {
                uc.setRequestProperty(name, String.join((CharSequence)" ; ", values));
                return;
            }
        }
        for (String s : values) {
            uc.setRequestProperty(name, s);
        }
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public NWebCli setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public NWebCli setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    public static String UNIFORM_HEADER(String h) {
        return NStringUtils.trim(h).toUpperCase();
    }
}

