/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.time;

import java.text.DecimalFormat;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.util.BytesSizeFormat;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.xtra.time.CProgressBar;
import net.thevpc.nuts.runtime.standalone.xtra.time.ProgressOptions;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.time.NProgressEvent;
import net.thevpc.nuts.time.NProgressListener;

public class TraceNProgressListener
implements NProgressListener {
    private static DecimalFormat df = new DecimalFormat("##0.00");
    private NPrintStream out;
    private int minLength;
    private CProgressBar bar;
    private boolean optionsProcessed = false;
    private ProgressOptions options;
    private NLog logger;

    @Override
    public boolean onProgress(NProgressEvent event) {
        switch (event.getState()) {
            case START: {
                this.bar = CProgressBar.of();
                this.out = event.getSession().getTerminal().err();
                this.logger = NLog.of(TraceNProgressListener.class);
                if (event.getSession().isPlainOut()) {
                    this.onProgress0(event, false);
                }
                return true;
            }
            case COMPLETE: {
                if (event.getSession().isPlainOut()) {
                    boolean b = this.onProgress0(event, true);
                    this.out.resetLine();
                    return b;
                }
                return false;
            }
        }
        if (event.getSession().isPlainOut()) {
            return this.onProgress0(event, false);
        }
        return false;
    }

    public boolean onProgress0(NProgressEvent event, boolean end) {
        if (!this.optionsProcessed) {
            this.optionsProcessed = true;
            this.options = event.getSession().callWith(() -> ProgressOptions.of());
        }
        double partialSeconds = event.getPartialDuration().getTimeAsDoubleSeconds();
        if (event.getCurrentCount() == 0L || partialSeconds > 0.5 || event.getCurrentCount() == event.getMaxValue()) {
            NTexts text = NTexts.of();
            double globalSeconds = event.getDuration().getTimeAsDoubleSeconds();
            long globalSpeed = globalSeconds == 0.0 ? 0L : (long)((double)event.getCurrentCount() / globalSeconds);
            long partialSpeed = partialSeconds == 0.0 ? 0L : (long)((double)event.getPartialCount() / partialSeconds);
            double percent = event.getProgress();
            NTextBuilder formattedLine = text.ofBuilder();
            NText p = this.bar.progress(event.isIndeterminate() ? -1 : (int)event.getProgress());
            if (p == null || p.isEmpty()) {
                return false;
            }
            formattedLine.append(p);
            BytesSizeFormat mf = new BytesSizeFormat("BTD1F");
            if (Double.isNaN(percent)) {
                formattedLine.append(" ").append(text.ofStyled(String.format("%6s", ""), NTextStyle.config())).append("  ");
            } else {
                formattedLine.append(" ").append(text.ofStyled(String.format("%6s", df.format(percent)), NTextStyle.config())).append("% ");
            }
            formattedLine.append(" ").append(text.ofStyled(String.format("%6s", mf.formatString(partialSpeed)), NTextStyle.config())).append("/s");
            if (event.getMaxValue() < 0L) {
                if (globalSpeed == 0L) {
                    formattedLine.append(" ( -- )");
                } else {
                    formattedLine.append(" (").append(text.ofStyled(mf.formatString(globalSpeed), NTextStyle.info())).append(")");
                }
            } else {
                formattedLine.append(" (").append(text.ofStyled(mf.formatString(event.getMaxValue()), NTextStyle.warn())).append(")");
            }
            if (event.getError() != null) {
                formattedLine.append(" ").append(text.ofStyled("ERROR", NTextStyle.error())).append(" ");
            }
            formattedLine.append(" ").append(event.getMessage()).append(" ");
            String ff = formattedLine.toString();
            int length = text.ofBuilder().append(ff).length();
            if (length < this.minLength) {
                CoreStringUtils.fillString(' ', this.minLength - length, formattedLine);
            } else {
                this.minLength = length;
            }
            this.bar.printProgress2(formattedLine.build(), this.out);
            return true;
        }
        return false;
    }
}

