/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.time;

import java.util.logging.Level;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NProgressEvent;
import net.thevpc.nuts.time.NProgressListener;

class SilentStartNProgressListenerAdapter
implements NProgressListener {
    private final NProgressListener delegate;
    private final NMsg path;

    public SilentStartNProgressListenerAdapter(NProgressListener delegate, NMsg path) {
        this.delegate = delegate;
        this.path = path;
    }

    protected NLog _LOG() {
        return NLog.of(SilentStartNProgressListenerAdapter.class);
    }

    @Override
    public boolean onProgress(NProgressEvent event) {
        switch (event.getState()) {
            case START: {
                return false;
            }
            case COMPLETE: {
                boolean b = this.delegate.onProgress(event);
                if (event.getError() != null) {
                    this._LOG().log(NMsg.ofC(NI18n.of("download failed    : %s"), this.path).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL).withDurationMillis(event.getDuration().toMillis()));
                } else {
                    this._LOG().log(NMsg.ofC(NI18n.of("download succeeded : %s"), this.path).withLevel(Level.FINEST).withIntent(NMsgIntent.SUCCESS).withDurationMillis(event.getDuration().toMillis()));
                }
                return b;
            }
        }
        return this.delegate.onProgress(event);
    }
}

