/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.time;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NRef;
import net.thevpc.nuts.util.NStringMapFormat;

public class ProgressOptions {
    private final Map<String, NLiteral> vals = new LinkedHashMap<String, NLiteral>();
    private Boolean enabled;
    private NRef<Level> cachedLevel = null;

    public static ProgressOptions of() {
        return NApp.of().getOrComputeProperty(ProgressOptions.class.getName(), NScopeType.SESSION, () -> {
            String k;
            ProgressOptions o = new ProgressOptions();
            boolean enabledVisited = false;
            Map<String, String> m = NStringMapFormat.COMMA_FORMAT.parse(NSession.of().getProgressOptions()).get();
            for (Map.Entry<String, String> e : m.entrySet()) {
                k = e.getKey();
                String v = e.getValue();
                if (!enabledVisited) {
                    if (v == null) {
                        Boolean a = NLiteral.of(k).asBoolean().orNull();
                        if (a != null) {
                            o.setEnabled(a);
                            enabledVisited = true;
                            continue;
                        }
                        o.put(k, NLiteral.of(v));
                        continue;
                    }
                    o.put(k, NLiteral.of(v));
                    continue;
                }
                o.put(k, NLiteral.of(v));
            }
            for (Map.Entry<String, String> e : NWorkspace.of().getConfigMap().entrySet()) {
                if (!e.getKey().startsWith("progress.") || !o.get(k = e.getKey().substring("progress.".length())).isNotPresent()) continue;
                o.put(k, NLiteral.of(e.getValue()));
            }
            if (o.getEnabled().isEmpty() && !o.vals.isEmpty()) {
                o.setEnabled(true);
            }
            return o;
        });
    }

    public boolean isEnabled() {
        return this.enabled == null || this.enabled != false;
    }

    public NOptional<Boolean> getEnabled() {
        return NOptional.of(this.enabled);
    }

    public boolean isArmedNewline() {
        NOptional<NLiteral> item = this.get("newline");
        if (item.isEmpty()) {
            item = this.get("%n");
        }
        if (item.isEmpty()) {
            return false;
        }
        return item.isBlank() || item.flatMap(NLiteral::asBoolean).orElse(false) != false;
    }

    public Level getArmedLogLevel() {
        if (this.cachedLevel == null) {
            this.cachedLevel = NRef.of(this.getArmedLogLevel0());
        }
        return this.cachedLevel.get();
    }

    private Level getArmedLogLevel0() {
        for (Level level : new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL}) {
            String[] ids = new String[]{"log-" + level.getName().toLowerCase()};
            if (level == Level.FINEST) {
                ids = new String[]{"log-" + level.getName().toLowerCase(), "log-verbose"};
            }
            for (String id : ids) {
                NOptional<NLiteral> item = this.get(id);
                if (item.isEmpty()) continue;
                if (item.flatMap(NLiteral::asBoolean).orElse(true).booleanValue()) {
                    return level;
                }
                return null;
            }
        }
        NOptional<NLiteral> item = this.get("log");
        if (item.isEmpty()) {
            return null;
        }
        NLiteral iValue = item.get();
        String s = iValue.asString().orNull();
        if (s != null) {
            for (Level level : new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL}) {
                String[] ids = new String[]{"log-" + level.getName().toLowerCase()};
                if (level == Level.FINEST) {
                    ids = new String[]{level.getName().toLowerCase(), "verbose"};
                }
                for (String id : ids) {
                    if (!id.equals(s.toLowerCase())) continue;
                    return level;
                }
            }
        }
        return iValue.asBoolean().orElse(true) != false ? Level.FINEST : null;
    }

    public ProgressOptions put(String k, NLiteral e) {
        this.invalidateCache();
        this.vals.put(k, e);
        return this;
    }

    private void invalidateCache() {
        this.cachedLevel = null;
    }

    public NOptional<NLiteral> get(String k) {
        NLiteral s = this.vals.get(k);
        return s == null ? NOptional.ofNamedEmpty("property " + k) : NOptional.of(s);
    }

    public ProgressOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.invalidateCache();
        return this;
    }
}

