/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.time;

import java.util.ArrayList;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.runtime.standalone.xtra.time.DefaultNInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.xtra.time.DefaultNProgressFactory;
import net.thevpc.nuts.runtime.standalone.xtra.time.NProgressListenerList;
import net.thevpc.nuts.runtime.standalone.xtra.time.SilentNProgressListener;
import net.thevpc.nuts.runtime.standalone.xtra.time.TraceNProgressListener;
import net.thevpc.nuts.time.NProgressFactory;
import net.thevpc.nuts.time.NProgressListener;

public class NProgressUtils {
    public static NProgressFactory createLogProgressMonitorFactory(MonitorType mt) {
        NWorkspace workspace = NWorkspace.of();
        switch (mt.ordinal()) {
            case 0: {
                return new DefaultNInputStreamProgressFactory();
            }
            case 1: {
                return new DefaultNProgressFactory();
            }
        }
        return new DefaultNProgressFactory();
    }

    public static NProgressListener createProgressMonitor(MonitorType mt, NInputSource source, Object sourceOrigin, NWorkspace workspace, boolean logProgress, boolean traceProgress, NProgressFactory progressFactory) {
        NProgressListener e;
        ArrayList<NProgressListener> all = new ArrayList<NProgressListener>();
        if (logProgress && (e = NProgressUtils.createLogProgressMonitorFactory(mt).createProgressListener(source, sourceOrigin)) != null) {
            all.add(e);
        }
        if (traceProgress && workspace.currentSession().isProgress()) {
            all.add(new TraceNProgressListener());
        }
        if (progressFactory != null && (e = progressFactory.createProgressListener(source, sourceOrigin)) != null) {
            all.add(e);
        }
        if (all.isEmpty()) {
            return new SilentNProgressListener();
        }
        if (all.size() == 1) {
            return (NProgressListener)all.get(0);
        }
        return new NProgressListenerList(all.toArray(new NProgressListener[0]));
    }

    public static enum MonitorType {
        STREAM,
        DEFAULT;

    }
}

