/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.time;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NProgressMonitor;
import net.thevpc.nuts.time.NProgressRunner;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;

public class NDefaultProgressRunner
implements NProgressRunner {
    private List<WeightedProcessor> all = new ArrayList<WeightedProcessor>();

    @Override
    public void add(Consumer<NProgressRunner.Context> processor, double weight) {
        this.all.add(new WeightedProcessor(processor, weight));
    }

    @Override
    public void add(Consumer<NProgressRunner.Context> processor) {
        this.all.add(new WeightedProcessor(processor, 1.0));
    }

    @Override
    public void add(Runnable processor, double weight) {
        this.all.add(new WeightedProcessor(c -> processor.run(), weight));
    }

    @Override
    public void add(Runnable processor) {
        this.all.add(new WeightedProcessor(c -> processor.run(), 1.0));
    }

    @Override
    public void run() {
        ContextImpl cc = new ContextImpl();
        NProgressMonitor m = NProgressMonitor.of();
        m.start();
        NProgressMonitor[] mons = m.split(this.all.stream().mapToDouble(x -> ((WeightedProcessor)x).weight).toArray());
        for (int i = 0; i < mons.length; ++i) {
            NProgressMonitor mon = mons[i];
            mon.start();
            this.all.get(i).processor.accept(cc);
            mon.complete();
        }
        m.complete();
    }

    private class WeightedProcessor {
        private Consumer<NProgressRunner.Context> processor;
        private double weight;

        public WeightedProcessor(Consumer<NProgressRunner.Context> processor, double weight) {
            this.processor = processor;
            this.weight = weight;
        }
    }

    public static class ContextImpl
    implements NProgressRunner.Context {
        private Map<String, Object> context = new HashMap<String, Object>();

        @Override
        public <T> NOptional<T> get(String name) {
            return this.get(name, null);
        }

        @Override
        public <T> ContextImpl set(String name, Object value) {
            this.context.put(name, value);
            return this;
        }

        @Override
        public <T> NOptional<T> get(String name, Class<T> expectedType) {
            NAssert.requireNonNull(name, "name");
            Object o = this.context.get(name);
            if (o == null) {
                if (this.context.containsKey(name)) {
                    return NOptional.ofNull();
                }
                return NOptional.ofNamedEmpty(name);
            }
            if (expectedType != null) {
                if (expectedType.isInstance(o)) {
                    return NOptional.of(expectedType.cast(o));
                }
                return NOptional.ofEmpty(NMsg.ofC("invalid type for %s", name));
            }
            return NOptional.ofNamed(o, name);
        }
    }
}

