/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.time;

import java.io.File;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NContentMetadataProvider;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NInputSourceBuilder;
import net.thevpc.nuts.io.NInputStreamMonitor;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.xtra.time.NProgressUtils;
import net.thevpc.nuts.runtime.standalone.xtra.time.SilentStartNProgressListenerAdapter;
import net.thevpc.nuts.runtime.standalone.xtra.time.SingletonNInputStreamProgressFactory;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.time.NProgressEvent;
import net.thevpc.nuts.time.NProgressFactory;
import net.thevpc.nuts.time.NProgressListener;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNInputStreamMonitor
implements NInputStreamMonitor {
    private final NWorkspace workspace;
    private String sourceTypeName;
    private NInputSource source;
    private Object sourceOrigin;
    private NMsg sourceName;
    private long length = -1L;
    private boolean logProgress;
    private boolean traceProgress;
    private NProgressFactory progressFactory;

    public DefaultNInputStreamMonitor(NWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public NMsg getName() {
        return this.sourceName;
    }

    @Override
    public NInputStreamMonitor setName(NMsg name) {
        this.sourceName = name;
        return this;
    }

    @Override
    public Object getOrigin() {
        return this.sourceOrigin;
    }

    @Override
    public NInputStreamMonitor setOrigin(Object origin) {
        this.sourceOrigin = origin;
        return this;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public NInputStreamMonitor setLength(long len) {
        this.length = len;
        return this;
    }

    @Override
    public NInputStreamMonitor setSource(NInputSource source) {
        this.source = source;
        return this;
    }

    @Override
    public NInputStreamMonitor setSource(NPath inputSource) {
        this.source = inputSource;
        return this;
    }

    @Override
    public NInputStreamMonitor setSource(Path path) {
        this.source = path == null ? null : NPath.of(path);
        return this;
    }

    @Override
    public NInputStreamMonitor setSource(File path) {
        this.source = path == null ? null : NPath.of(path);
        return this;
    }

    @Override
    public NInputStreamMonitor setSource(InputStream path) {
        this.source = path == null ? null : NInputSource.of(path);
        return this;
    }

    @Override
    public InputStream create() {
        String sourceTypeName;
        NAssert.requireNonNull(this.source, "source");
        NMsg sourceName = this.sourceName;
        if (sourceName == null && this.source != null) {
            sourceName = NMsg.ofNtf(NText.of(this.source));
        }
        if (sourceName == null) {
            sourceName = NMsg.ofNtf(NText.of(this.source.getMetaData().getName()));
        }
        NProgressListener monitor = NProgressUtils.createProgressMonitor(NProgressUtils.MonitorType.STREAM, this.source, this.sourceOrigin, this.workspace, this.isLogProgress(), this.isTraceProgress(), this.getProgressFactory());
        boolean verboseMode = CoreNUtils.isCustomFalse("---monitor-start");
        long size = -1L;
        try {
            if (verboseMode && monitor != null) {
                monitor.onProgress(NProgressEvent.ofStart(this.source, sourceName, size));
            }
            size = this.source.getMetaData().getContentLength().orElse(-1L);
        }
        catch (UncheckedIOException | NIOException e) {
            if (verboseMode && monitor != null) {
                monitor.onProgress(NProgressEvent.ofComplete(this.source, sourceName, 0L, 0L, null, 0L, 0L, size, e));
            }
            throw e;
        }
        if (size < 0L) {
            size = this.getLength();
        }
        if (monitor == null) {
            return this.source.getInputStream();
        }
        InputStream openedStream = this.source.getInputStream();
        if (!verboseMode) {
            monitor.onProgress(NProgressEvent.ofStart(this.source, sourceName, size));
        }
        if ((sourceTypeName = this.getSourceTypeName()) == null) {
            sourceTypeName = this.source.getMetaData().getKind().orElse("nuts-Path");
        }
        InputStream z = NInputSourceBuilder.of(openedStream).setSource(this.source).setMonitoringListener(new SilentStartNProgressListenerAdapter(monitor, sourceName)).createInputStream();
        ((NContentMetadataProvider)((Object)z)).getMetaData().setKind(sourceTypeName);
        return z;
    }

    @Override
    public NInputSource getSource() {
        return this.source;
    }

    @Override
    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    @Override
    public NInputStreamMonitor setSourceTypeName(String sourceType) {
        this.sourceTypeName = sourceType;
        return this;
    }

    @Override
    public boolean isTraceProgress() {
        return this.traceProgress;
    }

    @Override
    public boolean isLogProgress() {
        return this.logProgress;
    }

    @Override
    public NInputStreamMonitor setLogProgress(boolean value) {
        this.logProgress = value;
        return this;
    }

    @Override
    public NInputStreamMonitor setTraceProgress(boolean value) {
        this.traceProgress = value;
        return this;
    }

    @Override
    public NProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    @Override
    public NInputStreamMonitor setProgressFactory(NProgressFactory value) {
        this.progressFactory = value;
        return this;
    }

    @Override
    public NInputStreamMonitor setProgressMonitor(NProgressListener value) {
        this.progressFactory = value == null ? null : new SingletonNInputStreamProgressFactory(value);
        return this;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

