/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.time;

import java.text.DecimalFormat;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.util.BytesSizeFormat;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.xtra.time.CProgressBar;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.time.NProgressEvent;
import net.thevpc.nuts.time.NProgressListener;

public class DefaultNCountProgressListener
implements NProgressListener {
    private NPrintStream out;
    private int minLength;

    public DecimalFormat df(NProgressEvent event) {
        return new DecimalFormat("##0.00");
    }

    public BytesSizeFormat mf(NProgressEvent event) {
        return new BytesSizeFormat("BTD1F");
    }

    @Override
    public boolean onProgress(NProgressEvent event) {
        switch (event.getState()) {
            case START: {
                this.out = event.getSession().getTerminal().err();
                if (!event.getSession().isPlainOut()) break;
                this.onProgress0(event, false);
                break;
            }
            case COMPLETE: {
                if (!event.getSession().isPlainOut()) break;
                this.onProgress0(event, true);
                break;
            }
            case PROGRESS: {
                if (!event.getSession().isPlainOut()) break;
                return this.onProgress0(event, false);
            }
        }
        return true;
    }

    public boolean onProgress0(NProgressEvent event, boolean end) {
        double partialSeconds = event.getPartialDuration().getTimeAsDoubleSeconds();
        if (event.getCurrentCount() == 0L || partialSeconds > 0.5 || event.getCurrentCount() == event.getMaxValue()) {
            NTexts text = NTexts.of();
            this.out.resetLine();
            double globalSeconds = event.getDuration().getTimeAsDoubleSeconds();
            long globalSpeed = globalSeconds == 0.0 ? 0L : (long)((double)event.getCurrentCount() / globalSeconds);
            long partialSpeed = partialSeconds == 0.0 ? 0L : (long)((double)event.getPartialCount() / partialSeconds);
            double percent = event.getProgress();
            if (event.isIndeterminate()) {
                percent = end ? 100.0 : 0.0;
            }
            NTextBuilder formattedLine = text.ofBuilder();
            CProgressBar cp = CProgressBar.of();
            formattedLine.append(cp.progress((int)percent));
            BytesSizeFormat mf = this.mf(event);
            DecimalFormat df = this.df(event);
            formattedLine.append(" ").append(text.ofStyled(String.format("%6s", df.format(percent)), NTextStyle.config())).append("% ");
            formattedLine.append(" ").append(text.ofStyled(mf.formatString(partialSpeed), NTextStyle.config())).append("/s");
            if (event.getMaxValue() < 0L) {
                if (globalSpeed == 0L) {
                    formattedLine.append(" ( -- )");
                } else {
                    formattedLine.append(" (").append(text.ofStyled(mf.formatString(globalSpeed), NTextStyle.info())).append(")");
                }
            } else {
                formattedLine.append(" (").append(text.ofStyled(mf.formatString(event.getMaxValue()), NTextStyle.warn())).append(")");
            }
            if (event.getError() != null) {
                formattedLine.append(" ").append(text.ofStyled("ERROR", NTextStyle.error())).append(" ");
            }
            formattedLine.append(" ").append(event.getMessage()).append(" ");
            String ff = formattedLine.toString();
            int length = text.ofBuilder().append(ff).length();
            if (length < this.minLength) {
                CoreStringUtils.fillString(' ', this.minLength - length, formattedLine);
            } else {
                this.minLength = length;
            }
            this.out.print(ff);
            this.out.flush();
            return true;
        }
        return false;
    }
}

