/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.time;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.xtra.time.ProgressOptions;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NLiteral;

public class CProgressBar {
    private static final IndeterminatePosition DEFAULT_INDETERMINATE_POSITION = new DefaultIndeterminatePosition();
    private int determinateSize = 10;
    private int indeterminateSize = 10;
    private int maxMessage = 0;
    private float indeterminateRatio = 0.3f;
    private NLog logger;
    private int columns = 3;
    private boolean suffixMoveLineStart = true;
    private boolean prefixMoveLineStart = true;
    private long lastPrint = 0L;
    private long minPeriod = 0L;
    private IndeterminatePosition indeterminatePosition = DEFAULT_INDETERMINATE_POSITION;
    private ProgressOptions options;
    private Formatter formatter;
    private static Map<String, Supplier<Formatter>> formatters = new HashMap<String, Supplier<Formatter>>();
    private int maxColumnsInText = 133;
    private int maxColumnsInOutput = 80;

    private static void reg(String name, Supplier<Formatter> f) {
        formatters.put(name, f);
    }

    public static CProgressBar of() {
        return NApp.of().getOrComputeProperty(CProgressBar.class.getName(), NScopeType.SESSION, CProgressBar::new);
    }

    public CProgressBar() {
        this(-1);
    }

    public CProgressBar(int determinateSize) {
        this.logger = NLog.of(CProgressBar.class);
        this.options = ProgressOptions.of();
        this.formatter = CProgressBar.createFormatter(this.options.get("type").flatMap(NLiteral::asString).orElse(""));
        if (determinateSize <= 0) {
            determinateSize = this.options.get("size").flatMap(NLiteral::asInt).orElse(this.formatter.getDefaultWidth());
        }
        this.setDeterminateSize(determinateSize);
    }

    public String[] getFormatterNames() {
        return formatters.keySet().toArray(new String[0]);
    }

    public static Formatter createFormatter(String name) {
        Formatter u;
        Supplier<Formatter> e = formatters.get(name);
        if (e != null && (u = e.get()) != null) {
            return u;
        }
        return formatters.get("").get();
    }

    public long getMinPeriod() {
        return this.minPeriod;
    }

    public void setMinPeriod(long minPeriod) {
        this.minPeriod = minPeriod;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public CProgressBar setFormatter(String formatter) {
        return this.setFormatter(CProgressBar.createFormatter(formatter));
    }

    public CProgressBar setFormatter(Formatter formatter) {
        this.formatter = formatter == null ? CProgressBar.createFormatter("") : formatter;
        return this;
    }

    public IndeterminatePosition getIndeterminatePosition() {
        return this.indeterminatePosition;
    }

    public CProgressBar setIndeterminatePosition(IndeterminatePosition indeterminatePosition) {
        this.indeterminatePosition = indeterminatePosition == null ? DEFAULT_INDETERMINATE_POSITION : indeterminatePosition;
        return this;
    }

    public int getEffSize(boolean indeterminate) {
        int s;
        int m = indeterminate ? this.formatter.getIndeterminateMaxWidth() : this.formatter.getMaxWidth();
        int n = s = indeterminate ? this.getIndeterminateSize() : this.getDeterminateSize();
        if (m > 0 && m < s) {
            return m;
        }
        return s;
    }

    public int getDeterminateSize() {
        return this.determinateSize;
    }

    public CProgressBar setDeterminateSize(int determinateSize) {
        this.determinateSize = determinateSize;
        return this;
    }

    public int getColumns() {
        return this.columns;
    }

    public CProgressBar setColumns(int columns) {
        this.columns = columns <= 1 ? 1 : columns;
        return this;
    }

    public boolean isSuffixMoveLineStart() {
        return this.suffixMoveLineStart;
    }

    public boolean isPrefixMoveLineStart() {
        return this.prefixMoveLineStart;
    }

    public boolean isNoMoveLineStart() {
        return !this.isPrefixMoveLineStart() && !this.isSuffixMoveLineStart();
    }

    public CProgressBar setSuffixMoveLineStart(boolean v) {
        this.suffixMoveLineStart = v;
        return this;
    }

    public CProgressBar setPrefixMoveLineStart(boolean v) {
        this.prefixMoveLineStart = v;
        return this;
    }

    public NText progress(int percent) {
        int i;
        long now = System.currentTimeMillis();
        NTexts txt = NTexts.of();
        if (now < this.lastPrint + this.minPeriod) {
            return NText.ofBlank();
        }
        this.lastPrint = now;
        boolean indeterminate = percent < 0;
        int eSize = this.getEffSize(indeterminate);
        if (indeterminate) {
            int i2;
            NTextBuilder formattedLine = txt.ofBuilder();
            formattedLine.append(this.getFormatter().getStart());
            int indeterminateSize = (int)(this.indeterminateRatio * (float)eSize);
            boolean forward = true;
            if (indeterminateSize >= eSize) {
                indeterminateSize = eSize - 1;
            }
            if (indeterminateSize < 1) {
                indeterminateSize = 1;
            }
            int x = 0;
            if (indeterminateSize < eSize) {
                int p = eSize - indeterminateSize;
                int h = this.indeterminatePosition.evalIndeterminatePos(this, 2 * p);
                if (h < 0) {
                    h = -h;
                }
                if ((x = h % (2 * p)) >= p) {
                    forward = false;
                    x = 2 * p - x;
                }
            } else {
                x = 0;
            }
            if (x < 0) {
                x = 0;
            }
            for (i2 = 0; i2 < x; ++i2) {
                formattedLine.append(this.getFormatter().getIndicator(0.0f, i2));
            }
            for (i2 = 0; i2 < indeterminateSize; ++i2) {
                formattedLine.append(this.getFormatter().getIntermediateIndicator(i2, indeterminateSize, x, forward));
            }
            int r = eSize - x - indeterminateSize;
            for (int i3 = 0; i3 < r; ++i3) {
                formattedLine.append(this.getFormatter().getIndicator(0.0f, x + indeterminateSize + i3));
            }
            formattedLine.append(this.getFormatter().getEnd());
            return formattedLine.build();
        }
        if (percent > 100) {
            percent = 100 - percent;
        }
        double d = (double)eSize / 100.0 * (double)percent;
        int x = (int)d;
        float rest = (float)(d - (double)x);
        NTextBuilder formattedLine = txt.ofBuilder();
        formattedLine.append(this.getFormatter().getStart());
        if (x > 0) {
            for (i = 0; i < x; ++i) {
                formattedLine.append(this.getFormatter().getIndicator(1.0f, i));
            }
        }
        if (rest > 0.0f && eSize - x > 0) {
            formattedLine.append(this.getFormatter().getIndicator(rest, x));
            for (i = 0; i < eSize - x - 1; ++i) {
                formattedLine.append(this.getFormatter().getIndicator(0.0f, x + 1 + i));
            }
        } else {
            for (i = 0; i < eSize - x; ++i) {
                formattedLine.append(this.getFormatter().getIndicator(0.0f, x + i));
            }
        }
        formattedLine.append(this.getFormatter().getEnd());
        return formattedLine.build();
    }

    public void printProgress(int percent, NText msg, NPrintStream out) {
        Level armedLogLevel = this.options.getArmedLogLevel();
        if (armedLogLevel != null) {
            NText p = this.progress(percent, msg, true);
            if (p == null || p.isEmpty()) {
                return;
            }
            this.logger.log(NMsg.ofNtf(p).withLevel(armedLogLevel).withIntent(NMsgIntent.PROGRESS));
        } else {
            NTerminalMode m = out.getTerminalMode();
            NText p = this.progress(percent, msg, m == NTerminalMode.FILTERED);
            if (p == null || p.isEmpty()) {
                return;
            }
            this.printStreamWithCut(p, out);
        }
    }

    public void printProgress2(NText p, NPrintStream out) {
        if (p == null || p.isEmpty()) {
            return;
        }
        boolean forceNewline = out.getTerminalMode() == NTerminalMode.FILTERED;
        Level armedLogLevel = this.options.getArmedLogLevel();
        if (this.options.isArmedNewline() || forceNewline) {
            out.print("\n");
        } else if (armedLogLevel != null) {
            this.logger.log(NMsg.ofNtf(p).withLevel(armedLogLevel).withIntent(NMsgIntent.PROGRESS));
        } else {
            this.printStreamWithCut(p, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStreamWithCut(NText p, NPrintStream out) {
        Class<CProgressBar> clazz = CProgressBar.class;
        synchronized (CProgressBar.class) {
            NSystemTerminalBase.Size size = null;
            int max = this.maxColumnsInOutput;
            try {
                size = out.getTerminal().getTerminalSize();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (size != null && size.getColumns() > 0) {
                max = size.getColumns() - 1;
            }
            out.resetLine();
            int len = p.length();
            if (len > max) {
                p = p.substring(0, max);
            }
            out.print(p);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public NText progress(int percent, NText msg, boolean forceNewline) {
        NText p;
        NTexts txt = NTexts.of();
        NTextBuilder sb = txt.ofBuilder();
        if (this.maxMessage < this.columns) {
            this.maxMessage = this.columns;
        }
        int s2 = 0;
        if (msg == null) {
            msg = NText.ofBlank();
        }
        s2 = msg.length();
        Level armedLogLevel = this.options.getArmedLogLevel();
        if (armedLogLevel == null && this.isPrefixMoveLineStart()) {
            if (this.options.isArmedNewline()) {
                if (!this.isSuffixMoveLineStart() || forceNewline) {
                    sb.append("\n");
                }
            } else {
                sb.append(txt.ofCommand(NTerminalCmd.CLEAR_LINE));
                sb.append(txt.ofCommand(NTerminalCmd.MOVE_LINE_START));
            }
        }
        if ((p = this.progress(percent)) == null) {
            return txt.ofBlank();
        }
        sb.append(p).append(" ");
        sb.append(msg);
        sb.append(CoreStringUtils.fillString(' ', this.maxMessage - s2));
        if (this.isSuffixMoveLineStart() && (armedLogLevel == null && this.options.isArmedNewline() || forceNewline)) {
            sb.append("\n");
        }
        if (this.maxMessage < s2) {
            this.maxMessage = s2;
        }
        if (this.maxMessage > this.maxColumnsInText) {
            this.maxMessage = this.maxColumnsInText;
        }
        return sb.build();
    }

    public float getIndeterminateRatio() {
        return this.indeterminateRatio;
    }

    public CProgressBar setIndeterminateRatio(float indeterminateRatio) {
        if (indeterminateRatio <= 0.0f || indeterminateRatio >= 1.0f) {
            indeterminateRatio = 0.3f;
        }
        this.indeterminateRatio = indeterminateRatio;
        return this;
    }

    public int getIndeterminateSize() {
        return this.indeterminateSize;
    }

    public CProgressBar setIndeterminateSize(int indeterminateSize) {
        this.indeterminateSize = indeterminateSize;
        return this;
    }

    static {
        CProgressBar.reg("", () -> {
            NTexts txt = NTexts.of();
            return CorePlatformUtils.SUPPORTS_UTF_ENCODING ? CProgressBar.createFormatter("braille") : CProgressBar.createFormatter("simple");
        });
        CProgressBar.reg("square", () -> {
            NTexts txt = NTexts.of();
            if (!CorePlatformUtils.SUPPORTS_UTF_ENCODING) {
                return null;
            }
            return new SimpleFormatter("square", new NText[]{txt.ofStyled("\u2b1c", NTextStyle.primary1()), txt.ofStyled("\u2b1b", NTextStyle.primary1())}, new NText[]{txt.ofStyled("\u2b1b", NTextStyle.primary1())}, 10, -1, 10, 10);
        });
        CProgressBar.reg("vbar", () -> {
            if (!CorePlatformUtils.SUPPORTS_UTF_ENCODING) {
                return null;
            }
            NTexts txt = NTexts.of();
            return new SimpleFormatter("vbar", new NText[]{txt.ofStyled(" ", NTextStyle.primary1()), txt.ofStyled("\u2581", NTextStyle.primary1()), txt.ofStyled("\u2582", NTextStyle.primary1()), txt.ofStyled("\u2583", NTextStyle.primary1()), txt.ofStyled("\u2584", NTextStyle.primary1()), txt.ofStyled("\u2585", NTextStyle.primary1()), txt.ofStyled("\u2586", NTextStyle.primary1()), txt.ofStyled("\u2587", NTextStyle.primary1()), txt.ofStyled("\u2588", NTextStyle.primary1())}, new NText[]{txt.ofStyled("\u2581", NTextStyle.primary1()), txt.ofStyled("\u2582", NTextStyle.primary1()), txt.ofStyled("\u2583", NTextStyle.primary1()), txt.ofStyled("\u2584", NTextStyle.primary1()), txt.ofStyled("\u2585", NTextStyle.primary1()), txt.ofStyled("\u2586", NTextStyle.primary1()), txt.ofStyled("\u2587", NTextStyle.primary1()), txt.ofStyled("\u2588", NTextStyle.primary1())}, new NText[]{txt.ofStyled("\u2588", NTextStyle.primary1()), txt.ofStyled("\u2587", NTextStyle.primary1()), txt.ofStyled("\u2586", NTextStyle.primary1()), txt.ofStyled("\u2585", NTextStyle.primary1()), txt.ofStyled("\u2584", NTextStyle.primary1()), txt.ofStyled("\u2583", NTextStyle.primary1()), txt.ofStyled("\u2582", NTextStyle.primary1()), txt.ofStyled("\u2581", NTextStyle.primary1())}, 1, 1, 10, 10);
        });
        CProgressBar.reg("shadow", () -> {
            NTexts txt = NTexts.of();
            if (!CorePlatformUtils.SUPPORTS_UTF_ENCODING) {
                return null;
            }
            return new SimpleFormatter("shadow", new NText[]{txt.ofStyled(" ", NTextStyle.primary1()), txt.ofStyled("\u2591", NTextStyle.primary1()), txt.ofStyled("\u2592", NTextStyle.primary1()), txt.ofStyled("\u2593", NTextStyle.primary1()), txt.ofStyled("\u2588", NTextStyle.primary1())}, new NText[]{txt.ofStyled("\u2588", NTextStyle.primary1())}, 1, 1, 10, 10);
        });
        CProgressBar.reg("hbar", () -> {
            NTexts txt = NTexts.of();
            if (!CorePlatformUtils.SUPPORTS_UTF_ENCODING) {
                return null;
            }
            return new SimpleFormatter("hbar", new NText[]{txt.ofStyled(" ", NTextStyle.primary1()), txt.ofStyled("\u258f", NTextStyle.primary1()), txt.ofStyled("\u258e", NTextStyle.primary1()), txt.ofStyled("\u258d", NTextStyle.primary1()), txt.ofStyled("\u258c", NTextStyle.primary1()), txt.ofStyled("\u258b", NTextStyle.primary1()), txt.ofStyled("\u258a", NTextStyle.primary1()), txt.ofStyled("\u2589", NTextStyle.primary1()), txt.ofStyled("\u2588", NTextStyle.primary1())}, new NText[]{txt.ofStyled("\u2588", NTextStyle.primary1())}, 10, -1, 10, 10);
        });
        CProgressBar.reg("circle", () -> {
            NTexts txt = NTexts.of();
            if (!CorePlatformUtils.SUPPORTS_UTF_ENCODING) {
                return null;
            }
            return new SimpleFormatter("circle", new NText[]{txt.ofStyled("\u26aa", NTextStyle.primary1()), txt.ofStyled("\u26ab", NTextStyle.primary1())}, new NText[]{txt.ofStyled("\u26ab", NTextStyle.primary1())}, 10, -1, 10, 10);
        });
        CProgressBar.reg("parallelogram", () -> {
            NTexts txt = NTexts.of();
            if (!CorePlatformUtils.SUPPORTS_UTF_ENCODING) {
                return null;
            }
            return new SimpleFormatter("parallelogram", new NText[]{txt.ofStyled("\u25b1", NTextStyle.primary1()), txt.ofStyled("\u25b0", NTextStyle.primary1())}, new NText[]{txt.ofStyled("\u25b0", NTextStyle.primary1())}, 10, -1, 10, 10);
        });
        CProgressBar.reg("simple", () -> {
            NTexts txt = NTexts.of();
            return new SimpleFormatter("simple", new NText[]{txt.ofStyled(" ", NTextStyle.primary1()), txt.ofStyled("*", NTextStyle.primary1())}, new NText[]{txt.ofStyled("*", NTextStyle.primary1())}, null, txt.ofStyled("[", NTextStyle.primary4()), txt.ofStyled("]", NTextStyle.primary4()), 10, -1, 10, 10);
        });
        CProgressBar.reg("clock", () -> {
            NTexts txt = NTexts.of();
            if (!CorePlatformUtils.SUPPORTS_UTF_ENCODING) {
                return null;
            }
            return new SimpleFormatter("clock", new NText[]{txt.ofStyled("\u25cb", NTextStyle.primary1()), txt.ofStyled("\u25d4", NTextStyle.primary1()), txt.ofStyled("\u25d1", NTextStyle.primary1()), txt.ofStyled("\u25d5", NTextStyle.primary1()), txt.ofStyled("\u25cf", NTextStyle.primary1())}, new NText[]{txt.ofStyled("\u25cf", NTextStyle.primary1())}, 1, 1, 10, 10);
        });
        CProgressBar.reg("braille", () -> {
            NTexts txt = NTexts.of();
            if (!CorePlatformUtils.SUPPORTS_UTF_ENCODING) {
                return null;
            }
            return new SimpleFormatter("braille", new NText[]{txt.ofStyled("\u2800", NTextStyle.primary1()), txt.ofStyled("\u2801", NTextStyle.primary1()), txt.ofStyled("\u2803", NTextStyle.primary1()), txt.ofStyled("\u2807", NTextStyle.primary1()), txt.ofStyled("\u2846", NTextStyle.primary1()), txt.ofStyled("\u28c4", NTextStyle.primary1()), txt.ofStyled("\u28e0", NTextStyle.primary1()), txt.ofStyled("\u28b0", NTextStyle.primary1()), txt.ofStyled("\u2838", NTextStyle.primary1()), txt.ofStyled("\u2819", NTextStyle.primary1()), txt.ofStyled("\u2819", NTextStyle.primary1()), txt.ofStyled("\u2809", NTextStyle.primary1())}, new NText[]{txt.ofStyled("\u2815", NTextStyle.primary1()), txt.ofStyled("\u2817", NTextStyle.primary1())}, new NText[]{txt.ofStyled("\u282a", NTextStyle.primary1()), txt.ofStyled("\u283a", NTextStyle.primary1())}, 1, 1, 10, 10);
        });
    }

    public static interface IndeterminatePosition {
        public int evalIndeterminatePos(CProgressBar var1, int var2);
    }

    public static interface Formatter {
        public NText getIntermediateIndicator(int var1, int var2, int var3, boolean var4);

        public NText getIndicator(float var1, int var2);

        public NText getStart();

        public NText getEnd();

        public int getMaxWidth();

        public int getDefaultWidth();

        public int getIndeterminateMaxWidth();

        public int getDefaultIndeterminateWidth();
    }

    public static class SimpleFormatter
    implements Formatter {
        private NText[] style;
        private NText[] intermediateForwardStyle;
        private NText[] intermediateBackwardStyle;
        private NText start;
        private NText end;
        private int defaultWidth;
        private int maxWidth;
        private int defaultIndeterminateWidth;
        private int maxIndeterminateWidth;
        private String name;

        public SimpleFormatter(String name, NText[] style, int defaultWidth, int maxWidth, int defaultIndeterminateWidth, int maxIndeterminateWidth) {
            this(name, style, null, null, null, null, defaultWidth, maxWidth, defaultIndeterminateWidth, maxIndeterminateWidth);
        }

        public SimpleFormatter(String name, NText[] style, NText[] forward, int defaultWidth, int maxWidth, int defaultIndeterminateWidth, int maxIndeterminateWidth) {
            this(name, style, forward, null, null, null, defaultWidth, maxWidth, defaultIndeterminateWidth, maxIndeterminateWidth);
        }

        public SimpleFormatter(String name, NText[] style, NText[] forward, NText[] backward, int defaultWidth, int maxWidth, int defaultIndeterminateWidth, int maxIndeterminateWidth) {
            this(name, style, forward, backward, null, null, defaultWidth, maxWidth, defaultIndeterminateWidth, maxIndeterminateWidth);
        }

        public SimpleFormatter(String name, NText[] style, NText[] forward, NText[] backward, NText start, NText end, int defaultWidth, int maxWidth, int defaultIndeterminateWidth, int maxIndeterminateWidth) {
            if (forward == null) {
                forward = style;
            }
            if (backward == null) {
                backward = forward;
            }
            this.name = name;
            this.defaultWidth = defaultWidth;
            this.maxWidth = maxWidth;
            this.style = style;
            this.intermediateForwardStyle = forward;
            this.intermediateBackwardStyle = backward;
            this.start = start;
            this.end = end;
            this.maxIndeterminateWidth = maxIndeterminateWidth;
            this.defaultIndeterminateWidth = defaultIndeterminateWidth;
        }

        @Override
        public int getMaxWidth() {
            return this.maxWidth;
        }

        @Override
        public int getDefaultWidth() {
            return this.defaultWidth;
        }

        @Override
        public NText getIndicator(float itemDensity, int itemPosition) {
            return this.getIndicator(this.style, itemDensity, itemPosition);
        }

        public NText getIndicator(NText[] style, float itemDensity, int itemPosition) {
            int length = style.length;
            int p = (int)(itemDensity * (float)length);
            if (p < 0) {
                p = 0;
            } else if (p >= length) {
                p = length - 1;
            }
            return style[p];
        }

        @Override
        public NText getIntermediateIndicator(int intermediatePosition, int indeterminateSize, int intermediateStartPosition, boolean forward) {
            float density = (float)intermediatePosition * 1.0f / (float)indeterminateSize;
            if (forward) {
                int length = this.intermediateForwardStyle.length;
                int p = (int)(density * (float)length);
                if (p < 0) {
                    p = 0;
                } else if (p >= length) {
                    p = length - 1;
                }
                return this.intermediateForwardStyle[p];
            }
            int length = this.intermediateBackwardStyle.length;
            int p = (int)(density * (float)length);
            if (p < 0) {
                p = 0;
            } else if (p >= length) {
                p = length - 1;
            }
            return this.intermediateBackwardStyle[p];
        }

        @Override
        public NText getStart() {
            return this.start;
        }

        @Override
        public NText getEnd() {
            return this.end;
        }

        @Override
        public int getIndeterminateMaxWidth() {
            return this.maxIndeterminateWidth;
        }

        @Override
        public int getDefaultIndeterminateWidth() {
            return this.defaultIndeterminateWidth;
        }
    }

    public static class DefaultIndeterminatePosition
    implements IndeterminatePosition {
        @Override
        public int evalIndeterminatePos(CProgressBar bar, int size) {
            int ss = 2 * Calendar.getInstance().get(13);
            int ms = Calendar.getInstance().get(14);
            if (ms > 500) {
                ++ss;
            }
            return ss;
        }
    }
}

