/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.throwables;

import java.io.PrintStream;
import javax.swing.JOptionPane;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.app.NApplications;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NSessionAwareExceptionBase;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.core.NWorkspaceOptionsBuilder;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.internal.NApiUtilsRPI;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NAnyFormattedExceptionBase;
import net.thevpc.nuts.util.NExceptionWorkspaceHandler;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

@NComponentScope(value=NScopeType.SESSION)
public class DefaultNExceptionWorkspaceHandler
implements NExceptionWorkspaceHandler {
    @Override
    public int processThrowable(String[] args, Throwable throwable) {
        NSession session = NSession.of();
        NWorkspaceOptionsBuilder bo = null;
        bo = NWorkspace.of().getBootOptions().toWorkspaceOptions().builder();
        if (!NWorkspace.of().isGraphicalDesktopEnvironment()) {
            bo.setGui(false);
        }
        NWorkspaceOptions bbo = bo.build();
        boolean showGui = NApiUtilsRPI.resolveGui(bbo);
        boolean showTrace = NApiUtilsRPI.resolveShowStackTrace(bbo);
        int errorCode = NExceptions.resolveExitCode(throwable).orElse(204);
        NMsg fm = NSessionAwareExceptionBase.resolveSessionAwareExceptionBase(throwable).map(NAnyFormattedExceptionBase::getFormattedMessage).orNull();
        String m = throwable.getMessage();
        if (m == null || m.length() < 5) {
            m = throwable.toString();
        }
        NPrintStream fout = null;
        try {
            fout = NIO.of().getSystemTerminal().getErr();
            fm = fm != null ? NMsg.ofStyledError(fm) : NMsg.ofStyledError(m);
        }
        catch (Exception ex2) {
            NLog.of(NApplications.class).log(NMsg.ofPlain("unable to get system terminal").asFine(ex2));
        }
        if (fout != null) {
            if (session.getOutputFormat().orDefault() == NContentType.PLAIN) {
                if (fm != null) {
                    fout.resetLine().println(fm);
                } else {
                    fout.resetLine().println(m);
                }
                if (showTrace) {
                    throwable.printStackTrace(fout.asPrintStream());
                }
                fout.flush();
            } else {
                NArrayElementBuilder e;
                if (fm != null) {
                    session.out().resetLine();
                    session.eout().add(NElement.ofObjectBuilder().set("app-id", NStringUtils.toStringOrEmpty(NApp.of().getId().orNull())).set("error", NText.of(fm).filteredText()).build());
                    if (showTrace) {
                        session.eout().add(NElement.ofObjectBuilder().set("errorTrace", (NElement)NElement.ofArrayBuilder().addAll(NStringUtils.stacktraceArray(throwable)).build()).build());
                    }
                    if ((e = session.eout()).size() > 0) {
                        fout.println(e.build());
                        e.clear();
                    }
                    fout.flush();
                } else {
                    session.out().resetLine();
                    session.eout().add(NElement.ofObjectBuilder().set("app-id", NStringUtils.toStringOrEmpty(NApp.of().getId().orNull())).set("error", m).build());
                    if (showTrace) {
                        session.eout().add(NElement.ofObjectBuilder().set("errorTrace", (NElement)NElement.ofArrayBuilder().addAll(NStringUtils.stacktraceArray(throwable)).build()).build());
                    }
                    if ((e = session.eout()).size() > 0) {
                        fout.println(e.build());
                        e.clear();
                    }
                    fout.flush();
                }
                fout.flush();
            }
        } else {
            PrintStream out = System.err;
            if (fm != null) {
                out.println(fm);
            } else {
                out.println(m);
            }
            if (showTrace) {
                throwable.printStackTrace(out);
            }
            out.flush();
        }
        if (showGui) {
            StringBuilder sb = new StringBuilder();
            if (fm != null) {
                sb.append(NText.of(fm).filteredText());
            } else {
                sb.append(m);
            }
            if (showTrace && sb.length() > 0) {
                sb.append("\n");
                sb.append(NStringUtils.stacktrace(throwable));
            }
            String title = "Nuts Package Manager - Error";
            try {
                JOptionPane.showMessageDialog(null, NMsg.ofPlain(sb.toString()).toString());
            }
            catch (UnsatisfiedLinkError e) {
                System.err.printf("[Graphical Environment Unsupported] %s%n", title);
            }
        }
        return errorCode;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

