/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.rnsh;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.io.NInputContentProvider;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathChildDigestInfo;
import net.thevpc.nuts.io.NPathChildStringDigestInfo;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.runtime.standalone.io.inputstream.NTempOutputStreamImpl;
import net.thevpc.nuts.runtime.standalone.xtra.rnsh.RnshHttpClient;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.spi.NPathSPIAware;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NHex;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class RnshPathFactorySPI
implements NPathFactorySPI {
    @Override
    public NScoredCallable<NPathSPI> createPath(String path, String protocol, ClassLoader classLoader) {
        NConnectionString cnx;
        if (protocol != null) {
            switch (protocol) {
                case "rnsh-http": 
                case "rnsh": 
                case "rnsh-https": 
                case "rnshs": {
                    break;
                }
                default: {
                    return NScoredCallable.ofInvalid(NMsg.ofC("Invalid path: %s", path));
                }
            }
        }
        if ((path.startsWith("rnsh-http:") || path.startsWith("rnsh:") || path.startsWith("rnsh-https:") || path.startsWith("rnshs:")) && (cnx = NConnectionString.get(path).orNull()) != null) {
            return NScoredCallable.of(3, () -> new NServerPathSPI(cnx));
        }
        return NScoredCallable.ofInvalid(NMsg.ofC("Invalid path: %s", path));
    }

    @Override
    public int getScore(NScorableContext context) {
        String path = (String)context.getCriteria();
        if (path.startsWith("rnsh-http:") || path.startsWith("rnsh:") || path.startsWith("rnsh-https:") || path.startsWith("rnshs:")) {
            return 10;
        }
        return -1;
    }

    public static class NServerPathSPI
    implements NPathSPI {
        final NConnectionString cnx;
        final RnshHttpClient client;
        final String remotePath;

        private NServerPathSPI(NConnectionString cnx, String remotePath, RnshHttpClient client) {
            this.cnx = cnx;
            this.client = client;
            this.remotePath = remotePath;
        }

        public NServerPathSPI(NConnectionString cnx) {
            this.cnx = cnx;
            this.client = new RnshHttpClient();
            this.client.setConnectionString(cnx);
            this.remotePath = NStringUtils.firstNonBlank(cnx.getPath(), "/");
        }

        @Override
        public byte[] getDigest(NPath basePath, String algo) {
            this.client.ensureConnected();
            String hash = this.client.digest(this.remotePath, algo);
            return NHex.toBytes(hash);
        }

        @Override
        public List<NPathChildDigestInfo> listDigestInfo(NPath basePath, String algo) {
            this.client.ensureConnected();
            List<NPathChildStringDigestInfo> nPathChildStringDigestInfos = this.client.directoryListDigest(this.remotePath, algo);
            if (nPathChildStringDigestInfos == null) {
                return new ArrayList<NPathChildDigestInfo>();
            }
            return nPathChildStringDigestInfos.stream().map(x -> new NPathChildDigestInfo().setName(x.getName()).setDigest(NHex.toBytes(x.getDigest()))).collect(Collectors.toList());
        }

        @Override
        public NStream<NPath> list(NPath basePath) {
            if (!this.client.ensureConnectedSafely()) {
                return NStream.ofEmpty();
            }
            return NStream.ofArray(this.client.listNames(this.remotePath)).map(x -> NPath.of(this.cnx.resolve((String)x).toString()));
        }

        @Override
        public boolean copyTo(NPath basePath, NPath other, NPathOption ... options) {
            if (basePath instanceof NPathSPIAware && other instanceof NPathSPIAware) {
                NPathSPI spi1 = ((NPathSPIAware)((Object)basePath)).spi();
                NPathSPI spi2 = ((NPathSPIAware)((Object)other)).spi();
                if (spi1 instanceof NServerPathSPI && spi2 instanceof NServerPathSPI) {
                    NServerPathSPI ssh1 = (NServerPathSPI)spi1;
                    NServerPathSPI ssh2 = (NServerPathSPI)spi2;
                    if (ssh1.cnx.withPath("/").equals(ssh2.cnx.withPath("/"))) {
                        this.client.exec("cp", "-r", ssh1.remotePath, ssh2.remotePath);
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public NPathType getType(NPath basePath) {
            if (!this.client.ensureConnectedSafely()) {
                return NPathType.NOT_FOUND;
            }
            try {
                this.client.ensureConnected();
                RnshHttpClient.NFileInfo i = this.client.getFileInfo(this.remotePath);
                if (i != null) {
                    return i.getPathType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return NPathType.NOT_FOUND;
        }

        @Override
        public boolean exists(NPath basePath) {
            if (!this.client.ensureConnectedSafely()) {
                return false;
            }
            return this.getType(basePath) != NPathType.NOT_FOUND;
        }

        @Override
        public long getContentLength(NPath basePath) {
            if (!this.client.ensureConnectedSafely()) {
                return -1L;
            }
            try {
                RnshHttpClient.NFileInfo i = this.client.getFileInfo(this.remotePath);
                return i.getContentLength();
            }
            catch (Exception e) {
                return -1L;
            }
        }

        @Override
        public InputStream getInputStream(NPath basePath, NPathOption ... options) {
            return this.client.getFile(this.remotePath).getInputStream();
        }

        @Override
        public OutputStream getOutputStream(NPath basePath, NPathOption ... options) {
            final String name = NPath.of(this.remotePath).getName();
            NTempOutputStreamImpl nTempOutputStream = new NTempOutputStreamImpl();
            nTempOutputStream.setOnCompleted(inputStream -> {
                this.client.ensureConnected();
                this.client.putFile(new NInputContentProvider(){
                    final /* synthetic */ InputStream val$inputStream;
                    {
                        this.val$inputStream = inputStream;
                    }

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public String getContentType() {
                        return "application/octet-stream";
                    }

                    @Override
                    public String getCharset() {
                        return null;
                    }

                    @Override
                    public InputStream getInputStream() {
                        return this.val$inputStream;
                    }
                }, this.remotePath);
            });
            return nTempOutputStream;
        }

        @Override
        public void delete(NPath basePath, boolean recurse) {
            this.client.ensureConnected();
            this.client.exec("rm", "-R", this.remotePath);
        }

        @Override
        public void mkdir(boolean parents, NPath basePath) {
            this.client.ensureConnected();
            this.client.exec("mkdir", parents ? "-p" : null, this.remotePath);
        }

        @Override
        public List<String> getNames(NPath basePath) {
            return this.cnx.getNames();
        }

        @Override
        public NPath getRoot(NPath basePath) {
            if (this.isRoot(basePath).booleanValue()) {
                return basePath;
            }
            return NPath.of(this.cnx.getRoot().toString());
        }

        @Override
        public Boolean isRoot(NPath basePath) {
            return "/".equals(String.valueOf(this.cnx.getPath()));
        }

        @Override
        public NPath getParent(NPath basePath) {
            if (this.isRoot(basePath).booleanValue()) {
                return null;
            }
            return NPath.of(this.cnx.getParent().toString());
        }

        @Override
        public String toString() {
            return this.cnx.builder().setPath(this.remotePath).build().toString();
        }

        @Override
        public String getLocation(NPath basePath) {
            return this.remotePath;
        }
    }
}

